/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;

public class EvaluatorException
extends RuntimeException {
    private String sourceName;
    private int lineNumber;
    private String lineSource;
    private int columnNumber;

    public EvaluatorException(String detail) {
        super(detail);
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            int[] linep = new int[]{0};
            this.sourceName = Context.getSourcePositionFromStack(linep);
            this.lineNumber = linep[0];
        }
    }

    public EvaluatorException(String detail, String sourceName, int lineNumber, String lineSource, int columnNumber) {
        super(EvaluatorException.generateErrorMessage(detail, sourceName, lineNumber));
        this.sourceName = sourceName;
        this.lineNumber = lineNumber;
        this.lineSource = lineSource;
        this.columnNumber = columnNumber;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLineSource() {
        return this.lineSource;
    }

    static String generateErrorMessage(String message, String sourceName, int line) {
        if (sourceName == null || line <= 0) {
            return message;
        }
        StringBuffer buf = new StringBuffer(message);
        buf.append(" (");
        if (sourceName != null) {
            buf.append(sourceName);
        }
        if (line > 0) {
            buf.append('#');
            buf.append(line);
        }
        buf.append(')');
        return buf.toString();
    }
}

