/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XKeysSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CommandMetaData
extends DBMetaData {
    public Map FieldTitleSet = new HashMap();
    public String[] AllFieldNames = new String[0];
    public FieldColumn[] FieldColumns = new FieldColumn[0];
    public String[] GroupFieldNames = new String[0];
    private String[][] SortFieldNames = new String[0][];
    private String[] RecordFieldNames = new String[0];
    public String[][] AggregateFieldNames = new String[0][];
    public String[] NumericFieldNames = new String[0];
    public String[] NonAggregateFieldNames;
    public int[] FieldTypes;
    private int CommandType;
    private String Command;
    boolean bCatalogAtStart = true;
    String sCatalogSep = "";
    String sIdentifierQuote = "";
    boolean bCommandComposerAttributesalreadyRetrieved = false;
    private XIndexAccess xIndexKeys;

    public CommandMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        super(xMultiServiceFactory, locale, numberFormatter);
    }

    public CommandMetaData(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void initializeFieldColumns(boolean bl, String string, String[] stringArray) {
        this.setCommandName(string);
        this.FieldColumns = new FieldColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, stringArray[i], this.getCommandName(), false);
            if (!bl) continue;
            this.FieldColumns[i].getDefaultValue();
        }
    }

    public void initializeFieldColumns(String[] stringArray, XNameAccess xNameAccess) {
        this.FieldColumns = new FieldColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, xNameAccess, stringArray[i]);
        }
    }

    public void initializeFieldColumns(String[] stringArray, String string) {
        this.setCommandName(string);
        this.FieldColumns = new FieldColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.FieldColumns[i] = new FieldColumn(this, stringArray[i], string, false);
            if (this.FieldTitleSet == null || !this.FieldTitleSet.containsKey(stringArray[i])) continue;
            this.FieldColumns[i].setFieldTitle((String)this.FieldTitleSet.get(stringArray[i]));
            if (this.FieldColumns[i].getFieldTitle() != null) continue;
            this.FieldColumns[i].setFieldTitle(stringArray[i]);
            this.FieldTitleSet.put(stringArray[i], stringArray[i]);
        }
    }

    public Map getFieldTitleSet() {
        return this.FieldTitleSet;
    }

    public XPropertySet getColumnObjectByFieldName(String string, boolean bl) {
        try {
            FieldColumn fieldColumn = null;
            fieldColumn = bl ? this.getFieldColumnByDisplayName(string) : this.getFieldColumnByFieldName(string);
            String string2 = fieldColumn.getCommandName();
            DBMetaData.CommandObject commandObject = this.getTableByName(string2);
            Object object = commandObject.xColumns.getByName(fieldColumn.m_sFieldName);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            return xPropertySet;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void prependSortFieldNames(String[] stringArray) {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = JavaTools.FieldInTable(this.SortFieldNames, stringArray[n]);
            String[] stringArray2 = new String[]{stringArray[n], n2 > -1 ? this.SortFieldNames[n2][1] : "ASC"};
            vector.add(stringArray2);
        }
        for (n = 0; n < this.SortFieldNames.length; ++n) {
            if (JavaTools.FieldInList(stringArray, this.SortFieldNames[n][0]) != -1) continue;
            vector.add(this.SortFieldNames[n]);
        }
        this.SortFieldNames = new String[vector.size()][2];
        vector.toArray((T[])this.SortFieldNames);
    }

    public String[][] getSortFieldNames() {
        return this.SortFieldNames;
    }

    public void setSortFieldNames(String[][] stringArray) {
        this.SortFieldNames = stringArray;
    }

    public FieldColumn getFieldColumn(String string, String string2) {
        if (this.FieldColumns.length > 0) {
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (!this.FieldColumns[i].m_sFieldName.equals(string) || !this.FieldColumns[i].getCommandName().equals(string2)) continue;
                return this.FieldColumns[i];
            }
        }
        return null;
    }

    public FieldColumn getFieldColumnByFieldName(String string) {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String string2;
            String string3 = this.FieldColumns[i].m_sFieldName;
            if (string3.equals(string)) {
                return this.FieldColumns[i];
            }
            if (string.indexOf(46) != -1 || !string3.equals(string2 = this.Command + "." + string)) continue;
            return this.FieldColumns[i];
        }
        throw new RuntimeException();
    }

    public FieldColumn getFieldColumnByDisplayName(String string) {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String string2;
            String string3 = this.FieldColumns[i].getDisplayFieldName();
            if (string3.equals(string)) {
                return this.FieldColumns[i];
            }
            if (string.indexOf(46) != -1 || !string3.equals(string2 = this.Command + "." + string)) continue;
            return this.FieldColumns[i];
        }
        throw new RuntimeException();
    }

    public FieldColumn getFieldColumnByTitle(String string) {
        int n;
        for (n = 0; n < this.FieldColumns.length; ++n) {
            if (!this.FieldColumns[n].getFieldTitle().equals(string)) continue;
            return this.FieldColumns[n];
        }
        for (n = 0; n < this.FieldColumns.length; ++n) {
            if (!this.FieldColumns[n].m_sFieldName.equals(string)) continue;
            return this.FieldColumns[n];
        }
        throw new RuntimeException();
    }

    public boolean getFieldNamesOfCommand(String string, int n, boolean bl) {
        Object object;
        try {
            object = new Vector(10);
            DBMetaData.CommandObject commandObject = this.getCommandByName(string, n);
            String[] stringArray = commandObject.xColumns.getElementNames();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object2 = commandObject.xColumns.getByName(stringArray[i]);
                    int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(object2, "Type"));
                    if (JavaTools.FieldInIntTable(this.WidthList, n2) < 0) continue;
                    ((Vector)object).addElement(stringArray[i]);
                }
                stringArray = new String[stringArray.length];
                this.FieldTypes = new int[stringArray.length];
                this.AllFieldNames = new String[((Vector)object).size()];
                ((Vector)object).copyInto(this.AllFieldNames);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        Resource resource = new Resource(this.xMSF, "Database", "dbw");
        object = resource.getResText(1045);
        object = JavaTools.replaceSubString((String)object, string, "%NAME");
        this.showMessageBox("ErrorBox", 0x400000, (String)object);
        return false;
    }

    public String[] getOrderableColumns(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            FieldColumn fieldColumn = this.getFieldColumnByFieldName(stringArray[i]);
            if (!this.getDBDataTypeInspector().isColumnOrderable(fieldColumn.getXColumnPropertySet())) continue;
            vector.addElement(stringArray[i]);
            ++n;
        }
        String[] stringArray2 = new String[n];
        vector.toArray(stringArray2);
        return stringArray2;
    }

    public String getCommandName() {
        return this.Command;
    }

    public void setCommandName(String string) {
        this.Command = string;
    }

    public int getCommandType() {
        return this.CommandType;
    }

    public void setCommandType(int n) {
        this.CommandType = n;
    }

    public boolean isnumeric(FieldColumn fieldColumn) {
        try {
            DBMetaData.CommandObject commandObject = super.getTableByName(fieldColumn.getCommandName());
            Object object = commandObject.xColumns.getByName(fieldColumn.getFieldName());
            int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(object, "Type"));
            int n2 = Arrays.binarySearch(this.NumericTypes, n);
            if (n2 < this.NumericTypes.length && n2 > 0) {
                return this.NumericTypes[n2] == n;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public String[] setNumericFields() {
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (!this.isnumeric(this.FieldColumns[i])) continue;
                vector.addElement(this.FieldColumns[i].getDisplayFieldName());
            }
            this.NumericFieldNames = new String[vector.size()];
            vector.toArray(this.NumericFieldNames);
            return this.NumericFieldNames;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return new String[0];
        }
    }

    public String[] getFieldNames(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!string.equals(this.FieldColumns[i].getCommandName()) || JavaTools.FieldInList(stringArray, this.FieldColumns[i].getDisplayFieldName()) <= -1) continue;
            vector.addElement(this.FieldColumns[i].m_sFieldName);
        }
        String[] stringArray2 = new String[vector.size()];
        vector.toArray(stringArray2);
        return stringArray2;
    }

    public String[] getFieldNames() {
        String[] stringArray = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            stringArray[i] = this.FieldColumns[i].m_sFieldName;
        }
        return stringArray;
    }

    public String[] getDisplayFieldNames() {
        String[] stringArray = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            stringArray[i] = this.FieldColumns[i].getDisplayFieldName();
        }
        return stringArray;
    }

    public String[] setNonAggregateFieldNames() {
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (JavaTools.FieldInTable(this.AggregateFieldNames, this.FieldColumns[i].getDisplayFieldName()) != -1) continue;
                vector.addElement(this.FieldColumns[i].getDisplayFieldName());
            }
            this.NonAggregateFieldNames = new String[vector.size()];
            vector.toArray(this.NonAggregateFieldNames);
            return this.NonAggregateFieldNames;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return new String[0];
        }
    }

    public boolean hasNumericalFields(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.isnumeric(this.getFieldColumnByDisplayName(stringArray[i]))) continue;
                return true;
            }
        }
        return false;
    }

    public String getFieldTitle(String string) {
        String string2 = string;
        if (this.FieldTitleSet != null && (string2 = (String)this.FieldTitleSet.get(string)) == null) {
            return string;
        }
        return string2;
    }

    public void setFieldTitles(String[] stringArray) {
        int n = this.FieldColumns.length;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i >= n) continue;
            this.FieldColumns[i].setFieldTitle(stringArray[i]);
        }
    }

    public String[] getFieldTitles() {
        String[] stringArray = new String[this.FieldColumns.length];
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            stringArray[i] = this.FieldColumns[i].getFieldTitle();
        }
        return stringArray;
    }

    public void setGroupFieldNames(String[] stringArray) {
        this.GroupFieldNames = stringArray;
    }

    public String[] getGroupFieldNames() {
        return this.GroupFieldNames;
    }

    public void createRecordFieldNames() {
        int n = this.FieldColumns.length;
        int n2 = JavaTools.getArraylength(this.GroupFieldNames);
        this.RecordFieldNames = new String[n - n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.FieldColumns[i].m_sFieldName;
            if (JavaTools.FieldInList(this.GroupFieldNames, string) >= 0) continue;
            this.RecordFieldNames[n3] = string;
            ++n3;
        }
    }

    public void setRecordFieldNames(String[] stringArray) {
        this.RecordFieldNames = stringArray;
    }

    public String[] getRecordFieldNames() {
        return this.RecordFieldNames;
    }

    public String getRecordFieldName(int n) {
        return this.RecordFieldNames[n];
    }

    public XComponent[] switchtoDesignmode(String string, int n, XFrame xFrame) {
        XComponent[] xComponentArray = null;
        PropertyValue[] propertyValueArray = new PropertyValue[n == 1 ? 5 : 3];
        propertyValueArray[0] = Properties.createProperty("DataSourceName", this.DataSourceName);
        propertyValueArray[1] = Properties.createProperty("ActiveConnection", this.DBConnection);
        if (n == 1) {
            propertyValueArray[2] = Properties.createProperty("GraphicalDesign", Boolean.TRUE);
            propertyValueArray[3] = Properties.createProperty("Command", string);
            propertyValueArray[4] = Properties.createProperty("CommandType", new Integer(n));
            xComponentArray = this.showCommandView(".component:DB/QueryDesign", propertyValueArray, xFrame);
        } else {
            propertyValueArray[2] = Properties.createProperty("CurrentTable", string);
            xComponentArray = this.showCommandView(".component:DB/TableDesign", propertyValueArray, xFrame);
        }
        return xComponentArray;
    }

    public XComponent[] switchtoDataViewmode(String string, int n, XFrame xFrame) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("DataSourceName", this.DataSourceName), Properties.createProperty("ActiveConnection", this.DBConnection), Properties.createProperty("Command", string), Properties.createProperty("CommandType", new Integer(n)), Properties.createProperty("ShowTreeView", Boolean.FALSE), Properties.createProperty("ShowTreeViewButton", Boolean.FALSE), Properties.createProperty("ShowMenu", Boolean.TRUE)};
        return this.showCommandView(".component:DB/DataSourceBrowser", propertyValueArray, xFrame);
    }

    public XComponent[] showCommandView(String string, PropertyValue[] propertyValueArray, XFrame xFrame) {
        XComponent[] xComponentArray = new XComponent[2];
        try {
            XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)this.xMSF.createInstance("com.sun.star.frame.TaskCreator"));
            Object[] objectArray = new Object[]{Properties.createProperty("ParentFrame", xFrame), Properties.createProperty("TopWindow", Boolean.TRUE)};
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xSingleServiceFactory.createInstanceWithArguments(objectArray));
            xComponentArray[0] = xComponentLoader.loadComponentFromURL(string, "_self", 0, propertyValueArray);
            if (xComponentArray[0] != null) {
                xComponentArray[0] = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xComponentLoader);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return xComponentArray;
    }

    public String[] getReferencedTables(String string, int n) {
        Object[] objectArray = new String[]{};
        try {
            if (n == 0 && this.xDBMetaData.supportsIntegrityEnhancementFacility()) {
                Vector<String> vector = new Vector<String>();
                Object object = this.xTableNames.getByName(string);
                XKeysSupplier xKeysSupplier = (XKeysSupplier)UnoRuntime.queryInterface(XKeysSupplier.class, (Object)object);
                this.xIndexKeys = xKeysSupplier.getKeys();
                for (int i = 0; i < this.xIndexKeys.getCount(); ++i) {
                    String string2;
                    XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xIndexKeys.getByIndex(i));
                    int n2 = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
                    if (n2 != 3 || !this.xTableNames.hasByName(string2 = AnyConverter.toString((Object)xPropertySet.getPropertyValue("ReferencedTable")))) continue;
                    vector.addElement(string2);
                }
                if (vector.size() > 0) {
                    objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return objectArray;
    }

    public String[][] getKeyColumns(String string) {
        String[][] stringArray = null;
        try {
            for (int i = 0; i < this.xIndexKeys.getCount(); ++i) {
                String string2;
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xIndexKeys.getByIndex(i));
                int n = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("Type"));
                if (n != 3 || !this.xTableNames.hasByName(string2 = AnyConverter.toString((Object)xPropertySet.getPropertyValue("ReferencedTable"))) || !string2.equals(string)) continue;
                XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)xPropertySet);
                String[] stringArray2 = xColumnsSupplier.getColumns().getElementNames();
                stringArray = new String[2][stringArray2.length];
                stringArray[0] = stringArray2;
                stringArray[1] = new String[stringArray2.length];
                for (int j = 0; j < stringArray2.length; ++j) {
                    XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xColumnsSupplier.getColumns().getByName(stringArray2[j]));
                    stringArray[1][j] = AnyConverter.toString((Object)xPropertySet2.getPropertyValue("RelatedColumn"));
                }
                return stringArray;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public void openFormDocument(boolean bl) {
        try {
            Object object = this.xMSF.createInstance("com.sun.star.embed.OOoEmbeddedObjectFactory");
            boolean bl2 = false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setCommandComposingAttributes() {
        try {
            boolean bl = this.xDBMetaData.isCatalogAtStart();
            this.sCatalogSep = this.xDBMetaData.getCatalogSeparator();
            this.sIdentifierQuote = this.xDBMetaData.getIdentifierQuoteString();
            this.bCommandComposerAttributesalreadyRetrieved = true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
        }
    }

    public boolean isCatalogAtStart() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.bCatalogAtStart;
    }

    public String getCatalogSeparator() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.sCatalogSep;
    }

    public String getIdentifierQuote() {
        if (!this.bCommandComposerAttributesalreadyRetrieved) {
            this.setCommandComposingAttributes();
        }
        return this.sIdentifierQuote;
    }
}

