/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.servicetag;

import com.sun.star.servicetag.ServiceTag;
import com.sun.star.servicetag.UnauthorizedAccessException;
import com.sun.star.servicetag.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetRegistryHelper {
    private static final String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static final String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static final int ST_ERR_NOT_AUTH = 245;
    private static final int ST_ERR_REC_NOT_FOUND = 225;
    private static final String INSTANCE_URN_OPEN_ELEMENT = "<instance_urn>";
    private static final String INSTANCE_URN_CLOSE_ELEMENT = "</instance_urn>";
    private static final String REGISTRY_URN = "<registry urn=\"";
    private static final String INSTANCE_URN_DESC = "Product instance URN=";
    private static boolean initialized = false;
    private static boolean supportsHelperClass = true;
    private static File stclient = null;
    private static String stclientPath = null;
    private static String SVCTAG_STCLIENT_CMD = "servicetag.stclient.cmd";
    private static String SVCTAG_STHELPER_SUPPORTED = "servicetag.sthelper.supported";

    private static synchronized String getSTclient() {
        if (!initialized) {
            if (System.getProperty(SVCTAG_STHELPER_SUPPORTED) != null) {
                supportsHelperClass = Boolean.getBoolean(SVCTAG_STHELPER_SUPPORTED);
            }
            if ((stclientPath = System.getProperty(SVCTAG_STCLIENT_CMD)) != null) {
                return stclientPath;
            }
            String string = System.getProperty("os.name");
            if (string.equals("SunOS")) {
                stclient = new File(STCLIENT_SOLARIS);
            } else if (string.equals("Linux")) {
                stclient = new File(STCLIENT_LINUX);
            } else if (string.startsWith("Windows")) {
                stclient = Util.getWindowsStClientFile();
            } else if (Util.isVerbose()) {
                System.out.println("Running on non-Sun JDK");
            }
            initialized = true;
        }
        if (stclientPath == null && stclient != null && stclient.exists()) {
            stclientPath = stclient.getAbsolutePath();
        }
        return stclientPath;
    }

    private static List<String> getCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (System.getProperty(SVCTAG_STCLIENT_CMD) != null) {
            String string = SysnetRegistryHelper.getSTclient();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c = ' ';
                if (string.charAt(n2) == '\"') {
                    c = '\"';
                    ++n2;
                }
                for (n3 = n2 + 1; n3 < n && string.charAt(n3) != c; ++n3) {
                }
                if (n2 == n3 - 1) {
                    arrayList.add("\"\"");
                } else {
                    arrayList.add(string.substring(n2, n3));
                }
                for (n2 = n3 + 1; n2 < n && Character.isSpaceChar(string.charAt(n2)); ++n2) {
                }
            }
            if (Util.isVerbose()) {
                System.out.println("Command list:");
                for (String string2 : arrayList) {
                    System.out.println(string2);
                }
            }
        } else {
            arrayList.add(SysnetRegistryHelper.getSTclient());
        }
        return arrayList;
    }

    private static ServiceTag checkReturnError(int n, String string, ServiceTag serviceTag) throws IOException {
        switch (n) {
            case 225: {
                return null;
            }
            case 245: {
                if (serviceTag != null) {
                    throw new UnauthorizedAccessException("Not authorized to access " + serviceTag.getInstanceURN() + " installer_uid=" + serviceTag.getInstallerUID());
                }
                throw new UnauthorizedAccessException("Not authorized:" + string);
            }
        }
        throw new IOException("stclient exits with error (" + n + ")\n" + string);
    }

    private static ServiceTag getServiceTag(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("instanceURN is null");
        }
        List<String> list = SysnetRegistryHelper.getCommandList();
        list.add("-g");
        list.add("-i");
        list.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = processBuilder.start();
        String string2 = Util.commandOutput(process);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -g command:");
            System.out.println(string2);
        }
        if (process.exitValue() == 0) {
            return SysnetRegistryHelper.parseServiceTag(string2);
        }
        return SysnetRegistryHelper.checkReturnError(process.exitValue(), string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceTag parseServiceTag(String string) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray;
            Properties properties = new Properties();
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                stringArray = string2.trim().split("=", 2);
                if (stringArray.length == 2) {
                    properties.setProperty(stringArray[0].trim(), stringArray[1].trim());
                    continue;
                }
                properties.setProperty(stringArray[0].trim(), "");
            }
            stringArray = properties.getProperty("instance_urn");
            String string3 = properties.getProperty("product_name");
            String string4 = properties.getProperty("product_version");
            String string5 = properties.getProperty("product_urn");
            String string6 = properties.getProperty("product_parent");
            String string7 = properties.getProperty("product_parent_urn");
            String string8 = properties.getProperty("product_defined_inst_id");
            String string9 = properties.getProperty("product_vendor");
            String string10 = properties.getProperty("platform_arch");
            String string11 = properties.getProperty("container");
            String string12 = properties.getProperty("source");
            int n = Util.getIntValue(properties.getProperty("installer_uid"));
            Date date = Util.parseTimestamp(properties.getProperty("timestamp"));
            ServiceTag serviceTag = new ServiceTag((String)stringArray, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, n, date);
            return serviceTag;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegistryURN() throws IOException {
        List<String> list = SysnetRegistryHelper.getCommandList();
        list.add("-x");
        BufferedReader bufferedReader = null;
        try {
            String string;
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            Process process = processBuilder.start();
            String string2 = Util.commandOutput(process);
            String string3 = null;
            if (process.exitValue() == 0) {
                bufferedReader = new BufferedReader(new StringReader(string2));
                string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String string4 = string.trim();
                    if (string4.indexOf(REGISTRY_URN) == -1 || (string4 = string4.substring(string4.indexOf(REGISTRY_URN) + REGISTRY_URN.length())).indexOf("\"") == -1) continue;
                    string3 = string4 = string4.substring(0, string4.indexOf("\""));
                    break;
                }
            } else {
                SysnetRegistryHelper.checkReturnError(process.exitValue(), string2, null);
            }
            string = string3;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ServiceTag> getServiceTags() throws IOException {
        List<String> list = SysnetRegistryHelper.getCommandList();
        list.add("-x");
        BufferedReader bufferedReader = null;
        try {
            Object object;
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            Process process = processBuilder.start();
            String string = Util.commandOutput(process);
            HashSet<ServiceTag> hashSet = new HashSet<ServiceTag>();
            if (process.exitValue() == 0) {
                bufferedReader = new BufferedReader(new StringReader(string));
                object = null;
                while ((object = bufferedReader.readLine()) != null) {
                    String string2 = ((String)object).trim();
                    if (string2.indexOf(INSTANCE_URN_OPEN_ELEMENT) == -1 || string2.indexOf(INSTANCE_URN_CLOSE_ELEMENT) == -1) continue;
                    string2 = string2.substring(string2.indexOf(INSTANCE_URN_OPEN_ELEMENT) + INSTANCE_URN_OPEN_ELEMENT.length(), string2.indexOf(INSTANCE_URN_CLOSE_ELEMENT));
                    try {
                        hashSet.add(SysnetRegistryHelper.getServiceTag(string2));
                    }
                    catch (Exception exception) {}
                }
            } else {
                SysnetRegistryHelper.checkReturnError(process.exitValue(), string, null);
            }
            object = hashSet;
            return object;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

