/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.servicetag;

import com.sun.star.servicetag.Installer;
import com.sun.star.servicetag.Util;
import java.io.IOException;
import java.util.Date;

public class ServiceTag {
    private String instanceURN;
    private String productName;
    private String productVersion;
    private String productURN;
    private String productParent;
    private String productParentURN;
    private String productDefinedInstanceID;
    private String productVendor;
    private String platformArch;
    private String container;
    private String source;
    private int installerUID;
    private Date timestamp;
    private final int MAX_URN_LEN = 255;
    private final int MAX_PRODUCT_NAME_LEN = 255;
    private final int MAX_PRODUCT_VERSION_LEN = 63;
    private final int MAX_PRODUCT_PARENT_LEN = 255;
    private final int MAX_PRODUCT_VENDOR_LEN = 63;
    private final int MAX_PLATFORM_ARCH_LEN = 63;
    private final int MAX_CONTAINER_LEN = 63;
    private final int MAX_SOURCE_LEN = 63;

    private ServiceTag() {
    }

    ServiceTag(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n, Date date) {
        this.setInstanceURN(string);
        this.setProductName(string2);
        this.setProductVersion(string3);
        this.setProductURN(string4);
        this.setProductParentURN(string6);
        this.setProductParent(string5);
        this.setProductDefinedInstanceID(string7);
        this.setProductVendor(string8);
        this.setPlatformArch(string9);
        this.setContainer(string10);
        this.setSource(string11);
        this.setInstallerUID(n);
        this.setTimestamp(date);
    }

    public static ServiceTag newInstance(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return new ServiceTag("", string, string2, string3, string4, string5, string6, string7, string8, string9, string10, -1, null);
    }

    public static ServiceTag newInstance(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        return new ServiceTag(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, -1, null);
    }

    static ServiceTag newInstanceWithUrnTimestamp(ServiceTag serviceTag) {
        String string = serviceTag.getInstanceURN().length() == 0 ? Util.generateURN() : serviceTag.getInstanceURN();
        ServiceTag serviceTag2 = new ServiceTag(string, serviceTag.getProductName(), serviceTag.getProductVersion(), serviceTag.getProductURN(), serviceTag.getProductParent(), serviceTag.getProductParentURN(), serviceTag.getProductDefinedInstanceID(), serviceTag.getProductVendor(), serviceTag.getPlatformArch(), serviceTag.getContainer(), serviceTag.getSource(), serviceTag.getInstallerUID(), new Date());
        return serviceTag2;
    }

    public static String generateInstanceURN() {
        return Util.generateURN();
    }

    public String getInstanceURN() {
        return this.instanceURN;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductURN() {
        return this.productURN;
    }

    public String getProductParentURN() {
        return this.productParentURN;
    }

    public String getProductParent() {
        return this.productParent;
    }

    public String getProductDefinedInstanceID() {
        return this.productDefinedInstanceID;
    }

    public String getProductVendor() {
        return this.productVendor;
    }

    public String getPlatformArch() {
        return this.platformArch;
    }

    public Date getTimestamp() {
        if (this.timestamp != null) {
            return (Date)this.timestamp.clone();
        }
        return null;
    }

    public String getContainer() {
        return this.container;
    }

    public String getSource() {
        return this.source;
    }

    public int getInstallerUID() {
        return this.installerUID;
    }

    private void setInstanceURN(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter instanceURN cannot be null");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("instanceURN \"" + string + "\" exceeds maximum length " + 255);
        }
        this.instanceURN = string;
    }

    private void setProductName(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productName cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("product name cannot be empty");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("productName \"" + string + "\" exceeds maximum length " + 255);
        }
        this.productName = string;
    }

    private void setProductVersion(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productVersion cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("product version cannot be empty");
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException("productVersion \"" + string + "\" exceeds maximum length " + 63);
        }
        this.productVersion = string;
    }

    private void setProductURN(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productURN cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("product URN cannot be empty");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("productURN \"" + string + "\" exceeds maximum length " + 255);
        }
        this.productURN = string;
    }

    private void setProductParentURN(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productParentURN cannot be null");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("productParentURN \"" + string + "\" exceeds maximum length " + 255);
        }
        this.productParentURN = string;
    }

    private void setProductParent(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productParent cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("product parent cannot be empty");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("productParent \"" + string + "\" exceeds maximum length " + 255);
        }
        this.productParent = string;
    }

    void setProductDefinedInstanceID(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productDefinedInstanceID cannot be null");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("productDefinedInstanceID \"" + string + "\" exceeds maximum length " + 255);
        }
        this.productDefinedInstanceID = string;
    }

    private void setProductVendor(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter productVendor cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("product vendor cannot be empty");
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException("productVendor \"" + string + "\" exceeds maximum length " + 63);
        }
        this.productVendor = string;
    }

    private void setPlatformArch(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter platformArch cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("platform architecture cannot be empty");
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException("platformArch \"" + string + "\" exceeds maximum length " + 63);
        }
        this.platformArch = string;
    }

    private void setTimestamp(Date date) {
        this.timestamp = date;
    }

    private void setContainer(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter container cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("container cannot be empty");
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException("container \"" + string + "\" exceeds maximum length " + 63);
        }
        this.container = string;
    }

    private void setSource(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter source cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("source cannot be empty");
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException("source \"" + string + "\" exceeds maximum length " + 63);
        }
        this.source = string;
    }

    private void setInstallerUID(int n) {
        this.installerUID = n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ServiceTag)) {
            return false;
        }
        ServiceTag serviceTag = (ServiceTag)object;
        if (serviceTag == this) {
            return true;
        }
        return serviceTag.getInstanceURN().equals(this.getInstanceURN());
    }

    public int hashCode() {
        int n = 7;
        n = 19 * n + (this.instanceURN != null ? this.instanceURN.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("instance_urn").append("=").append(this.instanceURN).append("\n");
        stringBuilder.append("product_name").append("=").append(this.productName).append("\n");
        stringBuilder.append("product_version").append("=").append(this.productVersion).append("\n");
        stringBuilder.append("product_urn").append("=").append(this.productURN).append("\n");
        stringBuilder.append("product_parent_urn").append("=").append(this.productParentURN).append("\n");
        stringBuilder.append("product_parent").append("=").append(this.productParent).append("\n");
        stringBuilder.append("product_defined_inst_id").append("=").append(this.productDefinedInstanceID).append("\n");
        stringBuilder.append("product_vendor").append("=").append(this.productVendor).append("\n");
        stringBuilder.append("platform_arch").append("=").append(this.platformArch).append("\n");
        stringBuilder.append("timestamp").append("=").append(Util.formatTimestamp(this.timestamp)).append("\n");
        stringBuilder.append("container").append("=").append(this.container).append("\n");
        stringBuilder.append("source").append("=").append(this.source).append("\n");
        stringBuilder.append("installer_uid").append("=").append(String.valueOf(this.installerUID)).append("\n");
        return stringBuilder.toString();
    }

    public static ServiceTag getJavaServiceTag(String string) throws IOException {
        return Installer.getJavaServiceTag(string);
    }
}

