/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.style.I18n;
import writer2latex.latex.style.StyleMap;
import writer2latex.util.BooleanOption;
import writer2latex.util.IntegerOption;
import writer2latex.util.Misc;
import writer2latex.util.Option;
import writer2latex.xmerge.NewDOMDocument;

public class Config {
    public static final int GENERIC = 0;
    public static final int DVIPS = 1;
    public static final int PDFTEX = 2;
    public static final int IGNORE_ALL = 0;
    public static final int IGNORE_MOST = 1;
    public static final int CONVERT_BASIC = 2;
    public static final int CONVERT_MOST = 3;
    public static final int CONVERT_ALL = 4;
    public static final int CONVERT_HEADER_FOOTER = 5;
    private static final int CREATE_USER_CONFIG = 0;
    private static final int BACKEND = 1;
    private static final int NO_PREAMBLE = 2;
    private static final int DOCUMENTCLASS = 3;
    private static final int GLOBAL_OPTIONS = 4;
    private static final int INPUTENCODING = 5;
    private static final int MULTILINGUAL = 6;
    private static final int GREEK_MATH = 7;
    private static final int USE_OOOMATH = 8;
    private static final int USE_PIFONT = 9;
    private static final int USE_IFSYM = 10;
    private static final int USE_WASYSYM = 11;
    private static final int USE_BBDING = 12;
    private static final int USE_EUROSYM = 13;
    private static final int USE_TIPA = 14;
    private static final int USE_COLOR = 15;
    private static final int USE_HYPERREF = 16;
    private static final int USE_ENDNOTES = 17;
    private static final int USE_ULEM = 18;
    private static final int USE_LASTPAGE = 19;
    private static final int USE_BIBTEX = 20;
    private static final int BIBTEX_STYLE = 21;
    private static final int FORMATTING = 22;
    private static final int PAGE_FORMATTING = 23;
    private static final int IGNORE_HARD_PAGE_BREAKS = 24;
    private static final int IGNORE_HARD_LINE_BREAKS = 25;
    private static final int IGNORE_EMPTY_PARAGRAPHS = 26;
    private static final int IGNORE_DOUBLE_SPACES = 27;
    private static final int DEBUG = 28;
    private static final int OPTION_COUNT = 29;
    Option[] options = new Option[29];
    protected boolean bDebug = false;
    protected LinkedList customPreamble = new LinkedList();
    protected StyleMap par = new StyleMap();
    protected StyleMap parBlock = new StyleMap();
    protected StyleMap text = new StyleMap();
    protected StyleMap list = new StyleMap();
    protected StyleMap listItem = new StyleMap();
    protected HeadingMap headingMap = new HeadingMap(5);
    protected Hashtable mathSymbols = new Hashtable();

    public Config() {
        Object object;
        this.options[0] = new BooleanOption("create_user_config", "true");
        this.options[2] = new BooleanOption("no_preamble", "false");
        this.options[3] = new Option("documentclass", "article");
        this.options[4] = new Option("global_options", "");
        this.options[1] = new IntegerOption("backend", "generic"){

            void setString(String string) {
                super.setString(string);
                if ("generic".equals(string)) {
                    this.nValue = 0;
                } else if ("dvips".equals(string)) {
                    this.nValue = 1;
                } else if ("pdftex".equals(string)) {
                    this.nValue = 2;
                }
            }
        };
        this.options[5] = new IntegerOption("inputencoding", I18n.writeInputenc(0)){

            void setString(String string) {
                super.setString(string);
                this.nValue = I18n.readInputenc(string);
            }
        };
        this.options[6] = new BooleanOption("multilingual", "true");
        this.options[7] = new BooleanOption("greek_math", "true");
        this.options[8] = new BooleanOption("use_ooomath", "false");
        this.options[9] = new BooleanOption("use_pifont", "false");
        this.options[10] = new BooleanOption("use_ifsym", "false");
        this.options[11] = new BooleanOption("use_wasysym", "false");
        this.options[12] = new BooleanOption("use_bbding", "false");
        this.options[13] = new BooleanOption("use_eurosym", "false");
        this.options[14] = new BooleanOption("use_tipa", "false");
        this.options[15] = new BooleanOption("use_color", "true");
        this.options[16] = new BooleanOption("use_hyperref", "true");
        this.options[17] = new BooleanOption("use_endnotes", "false");
        this.options[18] = new BooleanOption("use_ulem", "false");
        this.options[19] = new BooleanOption("use_lastpage", "false");
        this.options[20] = new BooleanOption("use_bibtex", "false");
        this.options[21] = new Option("bibtex_style", "plain");
        this.options[22] = new IntegerOption("formatting", "convert_basic"){

            void setString(String string) {
                super.setString(string);
                if ("convert_all".equals(string)) {
                    this.nValue = 4;
                } else if ("convert_most".equals(string)) {
                    this.nValue = 3;
                } else if ("convert_basic".equals(string)) {
                    this.nValue = 2;
                } else if ("ignore_most".equals(string)) {
                    this.nValue = 1;
                } else if ("ignore_all".equals(string)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[23] = new IntegerOption("page_formatting", "convert_all"){

            void setString(String string) {
                super.setString(string);
                if ("convert_all".equals(string)) {
                    this.nValue = 4;
                } else if ("convert_header_footer".equals(string)) {
                    this.nValue = 5;
                } else if ("ignore_all".equals(string)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[24] = new BooleanOption("ignore_hard_page_breaks", "false");
        this.options[25] = new BooleanOption("ignore_hard_line_breaks", "false");
        this.options[26] = new BooleanOption("ignore_empty_paragraphs", "false");
        this.options[27] = new BooleanOption("ignore_double_spaces", "false");
        this.options[28] = new BooleanOption("debug", "false");
        this.headingMap.setLevelData(1, "section", 1);
        this.headingMap.setLevelData(2, "subsection", 2);
        this.headingMap.setLevelData(3, "subsubsection", 3);
        this.headingMap.setLevelData(4, "paragraph", 4);
        this.headingMap.setLevelData(5, "subparagraph", 5);
        String string = this.getClass().getResource("Config.class").toString();
        String string2 = string.substring(string.indexOf("file:"), string.indexOf("writer2latex.jar!"));
        String string3 = string2 + "writer2latex.xml";
        try {
            object = new File(new URI(string3));
            if (((File)object).exists()) {
                this.read(((File)object).getPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = System.getProperty("user.home") + System.getProperty("file.separator") + "writer2latex.xml";
        File file = new File((String)object);
        if (file.exists()) {
            this.read((String)object);
        } else if (this.createUserConfig()) {
            this.write((String)object);
        }
    }

    public void read(String string) {
        NewDOMDocument newDOMDocument = new NewDOMDocument(string, ".xml");
        try {
            newDOMDocument.read(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.out.println("Oops - I cannot read the configuration file " + string);
            iOException.printStackTrace();
            return;
        }
        Document document = newDOMDocument.getContentDOM();
        if (document == null) {
            System.out.println("Oops - I cannot understand the contents of the configuration file " + string);
            return;
        }
        Element element = document.getDocumentElement();
        if (!element.hasChildNodes()) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        block2: for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            Object object2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNodeName();
            if (string2.equals("option")) {
                object2 = Misc.getAttribute(node, "name");
                String string3 = Misc.getAttribute(node, "value");
                for (n2 = 0; n2 < 29; ++n2) {
                    if (!this.options[n2].getName().equals(object2)) continue;
                    this.options[n2].setString(string3);
                    continue block2;
                }
                continue;
            }
            if (string2.equals("style-map")) {
                object2 = Misc.getAttribute(node, "name");
                String string4 = Misc.getAttribute(node, "class");
                String string5 = Misc.getAttribute(node, "before");
                object = Misc.getAttribute(node, "after");
                boolean bl = !"false".equals(Misc.getAttribute(node, "line-break"));
                boolean bl2 = "true".equals(Misc.getAttribute(node, "verbatim"));
                if ("paragraph".equals(string4)) {
                    this.par.put((String)object2, string5, (String)object, bl, bl2);
                }
                if ("paragraph-block".equals(string4)) {
                    String string6 = Misc.getAttribute(node, "next");
                    this.parBlock.put((String)object2, string5, (String)object, string6);
                    continue;
                }
                if ("text".equals(string4)) {
                    this.text.put((String)object2, string5, (String)object, false, bl2);
                    continue;
                }
                if ("list".equals(string4)) {
                    this.list.put((String)object2, string5, (String)object);
                    continue;
                }
                if (!"listitem".equals(string4)) continue;
                this.listItem.put((String)object2, string5, (String)object);
                continue;
            }
            if (string2.equals("heading-map")) {
                this.readHeadingMap(node);
                continue;
            }
            if (string2.equals("custom-preamble")) {
                if (!node.hasChildNodes()) continue;
                object2 = node.getChildNodes();
                int n3 = object2.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    object = object2.item(n2);
                    if (object.getNodeType() != 3) continue;
                    this.customPreamble.add(object.getNodeValue());
                }
                continue;
            }
            if (!string2.equals("math-symbol-map")) continue;
            object2 = Misc.getAttribute(node, "name");
            String string7 = Misc.getAttribute(node, "latex");
            this.mathSymbols.put(object2, string7);
        }
    }

    public void readHeadingMap(Node node) {
        int n = Misc.getPosInteger(Misc.getAttribute(node, "max-level"), 0);
        this.headingMap.reset(n);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !(string = node2.getNodeName()).equals("heading-level-map")) continue;
            int n3 = Misc.getPosInteger(Misc.getAttribute(node2, "writer-level"), 1);
            String string2 = Misc.getAttribute(node2, "name");
            int n4 = Misc.getPosInteger(Misc.getAttribute(node2, "level"), 0);
            this.headingMap.setLevelData(n3, string2, n4);
        }
    }

    public void write(String string) {
        Element element;
        Object object;
        Object object2;
        NewDOMDocument newDOMDocument = new NewDOMDocument(string, ".xml");
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object = documentBuilder.getDOMImplementation();
            document = object.createDocument("", "config", null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        object2 = document.getDocumentElement();
        for (int i = 0; i < 29; ++i) {
            object = document.createElement("option");
            object.setAttribute("name", this.options[i].getName());
            object.setAttribute("value", this.options[i].getString());
            object2.appendChild((Node)object);
        }
        Enumeration enumeration = this.mathSymbols.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = (String)this.mathSymbols.get(object);
            element = document.createElement("math-symbol-map");
            element.setAttribute("name", (String)object);
            element.setAttribute("latex", string2);
            object2.appendChild(element);
        }
        this.writeStyleMap(document, this.par, "paragraph");
        this.writeStyleMap(document, this.parBlock, "paragraph-block");
        this.writeStyleMap(document, this.text, "text");
        this.writeStyleMap(document, this.list, "list");
        this.writeStyleMap(document, this.listItem, "listitem");
        object = document.createElement("heading-map");
        object.setAttribute("max-level", Integer.toString(this.headingMap.getMaxLevel()));
        object2.appendChild((Node)object);
        for (int i = 1; i <= this.headingMap.getMaxLevel(); ++i) {
            element = document.createElement("heading-level-map");
            element.setAttribute("writer-level", Integer.toString(i));
            element.setAttribute("name", this.headingMap.getName(i));
            element.setAttribute("level", Integer.toString(this.headingMap.getLevel(i)));
            object.appendChild(element);
        }
        this.writeContent(document, this.customPreamble, "custom-preamble");
        newDOMDocument.setContentDOM(document);
        try {
            newDOMDocument.write(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            System.out.println("Oops - problem writing the configuration");
            iOException.printStackTrace();
        }
    }

    public boolean createUserConfig() {
        return ((BooleanOption)this.options[0]).getValue();
    }

    public boolean debug() {
        return ((BooleanOption)this.options[28]).getValue();
    }

    public String getDocumentclass() {
        return this.options[3].getString();
    }

    public String getGlobalOptions() {
        return this.options[4].getString();
    }

    public int getBackend() {
        return ((IntegerOption)this.options[1]).getValue();
    }

    public int getInputencoding() {
        return ((IntegerOption)this.options[5]).getValue();
    }

    public boolean multilingual() {
        return ((BooleanOption)this.options[6]).getValue();
    }

    public boolean greekMath() {
        return ((BooleanOption)this.options[7]).getValue();
    }

    public boolean noPreamble() {
        return ((BooleanOption)this.options[2]).getValue();
    }

    public boolean useOoomath() {
        return ((BooleanOption)this.options[8]).getValue();
    }

    public boolean usePifont() {
        return ((BooleanOption)this.options[9]).getValue();
    }

    public boolean useIfsym() {
        return ((BooleanOption)this.options[10]).getValue();
    }

    public boolean useWasysym() {
        return ((BooleanOption)this.options[11]).getValue();
    }

    public boolean useBbding() {
        return ((BooleanOption)this.options[12]).getValue();
    }

    public boolean useEurosym() {
        return ((BooleanOption)this.options[13]).getValue();
    }

    public boolean useTipa() {
        return ((BooleanOption)this.options[14]).getValue();
    }

    public boolean useColor() {
        return ((BooleanOption)this.options[15]).getValue();
    }

    public boolean useHyperref() {
        return ((BooleanOption)this.options[16]).getValue();
    }

    public boolean useEndnotes() {
        return ((BooleanOption)this.options[17]).getValue();
    }

    public boolean useUlem() {
        return ((BooleanOption)this.options[18]).getValue();
    }

    public boolean useLastpage() {
        return ((BooleanOption)this.options[19]).getValue();
    }

    public boolean useBibtex() {
        return ((BooleanOption)this.options[20]).getValue();
    }

    public String bibtexStyle() {
        return this.options[21].getString();
    }

    public int formatting() {
        return ((IntegerOption)this.options[22]).getValue();
    }

    public int pageFormatting() {
        return ((IntegerOption)this.options[23]).getValue();
    }

    public boolean ignoreHardPageBreaks() {
        return ((BooleanOption)this.options[24]).getValue();
    }

    public boolean ignoreHardLineBreaks() {
        return ((BooleanOption)this.options[25]).getValue();
    }

    public boolean ignoreEmptyParagraphs() {
        return ((BooleanOption)this.options[26]).getValue();
    }

    public boolean ignoreDoubleSpaces() {
        return ((BooleanOption)this.options[27]).getValue();
    }

    public Hashtable getMathSymbols() {
        return this.mathSymbols;
    }

    public StyleMap getParStyleMap() {
        return this.par;
    }

    public StyleMap getParBlockStyleMap() {
        return this.parBlock;
    }

    public StyleMap getTextStyleMap() {
        return this.text;
    }

    public StyleMap getListStyleMap() {
        return this.list;
    }

    public StyleMap getListItemStyleMap() {
        return this.listItem;
    }

    public HeadingMap getHeadingMap() {
        return this.headingMap;
    }

    public LinkedList getCustomPreamble() {
        return this.customPreamble;
    }

    private void writeStyleMap(Document document, StyleMap styleMap, String string) {
        Enumeration enumeration = styleMap.getNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Element element = document.createElement("style-map");
            element.setAttribute("name", string2);
            element.setAttribute("class", string);
            element.setAttribute("before", styleMap.getBefore(string2));
            element.setAttribute("after", styleMap.getAfter(string2));
            if (styleMap.getNext(string2) != null) {
                element.setAttribute("next", styleMap.getNext(string2));
            }
            if (!styleMap.getLineBreak(string2)) {
                element.setAttribute("line-break", "false");
            }
            if (styleMap.getVerbatim(string2)) {
                element.setAttribute("verbatim", "true");
            }
            document.getDocumentElement().appendChild(element);
        }
    }

    private void writeContent(Document document, LinkedList linkedList, String string) {
        Element element = document.createElement(string);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            element.appendChild(document.createTextNode((String)linkedList.get(i)));
        }
        document.getDocumentElement().appendChild(element);
    }
}

