/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHUnaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;
    public boolean postfix = false;

    BSHUnaryExpression(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        try {
            if (this.kind == 100 || this.kind == 101) {
                LHS lHS = ((BSHPrimaryExpression)simpleNode).toLHS(callStack, interpreter);
                return this.lhsUnaryOperation(lHS, interpreter.getStrictJava());
            }
            return this.unaryOperation(simpleNode.eval(callStack, interpreter), this.kind);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    private Object lhsUnaryOperation(LHS lHS, boolean bl) throws UtilEvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("lhsUnaryOperation");
        }
        Object object = lHS.getValue();
        Object object2 = this.unaryOperation(object, this.kind);
        Object object3 = this.postfix ? object : object2;
        lHS.assign(object2, bl);
        return object3;
    }

    private Object unaryOperation(Object object, int n) throws UtilEvalError {
        if (object instanceof Boolean || object instanceof Character || object instanceof Number) {
            return this.primitiveWrapperUnaryOperation(object, n);
        }
        if (!(object instanceof Primitive)) {
            throw new UtilEvalError("Unary operation " + tokenImage[n] + " inappropriate for object");
        }
        return Primitive.unaryOperation((Primitive)object, n);
    }

    private Object primitiveWrapperUnaryOperation(Object object, int n) throws UtilEvalError {
        Class<?> clazz = object.getClass();
        Object object2 = Primitive.promoteToInteger(object);
        if (object2 instanceof Boolean) {
            return new Boolean(Primitive.booleanUnaryOperation((Boolean)object2, n));
        }
        if (object2 instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object2, n);
            if (n == 100 || n == 101) {
                if (clazz == Byte.TYPE) {
                    return new Byte((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Short((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Character((char)n2);
                }
            }
            return new Integer(n2);
        }
        if (object2 instanceof Long) {
            return new Long(Primitive.longUnaryOperation((Long)object2, n));
        }
        if (object2 instanceof Float) {
            return new Float(Primitive.floatUnaryOperation((Float)object2, n));
        }
        if (object2 instanceof Double) {
            return new Double(Primitive.doubleUnaryOperation((Double)object2, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }
}

