/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.CodeSource;
import com.sun.star.lib.sandbox.Permission;
import com.sun.star.lib.sandbox.PermissionCollection;
import java.security.Identity;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;

public final class ProtectionDomain {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("ProtectionDomain");
        }
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
    }

    public PermissionCollection getPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("ProtectionDomain");
        }
        return this.permissionCollection;
    }

    boolean isTrusted() {
        Identity[] identityArray = this.codeSource.identities;
        boolean bl = false;
        if (identityArray != null) {
            int n;
            for (n = 0; n < identityArray.length && !bl; ++n) {
                System.out.println("XXX:" + identityArray[n].toString(true));
            }
            for (n = 0; n < identityArray.length; ++n) {
                SystemIdentity systemIdentity;
                if (identityArray[n] instanceof SystemIdentity) {
                    systemIdentity = (SystemIdentity)identityArray[n];
                    bl = systemIdentity.isTrusted();
                    continue;
                }
                if (!(identityArray[n] instanceof SystemSigner)) continue;
                systemIdentity = (SystemSigner)identityArray[n];
                bl = systemIdentity.isTrusted();
            }
        }
        return bl;
    }

    boolean implies(Permission permission) {
        return this.isTrusted() || this.permissionCollection.implies(permission);
    }
}

