/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class PdbHeader {
    byte[] pdbName = null;
    short attribute = 0;
    int version = 0;
    long creationDate = 0L;
    long modificationDate = 0L;
    long lastBackupDate = 0L;
    long modificationNumber = 0L;
    int appInfoID = 0;
    int sortInfoID = 0;
    int typeID = 0;
    int creatorID = 0;
    int uniqueIDSeed = 0;
    int nextRecordListID = 0;
    int numRecords = 0;

    PdbHeader() {
    }

    public void read(DataInput dataInput) throws IOException {
        this.pdbName = new byte[32];
        dataInput.readFully(this.pdbName);
        this.attribute = dataInput.readShort();
        this.version = dataInput.readUnsignedShort();
        this.creationDate = (long)dataInput.readInt() & 0xFFFFFFFFL;
        this.modificationDate = (long)dataInput.readInt() & 0xFFFFFFFFL;
        this.lastBackupDate = (long)dataInput.readInt() & 0xFFFFFFFFL;
        this.modificationNumber = (long)dataInput.readInt() & 0xFFFFFFFFL;
        this.appInfoID = dataInput.readInt();
        this.sortInfoID = dataInput.readInt();
        this.creatorID = dataInput.readInt();
        this.typeID = dataInput.readInt();
        this.uniqueIDSeed = dataInput.readInt();
        this.nextRecordListID = dataInput.readInt();
        this.numRecords = dataInput.readUnsignedShort();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.pdbName);
        dataOutput.writeShort(this.attribute);
        dataOutput.writeShort(this.version);
        dataOutput.writeInt((int)this.creationDate);
        dataOutput.writeInt((int)this.modificationDate);
        dataOutput.writeInt((int)this.lastBackupDate);
        dataOutput.writeInt((int)this.modificationNumber);
        dataOutput.writeInt(this.appInfoID);
        dataOutput.writeInt(this.sortInfoID);
        dataOutput.writeInt(this.typeID);
        dataOutput.writeInt(this.creatorID);
        dataOutput.writeInt(this.uniqueIDSeed);
        dataOutput.writeInt(this.nextRecordListID);
        dataOutput.writeShort(this.numRecords);
    }
}

