/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.Convert;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterFactory;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.test.ConverterInfoList;
import org.openoffice.xmerge.util.registry.ConverterInfoMgr;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;

public final class Driver {
    private String fromMime = null;
    private String toMime = null;
    private String mergeFile = null;
    private Vector deviceFiles = new Vector();
    private String[] mimeTypes = new String[]{"sxc", "staroffice/sxc", "sxw", "staroffice/sxw"};

    public static void main(String[] stringArray) {
        Object object;
        String string = "ConverterInfoList.properties";
        ConverterInfoList converterInfoList = null;
        try {
            converterInfoList = new ConverterInfoList(string);
        }
        catch (Exception exception) {
            System.out.println("\nCannot not load " + string + " property file");
        }
        Enumeration enumeration = converterInfoList.getJarFileEnum();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            try {
                ConverterInfoReader converterInfoReader = new ConverterInfoReader((String)object, false);
                Enumeration enumeration2 = converterInfoReader.getConverterInfoEnumeration();
                ConverterInfoMgr.addPlugIn(enumeration2);
            }
            catch (Exception exception) {
                System.out.println("\nCannot not load <" + (String)object + "> from the <" + string + "> property file");
            }
        }
        try {
            object = new Driver();
            super.parseCommandLine(stringArray);
            super.doConversion();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = illegalArgumentException.getMessage();
            if (string2 != null) {
                System.out.println("\n" + string2);
            }
            Driver.showUsage();
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 != null) {
                System.out.println("\n" + string3);
            }
            exception.printStackTrace();
        }
    }

    private void doConversion() throws IllegalArgumentException {
        block14: {
            Object object;
            Object object2;
            Object object3;
            ConverterFactory converterFactory = new ConverterFactory();
            Convert convert = converterFactory.getConverter(this.fromMime, this.toMime);
            String string = null;
            if (convert == null) {
                System.out.println("\nNo plug-in exists to convert from <" + this.fromMime + "> to <" + this.toMime + ">");
                throw new IllegalArgumentException();
            }
            try {
                object3 = this.deviceFiles.elements();
                while (object3.hasMoreElements()) {
                    string = (String)object3.nextElement();
                    object2 = new File(string);
                    if (!((File)object2).exists()) {
                        System.out.println(string + " does not exist!");
                        System.exit(0);
                    }
                    object = new FileInputStream((File)object2);
                    convert.addInputStream(((File)object2).getName(), (InputStream)object);
                }
            }
            catch (Exception exception) {
                System.out.println("\nFile <" + string + "> is not in <" + this.fromMime + "> format");
                throw new IllegalArgumentException();
            }
            object3 = null;
            try {
                object3 = convert.convert();
            }
            catch (Exception exception) {
                System.out.println("\nThere was an error in the conversion");
                exception.printStackTrace();
            }
            if (object3 == null) break block14;
            if (this.mergeFile == null) {
                object2 = ((ConvertData)object3).getDocumentEnumeration();
                while (object2.hasMoreElements()) {
                    object = (Document)object2.nextElement();
                    String string2 = object.getFileName();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        object.write(fileOutputStream);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        System.out.println("\nThere was an writing out file <" + string2 + ">");
                        exception.printStackTrace();
                    }
                }
            } else {
                try {
                    object2 = new FileInputStream(this.mergeFile);
                    object = convert.getOfficeDocument(this.mergeFile, (InputStream)object2);
                    DocumentMerger documentMerger = convert.getDocumentMerger((Document)object);
                    Enumeration enumeration = ((ConvertData)object3).getDocumentEnumeration();
                    Document document = (Document)enumeration.nextElement();
                    documentMerger.merge(document);
                    ((FileInputStream)object2).close();
                    FileOutputStream fileOutputStream = new FileOutputStream(this.mergeFile);
                    object.write(fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    System.out.println("\nThere was an error in the merge");
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void showUsage() {
        System.out.println("\nUsage:");
        System.out.println("\n   java org.openoffice.xmerge.test.Driver <args>");
        System.out.println("\n   where <args> is as follows:");
        System.out.println("   -from <MIMETYPE> -to <MIMETYPE> [ -merge <OrigDoc ] <document>\n");
    }

    private void parseCommandLine(String[] stringArray) throws IllegalArgumentException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if ("-to".equals(string)) {
                this.toMime = this.extractArg(i, stringArray);
                for (n = 0; n < this.mimeTypes.length; n += 2) {
                    if (!this.mimeTypes[n].equals(this.extractArg(i, stringArray))) continue;
                    this.toMime = this.mimeTypes[n + 1];
                }
                ++i;
                continue;
            }
            if ("-from".equals(string)) {
                this.fromMime = this.extractArg(i, stringArray);
                for (n = 0; n < this.mimeTypes.length; n += 2) {
                    if (!this.mimeTypes[n].equals(this.extractArg(i, stringArray))) continue;
                    this.fromMime = this.mimeTypes[n + 1];
                }
                ++i;
                continue;
            }
            if ("-merge".equals(string)) {
                this.mergeFile = this.extractArg(i, stringArray);
                if (!this.isZip(this.mergeFile)) {
                    throw new IllegalArgumentException("Arg " + i + ": expected zip, got " + this.mergeFile);
                }
                ++i;
                continue;
            }
            this.deviceFiles.add(string);
        }
        System.out.println("\nConverting from " + this.fromMime + " to " + this.toMime + (this.mergeFile != null ? " with merge " : " "));
    }

    private String extractArg(int n, String[] stringArray) throws IllegalArgumentException {
        if (n + 1 < stringArray.length) {
            return stringArray[n + 1];
        }
        throw new IllegalArgumentException("Arg " + n + ": expected arg for " + stringArray[n]);
    }

    private boolean isZip(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith("sxw") || string.endsWith("sxc");
    }
}

