/**********************************************************************
 * $Id: SegmentIntersector.h 1820 2006-09-06 16:54:23Z mloskot $
 *
 * GEOS - Geometry Engine Open Source
 * http://geos.refractions.net
 *
 * Copyright (C) 2005-2006 Refractions Research Inc.
 * Copyright (C) 2001-2002 Vivid Solutions Inc.
 *
 * This is free software; you can redistribute and/or modify it under
 * the terms of the GNU Lesser General Public Licence as published
 * by the Free Software Foundation. 
 * See the COPYING file for more information.
 *
 **********************************************************************/

#ifndef GEOS_GEOMGRAPH_INDEX_SEGMENTINTERSECTOR_H
#define GEOS_GEOMGRAPH_INDEX_SEGMENTINTERSECTOR_H

#include <vector>

#include <geos/geom/Coordinate.h> // for composition

// Forward declarations
namespace geos {
	namespace algorithm {
		class LineIntersector;
	}
	namespace geomgraph {
		class Node;
		class Edge;
	}
}

namespace geos {
namespace geomgraph { // geos::geomgraph
namespace index { // geos::geomgraph::index


class SegmentIntersector{

private:

	/**
	 * These variables keep track of what types of intersections were
	 * found during ALL edges that have been intersected.
	 */
	bool hasIntersectionVar;

	bool hasProper;

	bool hasProperInterior;

	// the proper intersection point found
	geom::Coordinate properIntersectionPoint;

	algorithm::LineIntersector *li;

	bool includeProper;

	bool recordIsolated;

	//bool isSelfIntersection;

	//bool intersectionFound;

	int numIntersections;

	/// Elements are externally owned
	std::vector<std::vector<Node*>*> bdyNodes;

	bool isTrivialIntersection(Edge *e0,int segIndex0,Edge *e1, int segIndex1);

	bool isBoundaryPoint(algorithm::LineIntersector *li,
			std::vector<std::vector<Node*>*>& tstBdyNodes);

	bool isBoundaryPoint(algorithm::LineIntersector *li,
			std::vector<Node*> *tstBdyNodes);

public:

	static bool isAdjacentSegments(int i1,int i2);

	// testing only
	int numTests;

	//SegmentIntersector();

	virtual ~SegmentIntersector() {}

	SegmentIntersector(algorithm::LineIntersector *newLi,
			bool newIncludeProper, bool newRecordIsolated)
		:
		hasIntersectionVar(false),
		hasProper(false),
		hasProperInterior(false),
		li(newLi),
		includeProper(newIncludeProper),
		recordIsolated(newRecordIsolated),
		numIntersections(0),
		bdyNodes(2),
		numTests(0)
	{}

	/// \brief
	/// Parameters are externally owned.
	/// Make sure they live for the whole lifetime of this object
	void setBoundaryNodes(std::vector<Node*> *bdyNodes0,
			std::vector<Node*> *bdyNodes1);

	geom::Coordinate& getProperIntersectionPoint();

	bool hasIntersection();

	bool hasProperIntersection();

	bool hasProperInteriorIntersection();

	void addIntersections(Edge *e0, int segIndex0, Edge *e1, int segIndex1);

};


} // namespace geos.geomgraph.index
} // namespace geos.geomgraph
} // namespace geos

#endif

/**********************************************************************
 * $Log$
 * Revision 1.1  2006/03/14 12:55:55  strk
 * Headers split: geomgraphindex.h, nodingSnapround.h
 *
 **********************************************************************/

