#!/bin/bash
# GEOS
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-24
# require:
#
SRC_URI=http://geos.refractions.net/downloads/geos-3.0.0.tar.bz2
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.bz2}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/gis
PAC_DIR=$PLAMO/Packages/4.5/GIS
BUILD_DIR=$PLAMO/geos
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


bzip2 -dc $SRC_DIR/$SRC_FILE  | tar xvf -
cd $PAC_NAME
 ./configure --prefix=/usr
 make
 make install DESTDIR=$WORK

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
      AUTHORS  COPYING  ChangeLog  INSTALL  NEWS  README  TODO \
	$WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR


# make package
cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
