#!/bin/bash
# OpenLayers	(http://openlayers.org/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-11-23
# require:
#	readline
#
SRC_URI=http://openlayers.org/download/OpenLayers-2.7.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
#SRC_NAME=${SRC_FILE%%.tar.gz}
#VERSION=${SRC_NAME##*_}
#PAC_NAME=${SRC_NAME%%_$VERSION}-$VERSION
#PAC_NAME=${SRC_NAME%%-stable}
#echo $PAC_NAME; exit

REL=P1
CPU=noname
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/gis/
PAC_DIR=$PLAMO/Packages/4.5/10_gis
BUILD_DIR=$PLAMO/openlayers
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_URI=http://prdownloads.sourceforge.net/naturaldocs/NaturalDocs-1.4.zip
PAT_FILE=${PAT_URI##*/}


echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/opt/teTeX/bin:/opt/php5/bin

if [! -f  "$PAT_FILE" ]; then
  wget -N $PAT_URI
fi
if [! -d naturaldocs ]; then
  mkdir naturaldocs
  (cd naturaldocs; unzip ../$PAT_FILE )
fi

tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME || exit 1
  cd build
    ./build.py
  cd ..

  ../naturaldocs/NaturalDocs -i lib/ -o HTML doc/ -p doc_config/ -s Default OL

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
    `find . -maxdepth 1 -type f -name  "[A-Z]*" | grep -vi makefile` \
    $WORK/$DOC_DIR/
cp -p $BUILD_DIR/`basename $0`  \
    *.txt    $WORK/$DOC_DIR/
mkdir -p  $WORK/$DOC_DIR/html || exit 1
mv -v  doc     $WORK/$DOC_DIR/html/
chown -R root.root $WORK/$DOC_DIR/
chmod -R a+rX,go-w $WORK/$DOC_DIR/


mkdir -p $WORK/install || exit 1
cat > $WORK/install/doinst.sh<<EOF
#%% begin initialize ${PAC_NAME}-${SYS_NAME}
(cd ./opt/htdocs && \
 rm -f OpenLayers; ln -sf $PAC_NAME OpenLayers)
(cd ./opt/htdocs && /bin/chown wadm:apache $PAC_NAME)
#%% end
EOF

mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://openlayers.org/
DOC	/${DOC_DIR}/
EXE	/OpenLayers/examples/
REM	OpenLayers, JavaScript library for map application
__EOCL__

mv -v $BUILD_DIR/$PAC_NAME $WORK/opt/htdocs/

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD

