
#include <linux/fb_doublebyte.h>

extern int fbcon_softback_size;
DBFontManager *UniconFontManager = NULL;
EXPORT_SYMBOL (UniconFontManager);

const unsigned short * hibyte_pos(struct vc_data *vc, const unsigned short *p)
{
	unsigned long pos=(long)p;
	if (pos >= vc->vc_origin && pos < vc->vc_scr_end) {
		/* pos in the vc buffer - Chrisl 99.11.12*/
		return (unsigned short*)(pos+vc->vc_screenbuf_size);
	} else if (vc->vc_num == fg_console){
		/*&& softback_lines,because the scroll will first change
		softback_lines, then call this function, so it is ignored here
							    -JimChen 99.11.12*/
		return (unsigned short*)(pos+fbcon_softback_size);
	} else {
		/* Should not happen */
		printk("Warnning, changing not active console\n");
		return p;
	}
}

static int fbcon_get_dchar_len (struct vc_data *vc,
                                struct display *p,
                                const unsigned short *s, int count)
{
        int n, i;
        struct double_byte * doublebyte_default = NULL;
        unsigned short charmask = vc->vc_hi_font_mask ? 0x1ff : 0xff;

        if (UniconFontManager != NULL)
                doublebyte_default = UniconFontManager->getfont (vc->vc_num);
        if (!doublebyte_default)
                return 0;

        for (n = 0, i = 0; i < count; i++, s++){
                if (doublebyte_default->is_left (*s & charmask) == 1 ||
                    doublebyte_default->is_right (*s & charmask) == 1)
                        n++;
        else
                break;
        }
        return n;
}

static int fbcon_get_schar_len (struct vc_data *vc,
                                struct display *p,
                                const unsigned short *s, int count)
{
        int n, i;
        struct double_byte * doublebyte_default = NULL;
        unsigned short charmask = vc->vc_hi_font_mask ? 0x1ff : 0xff;

        if (UniconFontManager != NULL)
                doublebyte_default = UniconFontManager->getfont (vc->vc_num);
        if (!doublebyte_default)
                return count;

        for (n = 0, i = 0; i < count; i++, s++){
                if (doublebyte_default->is_left (*s & charmask) == 0 &&
                    doublebyte_default->is_right (*s & charmask) == 0)
                        n++;
                else
                        break;
        }
        return n;
}
