/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIBookmarkTransactionManager.idl
 */

#ifndef __gen_nsIBookmarkTransactionManager_h__
#define __gen_nsIBookmarkTransactionManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIRDFResource; /* forward declaration */

class nsIRDFNode; /* forward declaration */

class nsIRDFLiteral; /* forward declaration */

class nsITransactionManager; /* forward declaration */


/* starting interface:    nsIBookmarkTransactionManager */
#define NS_IBOOKMARKTRANSACTIONMANAGER_IID_STR "f6305e79-1760-4991-ab4d-a42db60f0e67"

#define NS_IBOOKMARKTRANSACTIONMANAGER_IID \
  {0xf6305e79, 0x1760, 0x4991, \
    { 0xab, 0x4d, 0xa4, 0x2d, 0xb6, 0x0f, 0x0e, 0x67 }}

/**
 * nsIBookmarkTransactionService is a service designed to handle
 * nsITransactions that correspond to changes in bookmarks.  It is here as a 
 * service so that we can keep the transactions around without holding onto 
 * the whole global js scope+window.
 */
class NS_NO_VTABLE nsIBookmarkTransactionManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBOOKMARKTRANSACTIONMANAGER_IID)

  /**
   * Performs a new transaction according to the specified parameters
   *
   * @param aType         the type of transaction being performed.  Must be one
   *                      of the three constants defined below
   * @param aAction       the action to be performed.  Expected values are:
   *                          import, insert, move, and remove (see bookmarks.js)
   * @param aItem         the rdf node the transaction is being performed on
   * @param aIndex        the index of the item in its RDF Container
   * @param aParent       the rdf-parent of aItem, that is, the folder it
   *                      should be inserted into.
   * @param aRemovedProps properties removed from the item in question
   * 
   */
  /* void createAndCommitTxn (in unsigned long aType, in AString aAction, in nsIRDFNode aItem, in long aIndex, in nsIRDFResource aParent, in unsigned long aPropCount, [array, size_is (aPropCount)] in nsIRDFLiteral aRemovedProps); */
  NS_IMETHOD CreateAndCommitTxn(PRUint32 aType, const nsAString & aAction, nsIRDFNode *aItem, PRInt32 aIndex, nsIRDFResource *aParent, PRUint32 aPropCount, nsIRDFLiteral **aRemovedProps) = 0;

  /**
   * Constants corresponding to the 3 different types of transactions possible
   * Note that moving bookmarks is a combination of REMOVE+INSERT
   */
  enum { IMPORT = 0U };

  enum { INSERT = 1U };

  enum { REMOVE = 2U };

  /**
   * Signals the transaction manager that a series of transactions are going to
   * be performed, but that, for the purposes of undo and redo, they should all
   * be regarded as a single transaction.  That is, a single undo() call will 
   * undo all of the transactions created and committed between startBatch() and
   * endBatch().  See also nsITransactionManager::beginBatch
   *
   * @note if startBatch() is called multiple times.  The batch will not end
   *       endBatch() has been called the same number of times.
   */
  /* void startBatch (); */
  NS_IMETHOD StartBatch(void) = 0;

  /**
   * Ends the batch transaction in process, subject to the note above about
   * multiple, successive calls of startBatch().  See also
   * nsITransactionManager::endBatch
   */
  /* void endBatch (); */
  NS_IMETHOD EndBatch(void) = 0;

  /**
   * Undo the last transaction in the transaction manager's stack
   */
  /* void undo (); */
  NS_IMETHOD Undo(void) = 0;

  /**
   * Returns true if it is possible to undo a transaction at this time
   */
  /* boolean canUndo (); */
  NS_IMETHOD CanUndo(PRBool *_retval) = 0;

  /**
   * Redo the last transaction
   */
  /* void redo (); */
  NS_IMETHOD Redo(void) = 0;

  /**
   * Returns true if it is possible to redo a transaction at this time
   */
  /* boolean canRedo (); */
  NS_IMETHOD CanRedo(PRBool *_retval) = 0;

  /**
   * A reference to the transaction manager for bookmarks
   */
  /* readonly attribute nsITransactionManager transactionManager; */
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBOOKMARKTRANSACTIONMANAGER \
  NS_IMETHOD CreateAndCommitTxn(PRUint32 aType, const nsAString & aAction, nsIRDFNode *aItem, PRInt32 aIndex, nsIRDFResource *aParent, PRUint32 aPropCount, nsIRDFLiteral **aRemovedProps); \
  NS_IMETHOD StartBatch(void); \
  NS_IMETHOD EndBatch(void); \
  NS_IMETHOD Undo(void); \
  NS_IMETHOD CanUndo(PRBool *_retval); \
  NS_IMETHOD Redo(void); \
  NS_IMETHOD CanRedo(PRBool *_retval); \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBOOKMARKTRANSACTIONMANAGER(_to) \
  NS_IMETHOD CreateAndCommitTxn(PRUint32 aType, const nsAString & aAction, nsIRDFNode *aItem, PRInt32 aIndex, nsIRDFResource *aParent, PRUint32 aPropCount, nsIRDFLiteral **aRemovedProps) { return _to CreateAndCommitTxn(aType, aAction, aItem, aIndex, aParent, aPropCount, aRemovedProps); } \
  NS_IMETHOD StartBatch(void) { return _to StartBatch(); } \
  NS_IMETHOD EndBatch(void) { return _to EndBatch(); } \
  NS_IMETHOD Undo(void) { return _to Undo(); } \
  NS_IMETHOD CanUndo(PRBool *_retval) { return _to CanUndo(_retval); } \
  NS_IMETHOD Redo(void) { return _to Redo(); } \
  NS_IMETHOD CanRedo(PRBool *_retval) { return _to CanRedo(_retval); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) { return _to GetTransactionManager(aTransactionManager); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBOOKMARKTRANSACTIONMANAGER(_to) \
  NS_IMETHOD CreateAndCommitTxn(PRUint32 aType, const nsAString & aAction, nsIRDFNode *aItem, PRInt32 aIndex, nsIRDFResource *aParent, PRUint32 aPropCount, nsIRDFLiteral **aRemovedProps) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateAndCommitTxn(aType, aAction, aItem, aIndex, aParent, aPropCount, aRemovedProps); } \
  NS_IMETHOD StartBatch(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartBatch(); } \
  NS_IMETHOD EndBatch(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->EndBatch(); } \
  NS_IMETHOD Undo(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Undo(); } \
  NS_IMETHOD CanUndo(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CanUndo(_retval); } \
  NS_IMETHOD Redo(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Redo(); } \
  NS_IMETHOD CanRedo(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CanRedo(_retval); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransactionManager(aTransactionManager); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBookmarkTransactionManager : public nsIBookmarkTransactionManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBOOKMARKTRANSACTIONMANAGER

  nsBookmarkTransactionManager();

private:
  ~nsBookmarkTransactionManager();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBookmarkTransactionManager, nsIBookmarkTransactionManager)

nsBookmarkTransactionManager::nsBookmarkTransactionManager()
{
  /* member initializers and constructor code */
}

nsBookmarkTransactionManager::~nsBookmarkTransactionManager()
{
  /* destructor code */
}

/* void createAndCommitTxn (in unsigned long aType, in AString aAction, in nsIRDFNode aItem, in long aIndex, in nsIRDFResource aParent, in unsigned long aPropCount, [array, size_is (aPropCount)] in nsIRDFLiteral aRemovedProps); */
NS_IMETHODIMP nsBookmarkTransactionManager::CreateAndCommitTxn(PRUint32 aType, const nsAString & aAction, nsIRDFNode *aItem, PRInt32 aIndex, nsIRDFResource *aParent, PRUint32 aPropCount, nsIRDFLiteral **aRemovedProps)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startBatch (); */
NS_IMETHODIMP nsBookmarkTransactionManager::StartBatch()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void endBatch (); */
NS_IMETHODIMP nsBookmarkTransactionManager::EndBatch()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void undo (); */
NS_IMETHODIMP nsBookmarkTransactionManager::Undo()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean canUndo (); */
NS_IMETHODIMP nsBookmarkTransactionManager::CanUndo(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void redo (); */
NS_IMETHODIMP nsBookmarkTransactionManager::Redo()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean canRedo (); */
NS_IMETHODIMP nsBookmarkTransactionManager::CanRedo(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsITransactionManager transactionManager; */
NS_IMETHODIMP nsBookmarkTransactionManager::GetTransactionManager(nsITransactionManager * *aTransactionManager)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIBookmarkTransactionManager_h__ */
