#!/usr/bin/env python

## Printing troubleshooter

## Copyright (C) 2008 Red Hat, Inc.
## Copyright (C) 2008 Tim Waugh <twaugh@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import cups
from base import *
from base import _
class CheckLocalServerPublishing(Question):
    def __init__ (self, troubleshooter):
        Question.__init__ (self, troubleshooter, "Is local server publishing?")
        vbox = self.initial_vbox (_("Server Not Exporting Printers"),
                                  _("Although one or more printers are marked "
                                    "as being shared, this print server is "
                                    "not exporting shared printers to the "
                                    "network.") + '\n\n' +
                                  _("Enable the 'Share published printers "
                                    "connected to this system' option in "
                                    "the server settings using the printing "
                                    "administration tool.") + ' ' +
                                  TEXT_start_print_admin_tool)
        troubleshooter.new_page (vbox, self)

    def display (self):
        self.answers = {}
        cups.setServer ('')
        try:
            c = cups.Connection ()
            printers = c.getPrinters ()
            if len (printers) == 0:
                return False

            for name, printer in printers.iteritems ():
                if printer.get ('printer-is-shared', False):
                    break

            attr = c.getPrinterAttributes (name)
        except RuntimeError:
            return False
        except cups.IPPError:
            return False

        if not printer.get ('printer-is-shared', False):
            return False

        if attr.get ('server-is-sharing-printers', True):
            # server-is-sharing-printers is in CUPS 1.4
            return False

        return True

    def collect_answer (self):
        if self.displayed:
            return { 'local_server_exporting_printers': False }

        return {}
