;;;
;;; Copyright (c) 2003-2007 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;
;; kanji extracted from Unihan-4.0.1d3b.txt, a work in progress file
;; from <http://www.unicode.org/Public/4.0-Update1/>
(define pyunihan-rule
  '(((("a"))("吖" "啊" "嗄" "腌" "錒" "锕" "阿"))
    ((("a" "i"))("㑸" "㕌" "㗒" "㗨" "㘷" "㝶" "㢊" "㤅" "㱯" "㿄" "䀳" "䅬" "䑂" "䔽" "䝽" "䠹" "䨠" "䬵" "䶣" "伌" "佁" "僾" "叆" "呆" "哀" "哎" "唉" "啀" "嗌" "嗳" "嘊" "噯" "埃" "堨" "塧" "壒" "娭" "娾" "嫒" "嬡" "嵦" "愛" "懓" "懝" "戹" "挨" "捱" "敱" "敳" "昹" "暧" "曖" "欸" "毐" "濭" "爱" "瑷" "璦" "癌" "皑" "皚" "皧" "瞹" "矮" "砨" "砹" "硋" "硙" "碍" "磑" "礙" "艾" "蔼" "薆" "藹" "誒" "譪" "诶" "賹" "躷" "銰" "鎄" "鑀" "锿" "閡" "阨" "阸" "隘" "霭" "靄" "靉" "餲" "馤" "騃" "鴱"))
    ((("a" "n"))("㜝" "㟁" "㱘" "㸩" "㽢" "䁆" "䅁" "䅖" "䎏" "䎨" "䜙" "䬓" "䮗" "䯥" "侒" "俺" "儑" "匎" "匼" "厂" "厈" "唵" "啽" "垵" "埯" "堓" "媕" "安" "岸" "峎" "峖" "广" "庵" "按" "揞" "攣" "晻" "暗" "案" "桉" "氨" "洝" "犴" "玵" "痷" "癴" "盒" "盦" "盫" "罯" "胺" "腌" "腤" "荌" "菴" "萻" "葊" "蓭" "蝻" "誝" "諳" "谙" "豻" "鉗" "銨" "錌" "铵" "闇" "阥" "阴" "陰" "隂" "隌" "雸" "鞌" "鞍" "韽" "頇" "馣" "鮟" "鵪" "鶕" "鹌" "黬" "黯"))
    ((("a" "n" "g"))("㦹" "㭿" "㼜" "䀚" "䍩" "䒢" "䩕" "䬓" "䭹" "䭺" "仰" "卬" "岇" "昂" "昻" "枊" "盎" "肮" "軮" "醠" "雵" "骯"))
    ((("a" "o"))("㑃" "㕭" "㘬" "㘭" "㜜" "㜩" "㟼" "㠂" "㠗" "㤇" "㥿" "㿰" "䁱" "䐿" "䚫" "䜒" "䞝" "䥝" "䦋" "䫨" "䮯" "䯠" "䴈" "䵅" "傲" "凹" "厫" "嗷" "嗸" "嚣" "圫" "坳" "垇" "墺" "奡" "奥" "奧" "媪" "媼" "嫯" "岙" "嶅" "嶴" "廒" "慠" "懊" "扷" "抝" "拗" "摮" "擙" "敖" "柪" "梎" "棍" "浇" "滶" "澆" "澳" "熬" "燠" "爊" "狕" "獒" "獓" "璈" "磝" "磽" "翱" "翺" "聱" "芺" "蔜" "螯" "袄" "襖" "詏" "謷" "謸" "軪" "遨" "鏊" "鏖" "镺" "隞" "隩" "驁" "骜" "鰲" "鳌" "鷔" "鼇" "𥜌"))
    ((("b" "a"))("㔜" "㖠" "㞎" "㧊" "㶚" "䃻" "䆉" "䇑" "䎬" "䎱" "䟦" "䥯" "䩗" "䩻" "䰾" "䱝" "䳁" "䳊" "仈" "伯" "八" "叐" "叭" "吧" "哵" "坝" "坺" "垻" "墢" "壩" "夿" "妭" "岜" "峇" "巴" "弝" "扒" "把" "抜" "拔" "捌" "朳" "杷" "欛" "湃" "灞" "炦" "爸" "犮" "猈" "玐" "疤" "癹" "秡" "笆" "粑" "罢" "罷" "羓" "耙" "胈" "芭" "茇" "菝" "覇" "詙" "豝" "跋" "軷" "釟" "鈀" "鈸" "钯" "钹" "霸" "靶" "颰" "馛" "魃" "鮁" "鮊" "鲃" "鲅" "鲌" "鼥"))
    ((("b" "a" "i"))("㗑" "㗗" "㠔" "㼟" "㼣" "㿟" "䒔" "䙓" "䢙" "䥯" "䳆" "䴽" "伯" "佰" "呗" "唄" "庍" "拜" "拝" "捭" "掰" "摆" "擺" "敗" "柏" "栢" "棑" "派" "白" "百" "矲" "稗" "粨" "粺" "絔" "罢" "罷" "薜" "蛽" "襬" "贁" "败" "鞴"))
    ((("b" "a" "n"))("㚘" "㩯" "㪵" "㸞" "㺜" "䉽" "䕰" "䬳" "伴" "办" "半" "坂" "埿" "姅" "岅" "怑" "扮" "扳" "拌" "搬" "攽" "斑" "斒" "昄" "朌" "板" "湴" "版" "班" "瓣" "瘢" "癍" "秚" "粄" "絆" "绊" "肦" "舨" "般" "虨" "蝂" "螌" "褩" "辦" "辨" "辬" "辯" "鈑" "鉡" "钣" "闆" "阪" "靽" "頒" "颁" "魬"))
    ((("b" "a" "n" "g"))("㔙" "㭋" "㮄" "㯁" "㾦" "䂜" "䎧" "䖫" "䟺" "䧛" "䰷" "並" "傍" "垹" "埲" "塝" "帮" "幇" "幚" "幫" "挷" "捠" "搒" "旁" "梆" "棒" "棓" "榜" "氆" "浜" "牓" "玤" "磅" "稖" "竝" "紡" "綁" "縍" "纺" "绑" "膀" "艕" "蒡" "蚌" "蜯" "螃" "謗" "谤" "邦" "邫" "鎊" "镑" "鞤" "髈"))
    ((("b" "a" "o"))("㙅" "㙸" "㫧" "㲏" "㲒" "㵡" "㻄" "㿺" "䈏" "䎂" "䤖" "䥤" "䨌" "䨔" "䪨" "䭋" "䳈" "䳰" "䴐" "保" "儤" "刨" "剝" "剥" "勹" "勽" "包" "堡" "堢" "報" "嫑" "孢" "宝" "宲" "寚" "寳" "寶" "忁" "怉" "抔" "报" "抱" "掊" "暴" "曓" "枹" "瀑" "炮" "煲" "爆" "犦" "珤" "瓟" "窇" "笣" "緥" "胞" "脬" "苞" "苴" "菢" "葆" "蕔" "薄" "虣" "袌" "袍" "裒" "褒" "褓" "褴" "襃" "豹" "賲" "趵" "鉋" "鑤" "铇" "雹" "靌" "鞄" "飽" "饱" "駂" "骲" "鮑" "鲍" "鳵" "鴇" "鸔" "鸨"))
    ((("b" "e" "i"))("㓈" "㔨" "㛝" "㣁" "㤳" "㰆" "㱯" "㶔" "㷶" "㸢" "㸬" "㸽" "㻗" "㼎" "㾱" "䁅" "䋳" "䔒" "䟺" "䠙" "䡶" "䩀" "䰽" "伓" "俻" "倍" "偝" "偹" "備" "僃" "北" "卑" "呗" "唄" "埤" "壀" "备" "孛" "岥" "庳" "悖" "悲" "惫" "愂" "憊" "拔" "排" "揹" "昁" "杮" "杯" "桮" "梖" "棓" "椑" "波" "焙" "牬" "犕" "犤" "狈" "狽" "珼" "琲" "痺" "盃" "碑" "碚" "禆" "箄" "簰" "糒" "紴" "絥" "綼" "背" "臂" "菩" "萆" "葡" "蓓" "藣" "蜚" "被" "褙" "誖" "貝" "贝" "跋" "軰" "輩" "辈" "邶" "郥" "鄁" "鉳" "鋇" "錃" "鐾" "钡" "陂" "鞁" "鞴" "韛" "骳" "鵯" "鹎"))
    ((("b" "e" "n"))("㡷" "㤓" "㨧" "㮺" "㱵" "䬱" "体" "倴" "坌" "夯" "夲" "奔" "奙" "捹" "撪" "本" "栟" "桳" "楍" "泍" "渀" "燌" "犇" "獖" "畚" "笨" "苯" "蟦" "賁" "贲" "軬" "輽" "逩" "錛" "鐼" "锛"))
    ((("b" "e" "n" "g"))("㑟" "㛝" "㱶" "㷯" "䋽" "䙀" "䨻" "䩬" "䭰" "䳞" "伻" "唪" "嘣" "埲" "堋" "塴" "崩" "嵭" "抨" "挷" "搒" "榜" "槰" "泵" "玤" "琫" "甏" "甭" "祊" "絣" "綳" "繃" "绷" "菶" "蚌" "螷" "蠯" "誁" "跰" "蹦" "迸" "逬" "錋" "鏰" "镚" "閍" "鞛"))
    ((("b" "i"))("㓖" "㕭" "㗉" "㘠" "㘩" "㙄" "㚰" "㠲" "㡀" "㡙" "㢰" "㢶" "㢸" "㧙" "㪏" "㪤" "㮄" "㮰" "㮿" "㯇" "㱸" "㳼" "㵥" "㵨" "㷶" "㹃" "㻫" "㻶" "㿫" "䀣" "䁅" "䁹" "䃾" "䄶" "䇷" "䊧" "䋔" "䌟" "䎵" "䏢" "䏶" "䐿" "䕗" "䖩" "䘡" "䟆" "䟤" "䠋" "䣥" "䦘" "䧗" "䨆" "䩛" "䪐" "䫁" "䫾" "䬛" "䭮" "䮡" "䯗" "䵄" "佊" "佖" "俾" "偪" "匕" "吡" "咇" "哔" "啚" "嗶" "坒" "埤" "堛" "壀" "壁" "夶" "奰" "妣" "妼" "婢" "嬖" "屄" "币" "幣" "庇" "庳" "廦" "弊" "弻" "弼" "彃" "彼" "必" "怭" "愊" "愎" "拂" "敝" "斃" "服" "朼" "枇" "枈" "柀" "柲" "梐" "楅" "檗" "檘" "殍" "比" "毕" "毖" "毙" "毴" "沘" "泌" "波" "湢" "滗" "滭" "潷" "濞" "煏" "熚" "狴" "獘" "獙" "珌" "璧" "畀" "畁" "畢" "疕" "疪" "痹" "痺" "皀" "皕" "睤" "睥" "瞥" "碧" "秕" "秘" "稫" "笔" "筆" "筚" "箄" "箅" "箆" "篦" "篳" "粃" "粊" "紕" "綼" "縪" "繴" "纰" "罷" "罼" "聛" "肥" "肸" "肹" "脾" "腷" "臂" "舭" "芘" "苾" "荜" "荸" "菝" "萆" "蓖" "蓽" "蔽" "薜" "蘖" "蚍" "蜌" "螕" "螷" "袐" "被" "裨" "襞" "襣" "觱" "詖" "诐" "豍" "貏" "貱" "費" "賁" "贔" "贲" "费" "赑" "跛" "跸" "蹕" "躃" "躄" "辟" "逼" "避" "邲" "鄙" "鄨" "鄪" "鉍" "鎞" "鏎" "鐴" "鐾" "铋" "閇" "閉" "閟" "闭" "陂" "陛" "陴" "鞞" "鞸" "韠" "颷" "飶" "饆" "馝" "馥" "駜" "驆" "骳" "髀" "髲" "魓" "魮" "鮅" "鰏" "鲾" "鵖" "鷝" "鷩" "鸊" "鼊" "鼻"))
    ((("b" "i" "a" "n"))("㝸" "㣐" "㦚" "㭓" "㲢" "㳎" "㳒" "㴜" "㵷" "㺹" "㻞" "䁵" "䉸" "䒪" "䛒" "䡢" "䪻" "便" "匥" "匾" "卞" "变" "変" "弁" "徧" "忭" "惼" "扁" "抃" "揙" "昪" "汳" "汴" "煸" "牑" "猵" "獱" "玣" "甂" "砭" "碥" "稨" "稹" "窆" "笾" "箯" "籩" "糄" "編" "緶" "缏" "编" "艑" "苄" "萹" "藊" "蝙" "褊" "覍" "變" "貶" "贬" "辡" "辧" "辨" "辩" "辫" "辮" "辯" "边" "辺" "遍" "邉" "邊" "釆" "鍽" "閞" "鞭" "鯾" "鯿" "鳊" "鴘"))
    ((("b" "i" "a" "o"))("㟽" "㠒" "㧼" "㯱" "㯹" "䔸" "䞄" "俵" "儦" "墂" "婊" "幖" "彪" "徱" "摽" "杓" "标" "標" "檦" "滮" "漂" "瀌" "灬" "焱" "熛" "爂" "猋" "瘭" "磦" "穮" "脿" "膘" "臕" "苞" "蔈" "藨" "表" "裱" "褾" "覅" "諘" "謤" "贆" "錶" "鏖" "鏢" "鑣" "镖" "镳" "颩" "颮" "飆" "飇" "飈" "飍" "飑" "飙" "飚" "驃" "驫" "骉" "骠" "髟" "鰾" "鳔" "麃" "麅" bie "㓖" "㜩" "㢼" "㱸" "㲢" "㿜" "䇷" "䉲" "䋢" "䏟" "䠥" "䭱" "別" "别" "彆" "徶" "憋" "瘪" "癟" "秘" "莂" "虌" "蛂" "蟞" "襒" "蹩" "鱉" "鳖" "鷩" "鼈" "龞"))
    ((("b" "i" "e"))("㓖" "㜩" "㢼" "㱸" "㲢" "㿜" "䇷" "䉲" "䋢" "䏟" "䠥" "䭱" "別" "别" "彆" "徶" "憋" "瘪" "癟" "秘" "莂" "虌" "蛂" "蟞" "襒" "蹩" "鱉" "鳖" "鷩" "鼈" "龞"))
    ((("b" "i" "n"))("䐔" "䳁" "份" "傧" "儐" "宾" "彬" "摈" "擯" "攽" "斌" "梹" "椕" "槟" "檳" "殡" "殯" "汃" "浜" "滨" "濒" "濱" "瀕" "獱" "玢" "瑸" "璸" "矉" "禀" "繽" "缤" "膑" "臏" "蠙" "豩" "豳" "賓" "賔" "邠" "鑌" "镔" "霦" "頻" "顮" "频" "馪" "驞" "髌" "髕" "髩" "鬂" "鬓" "鬢")) 
    ((("b" "i" "n" "g"))("㓈" "㨀" "䈂" "䋑" "䓑" "䗒" "䴵" "丙" "並" "仌" "併" "倂" "偋" "傡" "兵" "冫" "冰" "寎" "屏" "屛" "并" "幷" "廪" "怲" "抦" "掤" "摒" "昞" "昺" "枋" "柄" "栟" "栤" "梹" "棅" "槟" "檳" "氷" "炳" "燹" "琕" "病" "癛" "癝" "眪" "禀" "秉" "稟" "窉" "竝" "絣" "綆" "苪" "蛃" "迸" "邴" "鈵" "鉼" "陃" "靐" "鞞" "餅" "餠" "饼" "鮩" "鵧")) 
    ((("b" "o"))("㑟" "㔜" "㖕" "㗘" "㙸" "㝿" "㟑" "㧳" "㩧" "㩭" "㪍" "㬍" "㬧" "㱟" "㴾" "㶿" "㹀" "㼎" "㼣" "䂍" "䊿" "䍨" "䍸" "䑈" "䒄" "䗚" "䙏" "䞳" "䟆" "䟛" "䟦" "䢌" "䢪" "䥬" "䨌" "䪇" "䪬" "䫊" "䬪" "䭦" "䭯" "䮀" "䮂" "䯋" "䰊" "䰷" "䳁" "䵄" "䶈" "亳" "伯" "佰" "侼" "僰" "剝" "剥" "勃" "博" "发" "哱" "啵" "嚗" "坺" "墢" "壆" "孛" "孹" "嶏" "嶓" "帛" "彂" "悖" "愽" "懪" "拍" "拨" "挀" "挬" "搏" "撥" "播" "擘" "敀" "暴" "曓" "柏" "柭" "栢" "桲" "檗" "欂" "泊" "波" "泺" "泼" "浡" "渤" "溥" "潑" "潘" "濼" "瀑" "煿" "爆" "牔" "犦" "犻" "猼" "玻" "瓝" "瓟" "番" "疈" "癶" "發" "白" "百" "盋" "砵" "碆" "磻" "礡" "礴" "箔" "箥" "簙" "簸" "簿" "糪" "繴" "缽" "胉" "脖" "膊" "般" "舶" "艊" "艴" "苩" "茀" "荸" "菔" "菠" "菩" "葧" "蒲" "蔔" "蕃" "薄" "薜" "蘖" "蘗" "蚾" "袚" "袯" "襏" "襮" "誖" "謈" "譒" "豰" "趵" "跑" "跛" "踄" "踣" "蹳" "郣" "鈸" "鉑" "鉢" "鋍" "鎛" "鑮" "钵" "钹" "铂" "镈" "雹" "餑" "餺" "饽" "馎" "馞" "駁" "駊" "駮" "驋" "驳" "髆" "髉" "魄" "鮁" "鮊" "鱍" "鲅" "鲌" "鵓" "鹁"))
    ((("b" "u"))("㘵" "㙛" "㚴" "㨐" "㳍" "㻉" "㾟" "䀯" "䊇" "䋠" "䍌" "䏽" "䑰" "䒈" "䝵" "䪁" "䪔" "䬏" "䳝" "䴝" "䴺" "不" "佈" "卜" "卟" "卩" "吥" "咘" "哺" "埔" "埗" "埠" "堡" "峬" "布" "庯" "怖" "悑" "惚" "扑" "捕" "捗" "擈" "晡" "步" "歨" "歩" "溥" "瓿" "篰" "簿" "纀" "荹" "菩" "蔀" "薄" "补" "補" "誧" "轐" "逋" "部" "郶" "醭" "鈈" "鈽" "钚" "钸" "附" "鞴" "餔" "餢" "鮬" "鳪" "鵏"))
    ((("c" "a"))("䟃" "䵽" "嚓" "囃" "拆" "擦" "磣" "礤" "蔡"))
    ((("c" "a" "i"))("㒲" "㥒" "䌨" "䌽" "䐆" "䣋" "䰂" "䴭" "䴺" "倸" "埰" "婇" "寀" "彩" "才" "採" "材" "棌" "溨" "犲" "猜" "睬" "綵" "縩" "纔" "菜" "蔡" "裁" "財" "财" "跐" "跴" "踩" "釆" "采"))
    ((("c" "a" "n"))("㘔" "㛑" "㜗" "㣓" "㥇" "㦧" "㨻" "㱚" "㺑" "㻮" "㽩" "㿊" "䅟" "䍼" "䏼" "䑶" "䗝" "䗞" "䘉" "䙁" "䛹" "䝳" "䣟" "䫮" "䬫" "䳻" "傪" "参" "參" "叄" "叅" "喰" "嬠" "嬱" "孱" "惨" "惭" "慘" "慙" "慚" "憯" "掺" "摻" "昝" "朁" "残" "殘" "淺" "湌" "澯" "灿" "燦" "璨" "穇" "粲" "蓡" "薒" "蚕" "蝅" "蠶" "蠺" "謲" "飡" "餐" "驂" "骖" "鰺" "黪" "黲"))
    ((("c" "a" "n" "g"))("㵴" "㶓" "䅮" "䢢" "仓" "仺" "伧" "倉" "傖" "凔" "匨" "嵢" "沧" "滄" "獊" "臧" "舱" "艙" "苍" "蒼" "蔵" "藏" "螥" "賶" "鑶" "鶬" "鸧")) 
    ((("c" "a" "o"))("㜖" "㯥" "㽩" "䄚" "䏆" "䐬" "䒃" "䒑" "傮" "嘈" "屮" "嶆" "愺" "慅" "慥" "懆" "撡" "操" "曹" "曺" "槽" "漕" "澡" "糙" "肏" "艚" "艸" "草" "蓸" "螬" "褿" "襙" "造" "鄵" "鏪" "騲"))
    ((("c" "e"))("㥽" "㨲" "㩍" "䇲" "䈟" "䊂" "䔴" "䜺" "侧" "側" "冊" "册" "厕" "厠" "嫧" "廁" "恻" "惻" "憡" "拺" "敇" "柵" "栅" "测" "測" "溭" "畟" "矠" "笧" "策" "筞" "筴" "箣" "粣" "茦" "荝" "萗" "萴" "蓛" "赦" "遪" "頙"))
    ((("c" "e" "n"))("㞥" "㻸" "䃡" "䅾" "䤁" "䨙" "䯔" "䲋" "参" "參" "叄" "叅" "埁" "岑" "嵾" "梣" "梫" "橬" "涔" "硶" "笒" "篸"))
    ((("c" "e" "n" "g"))("㣒" "㬝" "䁬" "䉕" "噌" "层" "層" "嶒" "曽" "曾" "碀" "竲" "繒" "缯" "蹭" "鄫"))
    ((("c" "h" "a"))("㛳" "㢉" "㢎" "㢒" "㣾" "㤞" "㪯" "㫅" "䁟" "䆛" "䊬" "䑘" "䒲" "䓭" "䕓" "䟕" "䡨" "䤩" "䰈" "䲦" "䶪" "侘" "偛" "刹" "剎" "叉" "吒" "咤" "喳" "嗏" "垞" "奼" "姹" "嫅" "察" "岔" "嵖" "扠" "扱" "挿" "插" "揷" "搋" "搽" "擑" "杈" "查" "査" "楂" "槎" "檫" "汊" "疀" "痄" "碴" "秅" "紁" "肞" "臿" "艖" "苴" "茬" "茶" "荖" "荼" "蜡" "衩" "訍" "詧" "詫" "诧" "蹅" "釵" "銟" "鍤" "鑔" "锸" "镲" "靫" "餷" "馇" "𦉆"))
    ((("c" "h" "a" "i"))("㑪" "㳗" "㾹" "䓱" "䘍" "䡨" "侪" "儕" "喍" "囆" "差" "拆" "柴" "犲" "瘥" "祡" "芆" "茈" "茝" "虿" "蠆" "袃" "豺" "釵" "钗" "靫" "齜"))
    ((("c" "h" "a" "n"))("㔆" "㙴" "㙻" "㢆" "㢟" "㦃" "㬄" "㯆" "㵌" "㶣" "㸥" "㹌" "㹽" "㺥" "䀡" "䂁" "䊲" "䐮" "䑎" "䜛" "䠨" "䡪" "䡲" "䣑" "䤘" "䤫" "䥀" "䧯" "䩶" "䪜" "䱿" "䳻" "䴺" "䴼" "䵐" "丳" "产" "僝" "儃" "儳" "冁" "刬" "剗" "剷" "劖" "单" "啴" "單" "嘽" "嚵" "囅" "婵" "嬋" "孱" "嵼" "巉" "幝" "幨" "廛" "忏" "惉" "懴" "懺" "掸" "掺" "搀" "摌" "摻" "撣" "攙" "旵" "梴" "棎" "欃" "毚" "沾" "浐" "渐" "湹" "滻" "漸" "潹" "潺" "澶" "瀍" "瀺" "灛" "煘" "燀" "獑" "產" "産" "硟" "磛" "禅" "禪" "簅" "緾" "繟" "繵" "纏" "纒" "缠" "羼" "脠" "艬" "苫" "蒇" "蕆" "蝉" "螹" "蟬" "蟺" "蟾" "袩" "裧" "襜" "襝" "覘" "觇" "誗" "諂" "譂" "讇" "讒" "讖" "谄" "谗" "躔" "辿" "鄽" "酁" "鋋" "鋓" "鏟" "鑱" "铲" "镵" "閳" "闡" "阐" "韂" "顫" "颤" "饞" "馋" "驏" "骣"))
    ((("c" "h" "a" "n" "g"))("㙊" "㦂" "㫤" "䕋" "䗅" "䠀" "䠆" "䩨" "䯴" "仧" "伥" "倀" "倘" "倡" "偿" "僘" "償" "兏" "厂" "厰" "唱" "嘗" "嚐" "场" "場" "塲" "娼" "嫦" "尙" "尚" "尝" "常" "廠" "徜" "怅" "悵" "惝" "戃" "敞" "昌" "昶" "晿" "暢" "氅" "淌" "淐" "焻" "猖" "玚" "琩" "瑒" "瑺" "瓺" "甞" "畅" "畼" "肠" "脹" "腸" "膓" "苌" "菖" "萇" "裮" "裳" "誯" "鋹" "鋿" "錩" "鏛" "锠" "長" "镸" "长" "閶" "闛" "阊" "韔" "鬯" "鯧" "鱨" "鲳" "鲿" "鷩" "鼚"))
    ((("c" "h" "a" "o"))("㶤" "㷅" "䄻" "䎐" "䏚" "䬤" "䰫" "仦" "仯" "剿" "勦" "吵" "嘲" "巐" "巢" "巣" "弨" "怊" "抄" "晁" "朝" "樔" "欩" "潮" "濤" "炒" "焯" "煼" "眧" "禉" "窲" "紹" "綽" "縐" "繛" "绰" "罺" "耖" "觘" "訬" "謅" "謿" "超" "趠" "轈" "鄛" "鈔" "钞" "麨" "鼂" "鼌"))
    ((("c" "h" "e"))("㔭" "㥉" "㨋" "㬚" "㯙" "㱌" "㵃" "㵔" "㾝" "㿭" "䁤" "䋲" "䑲" "䒆" "䚢" "䛸" "䜠" "䞣" "䤁" "䧪" "䨁" "䰩" "伡" "俥" "偖" "勶" "呫" "唓" "坼" "尺" "屮" "彻" "徹" "扯" "拆" "掣" "撤" "撦" "池" "澈" "烲" "爡" "瞮" "砗" "硨" "硩" "聅" "莗" "蛼" "詀" "車" "轍" "车" "辙" "迠"))
    ((("c" "h" "e" "n"))("㕴" "㧱" "㫳" "㲀" "㴴" "㽸" "䆣" "䒞" "䗞" "䚘" "䜟" "䞋" "䟢" "䢅" "䢈" "䢻" "䣅" "䤟" "䫖" "儬" "儭" "嗔" "嚫" "塵" "墋" "夦" "宸" "尘" "屒" "忱" "愖" "抻" "捵" "敐" "晨" "曟" "桭" "梣" "棽" "榇" "樄" "橙" "櫬" "沈" "沉" "湛" "瀋" "煁" "琛" "疢" "疹" "眈" "瞋" "硶" "碜" "磣" "祳" "秤" "称" "稱" "綝" "縝" "肜" "胂" "臣" "茞" "莀" "莐" "蔯" "薼" "藽" "螴" "衬" "襯" "訦" "諃" "諶" "謓" "讖" "谌" "谶" "賝" "贂" "趁" "趂" "趻" "踸" "軙" "辰" "迧" "郴" "鈂" "鍖" "闖" "闯" "陈" "陳" "霃" "鷐" "麎" "齓" "齔" "龀"))
    ((("c" "h" "e" "n" "g"))("㐼" "㞼" "㨃" "㲂" "㼩" "䀕" "䁎" "䁤" "䄇" "䆑" "䆵" "䆸" "䇸" "䔲" "䗊" "䚘" "䧕" "䫆" "䮪" "丞" "乗" "乘" "伧" "侱" "偁" "傖" "呈" "噌" "城" "埕" "埥" "堘" "塍" "塖" "塣" "娍" "宬" "峸" "庱" "徎" "悜" "惩" "憆" "憕" "懲" "成" "承" "抢" "挰" "掁" "揨" "搶" "撐" "撑" "撜" "晟" "朾" "枨" "枪" "柽" "梬" "棖" "棦" "椉" "槍" "樘" "橕" "橙" "檉" "泟" "洆" "浈" "浾" "湞" "澂" "澄" "瀓" "爯" "牚" "珵" "珹" "琤" "盛" "盯" "睈" "瞠" "秤" "称" "程" "稱" "穪" "窚" "竀" "筬" "絾" "緽" "脀" "脭" "荿" "虰" "蛏" "蟶" "裎" "誠" "诚" "赪" "赬" "趟" "逞" "郕" "郢" "酲" "醒" "鋮" "鎗" "鏿" "鐺" "铖" "铛" "阷" "靗" "頳" "饓" "騁" "騬" "骋"))
    ((("c" "h" "i"))("㒆" "㓼" "㓾" "㔑" "㔭" "㘜" "㙜" "㞴" "㞿" "㟂" "㡿" "㢁" "㢋" "㢮" "㥉" "㮛" "㱀" "㳏" "㶴" "㽚" "䇼" "䈕" "䊼" "䐤" "䑛" "䔟" "䗖" "䙙" "䛂" "䜄" "䜵" "䜻" "䞾" "䟷" "䠠" "䤲" "䪧" "䮈" "䮻" "䰡" "䰩" "䳵" "䶔" "䶵" "乿" "佁" "侈" "侙" "倁" "傺" "勅" "勑" "匙" "叱" "叺" "吃" "呎" "呞" "哆" "哧" "啻" "喫" "嗤" "嘨" "噄" "坻" "垑" "墀" "奓" "姼" "媸" "尺" "岻" "弛" "彨" "彲" "彳" "彽" "徥" "徲" "恀" "恜" "恥" "慗" "憏" "懘" "扡" "抶" "拸" "持" "搋" "摛" "攡" "敕" "斥" "杘" "杝" "栻" "欫" "欼" "歭" "歯" "池" "汦" "沱" "治" "泜" "淔" "滯" "灻" "炽" "烾" "熾" "瓻" "痓" "痴" "痸" "瘈" "瘛" "癡" "眙" "眵" "瞝" "离" "移" "竾" "笞" "筂" "箈" "箎" "篪" "粎" "糦" "紕" "絺" "翄" "翅" "翤" "翨" "耛" "耻" "胝" "胣" "胵" "芪" "茌" "茬" "荎" "莉" "蚇" "蚩" "蚳" "蛇" "螭" "袳" "裭" "褫" "觢" "訵" "誃" "誺" "謘" "謻" "豉" "貾" "赤" "赿" "趍" "趩" "跮" "踅" "踟" "踶" "迟" "迣" "遅" "遟" "遫" "遲" "郗" "鉓" "鉹" "銐" "鍉" "離" "飭" "飾" "饎" "饬" "馳" "驪" "驰" "骴" "魑" "鴟" "鵄" "鵣" "鶒" "鷘" "黐" "齒" "齝" "齿"))
    ((("c" "h" "o" "n" "g"))("㓼" "㓽" "㧤" "㹐" "䌬" "䖝" "䳯" "充" "冲" "嘃" "埫" "宠" "寵" "崇" "崈" "徸" "忡" "憃" "憧" "揰" "摏" "桩" "樁" "橦" "沖" "浺" "涌" "漴" "潼" "爞" "珫" "痋" "盅" "种" "種" "罿" "翀" "舂" "艟" "茧" "茺" "虫" "蝩" "蟲" "衝" "衶" "褈" "蹖" "酮" "重" "銃" "铳" "隀" "𢥞" "𣀒"))
    ((("c" "h" "o" "u"))("㐜" "㘜" "㛶" "㤽" "㦞" "㨶" "㵞" "㿧" "䇺" "䊭" "䌧" "䌷" "䓓" "䔏" "䛬" "䥒" "䪮" "䲖" "丑" "丒" "仇" "侴" "俦" "偢" "儔" "吜" "嚋" "婤" "嬦" "帱" "幬" "怞" "惆" "愁" "懤" "抽" "搊" "搐" "杻" "杽" "栦" "椆" "殠" "焘" "燽" "燾" "牰" "犨" "犫" "畴" "疇" "瘳" "皗" "盩" "瞅" "矁" "稠" "筹" "篘" "簉" "籌" "紬" "絒" "綢" "绸" "臭" "臰" "菗" "薵" "裯" "詶" "謅" "讎" "讐" "踌" "躊" "酧" "酬" "醜" "醻" "鈕" "雔" "雠" "霌" "霔" "魗"))
    ((("c" "h" "u"))("㔘" "㕏" "㕑" "㗰" "㘜" "㙇" "㜗" "㡡" "㤕" "㤘" "㶆" "㹼" "㼥" "䅳" "䊰" "䎝" "䎤" "䖏" "䙕" "䙘" "䜴" "䟞" "䟣" "䠂" "䠧" "䦌" "䧁" "䮞" "亍" "俶" "傗" "储" "儊" "儲" "処" "出" "刍" "初" "厨" "处" "岀" "幮" "廚" "怵" "憷" "拀" "搐" "敊" "斣" "斶" "曯" "杵" "椘" "楚" "楮" "槒" "橱" "檚" "櫉" "櫥" "欪" "歜" "泏" "淑" "滀" "滁" "濋" "犓" "琡" "畜" "矗" "础" "硫" "礎" "祝" "禇" "竌" "竐" "篨" "絀" "絮" "绌" "耝" "耡" "臅" "芻" "荲" "著" "蒢" "蒭" "蕏" "藸" "處" "蜍" "褚" "触" "觸" "詘" "諸" "豖" "貙" "趎" "踀" "蹰" "躇" "躕" "遚" "鄐" "鉏" "鋤" "锄" "閦" "除" "雏" "雛" "鶵" "麆" "黜" "齣" "齭" "齼"))
    ((("c" "hu" "u" "a"))("䏆" "䫄" "欻" "歘"))
    ((("c" "h" "u" "a" "i"))("㪓" "㪜" "㱀" "䦟" "䦤" "䦷" "䴝" "嘬" "揣" "搋" "腄" "膗" "踹" "蹉"))
    ((("c" "h" "u" "a" "n"))("㯌" "㱛" "㼷" "䁣" "串" "伝" "传" "傳" "僢" "喘" "圌" "堾" "巛" "川" "暷" "椽" "歂" "氚" "汌" "玔" "瑏" "穿" "篅" "腨" "舛" "舡" "舩" "船" "荈" "諯" "賗" "輲" "遄" "釧" "钏"))
    ((("c" "h" "u" "a" "n" "g"))("㡖" "㵂" "䃥" "䇬" "䎫" "䚒" "䡴" "䭚" "刅" "创" "刱" "剏" "剙" "創" "噇" "囪" "囱" "幢" "床" "怆" "愴" "戧" "摐" "摤" "撞" "橦" "漺" "牀" "牎" "牕" "獊" "疒" "疮" "瘡" "磢" "窓" "窗" "窻" "舂" "葱" "闖" "闯"))
    ((("c" "h" "u" "i"))("㓃" "㝽" "㥨" "㩾" "䄲" "䍋" "䕓" "䞼" "䳠" "倕" "吹" "圌" "垂" "埀" "捶" "搥" "桘" "棰" "椎" "槌" "湷" "炊" "箠" "篅" "腄" "菙" "郵" "錘" "鎚" "锤" "陲" "顀" "魋" "龡")) 
    ((("c" "h" "u" "n"))("㖺" "㝄" "㝇" "㵮" "㸪" "㿤" "䄝" "䏛" "䏝" "䐇" "䐏" "䓐" "䔚" "䞐" "䣨" "䣩" "䥎" "䦮" "䫃" "䮞" "偆" "唇" "堾" "媋" "惷" "憌" "旾" "春" "暙" "杶" "椿" "橁" "櫄" "沌" "浱" "淳" "湻" "滣" "漘" "睶" "箺" "純" "纯" "肫" "脣" "膞" "膥" "芚" "莼" "萅" "萶" "蒓" "蓴" "蠢" "踳" "輇" "輴" "醇" "醕" "錞" "陙" "鯙" "鰆" "鶉" "鶞" "鹑"))
    ((("c" "h" "u" "o"))("㚟" "㲋" "䂐" "䃗" "䄪" "䆯" "䇍" "䋘" "䍳" "䓎" "䮕" "啜" "嚽" "娖" "婥" "婼" "惙" "戳" "擉" "歠" "涰" "淖" "焯" "犳" "珿" "畷" "磭" "簇" "綴" "綽" "繛" "绰" "缀" "腏" "荃" "蔟" "諁" "趠" "踔" "踱" "躇" "輟" "辍" "辵" "辶" "逴" "酫" "醊" "醛" "鎈" "鏃" "鑡" "齪" "齱" "齹" "龊"))
    ((("c" "i"))("㓨" "㘂" "㘹" "㞖" "㠿" "㡹" "㢀" "㤵" "㩞" "㹂" "䂣" "䆅" "䈘" "䓧" "䖪" "䗹" "䛐" "䦻" "䧳" "䨏" "䭣" "䯸" "䰍" "䲿" "䳄" "䳐" "伺" "佌" "佽" "偨" "兹" "刺" "刾" "垐" "嬨" "嵯" "嵳" "庛" "恣" "慈" "朿" "柌" "次" "此" "泚" "滋" "濨" "玆" "玼" "珁" "瓷" "甆" "疵" "皉" "磁" "礠" "祠" "秶" "粢" "糍" "紪" "絘" "茈" "茊" "茨" "茲" "莿" "薋" "蚝" "蛓" "螅" "螆" "蠀" "訾" "詞" "词" "賜" "赐" "赼" "趀" "趑" "跐" "辝" "辞" "辤" "辭" "郪" "雌" "飺" "餈" "骴" "髊" "鶿" "鷀" "鹚"))
    ((("c" "o" "n" "g"))("㗰" "㼻" "䉘" "䕺" "䳷" "丛" "从" "匆" "叢" "囪" "囱" "婃" "孮" "従" "徖" "從" "忩" "怱" "悤" "悰" "慒" "憁" "暰" "枞" "棇" "樅" "樬" "樷" "欉" "淙" "漎" "漗" "潀" "灇" "焧" "燪" "爜" "牎" "牕" "琮" "瑽" "璁" "瞛" "窓" "窗" "窼" "篵" "緫" "縦" "縱" "繱" "聡" "聦" "聪" "聰" "苁" "葱" "蓯" "蔥" "藂" "蟌" "誴" "謥" "賨" "賩" "錝" "鍐" "鍯" "鏓" "鏦" "騘" "驄" "骢"))
    ((("c" "o" "u"))("㫶" "傶" "凑" "揍" "族" "楱" "湊" "簇" "腠" "蔟" "藪" "趣" "趨" "輳" "辏"))
    ((("c" "u"))("㗤" "㤘" "㰗" "䃚" "䎌" "䓚" "䙯" "䛤" "䟟" "䠓" "䠞" "䢐" "䥄" "䥘" "䬨" "促" "卒" "噈" "塶" "徂" "憱" "数" "數" "梀" "槭" "殂" "殧" "猝" "瘄" "瘯" "皶" "簇" "粗" "縐" "縬" "脨" "蔟" "觕" "豠" "趋" "趗" "趣" "趨" "踧" "蹙" "蹴" "蹵" "酢" "醋" "錯" "错" "顣" "麁" "麄" "麤" "鼀")) 
    ((("c" "u" "a" "n"))("㠝" "㭫" "㵀" "㸑" "䆘" "䞼" "䰖" "劗" "巑" "撺" "攛" "攢" "櫕" "殩" "汆" "濽" "熶" "爨" "窜" "竄" "篡" "簒" "蹲" "蹿" "躥" "鋑" "鑹" "镩"))
    ((("c" "u" "i"))("㝮" "㥞" "㧘" "㯔" "㯜" "㱖" "㳃" "㵏" "㷃" "㷪" "䂱" "䃀" "䄟" "䆊" "䊫" "䔴" "䢪" "䧽" "伜" "倅" "催" "凗" "啐" "啛" "嗺" "墔" "崒" "崔" "崪" "忰" "悴" "慛" "摧" "榱" "槯" "橇" "毳" "洒" "淬" "漼" "焠" "獕" "琗" "璀" "疩" "瘁" "皠" "磪" "竁" "竴" "粋" "粹" "紣" "綷" "縗" "缞" "翆" "翠" "脃" "脆" "脺" "膬" "膵" "臎" "萃" "衰" "趡" "踤" "鏙" "隹" "顇"))
    ((("c" "u" "n"))("䍎" "刌" "吋" "墫" "存" "寸" "忖" "拵" "村" "浚" "澊" "皴" "籿" "袸" "踆" "蹲" "邨"))
    ((("c" "u" "o"))("㟇" "㭫" "㽨" "䂳" "䐣" "䐤" "䑘" "䟶" "䠡" "䣜" "䥘" "䰈" "䱜" "䴾" "侳" "剉" "剒" "厝" "嵯" "嵳" "挫" "措" "搓" "摧" "撮" "昔" "歵" "營" "瑳" "痤" "瘥" "睉" "矬" "磋" "縒" "脞" "莝" "莡" "蒫" "蓌" "蔖" "虘" "蹉" "躦" "逪" "遳" "鄼" "醝" "銼" "錯" "锉" "错" "鹺" "鹾" "齚" "齰"))
    ((("d" "a"))("㜓" "㟷" "㯚" "㾑" "㿯" "䃮" "䐊" "䑽" "䩢" "䳴" "䵣" "劄" "匒" "呾" "哒" "噠" "墶" "大" "妲" "怛" "打" "搨" "搭" "撘" "汏" "沓" "溚" "炟" "畗" "畣" "疸" "瘩" "眔" "笪" "答" "箚" "繨" "羍" "耷" "胆" "荅" "荙" "薘" "蟽" "褟" "褡" "觰" "詚" "跶" "躂" "达" "迖" "逹" "達" "酂" "酇" "鎝" "鐽" "靼" "鞑" "韃"))
    ((("d" "a" "i"))("㐲" "㞭" "㫹" "㯂" "㶡" "㻖" "㿃" "䈆" "䒫" "䚞" "䚟" "䲦" "代" "傣" "叇" "呆" "呔" "嘚" "埭" "大" "岱" "帒" "带" "帯" "帶" "廗" "待" "怠" "懛" "戴" "曃" "柋" "棣" "歹" "歺" "殆" "毒" "汏" "瀻" "獃" "玳" "瑇" "甙" "箈" "簤" "紿" "緿" "绐" "艜" "蝳" "袋" "襶" "詒" "貸" "贷" "跢" "蹛" "軑" "軚" "軩" "載" "轪" "迨" "递" "逮" "逯" "遝" "遞" "釱" "隶" "霴" "靆" "馱" "駘" "騃" "黛" "黱"))
    ((("d" "a" "n"))("㔊" "㕪" "㗖" "㡺" "㫜" "㱽" "㲷" "㵅" "㺗" "㽎" "䃫" "䄷" "䉞" "䉷" "䨢" "䨵" "䩥" "䭛" "䮰" "䱋" "䳉" "丹" "亶" "伔" "但" "僤" "儋" "刐" "勯" "匰" "单" "単" "唌" "啖" "啗" "啿" "單" "噉" "噡" "嚪" "妉" "媅" "帎" "弹" "弾" "彈" "惔" "惮" "憚" "憺" "担" "掸" "撢" "撣" "擔" "旦" "暺" "柦" "檐" "殚" "殫" "氮" "沊" "淡" "湛" "潬" "潭" "澶" "澸" "澹" "燀" "狚" "玬" "瓭" "甔" "疍" "疸" "瘅" "癉" "癚" "眈" "石" "砃" "禫" "窞" "箪" "簞" "紞" "耼" "耽" "聃" "聸" "胆" "腅" "膻" "膽" "舕" "萏" "蛋" "蜑" "蜒" "蟺" "衴" "襌" "覘" "觛" "訑" "詹" "誕" "诞" "贉" "贍" "赡" "躭" "郸" "鄲" "酖" "鉭" "钽" "霮" "頕" "餤" "饏" "馾" "駳" "髧" "鴠" "黕" "黮" "黵"))
    ((("d" "a" "n" "g"))("䑗" "䣊" "䣣" "䦒" "偒" "儅" "党" "凼" "噹" "圵" "垱" "壋" "婸" "宕" "嵣" "当" "愓" "挡" "擋" "攩" "档" "檔" "欓" "氹" "潒" "澢" "灙" "燙" "玚" "珰" "瑒" "璗" "璫" "瓽" "當" "瘍" "盪" "瞊" "砀" "碭" "礑" "筜" "簜" "簹" "艡" "荡" "菪" "蕩" "蘯" "蟷" "裆" "襠" "譡" "讜" "谠" "趤" "逿" "鐺" "铛" "闣" "雼" "黨"))
    ((("d" "a" "o"))("㔑" "㠀" "㨶" "㿒" "䆃" "䊭" "䌦" "䣣" "䧂" "䮻" "䲽" "倒" "刀" "刂" "到" "叨" "噵" "壔" "导" "導" "岛" "島" "嶋" "嶌" "嶹" "帱" "幍" "幬" "忉" "悼" "捣" "捯" "搗" "擣" "朷" "梼" "檤" "檮" "氘" "洮" "濤" "燾" "瓙" "盗" "盜" "祷" "禂" "禱" "稲" "稻" "纛" "翿" "舠" "菿" "衜" "衟" "裯" "蹈" "軇" "道" "釖" "陶" "隝" "隯" "魛" "鱽" "鳥"))
    ((("d" "e"))("㝵" "㝶" "㤫" "㥀" "㥁" "㯖" "䙷" "䙸" "嘚" "地" "墬" "底" "得" "徳" "德" "恴" "惪" "淂" "登" "的" "鍀" "锝" "陟"))
    ((("d" "e" "i"))("䮻" "哋" "得"))
    ((("d" "e" "n"))("参" "參" "扽"))
    ((("d" "e" "n" "g"))("䒭" "䠬" "䮴" "僜" "凳" "噔" "墱" "嬁" "嶝" "戥" "朩" "橙" "櫈" "澄" "灯" "燈" "璒" "登" "眙" "瞪" "磴" "竳" "等" "簦" "覴" "豋" "蹬" "邓" "鄧" "鐙" "镫" "隥" "霯"))
    ((("d" "i"))("㡳" "㢩" "㣙" "㦅" "㪆" "㭽" "㰅" "㹍" "㼵" "䀸" "䀿" "䂡" "䊮" "䍕" "䏑" "䑭" "䑯" "䗖" "䞶" "䟡" "䢑" "䣌" "䧝" "䨀" "䨢" "䨤" "䩘" "䩚" "䮤" "䯼" "䱃" "䱱" "䲦" "䴞" "䵠" "䶍" "仢" "仾" "低" "偙" "僀" "呧" "哋" "唙" "啇" "啲" "嘀" "嚁" "地" "坔" "坘" "坻" "埅" "埊" "埞" "堤" "墆" "墑" "墬" "奃" "娣" "媞" "嫡" "嵽" "嶳" "帝" "底" "廸" "弟" "弤" "怟" "慸" "抵" "拞" "掋" "提" "揥" "摕" "敌" "敵" "旳" "杕" "柢" "梊" "梑" "棣" "楴" "樀" "氐" "泜" "浟" "涤" "渧" "滌" "滴" "滺" "潪" "焍" "牴" "狄" "玓" "甋" "疐" "的" "眡" "睇" "砥" "碲" "磾" "祶" "禘" "笛" "第" "篴" "籊" "籴" "糴" "約" "締" "缔" "羝" "翟" "聜" "肑" "胝" "腣" "芍" "苐" "苖" "茋" "荻" "莜" "菂" "菧" "蒂" "蔋" "蔐" "蔕" "藋" "藡" "虳" "蝃" "螮" "袛" "覿" "觌" "觝" "詆" "諦" "诋" "谛" "豴" "赿" "趆" "踧" "踶" "蹄" "蹏" "蹢" "軑" "軧" "轪" "迪" "逐" "递" "逓" "逮" "遞" "適" "遰" "邸" "釱" "鉪" "鍉" "鏑" "镝" "阺" "隄" "隶" "靮" "鞮" "頔" "題" "题" "馰" "骶" "髢" "鬄" "鸐"))
    ((("d" "i" "a"))(??))
    ((("d" "i" "a" "n"))("㓠" "㚲" "㝪" "㞟" "㥆" "㵤" "㶘" "㸃" "㼭" "䍄" "䓦" "䟍" "䧃" "䩚" "佃" "傎" "典" "厧" "嚸" "坫" "垫" "墊" "壂" "奌" "奠" "婝" "婰" "嵮" "巅" "巓" "巔" "店" "惦" "扂" "拈" "掂" "攧" "敁" "敟" "槇" "槙" "橂" "殿" "沾" "涎" "淀" "滇" "澱" "点" "玷" "琔" "琠" "电" "甸" "痁" "痶" "瘨" "癜" "癫" "癲" "碘" "磹" "簟" "蒧" "蕇" "蜓" "蜔" "踮" "蹎" "鈿" "钿" "阽" "電" "靛" "顚" "顛" "颠" "驔" "點" "齻"))
    ((("d" "i" "a" "o"))("㒛" "㪕" "㹿" "䂪" "䂽" "䄪" "䄷" "䉆" "䔙" "䠼" "䳝" "䵲" "伄" "凋" "刁" "叼" "吊" "奝" "屌" "弔" "彫" "扚" "掉" "敦" "殦" "汈" "琱" "瘹" "盄" "瞗" "矵" "碉" "稠" "窎" "窵" "竨" "綢" "莜" "蓧" "藋" "虭" "蛁" "蜩" "訋" "誂" "調" "调" "貂" "趙" "跳" "踔" "軺" "釕" "釣" "銚" "銱" "鋽" "錭" "鑃" "钌" "钓" "铞" "雕" "魡" "鮉" "鯛" "鲷" "鳥" "鳭" "鵰" "鸟" "鼦"))
    ((("d" "i" "e"))("㑙" "㥈" "㦶" "㩸" "㩹" "㫼" "㬪" "㭯" "㲲" "㲳" "㷸" "㻡" "䏲" "䘭" "䞇" "䞕" "䠟" "䪥" "䮢" "䲀" "䳀" "䳻" "䴑" "佚" "叠" "咥" "啑" "喋" "垤" "堞" "墆" "峌" "嵽" "恎" "惵" "戜" "挕" "揲" "攧" "昳" "曡" "柣" "楪" "殜" "氎" "涉" "渉" "渫" "爹" "牃" "牒" "瓞" "畳" "疉" "疊" "眣" "眰" "碟" "窒" "絰" "绖" "耊" "耋" "聑" "胅" "至" "臷" "艓" "苵" "蜨" "蝶" "螲" "褋" "褶" "褺" "褻" "詄" "諜" "谍" "趃" "跌" "跕" "跮" "踢" "蹀" "軼" "轶" "迭" "鐵" "镻" "鰈" "鰨" "鲽" "鳎"))
    ((("d" "i" "n" "g"))("㝎" "㝪" "㫀" "㴿" "㼗" "丁" "仃" "叮" "啶" "奵" "娗" "婈" "定" "嵿" "帄" "庰" "忊" "椗" "檙" "汀" "濎" "玎" "町" "疔" "盯" "矴" "碇" "碠" "磸" "耵" "腚" "艼" "葶" "薡" "訂" "订" "酊" "釘" "鋌" "錠" "鐤" "钉" "锭" "靪" "頂" "顁" "顶" "飣" "饤" "鼎" "鼑"))
    ((("d" "i" "u"))("丟" "丢" "乣" "铥" "颩"))
    ((("d" "o" "n" "g"))("㑈" "㓊" "㖦" "㗢" "㜱" "㢥" "㨂" "㼯" "䂢" "䅍" "䍶" "䞒" "䵔" "东" "侗" "倲" "働" "冬" "冻" "凍" "动" "動" "咚" "垌" "埬" "墥" "娻" "嬞" "岽" "峒" "峝" "崠" "崬" "恫" "懂" "戙" "挏" "昸" "東" "栋" "棟" "氡" "氭" "洞" "涷" "湩" "甬" "眮" "硐" "笗" "筒" "箽" "胨" "胴" "腖" "苳" "菄" "董" "蕫" "蝀" "衕" "諌" "酮" "霘" "駧" "鯟" "鶇" "鸫" "鼕"))
    ((("d" "o" "u"))("㛒" "㞳" "㢄" "㪷" "㷆" "䄈" "䇺" "䕆" "䕱" "䛠" "䬦" "兜" "兠" "吺" "唗" "唞" "抖" "敨" "斗" "枓" "枡" "梪" "橷" "毭" "浢" "渎" "瀆" "痘" "窦" "窬" "竇" "篼" "脰" "荳" "蔸" "蚪" "讀" "读" "豆" "逗" "逾" "郖" "都" "鋀" "閗" "闘" "阧" "陡" "餖" "饾" "鬥" "鬦" "鬪" "鬬" "鬭" "都"))
    ((("d" "u"))("㓃" "㱩" "㸿" "㹍" "㾄" "䀾" "䄍" "䅊" "䈞" "䐗" "䓯" "䙱" "䟻" "䢱" "䪅" "䫳" "䮷" "䲧" "儥" "凟" "匵" "厾" "喥" "嘟" "堵" "妒" "妬" "嬻" "帾" "度" "斁" "暏" "杜" "椟" "橐" "櫝" "殬" "殰" "毒" "涜" "渎" "渡" "瀆" "牍" "牘" "犊" "犢" "独" "獨" "琽" "瓄" "皾" "督" "睹" "碡" "秺" "竇" "竺" "笃" "篤" "簬" "簵" "纛" "肚" "芏" "荰" "蝳" "螙" "蠧" "蠹" "裻" "襡" "覩" "詫" "読" "讀" "讟" "读" "豄" "賭" "贕" "赌" "都" "醏" "錖" "鍍" "鍺" "鑟" "镀" "閬" "闍" "阇" "陼" "靯" "韇" "韣" "韥" "頓" "顿" "騳" "髑" "黩" "黷" "都"))
    ((("d" "u" "a" "n"))("㫁" "㱭" "䠪" "偳" "剬" "塅" "媏" "断" "斷" "椴" "段" "毈" "煅" "瑖" "短" "碫" "端" "簖" "籪" "緞" "缎" "耑" "腶" "葮" "褍" "踹" "躖" "鍛" "鍴" "锻"))
    ((("d" "u" "i"))("㙂" "㟋" "㠚" "㨃" "㬣" "㳔" "㵽" "䇏" "䇤" "䔪" "䨴" "䨺" "䬈" "䬽" "䯟" "兊" "兌" "兑" "垖" "堆" "塠" "对" "対" "對" "嵟" "怼" "憝" "憞" "懟" "敦" "桘" "槌" "濧" "濻" "瀩" "痽" "碓" "磓" "祋" "綐" "薱" "譈" "轛" "追" "銳" "鋭" "錞" "鐓" "鐜" "锐" "镦" "队" "陮" "隊" "頧"))
    ((("d" "u" "n"))("㬿" "䤜" "伅" "吨" "噸" "囤" "墩" "墪" "墫" "崸" "庉" "弴" "惇" "扽" "撉" "撴" "敦" "沌" "潡" "炖" "燉" "犜" "盹" "盾" "砘" "礅" "腞" "蜳" "豚" "趸" "踲" "蹲" "蹾" "躉" "逇" "遁" "遯" "鈍" "鐓" "钝" "頓" "顿" "驐" "鶨" "𣎴"))
    ((("d" "u" "o"))("㔍" "㖼" "㙐" "㛆" "㛊" "㣞" "㥩" "㧷" "㻔" "㻧" "䁟" "䄍" "䅜" "䍴" "䐾" "䑨" "䒳" "䙃" "䙟" "䙤" "䠤" "䤪" "䤻" "䩔" "䩣" "䫂" "䯬" "亸" "凙" "刴" "剁" "剟" "剫" "咄" "哆" "哚" "嚉" "嚲" "垛" "垜" "埵" "堕" "墮" "墯" "多" "夛" "夺" "奪" "奲" "媠" "尮" "崜" "嶞" "度" "徳" "悳" "惰" "憜" "挅" "挆" "掇" "敓" "敚" "敠" "敪" "朵" "朶" "杕" "柁" "柂" "柮" "桗" "棰" "椯" "橢" "毲" "沱" "沲" "泽" "澤" "炧" "炨" "痑" "痥" "綞" "缍" "舵" "茤" "莌" "袳" "裰" "襗" "趓" "跥" "跺" "踱" "躱" "躲" "軃" "鄲" "鈬" "鍺" "鐸" "铎" "锗" "陀" "陊" "陏" "隋" "飿" "饳" "馱" "驮" "鬌" "鮵" "鵽" "點"))
    ((("e"))("㑼" "㓵" "㔀" "㔩" "㕎" "㖾" "㗁" "㗉" "㟧" "㠋" "㡋" "㦍" "㧖" "㩵" "㮙" "㱦" "㷈" "㼂" "㼢" "㼰" "䂮" "䄉" "䆓" "䌎" "䑥" "䑪" "䓊" "䔾" "䕏" "䖸" "䙳" "䛖" "䛚" "䝈" "䞩" "䣞" "䤚" "䤣" "䨋" "䩹" "䫷" "䱮" "䳗" "䳘" "䳬" "乇" "俄" "偔" "僫" "儑" "剠" "卾" "厄" "吪" "呃" "呝" "咢" "咹" "哑" "哦" "啞" "噁" "噩" "囮" "圔" "圙" "垩" "堊" "堨" "堮" "妸" "妿" "娥" "娿" "婀" "婐" "屙" "岋" "峉" "峨" "峩" "崿" "嶭" "恶" "悪" "惡" "愕" "戹" "扼" "掠" "搤" "搹" "撂" "擽" "枙" "櫮" "歹" "涐" "湂" "猗" "玀" "率" "珴" "琧" "略" "畧" "疟" "疴" "痾" "瘧" "皒" "睋" "砐" "硆" "硪" "磀" "稤" "胺" "腭" "苊" "莪" "萼" "蕚" "藥" "蘁" "虐" "蚅" "蛤" "蛾" "蝁" "覨" "訛" "詻" "誐" "誒" "諤" "謔" "譌" "讍" "讹" "谑" "谔" "豟" "貖" "軛" "軶" "轭" "迗" "遌" "遏" "遻" "邑" "鄂" "鈋" "鈳" "鋝" "鋢" "鋨" "鍔" "鑩" "钶" "锇" "锊" "锷" "閼" "阏" "阨" "阸" "阿" "隘" "隲" "頞" "頟" "額" "顎" "颚" "额" "餓" "餩" "饿" "騀" "鬲" "魤" "魥" "鰐" "鱷" "鳄" "鵝" "鵞" "鶚" "鹅" "鹗" "齃" "齶"))
    ((("e" "i"))("欸" "誒" "诶"))
    ((("e" "n"))("䅰" "䊐" "䬶" "䭓" "䭡" "奀" "恩" "摁" "蒽"))
    ((("e" "n" "g"))("鞥"))
    ((("e" "r"))("㒃" "㖇" "㚷" "㛅" "㜨" "㢽" "㧫" "㮕" "䋙" "䋩" "䌺" "䎟" "䎠" "䎶" "䏪" "䣵" "䮘" "二" "佴" "侕" "儞" "儿" "児" "兒" "刵" "咡" "唲" "尒" "尓" "尔" "峏" "弍" "弐" "栭" "栮" "樲" "檽" "毦" "洏" "洱" "渳" "濡" "爾" "珥" "眲" "而" "耏" "耳" "聏" "胹" "腝" "臑" "荋" "薾" "衈" "袻" "誀" "貮" "貳" "贰" "輀" "轜" "迩" "邇" "鉺" "铒" "陑" "隭" "餌" "饵" "駬" "髵" "鮞" "鲕" "鴯" "鸸"))
    ((("f" "a"))("㕹" "㘺" "㛲" "㳒" "䂲" "䇅" "䒥" "䣹" "乏" "伐" "佱" "傠" "发" "垡" "姂" "彂" "拨" "撥" "栰" "橃" "沷" "法" "泛" "灋" "珐" "琺" "疺" "発" "發" "瞂" "砝" "筏" "罚" "罰" "罸" "茷" "蕟" "藅" "閥" "阀" "髪" "髮"))
    ((("f" "a" "n"))("㕨" "㝃" "㠶" "㤆" "㳎" "㴀" "㶗" "㸋" "㺕" "㼝" "㽹" "㾱" "䀀" "䀟" "䉊" "䉒" "䊩" "䋣" "䋦" "䌓" "䐪" "䒠" "䒦" "䕰" "䛀" "䡊" "䣲" "䪛" "䪤" "䫶" "䭵" "䮳" "仮" "僠" "凡" "凢" "凣" "勫" "反" "噃" "墦" "奿" "嬎" "嬏" "帆" "幡" "忛" "憣" "拚" "旙" "旛" "杋" "柉" "梵" "棥" "樊" "橎" "氾" "汎" "泛" "滼" "潘" "瀪" "瀿" "烦" "煩" "燔" "犯" "犿" "璠" "瓪" "畈" "畨" "番" "盕" "矾" "礬" "笲" "笵" "範" "籓" "籵" "緐" "繁" "繙" "羳" "翻" "膰" "舧" "范" "蕃" "薠" "藩" "蘩" "蟠" "蠜" "袢" "襎" "觙" "訉" "販" "贩" "蹯" "軓" "軡" "軬" "轓" "返" "鄤" "釩" "鐇" "钒" "颿" "飜" "飯" "飰" "饭" "魬" "鱕" "鷭" "飯"))
    ((("f" "a" "n" "g"))("㑂" "㕫" "㤃" "㧍" "㯐" "䉊" "䢍" "䦈" "䲱" "仿" "倣" "匚" "坊" "埅" "妨" "彷" "房" "放" "方" "旊" "昉" "昘" "枋" "汸" "淓" "牥" "瓬" "眆" "紡" "纺" "肪" "舫" "芳" "蚄" "訪" "访" "趽" "邡" "鈁" "钫" "防" "髣" "魴" "鰟" "鲂" "鳑" "鴋" "鶭"))
    ((("f" "e" "i"))("㓈" "㔗" "㥱" "㩌" "㭭" "㵒" "㸬" "㹃" "㾱" "䀟" "䆏" "䈈" "䉬" "䍨" "䑔" "䒈" "䕁" "䕠" "䚨" "䛍" "䞳" "䠊" "䤵" "䨽" "䨾" "䰁" "俷" "剕" "匪" "厞" "吠" "啡" "墢" "奜" "妃" "婓" "屝" "废" "廃" "廢" "悱" "扉" "斐" "昲" "曊" "朏" "杮" "棐" "榧" "櫠" "沸" "淝" "渄" "濷" "狒" "猆" "疿" "痱" "癈" "砩" "祓" "篚" "紼" "緋" "绯" "翡" "肥" "肺" "胇" "胏" "腓" "芾" "茷" "菲" "萉" "蕜" "蕟" "蜚" "蜰" "蟦" "裴" "裶" "誹" "诽" "費" "賁" "贲" "费" "郿" "鐨" "镄" "陫" "霏" "靅" "非" "靟" "飛" "飝" "飞" "餥" "馡" "騑" "騛" "髴" "鯡" "鲱" "鼣"))
    ((("f" "e" "n"))("㖹" "㥹" "㮥" "㱵" "㷊" "㸮" "㻞" "㿎" "䀟" "䢍" "䩿" "䯨" "䴅" "份" "偾" "僨" "兝" "分" "吩" "坆" "坋" "坟" "墳" "奋" "奮" "妢" "岎" "帉" "幩" "弅" "忿" "愤" "憤" "拚" "昐" "朆" "朌" "枌" "梤" "棻" "棼" "橨" "氛" "汾" "濆" "瀵" "炃" "焚" "燌" "燓" "燔" "獖" "玢" "盼" "砏" "秎" "粉" "粪" "糞" "紛" "纷" "羒" "羵" "翂" "肦" "膹" "芬" "蒶" "蕡" "蚠" "蚡" "衯" "訜" "豮" "豶" "賁" "贲" "轒" "酚" "鈖" "鐼" "隫" "雰" "頒" "颁" "餴" "饙" "馚" "馩" "魵" "鱝" "鲼" "鳻" "黂" "黺" "鼖" "鼢" "𦐈"))
    ((("f" "e" "n" "g"))("㡝" "㦀" "㵯" "䏎" "䙜" "䟪" "䩬" "䩼" "䵄" "丰" "仹" "俸" "偑" "僼" "冯" "凤" "凨" "凬" "凮" "唪" "堸" "堼" "夆" "奉" "妦" "寷" "封" "峯" "峰" "崶" "捀" "摓" "方" "枫" "桻" "楓" "檒" "氾" "汎" "沣" "沨" "泛" "浲" "渢" "湗" "漨" "灃" "烽" "焨" "煈" "熢" "犎" "猦" "甮" "疯" "瘋" "盽" "砜" "碸" "篈" "綘" "縫" "缝" "艂" "莑" "葑" "蘴" "蚌" "蜂" "蠭" "覂" "諷" "讽" "豊" "豐" "賵" "赗" "逄" "逢" "鄷" "酆" "鋒" "鏠" "锋" "靊" "風" "飌" "风" "馮" "鳯" "鳳" "鴌" "鵬" "麷"))
    ((("f" "o"))("㤇" "仏" "佛" "坲"))
    ((("f" "o" "u"))("䬏" "䳕" "不" "剻" "否" "哹" "復" "椱" "殕" "竎" "紑" "缶" "缹" "缻" "芣" "裦" "雬" "鴀"))
    ((("f" "u"))("㓡" "㕮" "㗘" "㙏" "㚆" "㚕" "㜑" "㝿" "㞎" "㟊" "㠅" "㡝" "㤔" "㤱" "㪄" "㫙" "㬼" "㳇" "㵗" "㷆" "㽬" "㾈" "㾱" "䂤" "䃽" "䋨" "䋹" "䌗" "䌿" "䍌" "䍖" "䎅" "䑧" "䒀" "䒄" "䒇" "䓛" "䔰" "䕎" "䗄" "䘀" "䘄" "䘠" "䝾" "䞜" "䞞" "䞯" "䞸" "䟔" "䟮" "䠵" "䡍" "䥤" "䦣" "䧞" "䨗" "䨱" "䩉" "䪙" "䫍" "䫝" "䬪" "䭮" "䭸" "䮛" "䯱" "䯽" "䳝" "䵗" "䵾" "乀" "乶" "仆" "付" "伏" "伕" "佛" "俌" "俘" "俛" "俯" "偩" "傅" "冨" "冹" "凫" "刜" "副" "匐" "呋" "呒" "咈" "咐" "嘸" "嚩" "圑" "坿" "垘" "垺" "复" "夫" "妇" "妋" "姇" "婏" "婦" "媍" "嬔" "孚" "孵" "宓" "富" "尃" "岪" "峊" "巿" "帗" "幅" "幞" "府" "弗" "弣" "彿" "復" "怤" "怫" "懯" "払" "扶" "抙" "抚" "拂" "拊" "捬" "掊" "撫" "敷" "斧" "旉" "暊" "服" "枎" "枹" "柎" "柫" "栿" "桴" "棴" "榑" "氟" "沸" "泭" "洑" "浮" "涪" "溥" "滏" "澓" "炥" "烰" "焤" "父" "玞" "玸" "琈" "甫" "甶" "畉" "畐" "畗" "癁" "盙" "砆" "砩" "祓" "祔" "福" "秿" "稃" "稪" "符" "笰" "筟" "箙" "簠" "粰" "糐" "紨" "紱" "紼" "絥" "綍" "綒" "緮" "縛" "纀" "绂" "绋" "缚" "罘" "罦" "翇" "肤" "胕" "脯" "腐" "腑" "腹" "膚" "艀" "艴" "芙" "芾" "苻" "茀" "茯" "荴" "莆" "莩" "菔" "萯" "葍" "蔽" "蕧" "虙" "蚥" "蚨" "蚹" "蛗" "蜅" "蜉" "蝜" "蝠" "蝮" "衭" "袝" "袱" "複" "褔" "襆" "覆" "訃" "詂" "諨" "讣" "豧" "負" "賦" "賻" "负" "赋" "赙" "赴" "趺" "跗" "踾" "軵" "輔" "輹" "輻" "辅" "辐" "邞" "郙" "郛" "鄜" "釜" "釡" "鈇" "鉘" "鉜" "錇" "鍑" "鍢" "阜" "阝" "附" "陚" "鞴" "韍" "韨" "頫" "颫" "馥" "駙" "驸" "髴" "鬴" "鮄" "鮒" "鯆" "鰒" "鲋" "鳆" "鳧" "鳬" "鳺" "鴔" "鵩" "鶝" "麩" "麬" "麱" "麸" "黻" "黼" "福" "𦱖"))
    ((("g" "a"))("咖" "嘎" "嘠" "噶" "尕" "尜" "尬" "旮" "玍" "胳" "軋" "轧" "釓" "錷" "钆" "骱" "𠁥"))
    ((("g" "a" "i"))("㕢" "㧉" "㮣" "䏗" "䪱" "丐" "乢" "侅" "匃" "匄" "垓" "姟" "峐" "忋" "戤" "摡" "改" "晐" "概" "槩" "槪" "汽" "溉" "漑" "瓂" "畡" "盖" "祴" "絠" "絯" "胲" "芥" "荄" "葢" "蓋" "該" "该" "豥" "賅" "賌" "赅" "郂" "鈣" "钙" "閡" "阂" "陔" "隑" "骸" "𠁥" "𩕭"))
    ((("g" "a" "n"))("㺂" "䃭" "䇞" "䔈" "䤗" "䯎" "䲺" "䵟" "乹" "乾" "亁" "仠" "倝" "凎" "凲" "坩" "尲" "尴" "尶" "尷" "嵅" "干" "幹" "忓" "感" "扞" "擀" "攼" "敢" "旰" "杆" "柑" "桿" "榦" "橄" "檊" "汗" "汵" "泔" "涻" "淦" "漧" "澉" "灨" "玕" "甘" "疳" "皯" "盰" "矸" "秆" "稈" "竿" "筸" "簳" "粓" "紺" "绀" "肝" "芉" "苷" "虷" "蜬" "衦" "詌" "贑" "贛" "赣" "赶" "趕" "迀" "迁" "酐" "釬" "骭" "鱤" "鳡" "鳱"))
    ((("g" "a" "n" "g"))("㟠" "㟵" "㽘" "䴚" "亢" "冈" "冮" "刚" "剛" "堈" "堽" "岗" "岡" "崗" "戅" "戆" "戇" "扛" "掆" "摃" "杠" "棡" "槓" "港" "溝" "焵" "牨" "犅" "疘" "矼" "碙" "笐" "筻" "綱" "纲" "缸" "罁" "罓" "罡" "肛" "肮" "舡" "釭" "鋼" "鎠" "钢" "阬" "頏" "颃"))
    ((("g" "a" "o"))("㚏" "㚖" "㾸" "䗣" "䨢" "叝" "吿" "告" "咎" "夰" "搞" "暠" "杲" "桕" "槀" "槁" "槔" "槹" "橰" "檺" "櫜" "浩" "滜" "煰" "皋" "皐" "皜" "睪" "睾" "祮" "祰" "禞" "稁" "稾" "稿" "笴" "筶" "篙" "糕" "縞" "缟" "羔" "羙" "膏" "臯" "菒" "蒿" "藁" "藳" "誥" "诰" "郜" "鋯" "鎬" "锆" "镐" "餻" "高" "髙" "鯌" "鷎" "鼛"))
    ((("g" "e"))("㗆" "㝓" "㠷" "㦴" "㨰" "㪾" "㵧" "㷴" "䆟" "䈓" "䐙" "䕻" "䗘" "䘁" "䛋" "䛿" "䢔" "䧄" "䨣" "䩐" "䪂" "䪺" "䫦" "个" "仡" "佮" "個" "割" "匌" "各" "合" "呄" "咯" "哥" "哿" "嗝" "嗰" "噶" "圪" "塥" "嶱" "愅" "戈" "戓" "戨" "扢" "挌" "搁" "搿" "擖" "擱" "敋" "格" "槅" "歌" "浩" "渮" "滆" "滒" "烙" "牁" "牫" "牱" "獦" "疙" "盖" "砝" "硌" "笴" "箇" "紇" "纥" "肐" "胳" "膈" "臵" "舸" "茖" "菏" "葛" "葢" "蓋" "虼" "蛒" "蛤" "袼" "裓" "觡" "諽" "謌" "輵" "轕" "郃" "鉀" "鉻" "鉿" "鎘" "鎶" "铬" "镉" "閘" "閣" "閤" "闔" "阁" "阖" "隔" "革" "鞈" "鞷" "韐" "韚" "頜" "颌" "骼" "髂" "鬲" "鮯" "鰪" "鴚" "鴿" "鸽" "麧" "齃" "𪃿"))
    ((("g" "e" "i"))("給" "给" "胲"))
    ((("g" "e" "n"))("㫔" "㮓" "䫀" "亘" "亙" "刯" "剆" "哏" "根" "痕" "艮" "茛" "跟"))
    ((("g" "e" "n" "g"))("㾘" "䋁" "䌄" "䨣" "䱍" "䱎" "䱭" "䱴" "亘" "亙" "哽" "埂" "堩" "峺" "庚" "挭" "揯" "搄" "暅" "更" "梗" "浭" "炅" "炔" "畊" "硬" "秔" "稉" "粳" "絙" "絚" "綆" "緪" "縆" "绠" "羮" "羹" "耕" "耿" "莄" "菮" "賡" "赓" "邢" "郠" "頸" "颈" "骾" "鯁" "鲠" "鶊" "鹒"))
    ((("g" "o" "n" "g"))("㓋" "㔶" "㤨" "㧬" "㫒" "㭟" "㯯" "㺬" "㼦" "䂬" "䇨" "䔈" "䡗" "䢚" "䱋" "供" "公" "共" "功" "匑" "厷" "唝" "嗊" "塨" "宫" "宮" "工" "巩" "幊" "廾" "弓" "恭" "愩" "拱" "拲" "攻" "杛" "栱" "汞" "澒" "灨" "玜" "珙" "疘" "碽" "穬" "篢" "糼" "紅" "红" "羾" "肱" "虹" "蚣" "蛩" "蛬" "觥" "觵" "貢" "贑" "贛" "贡" "赣" "躬" "躳" "輁" "釭" "銾" "鋛" "鞏" "魟" "龏" "龔" "龚"))
    ((("g" "o" "u"))("㗕" "㜌" "㝅" "㝤" "㨌" "㳶" "㺃" "䃓" "䝭" "䞀" "佝" "傋" "冓" "勾" "句" "坸" "垢" "够" "夠" "姤" "媾" "岣" "彀" "拘" "搆" "撀" "构" "枸" "構" "沟" "溝" "煹" "狗" "玽" "痀" "穀" "笱" "篝" "緱" "缑" "耇" "耈" "耉" "耩" "芶" "苟" "茩" "蚼" "褠" "覯" "觏" "訽" "詬" "诟" "豰" "豿" "購" "购" "軥" "逅" "遘" "鈎" "鉤" "钩" "雊" "鞲" "韝" "骺" "鴝" "鷇"))
    ((("g" "u"))("㒴" "㚉" "㧽" "㯏" "㼋" "㽽" "㾶" "䀇" "䀜" "䀦" "䀰" "䅽" "䊺" "䍍" "䍛" "䐨" "䓛" "䓢" "䜼" "䡩" "䮩" "䵻" "䶜" "估" "僱" "凅" "古" "呱" "咕" "唂" "唃" "嘏" "固" "堌" "夃" "姑" "嫴" "孤" "家" "尳" "崓" "崮" "怘" "愲" "扢" "抇" "搰" "故" "杚" "柧" "梏" "棝" "榖" "榾" "橭" "毂" "汨" "汩" "沽" "泒" "淈" "滑" "濲" "瀔" "焸" "牯" "牿" "狜" "瓠" "痼" "皋" "皷" "皼" "盬" "瞽" "祻" "稒" "穀" "笟" "箍" "箛" "糓" "縎" "罛" "罟" "羖" "股" "胍" "脵" "臌" "苦" "苽" "菇" "菰" "蓇" "薣" "蛄" "蛊" "蛌" "蠱" "角" "觚" "詁" "诂" "谷" "賈" "贾" "軱" "轂" "辜" "酤" "鈲" "鈷" "錮" "钴" "锢" "雇" "離" "頋" "顧" "顾" "餶" "馉" "骨" "骰" "鮕" "鯝" "鲴" "鴣" "鵠" "鶮" "鶻" "鸪" "鹄" "鹘" "鼓" "鼔"))
    ((("g" "u" "a"))("㒷" "䈑" "冎" "刮" "剐" "剮" "劀" "卦" "叧" "呱" "啩" "坬" "寡" "懖" "括" "挂" "捖" "掛" "栝" "桰" "煱" "瓜" "瘑" "筈" "絓" "緺" "罣" "罫" "聒" "胍" "脶" "腡" "舌" "葀" "蜗" "蝸" "褂" "詿" "诖" "趏" "踻" "适" "銽" "頢" "颳" "騧" "髺" "鴰" "鸹"))
    ((("g" "u" "a" "i"))("㧔" "㷇" "㽇" "䂯" "䊽" "乖" "叏" "夬" "怪" "恠" "拐" "旝" "枴" "柺" "癐" "箉" "罫"))
    ((("g" "u" "a" "n"))("㮡" "㴦" "䂯" "䌯" "䎚" "䏓" "䗆" "䗰" "䘾" "䙛" "䙮" "䝺" "䦎" "䩪" "䪀" "䲘" "丱" "串" "倌" "关" "冠" "官" "悹" "悺" "惯" "慣" "掼" "摜" "擐" "斡" "棺" "樌" "櫬" "毌" "泴" "浣" "涫" "淪" "潅" "澣" "灌" "爟" "琯" "瓘" "痯" "瘝" "癏" "盥" "矔" "矜" "礶" "祼" "筦" "管" "綸" "纶" "缶" "罆" "罐" "脘" "舘" "莞" "菅" "蒄" "覌" "観" "觀" "观" "謴" "貫" "贯" "輨" "遦" "錧" "鏆" "鑵" "関" "闗" "關" "雚" "館" "馆" "鰥" "鱞" "鱹" "鳏" "鳤" "鸛" "鹳" "館"))
    ((("g" "u" "a" "n" "g"))("㫛" "䍍" "侊" "俇" "僙" "光" "咣" "垙" "姯" "广" "広" "廣" "桄" "横" "櫎" "洸" "潢" "灮" "炗" "炛" "烡" "犷" "獷" "珖" "胱" "臦" "臩" "茪" "輄" "迋" "逛" "銧" "黆"))
    ((("g" "u" "i"))("㔳" "㙺" "㧪" "㨳" "㩻" "㪈" "㱦" "㲹" "㸵" "䁛" "䃽" "䇈" "䌆" "䍯" "䍷" "䐴" "䖯" "䙆" "䝿" "䞈" "䞨" "䠩" "䣀" "䤥" "䯣" "䰎" "䳏" "亀" "会" "佹" "傀" "刽" "刿" "劊" "劌" "匦" "匭" "匮" "匱" "厬" "圭" "垝" "妫" "姽" "媯" "媿" "嫢" "嬀" "宄" "嶡" "巂" "巜" "帰" "庋" "庪" "廆" "归" "恑" "摫" "撅" "撌" "攰" "攱" "敮" "昋" "晷" "暩" "會" "朹" "柜" "桂" "桧" "椝" "概" "槻" "槼" "檜" "櫃" "歸" "氿" "洼" "溈" "溎" "潙" "炅" "炔" "珪" "瑰" "璝" "瓌" "癸" "皈" "眭" "瞆" "瞶" "硅" "祈" "祪" "禬" "窐" "筀" "簋" "繪" "膭" "蓕" "蛫" "蟡" "袿" "襘" "規" "规" "觖" "觤" "詭" "诡" "貴" "贵" "趹" "跪" "蹶" "軌" "轨" "邽" "郌" "鐀" "閨" "闺" "陒" "隗" "鞼" "騩" "鬶" "鬹" "鬼" "鮭" "鱖" "鱥" "鲑" "鳜" "龜" "龟"))
    ((("g" "u" "n"))("㔳" "㙥" "㨰" "㫎" "㯻" "䃂" "䎾" "䙛" "䜇" "䵪" "丨" "掍" "棍" "浑" "混" "渾" "滚" "滾" "璭" "睔" "睴" "磙" "緄" "绲" "蓘" "蔉" "衮" "袞" "袬" "裩" "裷" "輥" "辊" "錕" "鮌" "鯀" "鰥" "鲧"))
    ((("g" "u" "o"))("㕵" "㖪" "㚍" "㞅" "㳀" "㶁" "䂸" "䆐" "䐸" "䙨" "䤋" "䬎" "䴹" "呙" "啯" "嘓" "囯" "囶" "囻" "国" "圀" "國" "埚" "堝" "墎" "崞" "帼" "幗" "惈" "慖" "掴" "摑" "敋" "果" "椁" "槨" "活" "涡" "淉" "渦" "漍" "濄" "猓" "簂" "粿" "綶" "緺" "聒" "聝" "腂" "腘" "膕" "菓" "虢" "蜮" "蜾" "蝈" "蝸" "蟈" "蠃" "裹" "輠" "过" "過" "郭" "鈛" "錁" "鍋" "鐹" "锅" "餜" "馃" "馘")) 
    ((("h" "a"))("哈" "奤" "獬" "虾" "蛤" "蝦" "鉿" "铪" "𠀀"))
    ((("h" "a" "i"))("㕢" "㜾" "㤥" "㦟" "㧡" "㨟" "㱚" "㺔" "䂤" "䇋" "䍖" "䠹" "䠽" "䯐" "䱺" "亥" "咍" "咳" "嗐" "嗨" "孩" "害" "氦" "海" "烸" "胲" "还" "還" "酼" "醢" "閡" "頦" "颏" "餀" "饚" "駭" "骇" "骸" "𠀅" "𥩲"))
    ((("h" "a" "n"))("㑵" "㒈" "㖤" "㘎" "㘕" "㘚" "㙈" "㙔" "㙳" "㜦" "㟏" "㟔" "㢨" "㨔" "㪋" "㮀" "㲦" "㵄" "㵎" "㶰" "㸁" "㺖" "㼨" "㽉" "㽳" "䁔" "䈄" "䌍" "䍐" "䍑" "䎏" "䎯" "䏎" "䏷" "䐄" "䓍" "䓿" "䕿" "䖔" "䗙" "䗣" "䘶" "䛞" "䤴" "䥁" "䦈" "䧲" "䨡" "䫲" "䮧" "䶃" "佄" "傼" "函" "凾" "厂" "厈" "含" "哻" "唅" "喊" "嚂" "圅" "垾" "壏" "娢" "娨" "嫨" "寒" "屽" "崡" "干" "幹" "悍" "憨" "憾" "扞" "捍" "撖" "撼" "擀" "攌" "旰" "旱" "晗" "晘" "晥" "暵" "梒" "椷" "汉" "汗" "泔" "浛" "浫" "涆" "涵" "淊" "漢" "澉" "澏" "瀚" "灘" "炶" "焊" "焓" "熯" "犴" "猂" "琀" "甝" "皔" "睅" "筨" "罕" "翰" "肣" "莟" "菡" "蔊" "虷" "蚶" "蛿" "蜭" "螒" "譀" "谽" "豃" "豻" "貋" "軒" "邗" "邯" "酐" "酣" "釬" "鈐" "銲" "鋎" "鋡" "閈" "闞" "闬" "雗" "韓" "韩" "頇" "頜" "頷" "顄" "顉" "顸" "颌" "颔" "馠" "馯" "駻" "鬫" "魽" "鳱" "鶾" "鼾"))
    ((("h" "a" "n" "g"))("㤚" "䀪" "䘕" "䟘" "䢚" "䣈" "䦳" "䲳" "䴂" "吭" "夯" "巷" "斻" "杭" "桁" "汻" "沆" "炕" "狠" "狼" "笐" "筕" "絎" "绗" "肮" "航" "苀" "蚢" "行" "貥" "迒" "酐" "頏" "颃" "魧" "鴴" "鸻"))
    ((("h" "a" "o"))("㕺" "㘪" "㙱" "㚪" "㝀" "㞻" "㠙" "㩝" "㬔" "㬶" "㵆" "䒵" "䚽" "䝞" "䝥" "䧚" "䧫" "䪽" "䬉" "䯫" "侾" "傐" "儫" "勂" "号" "呺" "哠" "嗥" "嘷" "噑" "嚆" "嚎" "壕" "好" "峼" "恏" "悎" "昊" "昦" "晧" "暠" "暤" "暭" "曍" "椃" "毫" "浩" "涸" "淏" "滈" "滜" "澔" "濠" "瀥" "灏" "灝" "獆" "獋" "獔" "皋" "皓" "皜" "皞" "皡" "皥" "睪" "睾" "秏" "籇" "耗" "聕" "茠" "蒿" "薃" "薅" "薧" "藃" "號" "蚝" "蠔" "諕" "譹" "豪" "貈" "貉" "郝" "鄗" "鎬" "镐" "顥" "颢" "鰝"))
    ((("h" "e"))("㓭" "㔠" "㕡" "㕰" "㙳" "㥺" "㦦" "㪉" "㬞" "㭘" "㭱" "㮝" "㮫" "㲦" "㵑" "㷎" "㷤" "㹇" "㻧" "㿣" "䃒" "䅂" "䎋" "䒩" "䓼" "䕣" "䙓" "䚂" "䞦" "䢔" "䢗" "䪚" "䫘" "䮤" "䯨" "䳚" "䳽" "䴳" "䵱" "䶅" "何" "佫" "俰" "凅" "劾" "厒" "合" "吓" "呵" "咊" "和" "哬" "啝" "喛" "喝" "嗃" "嗑" "嗬" "嚇" "壑" "姀" "害" "峆" "嵑" "廅" "惒" "抲" "敆" "暍" "曷" "柇" "核" "楁" "槅" "欱" "毼" "河" "洽" "涸" "渴" "滆" "澕" "焃" "煂" "熆" "熇" "爀" "狢" "猲" "癋" "皬" "盇" "盉" "盍" "盒" "盖" "硅" "碋" "礉" "禾" "秴" "篕" "籺" "紇" "繳" "纥" "翮" "翯" "耠" "苛" "荷" "菏" "萂" "葢" "蒚" "蓋" "藿" "蚵" "蝎" "螛" "蠚" "袔" "褐" "覈" "訶" "訸" "詥" "诃" "貈" "貉" "賀" "贺" "赫" "輅" "轄" "郃" "釛" "鉀" "鉌" "钾" "閡" "閤" "闔" "阂" "阖" "隺" "霍" "靎" "靏" "鞨" "頜" "颌" "餄" "餲" "饸" "鬩" "魺" "鲄" "鵠" "鶡" "鶴" "鸖" "鹖" "鹤" "麧" "黑" "齕" "龁" "龢" "鶴"))
    ((("h" "e" "i"))("嘿" "潶" "黑" "黒"))
    ((("h" "e" "n"))("㯊" "䓳" "佷" "哏" "噷" "很" "恨" "拫" "狠" "痕" "艮" "詪" "鞎"))
    ((("h" "e" "n" "g"))("㔰" "㶇" "䄓" "䒛" "䬖" "䬝" "䯒" "亨" "哼" "啈" "姮" "恆" "恒" "悙" "揘" "撔" "桁" "楻" "横" "橫" "澋" "珩" "絎" "绗" "胻" "脝" "蘅" "行" "衡" "訇" "誙" "諻" "鐄" "鑅" "韹" "鴴" "鸻" "黉" "黌"))
    ((("h" "o" "n" "g"))("㖓" "㢬" "㬴" "㶹" "㷎" "䀧" "䂫" "䃔" "䆖" "䉺" "䍔" "䜫" "䞑" "䡌" "䡏" "䧆" "䨎" "䩑" "䪦" "䫹" "䫺" "䬝" "䲨" "仜" "叿" "吰" "呍" "哄" "唝" "嗊" "垬" "妅" "娂" "宏" "宖" "峵" "嵤" "弘" "彋" "揈" "晎" "汪" "汯" "泓" "洚" "洪" "浤" "港" "渱" "渹" "潂" "澒" "灴" "烘" "焢" "玒" "瓨" "硔" "硡" "竑" "竤" "篊" "粠" "紅" "紘" "紭" "綋" "红" "纮" "缸" "翃" "翝" "耾" "舼" "苰" "荭" "葒" "葓" "蕻" "薨" "虹" "触" "訇" "訌" "謍" "讧" "谹" "谼" "谾" "軣" "輷" "轟" "轰" "鈜" "鉷" "鋐" "鍙" "鍧" "閎" "閧" "闳" "霟" "鞃" "顭" "鬨" "魟" "鴻" "鸿" "黉" "黌"))
    ((("h" "o" "u"))("㕈" "㖃" "㗋" "㤧" "㫗" "㬋" "㮢" "㸸" "㺅" "䂉" "䗔" "䙈" "䞀" "䞧" "䡩" "䪷" "䫛" "䫺" "䳧" "侯" "候" "厚" "后" "吼" "吽" "呴" "喉" "垕" "堠" "帿" "後" "洉" "灬" "犼" "猴" "瘊" "睺" "矦" "篌" "糇" "缿" "翭" "腄" "茩" "葔" "詬" "豞" "逅" "郈" "鄇" "銗" "鍭" "餱" "骺" "鮜" "鯸" "鱟" "鲎" "鲘" "齁"))
    ((("h" "u"))("㕆" "㗅" "㦿" "㧽" "㨭" "㪶" "㯛" "㷤" "㸦" "㹱" "㺉" "㽇" "㾰" "㿥" "䁫" "䇘" "䈸" "䉉" "䉿" "䊀" "䊺" "䍓" "䎁" "䔯" "䕶" "䗂" "䚛" "䛎" "䞱" "䠒" "䧼" "䨥" "䨼" "䩴" "䪝" "䭅" "䭌" "䭍" "䮸" "䲵" "䵻" "乎" "乕" "互" "冱" "冴" "匢" "匫" "呼" "唬" "唿" "啒" "喖" "嘑" "嘝" "嚛" "囫" "垀" "壶" "壷" "壺" "婟" "媩" "嫭" "嫮" "寣" "岵" "峘" "帍" "幠" "弖" "弧" "忽" "怙" "戏" "戯" "戱" "戶" "户" "戸" "戽" "扈" "抇" "抚" "护" "搰" "摢" "撫" "擭" "斛" "昈" "昒" "曶" "枑" "核" "楛" "楜" "槲" "槴" "欻" "歑" "汩" "沍" "沪" "泘" "浒" "淴" "湖" "滬" "滸" "滹" "濩" "瀫" "烀" "烼" "焀" "煳" "熩" "狐" "猢" "琥" "瑚" "瓠" "瓳" "祜" "笏" "箶" "簄" "糊" "絗" "綔" "縠" "羽" "胍" "胡" "膴" "芋" "芐" "芴" "苸" "萀" "葫" "蔛" "蔰" "虍" "虎" "虖" "虝" "蝴" "螜" "衚" "觳" "許" "謼" "護" "许" "豰" "軤" "轷" "鄠" "酏" "醐" "鈷" "鍸" "雐" "韄" "頀" "頶" "餬" "鬍" "魱" "鰗" "鱯" "鳠" "鳸" "鴩" "鵠" "鶘" "鶦" "鶻" "鸌" "鹄" "鹕" "鹘" "鹱"))
    ((("h" "u" "a"))("㓰" "㕦" "㕲" "㕷" "㚌" "㟆" "㠏" "㠢" "㦊" "㦎" "㩇" "㭉" "㮯" "䅿" "䇈" "䊐" "䏦" "䔢" "䔯" "䛡" "䠉" "䱻" "䴳" "䶤" "划" "劃" "化" "华" "咶" "哗" "嘩" "婳" "嫿" "嬅" "崋" "搳" "摦" "杹" "桦" "槬" "樺" "滑" "澅" "澮" "狯" "猾" "獪" "画" "畫" "畵" "砉" "磆" "稞" "繣" "罫" "舙" "花" "芲" "華" "蕐" "蘤" "蘳" "螖" "觟" "話" "諣" "譁" "譮" "话" "豁" "踝" "輠" "釫" "鋘" "錵" "鏵" "铧" "驊" "骅" "鮭" "鷨" "𢄶"))
    ((("h" "u" "a" "i"))("㜳" "㠢" "䃶" "䈭" "䴜" "佪" "咶" "坏" "壊" "壞" "孬" "徊" "怀" "懐" "懷" "槐" "櫰" "淮" "瀤" "竵" "耲" "蘹" "蘾" "褢" "褱" "諙" "踝"))
    ((("h" "u" "a" "n"))("㓉" "㔳" "㕕" "㠢" "㡲" "㢰" "㣪" "㦥" "㪱" "㬇" "㬊" "㵹" "㶎" "㹖" "㼫" "㿪" "䀓" "䀨" "䁔" "䆠" "䈠" "䊐" "䍺" "䒛" "䝠" "䠉" "䥧" "䦡" "䭴" "䮝" "䯘" "䴟" "唍" "唤" "喚" "喛" "嚾" "圜" "垸" "奂" "奐" "嬛" "宦" "寏" "寰" "峘" "嵈" "幻" "患" "愌" "懁" "懽" "捖" "换" "換" "擐" "攌" "桓" "梙" "梡" "槵" "欢" "歓" "歡" "洹" "浣" "涣" "渙" "漶" "潅" "澣" "澴" "灌" "烉" "焕" "煥" "犿" "狟" "獂" "獾" "环" "瑍" "瑗" "環" "瓛" "痪" "瘓" "皖" "眩" "睆" "糫" "綄" "緩" "繯" "缓" "缳" "羦" "肒" "脘" "苋" "荁" "莧" "萈" "萑" "藧" "讙" "豢" "豲" "貆" "貛" "輐" "轘" "还" "逭" "還" "郇" "酄" "鍰" "鐶" "锾" "镮" "闤" "阛" "雈" "驩" "鬟" "鯇" "鯶" "鰀" "鲩" "鴅" "鵍" "鸛"))
    ((("h" "u" "a" "n" "g"))("㞷" "㤺" "㨪" "㬻" "㾠" "㾮" "䁜" "䄓" "䅣" "䊗" "䊣" "䌙" "䍿" "䐠" "䐵" "䑟" "䞹" "䪄" "䮲" "䳨" "偟" "兤" "凰" "喤" "嚝" "堭" "塃" "墴" "媓" "宺" "崲" "巟" "幌" "徨" "怳" "恍" "惶" "愰" "慌" "撗" "晃" "晄" "曂" "朚" "榥" "横" "櫎" "洸" "湟" "滉" "潢" "炾" "煌" "熀" "熿" "爌" "獚" "瑝" "璜" "癀" "皇" "皝" "皩" "磺" "穔" "篁" "簧" "肓" "艎" "芒" "茫" "荒" "葟" "蝗" "蟥" "衁" "詤" "謊" "谎" "趪" "軦" "遑" "鍠" "鎤" "锽" "隍" "餭" "騜" "鰉" "鱑" "鳇" "鷬" "黃" "黄" "𣄙" "𪏙"))
    ((("h" "u" "i"))("㑰" "㑹" "㒑" "㜇" "㞧" "㤬" "㥣" "㨤" "㨹" "㩓" "㩨" "㬩" "㰥" "㱱" "㷄" "㷐" "㻅" "㽇" "䂕" "䃣" "䅏" "䇻" "䌇" "䍷" "䎚" "䏨" "䕇" "䙌" "䙡" "䛛" "䛼" "䜋" "䠉" "䤧" "䧥" "䩈" "䫖" "䫭" "䰎" "䵻" "会" "僡" "儶" "匯" "卉" "叀" "咴" "哕" "喙" "嘒" "噅" "噕" "噦" "噧" "嚖" "囘" "回" "囬" "圚" "堕" "墮" "墯" "婎" "嬇" "寭" "幑" "廆" "廻" "廽" "彗" "彙" "彚" "徊" "徽" "恚" "恛" "恢" "恵" "悔" "悝" "惠" "慧" "憓" "戏" "戯" "戱" "拻" "挥" "揮" "撝" "晖" "晦" "暉" "暳" "會" "桧" "楎" "槥" "橞" "檓" "檜" "櫘" "殨" "毀" "毁" "毇" "汇" "沬" "泋" "洃" "洄" "渙" "湏" "滙" "潓" "澮" "濊" "瀈" "灰" "烜" "烠" "烣" "烩" "煇" "煒" "燬" "燴" "獩" "珲" "琿" "璯" "痐" "皓" "眭" "瞺" "禈" "禬" "秽" "穢" "篲" "絵" "繐" "繢" "繪" "绘" "缋" "翙" "翚" "翬" "翽" "芔" "茴" "荟" "蔧" "蕙" "薈" "薉" "藱" "虫" "虺" "蚘" "蛔" "蛕" "蜖" "蝰" "螝" "蟪" "袆" "褘" "詯" "詼" "誨" "諱" "譓" "譭" "譿" "讳" "诙" "诲" "豗" "賄" "贿" "輝" "輠" "辉" "迴" "逥" "違" "鉞" "鏸" "鐬" "鑴" "钺" "闠" "阓" "隓" "隳" "靧" "韋" "韢" "頮" "顪" "颒" "餯" "饖" "鮰" "鰴" "麾" "𠧩"))
    ((("h" "u" "n"))("㑮" "㕵" "㥵" "㨡" "㨰" "㮯" "㯻" "䅙" "䅱" "䊐" "䐊" "䚠" "䛰" "䧰" "䫟" "䮝" "䰟" "䴷" "俒" "倱" "圂" "堚" "婚" "忶" "惛" "惽" "慁" "掍" "敯" "昆" "昏" "昬" "棍" "棔" "棞" "楎" "殙" "浑" "涽" "混" "渾" "湣" "溷" "焄" "焜" "焝" "珲" "琿" "睔" "睧" "睯" "祵" "緄" "緡" "繉" "荤" "葷" "觨" "諢" "诨" "轋" "閽" "阍" "顐" "餛" "餫" "馄" "魂" "鯶" "鼲")) 
    ((("h" "u" "o"))("㓉" "㕡" "㗲" "㘞" "㚌" "㦜" "㦯" "㨯" "㨰" "㩇" "㯉" "㯛" "㶡" "㸌" "䁨" "䂄" "䄀" "䄆" "䄑" "䉟" "䋭" "䐸" "䣶" "䦚" "䨥" "䯏" "䰥" "伙" "佸" "剨" "劐" "咊" "和" "咟" "嗀" "嚄" "嚯" "嚿" "壑" "夥" "奯" "彟" "彠" "惑" "或" "捇" "掝" "擭" "攉" "旤" "曤" "楇" "檴" "沎" "活" "湱" "濊" "濩" "瀖" "火" "獲" "瓁" "瓠" "癨" "眓" "矆" "矐" "矱" "砉" "硅" "礊" "祸" "禍" "秮" "秳" "穫" "耠" "耯" "臒" "臛" "艧" "获" "萿" "蓃" "藿" "蠖" "謋" "讗" "豁" "豰" "貨" "货" "越" "過" "邩" "鈥" "鍃" "鑊" "钬" "锪" "镬" "閄" "雘" "霍" "霩" "靃" "韄" "頀" "騞" "鱯" "鳠" "鸌" "鹱" "龢" "嗀"))
    ((("j" "i"))("㑧" "㑵" "㒫" "㔕" "㖢" "㗊" "㗱" "㘍" "㙨" "㙫" "㚡" "㞃" "㞆" "㞛" "㞦" "㠍" "㠎" "㠖" "㠱" "㡇" "㡭" "㡮" "㡶" "㤂" "㥍" "㥛" "㦸" "㧀" "㨈" "㭰" "㭲" "㮟" "㮨" "㰟" "㱞" "㱦" "㱯" "㲅" "㲺" "㳵" "㴉" "㴕" "㸄" "㹄" "㻑" "㻷" "㽺" "㾊" "㾒" "㾵" "䁒" "䆅" "䋟" "䍤" "䍯" "䐀" "䐕" "䐚" "䒁" "䓧" "䓫" "䓽" "䗁" "䚐" "䛋" "䜞" "䝸" "䞘" "䟌" "䠏" "䢋" "䢳" "䣢" "䤒" "䤠" "䦇" "䦈" "䨖" "䩐" "䩯" "䮺" "䯂" "䰏" "䰥" "䲯" "䳭" "䶓" "䶩" "丌" "丮" "乩" "亟" "亼" "伋" "伎" "佶" "偈" "偮" "僟" "其" "兾" "冀" "几" "击" "刉" "刏" "剂" "剞" "剤" "劑" "勣" "卙" "即" "卽" "及" "叽" "吃" "吉" "咭" "哜" "唧" "唶" "喞" "喫" "嗘" "嘰" "嚌" "圾" "坖" "垍" "基" "堲" "塈" "塉" "墍" "墼" "奇" "妀" "妓" "姞" "姫" "姬" "嫉" "季" "寂" "寄" "尐" "居" "屐" "岌" "峜" "嵆" "嵇" "嵠" "嵴" "嶯" "己" "幾" "庪" "庴" "彐" "彑" "彶" "忌" "忣" "急" "悸" "惎" "愱" "憿" "懻" "戟" "戢" "技" "挤" "掎" "揖" "揤" "撃" "撠" "擊" "擠" "擮" "攲" "旡" "既" "旣" "暨" "曁" "朞" "期" "机" "极" "枅" "梞" "棋" "棘" "楖" "楫" "極" "槉" "樍" "機" "橶" "檕" "檝" "檱" "檵" "櫅" "櫭" "殛" "毄" "汲" "泲" "洁" "洎" "济" "済" "湒" "漃" "漈" "潗" "激" "濈" "濟" "瀱" "焏" "犄" "犱" "狤" "猗" "猤" "玑" "玘" "璣" "璾" "畸" "畿" "疵" "疾" "痵" "瘈" "瘠" "瘵" "癠" "皀" "皍" "睽" "瞡" "瞿" "矶" "磯" "礏" "祭" "禝" "禨" "积" "秶" "秸" "稘" "稩" "稷" "稽" "穄" "穊" "積" "穖" "穧" "笄" "笈" "筓" "箕" "箿" "簊" "籍" "粢" "系" "紀" "紒" "級" "結" "給" "継" "緁" "緝" "績" "繫" "繼" "级" "纪" "结" "给" "继" "绩" "缉" "罽" "羁" "羇" "羈" "耤" "耭" "聻" "肌" "脊" "脔" "膌" "臮" "艻" "芨" "芰" "茍" "茤" "荠" "莋" "萁" "葪" "蒺" "蓟" "蓻" "蔇" "蕀" "蕺" "薊" "薺" "藉" "蘄" "蘎" "蘮" "蘻" "虀" "虮" "蛣" "蜡" "蝍" "螏" "蟣" "蟻" "蟿" "裚" "褀" "襀" "襋" "覉" "覊" "覘" "覬" "覿" "觊" "觙" "觭" "計" "訐" "記" "誋" "諅" "諆" "譏" "譤" "计" "讥" "记" "賫" "賷" "赍" "跡" "跻" "跽" "踑" "踖" "踦" "蹐" "蹟" "躋" "躤" "躸" "輯" "轚" "辑" "近" "迹" "邔" "郅" "郆" "鈒" "鈘" "銈" "銡" "錤" "鍓" "鏶" "鐖" "鑇" "鑙" "钑" "际" "隔" "際" "隮" "集" "雞" "雦" "雧" "霁" "霵" "霽" "革" "鞊" "鞿" "韲" "飢" "饑" "饥" "騎" "驥" "骑" "骥" "髻" "鬾" "魕" "魝" "魢" "鮆" "鯚" "鯽" "鰶" "鰿" "鱀" "鱭" "鱾" "鲚" "鲫" "鳮" "鴶" "鵋" "鶏" "鶺" "鷄" "鸄" "鸡" "鹡" "麂" "麡" "齊" "齌" "齎" "齏" "齐" "齑" "𠼻" "𡜱"))
    ((("j" "i" "a"))("㔠" "㕅" "㪴" "㮖" "㼪" "㿓" "䀫" "䀹" "䁍" "䇲" "䑝" "䕛" "䛟" "䢔" "䩡" "乫" "仮" "价" "伽" "佳" "価" "假" "傢" "價" "加" "叚" "唊" "嘉" "嘏" "圿" "埉" "夏" "夹" "夾" "婽" "嫁" "家" "岬" "幏" "徦" "恝" "戛" "戞" "扴" "拁" "拮" "挟" "挾" "揳" "斚" "斝" "架" "枷" "柙" "梜" "椵" "榎" "榢" "槚" "檟" "毠" "泇" "浃" "浹" "犌" "猳" "玾" "珈" "甲" "痂" "瘕" "睱" "硈" "稼" "笳" "筴" "耞" "胛" "腵" "舺" "茄" "荚" "莢" "葭" "蛱" "蛺" "蝦" "袈" "袷" "裌" "豭" "貑" "賈" "贾" "跏" "跲" "迦" "郏" "郟" "鉀" "鉫" "鉿" "鋏" "鎵" "钾" "铗" "铪" "镓" "鞂" "鞈" "頡" "頬" "頰" "颉" "颊" "餄" "饸" "駕" "駱" "驾" "骱" "鴐" "鴚" "鵊" "麚"))
    ((("j" "i" "a" "n"))("㓺" "㔋" "㔓" "㣤" "㦗" "㨴" "㨵" "㯺" "㰄" "㱯" "㳨" "㵎" "㶕" "㺂" "㺝" "㽉" "䄯" "䅐" "䇟" "䉍" "䛳" "䞼" "䟅" "䟢" "䟰" "䤔" "䥜" "䧖" "䩆" "䬻" "䭈" "䭕" "䭠" "䮿" "䯛" "䯡" "䵖" "䵛" "䵡" "䵤" "䶠" "件" "侟" "俭" "俴" "俿" "倹" "偂" "健" "僣" "僭" "儉" "兼" "冿" "减" "剑" "剣" "剪" "剱" "劍" "劎" "劒" "劔" "劗" "囏" "囝" "坚" "堅" "堿" "奸" "姦" "姧" "寋" "尖" "帴" "建" "弿" "徤" "惤" "戋" "戔" "戩" "戬" "拣" "挸" "捡" "揀" "揃" "揵" "搛" "撿" "擶" "旔" "暕" "枅" "枧" "柬" "栫" "梘" "检" "検" "椷" "椾" "楗" "榗" "槛" "樫" "檢" "檻" "櫼" "歼" "殲" "毽" "沮" "洊" "涧" "淺" "渐" "減" "湔" "湕" "湛" "溅" "漸" "澗" "濫" "濺" "瀐" "瀳" "瀸" "瀽" "煎" "熞" "熸" "牋" "牮" "犍" "犴" "猏" "玪" "珔" "瑊" "瑐" "监" "監" "睑" "睷" "瞯" "瞷" "瞼" "硷" "碊" "碱" "磵" "礆" "礛" "笕" "笺" "筧" "简" "箋" "箭" "箴" "篯" "簡" "籛" "糋" "絸" "緘" "縑" "繝" "繭" "纖" "纤" "缄" "缣" "翦" "聻" "肩" "腱" "臶" "舰" "艦" "艰" "艱" "茛" "茧" "荐" "菅" "菺" "葌" "蒹" "蔪" "蕑" "蕳" "薦" "藆" "虃" "螹" "蠒" "裥" "襇" "襉" "襺" "見" "覵" "覸" "见" "諌" "諓" "諫" "謇" "謭" "譖" "譼" "譾" "谏" "谫" "谮" "豜" "豣" "賎" "賤" "贱" "趝" "趼" "跈" "践" "踐" "踺" "蹇" "軒" "釼" "鈃" "鉴" "銒" "鋻" "錢" "鍳" "鍵" "鎫" "鏨" "鏩" "鐗" "鐧" "鑑" "鑒" "鑬" "鑯" "鑳" "钘" "钱" "锏" "键" "閒" "間" "间" "險" "靬" "鞬" "鞯" "韀" "韉" "顅" "餞" "餰" "饯" "馢" "騝" "騫" "鬋" "魐" "魙" "鰎" "鰔" "鰜" "鰹" "鲣" "鳒" "鳽" "鵳" "鶼" "鹣" "鹸" "鹻" "鹼" "麉" "齊" "齐"))
    ((("j" "i" "a" "n" "g"))("㢡" "㯍" "䁰" "䉃" "䋌" "䒂" "䙹" "䞪" "䥒" "傹" "僵" "勥" "匞" "匠" "塂" "壃" "夅" "奖" "奨" "奬" "姜" "将" "將" "嵹" "弜" "弶" "強" "强" "彊" "摪" "摾" "桨" "槳" "橿" "殭" "江" "洚" "浆" "滰" "漿" "犟" "獎" "瓨" "畕" "畺" "疅" "疆" "礓" "糡" "糨" "紅" "絳" "繈" "繦" "繮" "绛" "缰" "翞" "膙" "茳" "葁" "蒋" "蔃" "蔣" "薑" "虹" "螀" "螿" "袶" "襁" "講" "謽" "讲" "豇" "酱" "醤" "醬" "降" "韁" "顜" "鱂" "鳉" "𢘸"))
    ((("j" "i" "a" "o"))("㠐" "㩭" "㩰" "㬭" "㭂" "㰾" "㱶" "㳅" "㽱" "㽲" "㿟" "䀊" "䁶" "䂃" "䆗" "䘨" "䚩" "䠛" "䢪" "䣤" "䥞" "䪒" "䴔" "䴛" "交" "佼" "侥" "僥" "僬" "儌" "剿" "劋" "勦" "叫" "呌" "咬" "嘂" "嘄" "嘐" "嘦" "噍" "噭" "嚼" "姣" "娇" "嫶" "嬌" "嬓" "孂" "峤" "峧" "嶕" "嶠" "徺" "徼" "憍" "憿" "挍" "挢" "捁" "搅" "摷" "撟" "撹" "攪" "敎" "教" "敫" "敽" "敿" "斅" "斆" "斠" "晈" "暞" "曒" "校" "椒" "樔" "浇" "湫" "湬" "滘" "漅" "漖" "潐" "澆" "激" "灂" "灚" "烄" "焦" "焳" "煍" "燋" "爝" "狡" "珓" "璬" "皎" "皛" "皦" "皭" "矫" "矯" "礁" "穚" "窌" "窖" "筊" "糺" "糾" "絞" "繳" "纠" "绞" "缴" "胶" "脚" "腳" "膠" "膲" "臫" "艽" "芁" "茭" "茮" "荞" "菽" "蕉" "蕎" "藠" "虠" "蛟" "蟂" "蟜" "蟭" "覐" "覺" "觉" "角" "訆" "詨" "譑" "譥" "賋" "趭" "跤" "踋" "較" "轇" "轎" "轿" "较" "郊" "酵" "醮" "醶" "釂" "鉸" "鐎" "铰" "顜" "餃" "饺" "驕" "骄" "鮫" "鱎" "鲛" "鴵" "鵁" "鷍" "鷦" "鷮" "鹪" "齩" "𨺹"))
    ((("j" "i" "e"))("㑘" "㑵" "㓗" "㓤" "㔾" "㘶" "㛃" "㝌" "㝏" "㞯" "㠍" "㠹" "㦢" "㨗" "㨩" "㨰" "㮞" "㮮" "㸄" "㸅" "㾏" "㿍" "䀷" "䁓" "䂃" "䂒" "䂝" "䂶" "䅥" "䇒" "䌖" "䔿" "䕙" "䗻" "䘁" "䛺" "䞦" "䟌" "䣠" "䥛" "䯰" "䰺" "䱄" "䲙" "䲸" "丯" "介" "价" "借" "倢" "偈" "偕" "偼" "傑" "價" "刦" "刧" "刼" "劫" "劼" "卩" "卪" "吤" "唶" "喈" "喼" "嗟" "堦" "堺" "姐" "婕" "媎" "孑" "家" "寁" "屆" "届" "岊" "岕" "崨" "嵑" "嵥" "巀" "幯" "庎" "廨" "徣" "悈" "戒" "截" "扻" "抾" "拮" "拾" "捷" "接" "掲" "揭" "搩" "擑" "擳" "昅" "杰" "栉" "栨" "桀" "桔" "械" "椄" "楐" "楬" "楶" "楷" "概" "榤" "檞" "櫛" "櫭" "毑" "洁" "洯" "渴" "湝" "滐" "潔" "瀄" "犗" "犵" "獬" "玠" "琾" "瑎" "界" "畍" "疖" "疥" "癤" "皆" "睫" "砎" "砝" "碣" "祖" "秸" "稭" "竭" "箑" "節" "籍" "紇" "紒" "結" "絜" "繲" "结" "罝" "羯" "耤" "脻" "腉" "艥" "节" "芥" "苴" "莭" "菨" "葜" "葪" "蓵" "薢" "藉" "蚧" "蛣" "蜐" "蝔" "蠘" "蠞" "蠽" "街" "衱" "袷" "袺" "裓" "褯" "解" "觧" "訐" "詰" "誡" "誱" "謯" "讦" "诘" "诫" "趌" "踕" "躤" "迼" "鉣" "鍇" "鍻" "鎅" "鐑" "锴" "阶" "階" "頡" "颉" "飷" "騔" "骱" "髻" "魀" "魪" "鮚" "鲒" "鶛" "鶡" "鹖" "𡽱"))
    ((("j" "i" "n"))("㝻" "㦗" "㨷" "㬐" "㬜" "㯲" "㯸" "㰹" "㱈" "㴆" "㶦" "㶳" "㹏" "㻸" "䀆" "䆮" "䉷" "䋮" "䌍" "䌝" "䐶" "䑤" "䒺" "䖐" "䗯" "䝲" "䢻" "䤐" "䥆" "䫴" "䭙" "䶖" "仅" "今" "伒" "侭" "僅" "僸" "儘" "凚" "劤" "劲" "勁" "卺" "厪" "噤" "嚍" "埐" "堇" "墐" "妗" "嫤" "嬧" "尽" "嶜" "巹" "巾" "廑" "惍" "慬" "搢" "斤" "晉" "晋" "暜" "枃" "槿" "歏" "殣" "津" "浕" "浸" "湛" "溍" "漌" "濅" "濜" "烬" "燼" "珒" "琎" "瑧" "瑨" "瑾" "璡" "璶" "瘽" "盡" "矜" "祲" "禁" "筋" "紟" "紧" "緊" "縉" "缙" "肋" "肵" "荕" "荩" "菫" "菳" "蓳" "藎" "衿" "襟" "覲" "觐" "觔" "訡" "謹" "谨" "賮" "贐" "赆" "近" "进" "進" "金" "釿" "鋟" "錦" "钅" "锦" "靲" "靳" "饉" "馑" "鹶" "黅" "齽"))
    ((("j" "i" "n" "g"))("㕋" "㘫" "㢣" "㣏" "㬌" "㵾" "㹵" "䑤" "䔔" "䜘" "䡖" "䴖" "䵞" "丼" "井" "京" "亰" "俓" "倞" "傹" "儆" "兢" "净" "凈" "刭" "剄" "劲" "勁" "坕" "坙" "境" "妌" "婙" "婛" "婧" "宑" "巠" "幜" "弪" "弳" "径" "徑" "惊" "憬" "憼" "擏" "敬" "旌" "旍" "景" "晶" "暻" "曔" "桱" "梷" "檠" "殑" "氏" "汬" "泾" "浄" "涇" "淨" "澋" "濪" "瀞" "烃" "烴" "燛" "猄" "獍" "獷" "璟" "璥" "痉" "痙" "睛" "秔" "稉" "穽" "竞" "竟" "竧" "竫" "競" "竸" "箐" "粳" "精" "経" "經" "经" "聙" "肼" "胫" "脛" "腈" "茎" "荆" "荊" "莖" "菁" "葏" "葝" "蜻" "蟼" "誩" "警" "踁" "迳" "逕" "醒" "鏡" "镜" "阱" "陉" "陘" "青" "靓" "靖" "静" "靚" "靜" "頚" "頸" "颈" "驚" "鯨" "鲸" "鵛" "鶁" "鶄" "麖" "麠" "黥" "鼱" "靖" "精"))
    ((("j" "i" "o" "n" "g"))("㑋" "㓏" "㖥" "㢠" "㤯" "㷗" "㷡" "䌹" "䐃" "䢛" "侰" "僒" "冂" "冋" "冏" "囧" "坰" "垧" "埛" "幜" "扃" "檾" "泂" "澃" "瀅" "炅" "炯" "烱" "煚" "煛" "熒" "熲" "皛" "窘" "絅" "綗" "蘏" "蘔" "褧" "迥" "逈" "鎣" "顈" "颎" "駉" "駫"))
    ((("j" "i" "u"))("㝌" "㠇" "㡱" "㧕" "㩆" "㲃" "㶭" "㺩" "㺵" "㼋" "䅢" "䆒" "䊆" "䊘" "䓘" "䛮" "䠓" "䡂" "䬨" "䳎" "䳔" "丩" "久" "乆" "九" "乣" "僦" "勼" "匓" "匛" "匶" "厩" "咎" "啾" "奺" "媨" "就" "廄" "廏" "廐" "慦" "捄" "揂" "揪" "揫" "摎" "救" "旧" "朻" "柩" "柾" "桕" "樛" "湫" "灸" "牞" "玖" "畂" "疚" "稵" "究" "糺" "紤" "繆" "纠" "缪" "臼" "舅" "舊" "舏" "艽" "萛" "蝤" "觓" "赳" "轇" "酒" "醔" "镹" "阄" "韭" "韮" "鬏" "鬮" "鯦" "鳩" "鷲" "鸠" "鹫" "麔" "齨"))
    ((("j" "u"))("㕢" "㘌" "㘲" "㜘" "㞐" "㞫" "㠪" "㥌" "㨿" "㩀" "㩴" "㪯" "㬬" "㮂" "㳥" "㹼" "㽤" "䃊" "䄔" "䅓" "䆽" "䈮" "䋰" "䎤" "䏱" "䕮" "䗇" "䛯" "䜯" "䡞" "䢹" "䣰" "䤎" "䪕" "䰬" "䱟" "䱡" "䳔" "䴗" "䵕" "䶙" "䶥" "且" "举" "侷" "俱" "倨" "倶" "偊" "具" "冣" "凥" "処" "刟" "剧" "劇" "勮" "匊" "句" "咀" "埧" "埾" "壉" "姖" "娵" "婅" "寠" "局" "居" "屦" "屨" "岠" "岨" "崌" "巈" "巨" "弆" "怇" "怚" "惧" "愳" "懅" "懼" "抅" "拒" "拘" "拠" "挙" "挶" "捄" "据" "掬" "據" "擧" "昛" "枸" "柜" "柤" "桔" "梮" "椇" "椈" "椐" "楀" "榉" "榘" "橘" "檋" "櫸" "欅" "歫" "毩" "毱" "沮" "泃" "泦" "洰" "涺" "淗" "渠" "湨" "澽" "炬" "焗" "焣" "犋" "犑" "狊" "狙" "琚" "疽" "痀" "眗" "瞿" "矩" "砠" "租" "秬" "窭" "窶" "竘" "筥" "箤" "簍" "簴" "籧" "粔" "粷" "絇" "繘" "罝" "耟" "聚" "腒" "舉" "艍" "苣" "苴" "莒" "菊" "菹" "萭" "葅" "蒟" "蔞" "蘜" "虡" "蚷" "蛆" "蜛" "蝺" "袓" "裾" "詎" "諊" "讵" "貗" "趄" "趜" "足" "跔" "跙" "距" "跼" "踘" "踙" "踞" "踽" "蹫" "躆" "躹" "車" "軥" "輂" "车" "遽" "邭" "郹" "鄒" "鄓" "鄹" "醵" "鉅" "鉏" "鋤" "鋦" "鋸" "鐻" "钜" "锔" "锯" "閰" "陱" "雎" "雛" "鞠" "鞫" "颶" "飓" "駏" "駒" "駶" "驕" "驧" "驹" "鬻" "鮈" "鮔" "鲏" "鴡" "鵙" "鵴" "鶋" "鶌" "鶪" "鼳" "齟" "龃"))
    ((("j" "u" "a" "n"))("㢧" "㢾" "㪻" "㯞" "㷷" "䄅" "䌸" "䐪" "䖭" "䚈" "䡓" "䳪" "倦" "剶" "劵" "勌" "勬" "卷" "圈" "埢" "姢" "娟" "婘" "巻" "帣" "悁" "慻" "捐" "捲" "朘" "桊" "泫" "涓" "淃" "狷" "獧" "琄" "瓹" "甄" "眩" "眷" "睊" "睠" "絭" "絹" "绢" "罥" "羂" "脧" "腃" "臇" "菤" "蕊" "蜷" "蠲" "裐" "身" "鄄" "鋗" "錈" "鎸" "鐫" "锩" "镌" "阮" "隽" "雋" "鞙" "韏" "飬" "鬳" "鵑" "鹃" "𩜇"))
    ((("j" "u" "e"))("㓸" "㔃" "㔢" "㔳" "㟲" "㤜" "㩱" "㭈" "㭰" "㭾" "㰐" "㵐" "㷾" "㸕" "㹟" "㻕" "㻡" "䀗" "䁷" "䆕" "䆢" "䇶" "䈑" "䋉" "䍊" "䍳" "䏐" "䏣" "䐘" "䖼" "䘿" "䙠" "䝌" "䞵" "䞷" "䟾" "䠇" "䡈" "䣤" "䦆" "䦼" "亅" "倔" "傕" "僪" "决" "刔" "劂" "勪" "厥" "咑" "啳" "嗟" "噘" "噱" "嚼" "孒" "孓" "屩" "屫" "崛" "崫" "嵑" "嶥" "弡" "彏" "憠" "憰" "戄" "抇" "抉" "挗" "捔" "掘" "撅" "撧" "攫" "斍" "柽" "桷" "梏" "橛" "橜" "欔" "欮" "殌" "氒" "決" "泬" "潏" "焆" "焳" "熦" "爑" "爝" "爴" "爵" "狂" "獗" "玃" "玦" "玨" "珏" "瑴" "璚" "疦" "瘚" "矍" "矞" "矡" "砄" "穴" "絕" "絶" "绝" "脚" "腳" "臄" "芵" "蕝" "蕞" "蕨" "蚗" "蛙" "蟨" "蟩" "蠼" "覐" "覚" "覺" "觉" "角" "觖" "觳" "觼" "訣" "譎" "诀" "谲" "谻" "貜" "赽" "趹" "踋" "蹶" "蹷" "蹻" "躩" "較" "较" "逫" "鈌" "鐍" "鐝" "钁" "镢" "镼" "闋" "闕" "阙" "駃" "鱊" "鱖" "鳜" "鴂" "鴃" "鷢" "龣" "𠢤" "𧽸" "𩪗"))
    ((("j" "u" "n"))("㑺" "㒞" "㓴" "㕙" "㝦" "㢠" "㤯" "㴫" "㻒" "㽙" "䇹" "䕑" "䜭" "䝌" "䝍" "俊" "儁" "军" "君" "呁" "均" "姰" "寯" "峻" "懏" "捃" "攈" "攟" "晙" "桾" "殾" "汮" "浚" "濬" "焌" "狻" "珺" "畯" "皲" "皸" "皹" "睃" "碅" "竣" "筠" "箘" "箟" "莙" "菌" "菎" "葰" "蔨" "蚐" "蜠" "袀" "覠" "訇" "軍" "逡" "郡" "鈞" "銁" "銞" "钧" "陖" "隽" "雋" "頵" "餕" "馂" "駿" "骏" "鮶" "鲪" "鵔" "鵘" "麇" "麏" "麕" "龜" "龟"))
    ((("k" "a"))("佧" "卡" "咔" "咖" "咯" "喀" "胩" "鉲" "髂"))
    ((("k" "a" "i"))("㗆" "㡁" "㲉" "㳀" "䁗" "䐩" "䒓" "䡷" "䫦" "凯" "凱" "剀" "剴" "勓" "咳" "嘅" "垲" "塏" "奒" "岂" "开" "忾" "恺" "愒" "愷" "愾" "慨" "揩" "暟" "楷" "欬" "渴" "溘" "炌" "炏" "烗" "痎" "礚" "蒈" "豈" "輆" "鍇" "鎧" "鐦" "铠" "锎" "锴" "開" "閡" "闓" "闿" "雉" "颽"))
    ((("k" "a" "n"))("㙳" "㵎" "㸝" "䀍" "䖔" "䘓" "䫲" "䬻" "䳚" "䶫" "侃" "偘" "冚" "刊" "刋" "勘" "坎" "埳" "堪" "塪" "墈" "崁" "嵁" "惂" "戡" "栞" "槛" "檻" "欿" "歁" "歞" "監" "看" "瞰" "矙" "砍" "磡" "竷" "莰" "薟" "衎" "譼" "輡" "轁" "轗" "闞" "阚" "顑" "餡" "鬫" "龕" "龛"))
    ((("k" "a" "n" "g"))("㰠" "䡉" "䲘" "亢" "伉" "匟" "囥" "嫝" "康" "忼" "慷" "扛" "抗" "摃" "杭" "槺" "沆" "漮" "炕" "犺" "砊" "穅" "粇" "糠" "肮" "荒" "躿" "邟" "鈧" "鏮" "钪" "閌" "闶" "骯" "鱇"))
    ((("k" "a" "o"))("㼥" "䎋" "䐧" "䘓" "䯪" "丂" "尻" "拷" "攷" "栲" "槀" "槁" "洘" "烤" "燺" "犒" "稁" "考" "薧" "藳" "銬" "铐" "靠" "髛" "鮳" "鲓" "鷱" "𥬯"))
    ((("k" "e"))("㒆" "㒞" "㕉" "㕎" "㝓" "㞹" "㤩" "㥛" "㪃" "㪙" "㪡" "㪼" "㰤" "㲉" "㲺" "㵣" "㼎" "㾧" "䁍" "䋉" "䕣" "䗘" "䘁" "䙐" "䶗" "克" "兣" "刻" "剋" "勀" "勊" "匼" "可" "咳" "哿" "喀" "嗑" "坷" "垎" "堁" "壳" "娔" "客" "尅" "岢" "峇" "嶱" "恪" "愘" "愙" "揢" "搕" "敤" "果" "柯" "棵" "榼" "樖" "欬" "殻" "殼" "氪" "渇" "渴" "溘" "炣" "犐" "珂" "疴" "痾" "盍" "瞌" "砢" "碣" "碦" "磕" "礍" "礚" "科" "稞" "窠" "簻" "緙" "缂" "胢" "苛" "荷" "萪" "薖" "蚵" "蝌" "衉" "課" "课" "趷" "軻" "轲" "醘" "鈳" "鉿" "錁" "錒" "钶" "铪" "锞" "閜" "頦" "顆" "颏" "颗" "騍" "骒" "髁" "龕"))
    ((("k" "e" "n"))("㸧" "啃" "垦" "墾" "恳" "懇" "掯" "狠" "珢" "硍" "肎" "肯" "肻" "裉" "褃" "豤" "錹" "頎" "颀" "齗" "齦" "龂" "龈"))
    ((("k" "e" "n" "g"))("䡰" "劥" "吭" "坈" "坑" "奟" "妔" "挳" "摼" "牼" "硁" "硎" "硜" "硻" "胫" "脛" "誙" "鉺" "銵" "鍞" "鏗" "铿" "阬"))
    ((("k" "o" "n" "g"))("㑋" "㤟" "㸜" "倥" "埪" "孔" "崆" "恐" "悾" "控" "涳" "硿" "穹" "空" "箜" "腔" "錓" "鞚" "鵼"))
    ((("k" "o" "u"))("㓂" "㔚" "㰯" "㲄" "㽛" "䍍" "䧆" "䳟" "䳹" "佝" "冦" "剾" "劶" "口" "叩" "宼" "寇" "彄" "怐" "扣" "抠" "挎" "摳" "敂" "毆" "溝" "滱" "瞉" "窛" "筘" "簆" "芤" "蔲" "蔻" "袧" "釦" "鏂" "鷇" "𦶲"))
    ((("k" "u"))("㒂" "㠸" "䇢" "䊿" "䔯" "俈" "刳" "哭" "喾" "嚳" "圐" "圣" "堀" "库" "庫" "扝" "挎" "枯" "桍" "楛" "焅" "瘔" "矻" "秙" "窋" "窟" "絝" "綯" "绔" "绹" "胐" "苦" "袴" "裤" "褲" "趶" "跍" "跨" "軲" "轱" "郀" "酷" "顝" "骷" "鮬"))
    ((("k" "u" "a"))("㡁" "䋀" "䦚" "侉" "咵" "垮" "夸" "姱" "恗" "挎" "晇" "胯" "荂" "誇" "跨" "銙" "錁" "锞" "骻" "髁"))
    ((("k" "u" "a" "i"))("㔞" "㙕" "㙗" "㟴" "㧟" "㨤" "㫎" "㬮" "㭈" "㱮" "㻅" "䈛" "䓒" "䭝" "䯤" "䶐" "会" "侩" "儈" "凷" "呙" "哙" "噲" "块" "塊" "墤" "巜" "廥" "快" "擓" "旝" "會" "栝" "桧" "檜" "欳" "浍" "澮" "狯" "獪" "禬" "筷" "糩" "脍" "膾" "蒉" "蒯" "蕢" "郐" "鄶" "駃" "鬠" "魁" "鱠" "鲙"))
    ((("k" "u" "a" "n"))("㮯" "㯘" "䕀" "䤭" "䥗" "䲌" "宽" "寛" "寬" "梡" "棵" "欵" "款" "歀" "窾" "臗" "顆" "颗" "髋" "髖"))
    ((("k" "u" "a" "n" "g"))("㔞" "㤮" "㫛" "㾠" "䂄" "䊯" "䵃" "俇" "儣" "况" "劻" "匡" "匩" "卝" "哐" "圹" "壙" "夼" "岲" "恇" "懬" "懭" "抂" "旷" "昿" "曠" "框" "況" "洭" "湟" "爌" "狂" "眖" "眶" "矌" "矿" "硄" "磺" "礦" "穬" "筐" "絖" "纊" "纩" "誆" "誑" "诓" "诳" "貺" "贶" "躀" "軭" "迋" "逛" "邝" "邼" "鄺" "鉱" "鑛" "鵟" "黋"))
    ((("k" "u" "i"))("㒑" "㕟" "㙓" "㙺" "㚍" "㚝" "㛻" "㟴" "㡭" "㤬" "㧉" "㨒" "㰐" "㱮" "㷇" "㾠" "䁛" "䇻" "䈐" "䍪" "䏗" "䕚" "䕫" "䖯" "䙆" "䙌" "䙡" "䟸" "䠑" "䤆" "䦱" "䧶" "䫥" "䯓" "䯣" "䰎" "䳫" "亏" "傀" "刲" "匮" "匱" "喟" "喹" "嘳" "夔" "奎" "媿" "尯" "岿" "巋" "归" "愦" "愧" "憒" "戣" "揆" "撌" "晆" "暌" "楏" "楑" "槶" "樻" "櫆" "歸" "湀" "溃" "潰" "煃" "犪" "盔" "睽" "瞆" "瞶" "磈" "窥" "窺" "篑" "簣" "籄" "聧" "聩" "聭" "聵" "腃" "臾" "茥" "葵" "蒉" "蔮" "蕢" "藈" "蘬" "蘷" "虁" "虧" "蝰" "規" "觖" "跬" "踩" "蹞" "躨" "逵" "鄈" "鍨" "鍷" "鐀" "鑎" "闋" "闚" "隗" "頃" "頄" "頍" "頯" "顷" "餽" "饋" "馈" "馗" "騤" "騩" "骙" "魁" "鮭"))
    ((("k" "u" "n"))("㕎" "㩲" "㫻" "䠅" "困" "坤" "堃" "壸" "壼" "婫" "崐" "崑" "巛" "悃" "惃" "捆" "昆" "晜" "梱" "涃" "混" "焜" "猑" "琨" "瑻" "睏" "硱" "祵" "稇" "稛" "綑" "菎" "蜫" "裈" "裍" "褌" "貇" "醌" "錕" "锟" "閫" "閸" "阃" "頑" "餛" "騉" "髠" "髡" "髨" "鯤" "鰥" "鲲" "鵾" "鶤" "鹍" "麇" "齫" "齳"))
    ((("k" "u" "o"))("㗥" "㣪" "㨯" "㪙" "䄆" "䄑" "䙃" "䟯" "䦢" "䯺" "噋" "姡" "廓" "彉" "彍" "扩" "拡" "括" "挄" "擃" "擴" "栝" "漷" "濶" "秮" "筈" "蛞" "适" "鄺" "闊" "阔" "霩" "鞟" "鞹" "髺" "鬠"))
    ((("l" "a"))("㕇" "㸊" "㻋" "㻝" "䀳" "䂰" "䃳" "䏀" "䓥" "䗶" "䝓" "䟑" "䪉" "䱫" "䶛" "剌" "啦" "喇" "嘑" "嚹" "垃" "拉" "揦" "揧" "搚" "摺" "擸" "攋" "旯" "柆" "楋" "爉" "瓎" "瘌" "癞" "癩" "砬" "磖" "翋" "腊" "臈" "臘" "菈" "落" "蓝" "藍" "藞" "蜡" "蝋" "蝲" "蠟" "辢" "辣" "邋" "鑞" "镴" "鞡" "鬎" "鯻" "癩"))
    ((("l" "a" "i"))("㚓" "㠣" "㥎" "㸊" "㾢" "䀳" "䂾" "䄤" "䅘" "䋱" "䓶" "䚅" "䠭" "䧒" "䲚" "來" "俫" "倈" "勑" "唻" "娕" "婡" "孻" "崃" "崍" "庲" "徕" "徠" "来" "梾" "棶" "櫴" "涞" "淶" "濑" "瀨" "瀬" "猍" "琜" "癞" "癩" "睐" "睞" "筙" "箂" "籁" "籟" "莱" "萊" "藾" "襰" "賚" "賴" "赉" "赖" "逨" "郲" "錸" "铼" "頼" "顂" "騋" "鯠" "鵣" "鶆" "麳" "黧")) 
    ((("l" "a" "n"))("㑣" "㔋" "㘓" "㘕" "㛦" "㜮" "㞩" "㦨" "㨫" "㩜" "㰖" "㱫" "㳕" "䃹" "䆾" "䊖" "䌫" "䍀" "䑌" "䦨" "䧒" "䪍" "䰐" "䲚" "䳿" "儖" "兰" "厱" "啉" "嚂" "囒" "壈" "壏" "婪" "嬾" "孄" "孏" "岚" "嵐" "幱" "廪" "惏" "懒" "懢" "懶" "拦" "揽" "擥" "攔" "攬" "斓" "斕" "暕" "栏" "榄" "欄" "欖" "欗" "浨" "滥" "漣" "漤" "澜" "濫" "瀾" "灆" "灠" "灡" "烂" "煉" "燗" "燣" "燷" "爁" "爛" "爤" "璼" "瓓" "礛" "礷" "篮" "籃" "籣" "糷" "繿" "纜" "缆" "罱" "葻" "蓝" "藍" "蘫" "蘭" "褴" "襕" "襤" "襴" "覧" "覽" "览" "譋" "讕" "谰" "躝" "連" "郴" "醂" "鑭" "钄" "镧" "闌" "阑" "韊" "顲" "𡒄"))
    ((("l" "a" "n" "g"))("㓪" "㙟" "㝗" "㟍" "㢃" "㫰" "㮾" "㱢" "㾗" "㾿" "䀶" "䁁" "䃹" "䆡" "䍚" "䕞" "䡙" "䯖" "䱶" "俍" "勆" "哴" "啷" "埌" "塱" "嫏" "崀" "廊" "朖" "朗" "朤" "桹" "榔" "樃" "欴" "浪" "烺" "狼" "琅" "瑯" "硠" "稂" "筤" "羮" "羹" "艆" "莨" "蒗" "蓈" "蓢" "蜋" "螂" "誏" "踉" "躴" "郎" "郞" "鋃" "鎯" "锒" "閬" "阆"))
    ((("l" "a" "o"))("㗦" "㞠" "㟉" "㟙" "㟹" "㧯" "㨓" "䃕" "䇭" "䕩" "䜎" "䝁" "䝤" "䲏" "䳓" "䵏" "佬" "僗" "劳" "労" "勞" "咾" "哰" "唠" "嘮" "姥" "嫪" "崂" "嶗" "恅" "憥" "憦" "捞" "撈" "栎" "栳" "橑" "橯" "櫟" "浶" "涝" "潦" "澇" "烙" "牢" "狫" "獠" "痨" "癆" "磱" "窂" "簝" "簩" "絡" "络" "老" "耢" "耮" "荖" "落" "蓼" "蟧" "軂" "轑" "酪" "醪" "銠" "鐒" "铑" "铹" "髝"))
    ((("l" "e"))("㔹" "㖀" "㦡" "㨋" "乐" "仂" "勒" "叻" "哷" "屴" "忇" "扐" "捋" "朸" "楽" "樂" "氻" "泐" "玏" "砳" "竻" "簕" "肋" "脟" "艻" "阞" "韷" "頱" "餎" "饹" "鰳" "鳓"))
    ((("l" "e" "i"))("㑍" "㒍" "㒦" "㔣" "㙼" "㡞" "㭩" "㰐" "㲕" "㲺" "㴃" "㵢" "㵽" "㶟" "㹎" "㻋" "㼍" "㿔" "䉂" "䉓" "䉪" "䍣" "䍥" "䐯" "䒹" "䛶" "䢮" "䣂" "䣦" "䨓" "䮑" "䴎" "傫" "儡" "儽" "勒" "厽" "嘞" "囄" "垒" "埒" "壘" "壨" "嫘" "擂" "攂" "樏" "檑" "櫐" "櫑" "欙" "泪" "洡" "涙" "淚" "漯" "灅" "瓃" "畾" "瘣" "癗" "磊" "磥" "礌" "礧" "礨" "禷" "类" "累" "絫" "縲" "纇" "纍" "纝" "缧" "罍" "羸" "耒" "肋" "蕌" "蕾" "藟" "蘱" "蘲" "蘽" "虆" "蠝" "誄" "讄" "诔" "轠" "酹" "銇" "錑" "鐳" "鑘" "鑸" "镭" "雷" "靁" "頛" "頪" "類" "颣" "鸓" "鼺"))
    ((("l" "e" "n" "g"))("䉄" "䚏" "䬋" "䮚" "倰" "冷" "堎" "塄" "崚" "愣" "棱" "楞" "睖" "碐" "稜" "薐" "踜" "輘"))
    ((("l" "i"))("㑦" "㒧" "㒿" "㓯" "㔏" "㕸" "㗚" "㘑" "㟳" "㠟" "㠣" "㡂" "㤡" "㤦" "㥎" "㦒" "㧰" "㬏" "㮚" "㯤" "㰀" "㰚" "㱹" "㴃" "㴝" "㷰" "㷴" "㸚" "㹈" "㺡" "㻎" "㻺" "㼖" "㽁" "㽝" "㾐" "㾖" "㿛" "㿨" "䁻" "䃯" "䄜" "䅄" "䅻" "䇐" "䉫" "䊍" "䊪" "䋥" "䍠" "䍥" "䍦" "䍽" "䓞" "䔁" "䔆" "䔉" "䔣" "䔧" "䕻" "䖥" "䖽" "䖿" "䗍" "䗶" "䘈" "䙰" "䚏" "䚕" "䟏" "䟐" "䡃" "䣓" "䣫" "䤙" "䤚" "䥶" "䧉" "䬅" "䬆" "䮋" "䮥" "䰛" "䰜" "䱘" "䲞" "䴄" "䴡" "䴻" "䵓" "䵩" "䶘" "丽" "例" "俐" "俚" "俪" "傈" "儮" "儷" "兣" "凓" "刕" "利" "剓" "剺" "劙" "力" "励" "勵" "历" "厉" "厘" "厤" "厯" "厲" "叓" "吏" "呖" "哩" "唎" "唳" "喱" "嚟" "嚦" "囄" "囇" "坜" "塛" "壢" "娌" "婯" "嫠" "孋" "孷" "屴" "岦" "峛" "峢" "峲" "巁" "廲" "悝" "悡" "悧" "悷" "慄" "戻" "戾" "捩" "搮" "摛" "擽" "攊" "攡" "攦" "攭" "斄" "暦" "曆" "曞" "朸" "李" "杝" "枥" "栎" "栗" "栛" "栵" "梨" "梩" "梸" "棃" "棙" "樆" "櫔" "櫟" "櫪" "欐" "欚" "歴" "歷" "氂" "沥" "沴" "泣" "浬" "浰" "涖" "淚" "溧" "漓" "漦" "澧" "濼" "濿" "瀝" "灑" "灕" "爄" "爏" "牦" "犁" "犂" "犛" "犡" "狸" "猁" "珕" "珞" "理" "琍" "瑮" "璃" "瓅" "瓈" "瓑" "瓥" "疠" "疬" "痢" "癘" "癧" "皪" "盠" "盭" "睝" "矋" "砅" "砬" "砺" "砾" "硌" "磿" "礪" "礫" "礰" "礼" "禮" "禲" "离" "秜" "秝" "穲" "立" "笠" "筣" "篥" "篱" "籬" "类" "粍" "粒" "粚" "粝" "粴" "糎" "糲" "綟" "縭" "纅" "纚" "缡" "罹" "翮" "脷" "艃" "苈" "苙" "茘" "荔" "莅" "莉" "菞" "蒞" "蓠" "蔾" "薶" "藜" "藶" "蘺" "蚸" "蛎" "蛠" "蜊" "蜧" "蝕" "蝷" "蟍" "蟸" "蠇" "蠡" "蠣" "蠫" "裏" "裡" "褵" "詈" "謧" "讈" "豊" "貍" "赲" "跞" "躒" "轢" "轣" "轹" "迣" "逦" "邌" "邐" "郦" "酈" "酾" "醨" "醴" "釃" "里" "釐" "鉝" "鋫" "鋰" "錅" "鎘" "鏫" "鑗" "鑠" "锂" "镉" "隶" "隷" "隸" "離" "雳" "雴" "霾" "靂" "靋" "類" "颯" "騹" "驪" "骊" "髦" "鬁" "鬲" "鯉" "鯬" "鱧" "鱱" "鱳" "鱺" "鲡" "鲤" "鳢" "鳨" "鴗" "鵹" "鷅" "鷑" "鸝" "鹂" "麗" "麜" "黎" "黐" "黧" "礼"))
    ((("l" "i" "a"))("俩" "倆")) 
    ((("l" "i" "a" "n"))("㓎" "㜃" "㜕" "㜻" "㝺" "㟀" "㡘" "㢘" "㥕" "㦁" "㦑" "㪘" "㪝" "㯬" "㰈" "㰸" "㱨" "㶌" "㶑" "㺦" "㼑" "㼓" "㾾" "䁠" "䃛" "䆂" "䇜" "䌞" "䏈" "䐄" "䙺" "䥥" "䨬" "䭑" "亷" "僆" "劆" "匲" "匳" "嗹" "噒" "堜" "奁" "奩" "奱" "娈" "媡" "嫾" "嬚" "孌" "帘" "廉" "怜" "恋" "慩" "憐" "戀" "捡" "摙" "撿" "敛" "斂" "栏" "梿" "楝" "槤" "櫣" "欄" "歛" "殓" "殮" "浰" "涊" "涟" "淰" "湅" "溓" "漣" "潋" "澰" "濂" "濓" "瀲" "炼" "煉" "熑" "燫" "琏" "瑓" "璉" "瞵" "碾" "磏" "稴" "簾" "籢" "籨" "粘" "練" "縺" "纞" "练" "羷" "羸" "翴" "联" "聫" "聮" "聯" "脸" "膁" "膦" "臁" "臉" "苓" "莲" "莶" "萰" "蓮" "蔹" "薕" "薟" "蘝" "蘞" "螊" "蠊" "裢" "裣" "褳" "襝" "覝" "謰" "譧" "蹥" "连" "連" "鄻" "錬" "鍊" "鎌" "鏈" "鐮" "链" "镰" "零" "鬑" "鰊" "鰱" "鲢"))
    ((("l" "i" "a" "n" "g"))("㒳" "㔝" "㹁" "㾗" "䀶" "䁁" "䓣" "䝶" "䠃" "䣼" "䩫" "䭪" "両" "两" "亮" "俩" "倆" "倞" "兩" "凉" "哴" "唡" "啢" "喨" "墚" "悢" "惊" "掚" "晾" "梁" "椋" "樑" "涼" "湸" "粮" "粱" "糧" "綡" "緉" "脼" "良" "莨" "蜽" "裲" "諒" "谅" "踉" "蹣" "輌" "輛" "輬" "辆" "辌" "量" "鍄" "阆" "靚" "駺" "魉" "魎"))
    ((("l" "i" "a" "o"))("㙩" "㜃" "㝋" "㞠" "㡻" "㨓" "㵳" "㶫" "㺒" "䄦" "䉼" "䍡" "䎆" "䑠" "䕞" "䜍" "䜮" "䝀" "䢧" "䣈" "䨅" "䩍" "乐" "了" "僚" "嘹" "嫽" "寥" "寮" "尞" "尥" "尦" "屪" "嵺" "嶚" "嶛" "廖" "廫" "憀" "憭" "摎" "撂" "撩" "敹" "料" "暸" "樂" "橑" "漻" "潦" "炓" "熮" "燎" "爒" "獠" "璙" "疗" "療" "瞭" "窷" "簝" "繆" "繚" "缪" "缭" "翏" "聊" "膋" "膫" "蓼" "蟉" "蟟" "豂" "賿" "蹘" "蹽" "轑" "辽" "遼" "鄝" "釕" "鐐" "钌" "镣" "镽" "顟" "飂" "飉" "髎" "鷚" "鷯" "鹨" "鹩"))
    ((("l" "i" "e"))("㤠" "㧜" "㬯" "㭞" "㯿" "㲱" "㸊" "㸹" "㻺" "㼲" "㽟" "䁽" "䅀" "䉭" "䓟" "䜲" "䝓" "䟩" "䟹" "䪉" "䮋" "䴕" "䶛" "儠" "冽" "列" "劣" "劽" "咧" "埓" "姴" "巤" "戾" "挒" "捩" "擸" "洌" "浖" "烈" "煭" "爉" "犣" "猎" "獵" "痎" "睙" "累" "聗" "脟" "膊" "茢" "蛚" "蛶" "裂" "趔" "躐" "迾" "邋" "颲" "鬛" "鬣" "鮤" "鱲" "鴷"))
    ((("l" "i" "n"))("㐭" "㔂" "㖁" "㖼" "㝝" "㝺" "㨆" "㷠" "䉮" "䕲" "䗲" "䚏" "䚬" "䟹" "䢧" "䢯" "䫐" "䫰" "䮼" "临" "亃" "僯" "凛" "凜" "厸" "吝" "啉" "壣" "嶙" "廩" "廪" "恡" "悋" "惏" "懍" "懔" "撛" "斴" "晽" "暽" "林" "橉" "檁" "檩" "淋" "滲" "潾" "澟" "瀶" "焛" "燐" "獜" "琳" "璘" "甐" "疄" "痳" "癛" "癝" "瞵" "矝" "碄" "磷" "禀" "稟" "箖" "粦" "粼" "綝" "繗" "罧" "翷" "膦" "臨" "菻" "蔺" "藺" "賃" "赁" "蹸" "躏" "躙" "躪" "轔" "轥" "辚" "遴" "邻" "鄰" "鏻" "閵" "隣" "霖" "驎" "鱗" "鳞" "麐" "麟"))
    ((("l" "i" "n" "g"))("㖫" "㡵" "㥄" "㦭" "㪮" "㬡" "㭩" "㯪" "㱥" "㲆" "㸳" "㻏" "㾉" "䄥" "䈊" "䉁" "䉖" "䉹" "䌢" "䍅" "䔖" "䕘" "䖅" "䙥" "䚖" "䠲" "䡼" "䡿" "䧙" "䨩" "䯍" "䰱" "䴇" "䴒" "䴫" "令" "伶" "倰" "凌" "刢" "另" "呤" "囹" "坽" "夌" "姈" "孁" "岭" "岺" "嶺" "彾" "拎" "掕" "昤" "朎" "柃" "棂" "棱" "櫺" "欞" "泠" "淩" "澪" "灵" "炩" "燯" "爧" "狑" "玲" "琌" "瓴" "皊" "睖" "砱" "碐" "磷" "祾" "秢" "稜" "竛" "笭" "紷" "綾" "绫" "羚" "翎" "聆" "舲" "苓" "菱" "蔆" "蕶" "蘦" "蛉" "衑" "袊" "裬" "詅" "跉" "軨" "輘" "酃" "醽" "釘" "鈴" "錂" "铃" "閝" "阾" "陵" "零" "霊" "霛" "霝" "靈" "領" "领" "駖" "魿" "鯪" "鲮" "鴒" "鸰" "鹷" "麢" "齡" "齢" "龄" "龗"))
    ((("l" "i" "u"))("㐬" "㙀" "㝋" "㧕" "㨨" "㳅" "㵳" "㶯" "㽌" "㽞" "䄂" "䉧" "䉹" "䋷" "䒥" "䗜" "䚧" "䝀" "䬟" "䭷" "䰘" "䱖" "䱞" "䶉" "六" "刘" "劉" "嚠" "坴" "塯" "媹" "嬼" "嵧" "廇" "懰" "摎" "斿" "旈" "旒" "柳" "栁" "桺" "榴" "橊" "橮" "沠" "泖" "泵" "流" "浏" "游" "溜" "漻" "澑" "瀏" "熘" "珋" "琉" "瑠" "瑬" "璢" "畂" "畄" "留" "畱" "疁" "瘤" "癅" "硫" "碌" "磂" "磟" "綹" "绺" "罶" "羀" "翏" "聊" "膢" "蒌" "蒥" "蓅" "蓼" "蔞" "藰" "蟉" "裗" "蹓" "遛" "鉚" "鋶" "鎏" "鎦" "鏐" "鐂" "铆" "锍" "镏" "镠" "陆" "陸" "雡" "霤" "飀" "飂" "飅" "飗" "飹" "餾" "馏" "駠" "駵" "騮" "驑" "骝" "鬸" "鰡" "鶹" "鷚" "鹠" "麍"))
    ((("l" "o"))("咯"))
    ((("l" "o" "n" "g"))("㑝" "㙙" "㚅" "㛞" "㝫" "㟖" "㡣" "㢅" "㦕" "㰍" "㳥" "㴳" "䃧" "䆍" "䏊" "䙪" "䡁" "䥢" "䪊" "儱" "咙" "哢" "嚨" "垄" "垅" "壟" "壠" "屸" "嶐" "巃" "巄" "弄" "徿" "拢" "挵" "攏" "昽" "曨" "朧" "栊" "梇" "櫳" "泷" "湰" "滝" "漋" "瀧" "爖" "珑" "瓏" "癃" "眬" "矓" "砻" "硦" "礱" "礲" "窿" "竉" "竜" "笼" "篢" "篭" "簼" "籠" "聋" "聾" "胧" "茏" "蕯" "蘢" "蝕" "蠪" "蠬" "衖" "襱" "豅" "贚" "躘" "鏧" "鑨" "陇" "隆" "隴" "霳" "靇" "鸗" "龍" "龒" "龓" "龙"))
    ((("l" "o" "u"))("㔷" "㟺" "㡞" "㥪" "㪹" "㲎" "㺏" "䁖" "䄛" "䅹" "䝏" "䣚" "䫫" "䮫" "䱾" "偻" "僂" "剅" "喽" "嘍" "囉" "塿" "娄" "婁" "寠" "屚" "嵝" "嶁" "廔" "慺" "搂" "摟" "楼" "樓" "溇" "漊" "漏" "熡" "牢" "甊" "瘘" "瘺" "瘻" "瞜" "窭" "窶" "篓" "簍" "耧" "耬" "膢" "艛" "蒌" "蔞" "蝼" "螻" "謱" "軁" "遱" "鏤" "镂" "陋" "露" "鞻" "髅" "髏" "鷜"))
    ((("l" "u"))("㓐" "㔪" "㖨" "㛬" "㜙" "㟤" "㠠" "㢚" "㢳" "㦇" "㪐" "㪖" "㪭" "㪹" "㫽" "㭔" "㯝" "㯟" "㯭" "㱺" "㼾" "㿖" "䃙" "䌒" "䍡" "䎑" "䎼" "䐂" "䕡" "䘵" "䚄" "䟿" "䡎" "䡜" "䩮" "䮉" "䰕" "䱚" "䲐" "䴪" "侓" "僇" "六" "剹" "勎" "勠" "卢" "卤" "噜" "嚕" "嚧" "圥" "垆" "垏" "塷" "壚" "娽" "峍" "庐" "廘" "廬" "彔" "录" "戮" "掳" "摝" "撸" "擄" "擼" "攎" "曥" "栌" "椂" "樐" "樚" "橹" "櫓" "櫨" "氌" "泸" "淕" "淥" "渌" "滷" "漉" "潞" "瀂" "瀘" "炉" "熝" "爐" "獹" "玈" "琭" "璐" "璷" "瓐" "甪" "瘳" "盝" "盧" "睩" "矑" "硉" "硵" "碌" "磟" "磠" "祿" "禄" "稑" "穋" "箓" "簏" "簬" "簵" "簶" "籙" "籚" "粶" "綠" "纑" "绿" "罏" "胪" "膔" "臚" "舻" "艣" "艪" "艫" "芦" "菉" "蓼" "蓾" "蔍" "蕗" "蘆" "虂" "虏" "虜" "螰" "蠦" "角" "觮" "觻" "谷" "賂" "赂" "趢" "路" "踛" "蹗" "輅" "轆" "轤" "轳" "辂" "辘" "逯" "酪" "醁" "錄" "録" "錴" "鏀" "鏕" "鏴" "鐪" "鑥" "鑪" "镥" "陆" "陸" "露" "顱" "颅" "騄" "騼" "髗" "魯" "魲" "鯥" "鱸" "鲁" "鲈" "鵦" "鵱" "鷺" "鸕" "鸬" "鹭" "鹵" "鹿" "麓" "黸"))
    ((("l" "u" "a" "n"))("㝈" "㡩" "㰸" "㱍" "㼑" "䖂" "䚕" "䜌" "乱" "亂" "卵" "圝" "圞" "娈" "孌" "孪" "孿" "峦" "巒" "挛" "攣" "曫" "栾" "欒" "滦" "灓" "灤" "癵" "羉" "脔" "脟" "臠" "薍" "虊" "釠" "銮" "鑾" "鵉" "鸞" "鸾"))
    ((("l" "u" "e"))("㨼" "掠"))
    ((("l" "u" "n"))("㕢" "㖮" "㷍" "䈁" "䑳" "仑" "伦" "侖" "倫" "囵" "圇" "埨" "婨" "崘" "崙" "惀" "抡" "掄" "棆" "沦" "淪" "溣" "碖" "稐" "綸" "纶" "耣" "腀" "菕" "蜦" "論" "论" "踚" "輪" "轮" "錀" "陯" "鯩"))
    ((("l" "u" "o"))("㑩" "㒩" "㓢" "㕵" "㖀" "㦬" "㩡" "㪾" "㮝" "㰁" "㱻" "㴖" "㵣" "㼈" "㽋" "㾖" "㿚" "䀩" "䃕" "䇔" "䈁" "䈷" "䉓" "䉿" "䊨" "䌱" "䌴" "䎅" "䙨" "䯁" "䲞" "乐" "倮" "儸" "啰" "嗠" "囉" "峈" "捋" "摞" "擽" "攞" "曪" "果" "椤" "樂" "橐" "欏" "氇" "氌" "泺" "洛" "漯" "濼" "烁" "烙" "爍" "犖" "猓" "猡" "玀" "珞" "瘰" "癳" "砢" "硌" "碌" "礫" "笿" "箩" "籮" "絡" "纙" "络" "罗" "羅" "脶" "腡" "臝" "荦" "萝" "落" "蓏" "蔂" "蘿" "蜾" "蝸" "螺" "蟸" "蠃" "蠡" "袼" "裸" "覙" "覶" "覼" "詻" "跞" "路" "躒" "躶" "逻" "邏" "酪" "鉻" "鎯" "鏍" "鑼" "铬" "锣" "镙" "雒" "饠" "駱" "騾" "驘" "骆" "骡" "鮥" "鴼" "鵅" "鸁"))
    ((("m" "a"))("㐷" "㑻" "㜫" "㦄" "㨸" "㾺" "䗫" "䠋" "䠨" "䣕" "䣖" "䧞" "䯦" "䳸" "么" "傌" "吗" "唛" "嗎" "嘛" "嘜" "嚜" "妈" "媽" "嬤" "嬷" "孖" "帓" "抹" "摩" "擵" "攠" "杩" "榪" "溤" "犘" "犸" "獁" "玛" "瑪" "痲" "睰" "码" "碼" "祃" "禡" "罵" "菻" "蔴" "蚂" "螞" "蟆" "蟇" "貈" "貉" "鎷" "閁" "馬" "駡" "驀" "马" "骂" "鰢" "鷌" "麻" "麼" "麽"))
    ((("m" "a" "i"))("㜥" "㦟" "㼮" "䁲" "䈿" "䘑" "䚑" "䜕" "䨪" "䨫" "䮮" "䳸" "买" "佅" "劢" "勱" "卖" "嘪" "埋" "売" "派" "狸" "眿" "脈" "脉" "荬" "蕒" "薶" "蝐" "衇" "貍" "買" "賣" "迈" "邁" "霡" "霢" "霾" "鷶" "麥" "麦"))
    ((("m" "a" "n"))("㒼" "㗄" "㗈" "㙢" "㛧" "㡢" "㬅" "㵘" "䅼" "䊡" "䐽" "䑱" "䒥" "䕕" "䛲" "䜱" "䝡" "䝢" "䟂" "䡬" "䨫" "䯶" "䰋" "僈" "埋" "墁" "姏" "嫚" "屘" "幔" "悗" "慢" "慲" "摱" "曼" "槾" "樠" "満" "满" "滿" "漫" "澫" "澷" "熳" "獌" "璊" "瞒" "瞞" "矕" "縵" "缦" "蔄" "蔓" "蛮" "螨" "蟎" "蠻" "襔" "謾" "谩" "蹒" "蹣" "鄤" "鏋" "鏝" "镘" "鞔" "顢" "颟" "饅" "馒" "鬗" "鬘" "鮸" "鰻" "鳗"))
    ((("m" "a" "n" "g"))("㙁" "㜃" "㝑" "㟌" "㟐" "㟿" "㡛" "㬒" "㵃" "㻊" "䀮" "䁳" "䅒" "䈍" "䒎" "䓼" "䖟" "䙪" "䟥" "䵨" "厖" "吂" "哤" "壾" "奀" "娏" "尨" "庬" "忙" "恾" "杗" "杧" "氓" "汒" "浝" "漭" "牤" "牻" "狵" "痝" "盲" "盳" "瞢" "矒" "硥" "硭" "笀" "芒" "茫" "茻" "莽" "莾" "蒙" "蘉" "蛖" "蟒" "蠎" "邙" "釯" "鋩" "铓" "駹" "鼆" "龍" "龙"))
    ((("m" "a" "o"))("㒵" "㒻" "㚹" "㝟" "㡌" "㧇" "㧌" "㪞" "㫯" "㬒" "㮘" "㲠" "㴘" "㹈" "㺺" "㿞" "䀤" "䅦" "䋃" "䓮" "䖥" "䡚" "䫉" "䭷" "兞" "冇" "冐" "卯" "堥" "夘" "媌" "媢" "嫹" "峁" "帽" "懋" "戼" "旄" "昴" "暓" "枆" "柕" "楙" "毛" "毣" "毷" "氂" "泖" "渵" "牟" "牦" "犛" "猫" "瑁" "皃" "眊" "瞀" "瞐" "矛" "笷" "罞" "耄" "耗" "艒" "芼" "茂" "茅" "茆" "萺" "蓩" "蝥" "蟊" "袤" "覒" "貌" "貓" "貿" "贸" "軞" "鄮" "酕" "鉚" "錨" "铆" "锚" "髦" "髳" "鶜"))
    ((("m" "e"))("么" "嚜" "没" "麼" "麽"))
    ((("m" "e" "i"))("㙁" "㜫" "㡌" "㭑" "㶬" "㺳" "䀛" "䀜" "䆀" "䉋" "䊈" "䊊" "䍙" "䒽" "䓺" "䜸" "䞼" "䤂" "䰨" "䰪" "䵢" "侎" "凂" "呅" "堳" "塺" "妹" "媄" "媒" "媚" "媺" "嬍" "寐" "嵄" "嵋" "徾" "挴" "攗" "昧" "枚" "栂" "梅" "楣" "楳" "槑" "毎" "每" "沒" "没" "沬" "浼" "渼" "湄" "湈" "煝" "煤" "燘" "猸" "玫" "珻" "瑁" "瑂" "痗" "眉" "眛" "睂" "睸" "祙" "禖" "穈" "篃" "糜" "美" "脄" "脢" "腜" "苺" "莓" "葿" "蝐" "蝞" "袂" "謎" "谜" "跊" "迷" "郿" "酶" "鋂" "鎂" "鎇" "镁" "镅" "霉" "靡" "韎" "鬽" "魅" "鶥" "鹛" "黣" "黴"))
    ((("m" "e" "n"))("㙢" "㡈" "㥃" "㦖" "㨺" "㱪" "㵍" "㻊" "䊟" "䝧" "䫒" "亹" "们" "們" "悗" "悶" "懑" "懣" "扪" "捫" "暪" "樠" "汶" "满" "滿" "焖" "燜" "璊" "瞒" "瞞" "穈" "菛" "虋" "鍆" "钔" "門" "閅" "门" "闷" "鞔"))
    ((("m" "e" "n" "g"))("㙹" "㚞" "㜴" "㝱" "㠓" "㩚" "㻊" "㽇" "䀄" "䁅" "䇇" "䉚" "䏵" "䑃" "䑅" "䒐" "䓝" "䖟" "䗈" "䙦" "䙩" "䝢" "䟥" "䠢" "䤓" "䥂" "䥰" "䰒" "䲛" "䴌" "䴿" "䵆" "儚" "冡" "勐" "夢" "夣" "孟" "尨" "幪" "懜" "懞" "懵" "曚" "朦" "梦" "橗" "檬" "氋" "氓" "溕" "濛" "猛" "獴" "瓾" "甍" "甿" "盟" "瞑" "瞢" "矇" "矒" "礞" "艋" "艨" "苎" "莔" "萌" "萠" "蒙" "蕄" "虻" "蜢" "蝱" "蟊" "蟒" "蠎" "蠓" "鄳" "鄸" "錳" "锰" "雺" "霥" "霧" "霿" "靀" "饛" "鯍" "鯭" "鸏" "鹲" "黽" "黾" "鼆"))
    ((("m" "i"))("㘠" "㜆" "㜷" "㝥" "㟜" "㠧" "㣆" "㥝" "㦄" "㨠" "㨺" "㩢" "㫘" "㰽" "㳴" "㳽" "㴵" "㵋" "㵥" "㸏" "㸓" "䀣" "䁇" "䈿" "䉲" "䉾" "䊫" "䊳" "䋛" "䋳" "䌏" "䌐" "䌕" "䌘" "䌩" "䍘" "䕳" "䕷" "䖑" "䛉" "䛑" "䛧" "䣥" "䣾" "䤉" "䤍" "䥸" "䪾" "䭧" "䭩" "䮭" "䱊" "䴢" "佴" "侎" "冖" "冞" "冪" "咪" "嘧" "塓" "孊" "宓" "宻" "密" "峚" "幂" "幎" "幦" "弥" "弭" "彌" "戂" "擟" "擵" "攠" "敉" "日" "榓" "樒" "檷" "櫁" "汨" "沕" "沵" "泌" "洣" "淧" "淿" "渳" "溟" "滵" "漞" "濔" "濗" "瀰" "灖" "熐" "爢" "狝" "猕" "獮" "獼" "瓕" "眫" "眯" "瞇" "祕" "祢" "禰" "秘" "簚" "籋" "米" "糜" "糸" "縻" "罙" "羃" "脒" "芈" "葞" "蒾" "蔝" "蔤" "藌" "蘪" "蘼" "蜜" "蠠" "覓" "覔" "覛" "觅" "詸" "謎" "謐" "谜" "谧" "辟" "迷" "醚" "醾" "醿" "釄" "銤" "鑖" "镾" "靡" "鸍" "麊" "麋" "麑" "麛" "鼏"))
    ((("m" "i" "a" "n"))("㐷" "㒙" "㛯" "㝃" "㝰" "㤁" "㥝" "㨺" "㫘" "㬆" "㮌" "㰃" "㴐" "㻰" "䀎" "䃇" "䌏" "䏃" "䛉" "䤄" "䫵" "䰓" "丏" "俛" "偭" "免" "冕" "勉" "勔" "厸" "喕" "娩" "婂" "媔" "嬵" "宀" "愐" "棉" "檰" "櫋" "汅" "沔" "泯" "渑" "湎" "澠" "眄" "眠" "瞑" "矈" "矊" "矏" "糆" "絻" "綿" "緜" "緡" "緬" "绵" "缅" "腼" "臱" "芇" "莬" "葂" "蝒" "醎" "面" "靣" "靦" "鮸" "麪" "麫" "麵" "麺" "黽" "黾"))
    ((("m" "i" "a" "o"))("㑤" "㠺" "㦝" "㷅" "䁧" "䅺" "䖢" "劰" "喵" "妙" "媌" "庙" "庿" "廟" "描" "杪" "淼" "渺" "猫" "玅" "眇" "瞄" "秒" "竗" "篎" "紗" "緢" "緲" "繆" "缈" "缪" "苗" "藐" "蜱" "訬" "邈" "鈔" "钞" "鱙" "鶓" "鹋"))
    ((("m" "i" "e"))("㒝" "㩢" "䁾" "䈼" "䌩" "䘊" "䩏" "乜" "吀" "咩" "哶" "孭" "幭" "懱" "搣" "櫗" "滅" "灭" "烕" "眜" "礣" "篾" "羋" "芈" "蔑" "薎" "蠛" "衊" "覕" "鑖" "鱴" "鴓"))
    ((("m" "i" "n"))("㞶" "㟩" "㟭" "㢯" "㥸" "㨉" "㬆" "㮌" "䁕" "䂥" "䃉" "䋋" "䝧" "䞀" "䟨" "䡅" "䡑" "䡻" "䪸" "䲄" "䶔" "僶" "冺" "刡" "勄" "姄" "岷" "崏" "忞" "忟" "怋" "悯" "愍" "慜" "憫" "抿" "捪" "敃" "敏" "敯" "旻" "旼" "昏" "昬" "暋" "民" "汶" "泯" "渑" "湣" "潣" "澠" "玟" "珉" "琘" "瑉" "痻" "皿" "盿" "眠" "砇" "碈" "笢" "簢" "緍" "緡" "繩" "绳" "缗" "罠" "苠" "賯" "鈱" "錉" "鍲" "閔" "閩" "閺" "闵" "闽" "鰵" "鳘" "黽" "黾"))
    ((("m" "i" "n" "g"))("㝠" "㟰" "㫥" "䄙" "䆨" "䆩" "䊅" "䒌" "䤉" "䫤" "䳟" "佲" "冥" "凕" "名" "命" "姳" "嫇" "慏" "明" "暝" "朙" "榠" "洺" "溟" "猽" "皿" "盟" "眀" "眳" "瞑" "茗" "萌" "蓂" "螟" "覭" "詺" "鄍" "酩" "銘" "铭" "鳴" "鸣"))
    ((("m" "i" "u"))("繆" "缪" "謬" "谬"))
    ((("m" "o"))("㜥" "㠢" "㱄" "㱳" "㶬" "㷬" "㷵" "㹮" "㾺" "䁼" "䁿" "䃺" "䉑" "䌕" "䏞" "䒬" "䘃" "䘑" "䜆" "䤉" "䩋" "䬴" "䭩" "䮬" "䯢" "䱅" "䳟" "䳮" "䴲" "万" "么" "冐" "冒" "劘" "嗼" "嘿" "嚜" "嚤" "嚰" "圽" "塺" "塻" "墨" "妺" "嫫" "嫼" "寞" "帕" "帞" "庅" "慔" "懡" "抹" "抺" "摩" "摸" "摹" "擵" "攠" "无" "昩" "暯" "末" "枺" "模" "橅" "歾" "歿" "殁" "沒" "没" "沫" "洦" "湐" "漠" "瀎" "無" "爅" "獏" "瘼" "百" "皌" "眜" "眽" "瞙" "砞" "磨" "礳" "秣" "粖" "糢" "絈" "縸" "纆" "耱" "脈" "脉" "膜" "茉" "莈" "莫" "蓦" "藐" "藦" "蘑" "蛨" "蟆" "蟔" "衇" "袜" "袹" "覛" "謨" "謩" "谟" "貃" "貈" "貉" "貊" "貘" "鄚" "銆" "鏌" "镆" "陌" "霡" "靡" "靺" "鞨" "饃" "饝" "馍" "驀" "髍" "鬕" "魔" "魩" "麼" "麽" "默" "黙"))
    ((("m" "o" "u"))("㖼" "㭌" "㼋" "䋷" "䍒" "䏬" "䗋" "䥐" "䦈" "䱕" "侔" "冒" "劺" "厶" "哞" "恈" "愗" "敄" "某" "桙" "毋" "洠" "牟" "眸" "瞀" "瞴" "繆" "缪" "蛑" "蝥" "蟱" "袤" "謀" "谋" "踇" "鉾" "鍪" "霿" "鞪" "鴾" "麰"))
    ((("m" "u"))("㒇" "㙁" "㜈" "㟂" "㣎" "㧅" "㫛" "㾇" "䀲" "䁼" "䊾" "䑵" "䥈" "䧔" "䮸" "䱯" "亩" "仫" "募" "坶" "墓" "姆" "姥" "峔" "幕" "幙" "恈" "慕" "拇" "暮" "木" "楘" "模" "橅" "母" "毣" "毪" "氁" "沐" "炑" "牟" "牡" "牧" "牳" "狇" "獏" "畂" "畆" "畒" "畝" "畞" "畮" "目" "睦" "砪" "穆" "縸" "繆" "缪" "胟" "艒" "苜" "莫" "莯" "蚞" "譕" "鉧" "鉬" "钼" "雮" "霂" "鞪" "鶩" "鹜"))
    ((("n" "a"))("㗙" "㙁" "㧱" "㨥" "㭯" "㴸" "䀑" "䅞" "䇣" "䇱" "䈫" "䎎" "䏧" "䖓" "䖧" "䛔" "䞕" "䟜" "䪏" "䫱" "䱹" "乸" "內" "南" "吶" "呐" "哪" "嗱" "妠" "娜" "拏" "拿" "挐" "捺" "痆" "笝" "箬" "納" "絮" "纳" "肭" "蒳" "衲" "袦" "訤" "訥" "誽" "讷" "豽" "貀" "軜" "那" "鈉" "鎿" "钠" "镎" "雫" "靹" "魶"))
    ((("n" "a" "i"))("㚷" "㜨" "㜷" "㮈" "㮏" "㲡" "㾍" "䅞" "䍲" "䘅" "䯮" "䱞" "乃" "佴" "倷" "儞" "奈" "奶" "妳" "嬭" "廼" "摨" "柰" "榒" "氖" "渿" "熋" "疓" "耏" "耐" "能" "艿" "萘" "螚" "褦" "迺" "釢" "錼" "鼐"))
    ((("n" "a" "n"))("㓓" "㫱" "㬮" "㽖" "䁪" "䈒" "䊖" "䔜" "䔳" "䕼" "䛁" "䶲" "侽" "南" "喃" "囝" "囡" "奻" "娚" "婻" "戁" "揇" "暔" "枏" "枬" "柟" "楠" "湳" "灘" "男" "畘" "罱" "腩" "莮" "萳" "蝻" "諵" "赧" "难" "難"))
    ((("n" "a" "n" "g"))("㒄" "㶞" "䂇" "乪" "儾" "嚢" "囊" "囔" "孃" "攮" "曩" "欜" "灢" "蠰" "饢" "馕" "齉"))
    ((("n" "a" "o"))("㑎" "㛴" "㞪" "㧘" "㺀" "㺁" "䃩" "䄩" "䑋" "䙹" "䛝" "䜀" "䜧" "䫸" "䴃" "匘" "呶" "垴" "堖" "夒" "嫐" "孬" "峱" "嶩" "巎" "巙" "怓" "恼" "悩" "惱" "憹" "挠" "撓" "桡" "橈" "淖" "澆" "猱" "獶" "獿" "瑙" "硇" "碯" "繷" "脑" "腝" "腦" "臑" "蟯" "詉" "譊" "鐃" "铙" "閙" "闹" "髐" "鬧"))
    ((("n" "e"))("䅞" "䎪" "䭆" "䭚" "吶" "呐" "呢" "哪" "疔" "眲" "訥" "讷" "那"))
    ((("n" "e" "i"))("㐻" "㕯" "㖏" "㘨" "㨅" "㼏" "䇣" "䜆" "䡾" "䲎" "䳖" "內" "内" "哪" "娞" "氝" "脮" "腇" "那" "餒" "餧" "馁" "鮾" "鯘"))
    ((("n" "e" "n"))("㒄" "㜛" "㯎" "㶧" "嫩" "嫰" "黁" "齳"))
    ((("n" "e" "n" "g"))("㲌" "㴰" "䏻" "䘅" "䪏" "嬣" "而" "耐" "能" "薴"))
    ((("n" "i"))("㞾" "㠜" "㣇" "㥾" "㦐" "㧱" "㪒" "㮞" "㲡" "㲻" "㵫" "㹸" "䀑" "䁥" "䍲" "䕥" "䘌" "䘦" "䘽" "䛏" "䝚" "䦵" "䧇" "䭲" "䮘" "䰯" "䵑" "䵒" "伱" "伲" "你" "倪" "儗" "儞" "匿" "呢" "坭" "埿" "堄" "妮" "妳" "婗" "嫟" "嬺" "孴" "尼" "屔" "屰" "嶷" "怩" "惄" "愵" "慝" "抳" "拟" "掜" "擬" "旎" "昵" "晲" "暱" "柅" "殢" "氼" "沵" "泥" "淣" "溺" "濔" "濘" "灄" "狋" "狔" "猊" "疑" "痆" "睨" "祢" "禰" "秜" "籾" "糑" "縌" "胒" "腻" "膩" "臡" "苨" "薿" "蚭" "蜺" "衵" "觬" "貎" "跜" "輗" "迡" "逆" "郳" "鈮" "鉨" "铌" "隬" "霓" "馜" "鯓" "鯢" "鲵" "鷁" "鷊" "鹝" "鹢" "麑" "齯"))
    ((("n" "i" "a" "n"))("㘝" "㞋" "㮟" "㲽" "䄭" "䄹" "䚓" "䟢" "䧔" "䩞" "䬯" "卄" "唸" "埝" "姩" "年" "廾" "廿" "念" "拈" "捻" "撚" "撵" "攆" "棯" "涊" "淰" "溓" "碾" "秊" "秥" "簐" "粘" "艌" "蔫" "跈" "蹍" "蹨" "躎" "輦" "輾" "辇" "辗" "鮎" "鯰" "鲇" "鲶" "黏" "鼰" "齞"))
    ((("n" "i" "a" "n" "g"))("䖆" "娘" "嬢" "孃" "酿" "醸" "釀"))
    ((("n" "i" "a" "o"))("㒟" "㜵" "㞙" "㠡" "㭤" "㳮" "㼭" "䃵" "䐁" "䙚" "䦊" "䮍" "嫋" "嬝" "嬲" "尿" "樢" "氽" "溺" "脲" "茑" "蔦" "袅" "裊" "褭" "鳥" "鸟"))
    ((("n" "i" "e"))("㖕" "㖖" "㘝" "㘿" "㙞" "㚔" "㜦" "㜸" "㟧" "㡪" "㩶" "㮆" "㴪" "㸎" "䂼" "䄒" "䌜" "䜓" "䞕" "䯀" "䯅" "䯵" "乜" "啮" "喦" "嗫" "噛" "嚙" "囁" "囓" "圼" "孼" "孽" "峊" "嵲" "嶭" "帇" "惗" "捏" "捻" "掜" "揑" "摂" "摄" "摰" "攝" "敜" "枿" "棿" "槷" "槸" "櫱" "泥" "涅" "湼" "疌" "篞" "糱" "糵" "聂" "聶" "臬" "臲" "苶" "菍" "蘖" "蠥" "諗" "踂" "踗" "蹑" "躡" "鈢" "鉨" "鉩" "錜" "鎳" "鑈" "鑷" "钀" "镊" "镍" "闑" "陧" "隉" "顳" "颞" "齧"))
    ((("n" "i" "n"))("㤛" "䋻" "䚾" "䛘" "囜" "您" "拰"))
    ((("n" "i" "n" "g"))("㝕" "㣷" "㩶" "㲰" "㿦" "䔭" "䗿" "䭢" "佞" "侫" "儜" "冰" "凝" "咛" "嚀" "宁" "寍" "寕" "寗" "寜" "寧" "拧" "擰" "柠" "橣" "檸" "泞" "泥" "濘" "狞" "獰" "甯" "疑" "矃" "聍" "聹" "苧" "薴" "鑏" "鬡" "鸋"))
    ((("n" "i" "u"))("㺲" "䀔" "䂇" "䋴" "䏔" "䒜" "䤔" "䮗" "妞" "忸" "扭" "抝" "拗" "杻" "炄" "牛" "狃" "紐" "纽" "莥" "蚴" "衂" "鈕" "钮" "靵"))
    ((("n" "o" "n" "g"))("㶶" "㺜" "䁸" "䂇" "䢉" "䵜" "侬" "儂" "农" "哝" "噥" "弄" "挊" "挵" "檂" "欁" "浓" "濃" "癑" "禯" "秾" "穠" "脓" "膿" "蕽" "襛" "譨" "農" "辳" "醲" "鬞" "齈"))
    ((("n" "o" "u"))("㕢" "㝹" "䅶" "䔈" "䘫" "䨲" "䫖" "䰭" "啂" "槈" "檽" "獳" "穀" "羺" "耨" "譨" "譳" "鎒" "鐞"))
    ((("n" "u"))("㚢" "䢞" "䢪" "伮" "努" "奴" "孥" "帑" "弩" "怒" "抐" "挐" "搙" "砮" "笯" "胬" "蒘" "褥" "駑" "驽" "鴑"))
    ((("n" "u" "a" "n"))("㬉" "䎡" "䙇" "偄" "暖" "渜" "濡" "煖" "煗" "餪"))
    ((("n" "u" "e"))("䖈" "䖋" "硸"))
    ((("n" "u" "o"))("㐡" "㑚" "㔮" "㖠" "㛂" "㡅" "㰙" "䇔" "䎟" "䚥" "傩" "儺" "喏" "娜" "愞" "懦" "懧" "挪" "挼" "捼" "掿" "搦" "搻" "撋" "梛" "橠" "濡" "砈" "砹" "稬" "穤" "糥" "糯" "袳" "諾" "诺" "蹃" "逽" "那" "郍" "鍩" "锘" "难" "難" "需"))
    ((("o"))("哦" "噢"))
    ((("o" "u"))("㒖" "㛏" "㸸" "㼴" "䌂" "䌔" "䚆" "䯚" "偶" "区" "區" "吘" "吽" "呕" "嘔" "塸" "怄" "慪" "櫙" "欧" "歐" "殴" "毆" "沤" "渥" "漚" "熰" "瓯" "甌" "眍" "瞘" "禺" "紆" "耦" "腢" "蕅" "藕" "謳" "讴" "鏂" "鴎" "鷗" "鸥" "齵"))
    ((("p" "a"))("㞎" "䎬" "䎱" "䯲" "䶕" "啪" "夿" "妑" "帊" "帕" "怕" "扒" "掱" "杷" "汃" "派" "潖" "爬" "琶" "皅" "筢" "耙" "舥" "芭" "葩" "蚆" "袙" "趴" "跁" "鈀" "钯"))
    ((("p" "a" "i"))("㭛" "㵺" "䃻" "䖰" "䮘" "䱝" "俖" "俳" "哌" "廹" "徘" "拍" "排" "棑" "汖" "派" "湃" "牌" "猅" "箄" "篺" "簰" "簲" "脾" "腗" "蒎" "輫" "迫" "鎃"))
    ((("p" "a" "n"))("㩯" "㳪" "㵗" "䃑" "䃲" "䈲" "䋣" "䙃" "䙪" "䰉" "䰔" "伴" "冸" "判" "叛" "坢" "奤" "媻" "幋" "弁" "扳" "抃" "拌" "拚" "搫" "攀" "柈" "槃" "樊" "沜" "泮" "洀" "溿" "潘" "瀊" "瀋" "炍" "爿" "片" "牉" "畔" "畨" "番" "皤" "盘" "盤" "盼" "眅" "砏" "砙" "磐" "磻" "緐" "縏" "繁" "胖" "般" "蒰" "螌" "蟠" "袢" "襻" "覍" "詊" "跘" "蹒" "蹣" "鄱" "鋬" "鎜" "鑻" "鞶" "頄" "頖"))
    ((("p" "a" "n" "g"))("㑂" "㜊" "㝑" "㤶" "㥬" "㫄" "䂇" "䅭" "䒍" "䠙" "䨦" "䮾" "乓" "仿" "倣" "傍" "厐" "厖" "嗙" "嫎" "尨" "庞" "庬" "彷" "徬" "房" "方" "旁" "榜" "滂" "炐" "磅" "篣" "耪" "肨" "胖" "胮" "膀" "膖" "舽" "蒡" "螃" "覫" "逄" "逢" "鎊" "雱" "霶" "騯" "髈" "鰟" "鳑" "龎" "龐"))
    ((("p" "a" "o"))("㘐" "㚿" "㯡" "䛌" "䠙" "䩝" "䶌" "刨" "匏" "咆" "垉" "奅" "庖" "抛" "拋" "泡" "炮" "炰" "爮" "狍" "疱" "皰" "砲" "礟" "礮" "胞" "脬" "苞" "袍" "趵" "跑" "軳" "鉋" "鑤" "靤" "鞄" "颮" "髱" "鮑" "麃" "麅" "麭" "齙" "龅"))
    ((("p" "e" "i"))("㟝" "㣆" "㤄" "㧩" "㨐" "㫲" "㳈" "㸬" "㾦" "䂜" "䊃" "䕗" "䟺" "䡊" "䣙" "䪹" "䫊" "䫠" "䲹" "伂" "佩" "呸" "啡" "坏" "垺" "培" "妃" "妚" "姵" "娝" "岯" "帔" "徘" "怌" "斾" "旆" "昢" "朏" "柸" "毰" "沛" "浿" "淠" "珮" "琣" "碚" "笩" "肧" "肺" "胐" "胚" "艴" "苝" "茇" "蜚" "衃" "裴" "裵" "賠" "赔" "輫" "轡" "辔" "邳" "配" "醅" "錇" "锫" "阫" "陪" "陫" "霈" "馷"))
    ((("p" "e" "n"))("㾦" "呠" "喯" "喷" "噴" "歕" "汾" "湓" "濆" "瓫" "盆" "翉" "翸" "葐"))
    ((("p" "e" "n" "g"))("㑟" "㔙" "㘐" "㛔" "㥊" "㮄" "㮟" "㱶" "㼞" "䄘" "䋽" "䡫" "䰃" "䴶" "䵄" "亨" "倗" "傰" "匉" "嘭" "埄" "堋" "塜" "塳" "弸" "彭" "怦" "恲" "憉" "抨" "挷" "捧" "掽" "搒" "朋" "梈" "棚" "椖" "椪" "樥" "泙" "淎" "淜" "漰" "澎" "烹" "甏" "痭" "皏" "砰" "硑" "硼" "碰" "磞" "稝" "竼" "篣" "篷" "纄" "膨" "芃" "苹" "菶" "蓬" "蟚" "蟛" "踫" "軯" "軿" "輣" "迸" "逢" "錋" "鑝" "閛" "韸" "韼" "駍" "驡" "髼" "鬅" "鬔" "鵬" "鹏"))
    ((("p" "i"))("㔃" "㔥" "㡙" "㨽" "㮰" "㯅" "㱟" "㳪" "㵨" "㼰" "㿙" "䏘" "䑀" "䑄" "䖩" "䗄" "䚰" "䚹" "䠘" "䡟" "䡶" "䤏" "䤨" "䪐" "䫌" "䰦" "䴙" "䴽" "丕" "仳" "伾" "僻" "劈" "匹" "否" "啤" "噼" "噽" "嚭" "圮" "坏" "坯" "埤" "壀" "媲" "嫓" "屁" "岥" "崥" "庀" "怶" "悂" "憵" "批" "披" "抷" "揊" "擗" "旇" "朇" "枇" "椑" "比" "毗" "毘" "淠" "渒" "潎" "澼" "濞" "炋" "焷" "犤" "狉" "狓" "玭" "琵" "甓" "番" "疈" "疋" "疲" "痞" "痦" "癖" "皮" "睥" "砒" "磇" "礔" "礕" "秛" "秠" "笓" "篦" "紕" "纰" "罢" "罴" "罷" "羆" "翍" "耚" "肶" "脴" "脾" "腗" "膍" "芘" "苉" "苤" "蕃" "薜" "蚌" "蚍" "蚽" "蜱" "螵" "螷" "被" "裨" "諀" "譬" "豼" "豾" "貔" "辟" "邳" "郫" "鄱" "釽" "鈈" "鈚" "鈹" "鉟" "銔" "銢" "錍" "鎞" "铍" "闢" "阰" "陂" "陴" "隦" "霹" "鞞" "頗" "駓" "髬" "髲" "魮" "魾" "鮍" "鲏" "鴄" "鷿" "鸊" "鼙"))
    ((("p" "i" "a" "n"))("㓲" "㛹" "㸤" "㼐" "䏒" "䮁" "便" "偏" "囨" "媥" "扁" "楄" "楩" "片" "犏" "玭" "甂" "篇" "緶" "缏" "翩" "胼" "腁" "萹" "蝙" "褊" "覑" "諚" "諞" "谝" "貵" "賆" "跰" "蹁" "輧" "辨" "辩" "辯" "頨" "駢" "騈" "騗" "騙" "骈" "骗" "骿" "鶣"))
    ((("p" "i" "a" "o"))("㩠" "㬓" "㯱" "㲏" "㵱" "㹾" "㺓" "㼼" "䏇" "䕯" "䴩" "僄" "剽" "勡" "嘌" "嫖" "彯" "徱" "慓" "摽" "旚" "朴" "殍" "淲" "漂" "犥" "瓢" "皫" "瞟" "票" "竂" "篻" "縹" "缥" "翲" "膘" "臕" "莩" "蔈" "薸" "藨" "蚫" "螵" "醥" "闝" "顠" "飃" "飄" "飘" "驃" "骠" "髟" "魒" "麃"))
    ((("p" "i" "e"))("䥕" "丿" "嫳" "撆" "撇" "暼" "氕" "潎" "瘪" "癟" "瞥" "苤" "覕" "鐅"))
    ((("p" "i" "n"))("㰋" "㲏" "㻞" "䀻" "品" "嚬" "姘" "娦" "嫔" "嬪" "拚" "拼" "榀" "泵" "涄" "牝" "獱" "玭" "琕" "矉" "礗" "聘" "苹" "薲" "蘋" "蠙" "貧" "贫" "頻" "顰" "频" "颦"))
    ((("p" "i" "n" "g"))("㲏" "㵗" "㺸" "㻂" "䈂" "䍈" "䓑" "䶄" "乒" "俜" "冯" "凭" "凴" "呯" "坪" "娉" "屏" "屛" "帡" "帲" "幈" "平" "慿" "憑" "枰" "泙" "洴" "淜" "焩" "玶" "瓶" "甁" "甹" "砯" "砰" "秤" "竮" "箳" "簈" "缾" "聘" "聠" "胓" "艵" "苹" "荓" "萍" "蓱" "蘋" "蚲" "蛢" "評" "评" "軿" "輧" "郱" "頩" "馮" "鮃" "鲆" "鵧"))
    ((("p" "o"))("㛘" "㜑" "㨇" "㩯" "㰴" "䄸" "䎅" "䎊" "䘠" "䞟" "䣪" "䣮" "䦌" "䨰" "䪖" "䪙" "䮘" "䯙" "叵" "嘙" "嚩" "坡" "婆" "尀" "岥" "岶" "廹" "拍" "攴" "朴" "桲" "櫇" "泊" "泺" "泼" "溌" "溥" "潑" "濼" "炇" "烞" "狛" "猼" "珀" "番" "癹" "皤" "破" "砶" "笸" "粕" "緐" "繁" "膊" "蒪" "蔢" "覇" "跛" "迫" "鄱" "酦" "醗" "醱" "釙" "鉕" "鏺" "钋" "钷" "陂" "霸" "頗" "颇" "駊" "魄"))
    ((("p" "o" "u"))("㕻" "㟝" "㧵" "㰴" "㼜" "䎧" "䯽" "䳝" "剖" "勏" "咅" "哣" "垺" "培" "堷" "婄" "廍" "抔" "抙" "捊" "掊" "棓" "涪" "犃" "瓿" "蔀" "裒" "踣" "部" "錇" "锫" "附"))
    ((("p" "u"))("㒒" "㙸" "㬥" "㯷" "㲫" "㹒" "㺪" "䈬" "䈻" "䑑" "䔕" "䗱" "䧤" "䪬" "䲕" "䴆" "仆" "僕" "剥" "匍" "噗" "圃" "圤" "埔" "堡" "墣" "扑" "扶" "抪" "撲" "擈" "攴" "普" "暴" "曝" "朴" "樸" "檏" "毞" "氆" "浦" "溥" "潽" "濮" "瀑" "烳" "獛" "璞" "甫" "痡" "瞨" "穙" "箁" "纀" "脯" "舖" "舗" "苻" "莆" "菐" "菩" "葡" "蒱" "蒲" "襆" "襥" "誧" "諩" "譜" "谱" "蹼" "轐" "酺" "醭" "鋪" "鏷" "鐠" "铺" "镤" "镨" "陠" "鯆"))
    ((("q" "i"))("㒅" "㓗" "㓞" "㔑" "㖢" "㘍" "㙨" "㜎" "㝄" "㞓" "㞚" "㞿" "㟓" "㟚" "㟢" "㠍" "㠎" "㠱" "㣬" "㥓" "㦢" "㩩" "㩽" "㫅" "㫓" "㮑" "㯦" "㹄" "㼤" "㾨" "䀈" "䀙" "䁈" "䁉" "䄎" "䄢" "䄫" "䅤" "䅲" "䉝" "䉻" "䋯" "䌌" "䎢" "䏅" "䏌" "䏠" "䏿" "䐡" "䐤" "䑴" "䒗" "䒻" "䓅" "䓫" "䔇" "䔾" "䙄" "䚉" "䚍" "䛛" "䛴" "䞚" "䟄" "䟚" "䠞" "䡋" "䡔" "䢀" "䧘" "䧵" "䩓" "䫔" "䬣" "䭫" "䭬" "䭶" "䭼" "䯥" "䰇" "䰍" "䰴" "䱈" "䲬" "䳢" "䶒" "䶓" "䶞" "七" "乞" "亓" "亝" "亟" "企" "伎" "俟" "倛" "僛" "其" "凄" "切" "刺" "刾" "剘" "启" "呇" "呮" "咠" "唘" "唭" "啓" "啔" "啟" "嘁" "噐" "器" "圻" "埼" "墄" "墘" "夡" "奇" "契" "妻" "娸" "婍" "屺" "岂" "岐" "岓" "崎" "嵠" "帺" "弃" "徛" "忔" "忯" "悽" "愒" "愭" "慼" "慽" "憇" "憩" "懠" "戚" "挈" "掑" "掲" "摖" "攲" "敧" "斉" "斊" "旂" "旗" "晵" "暣" "朞" "期" "杞" "枝" "柒" "栔" "栖" "桤" "桼" "棄" "棊" "棋" "棨" "棲" "榿" "槣" "槭" "檱" "檵" "櫀" "欹" "欺" "歧" "气" "気" "氣" "汔" "汽" "沏" "泣" "淇" "淒" "湆" "湇" "湿" "溪" "溼" "漆" "漬" "濕" "濝" "濟" "炁" "焏" "猉" "玂" "玘" "琦" "琪" "璂" "甈" "甭" "畁" "畦" "畸" "疷" "盀" "盵" "矵" "砌" "碁" "碕" "碛" "碶" "磎" "磜" "磧" "磩" "礘" "示" "祁" "祈" "祺" "禥" "稽" "竐" "竒" "粞" "粸" "綥" "綦" "綨" "綮" "綺" "緀" "緁" "緝" "纃" "绮" "缉" "罊" "翗" "耆" "肵" "脐" "臍" "艩" "芑" "芞" "芪" "荠" "萁" "萋" "萕" "葺" "蕲" "薺" "藄" "蘄" "虮" "蚑" "蚔" "蚚" "蛴" "蜝" "蜞" "蟣" "蟿" "蠐" "衹" "袳" "裿" "訖" "諆" "諬" "諿" "讫" "谿" "豈" "賫" "賷" "赍" "起" "趿" "跂" "踑" "踦" "蹊" "軙" "軝" "迄" "迉" "逗" "邔" "郪" "鄿" "釮" "錡" "錤" "鏚" "锜" "闙" "陭" "隑" "霋" "頎" "顣" "颀" "饑" "騎" "騏" "騹" "骐" "骑" "鬐" "鬿" "魌" "鮨" "鯕" "鰭" "鲯" "鳍" "鵸" "鶀" "鶈" "鸂" "麒" "鼜" "齊" "齌" "齎" "齐" "𠀁"))
    ((("q" "i" "a"))("㓞" "㓣" "㓤" "㡊" "㤉" "㦴" "㰤" "㵄" "䁍" "䂒" "䜑" "䠍" "䨐" "䯊" "䶗" "䶝" "匼" "卡" "圶" "帢" "恰" "掐" "楬" "殎" "洽" "疴" "葜" "跒" "酠" "髂" "鮚"))
    ((("q" "i" "a" "n"))("㐸" "㜞" "㝿" "㟻" "㡊" "㡨" "㥞" "㦮" "㧄" "㨜" "㩮" "㪠" "㯠" "㸫" "㹂" "䁮" "䃛" "䅐" "䅾" "䆂" "䈤" "䈴" "䊴" "䋮" "䍉" "䑶" "䔔" "䕭" "䖍" "䙺" "䢪" "䤘" "䥅" "䦲" "䨿" "䪈" "䫡" "䭠" "䭤" "䯡" "䵖" "乹" "乾" "仟" "仱" "佥" "倩" "傔" "僉" "儙" "兛" "刋" "前" "千" "厱" "唊" "嗛" "圱" "圲" "堑" "塹" "壍" "奷" "婜" "媊" "孅" "孯" "岍" "岒" "嵌" "嵰" "幵" "忴" "悓" "悭" "愆" "慊" "慳" "扦" "扲" "拑" "拪" "挳" "掔" "掮" "揵" "搴" "撁" "撖" "攐" "攑" "攓" "杄" "柑" "棈" "椠" "榩" "槏" "槧" "檶" "櫏" "欠" "欦" "歉" "歬" "汘" "汧" "浅" "涔" "淺" "渐" "漧" "漸" "潛" "潜" "濳" "濽" "灊" "煔" "燂" "燅" "燖" "爓" "牵" "牽" "犍" "皘" "筋" "签" "箝" "篏" "篟" "簽" "籤" "粁" "綪" "縴" "繾" "纤" "缱" "羟" "羥" "肷" "腱" "膁" "臤" "芊" "芡" "茜" "荨" "葥" "蒨" "蔳" "蕁" "虔" "蚈" "蜸" "褰" "諐" "謙" "譣" "譴" "谦" "谴" "谸" "赶" "蹇" "輤" "迁" "遣" "遷" "釺" "鈆" "鈐" "鉗" "鉛" "銭" "鋟" "錢" "鍼" "鐱" "钎" "钤" "钱" "钳" "铅" "锓" "阡" "雂" "韆" "顩" "騚" "騫" "骞" "鬜" "鬝" "鬵" "鰬" "鵮" "鶼" "鹐" "黔" "黚" "齦"))
    ((("q" "i" "a" "n" "g"))("㛨" "㩖" "䅚" "䵁" "丬" "傸" "勥" "呛" "唴" "啌" "嗆" "墏" "墙" "墻" "嫱" "嬙" "将" "將" "嵹" "嶈" "廧" "弜" "強" "强" "彊" "戕" "戗" "戧" "抢" "控" "搶" "斨" "枪" "椌" "槍" "樯" "檣" "溬" "漒" "炝" "熗" "爿" "牄" "牆" "猐" "玱" "瑲" "疆" "矼" "磢" "箐" "篬" "繈" "繦" "羌" "羗" "羟" "羥" "羫" "羻" "腔" "艢" "蔷" "薔" "蘠" "蜣" "襁" "謒" "跄" "跫" "蹌" "蹡" "軖" "錆" "鎗" "鏘" "鏹" "锖" "锵" "镪" "鶬" "鸧"))
    ((("q" "i" "a" "o"))("㚁" "㚽" "㝯" "㡑" "㢗" "㤍" "㨽" "㩰" "㪣" "㱶" "㴥" "䀉" "䃝" "䆻" "䇌" "䎗" "䏆" "䩌" "䱁" "䲾" "丂" "乔" "侨" "俏" "僑" "僺" "劁" "喬" "嘺" "墝" "墧" "墽" "壳" "峤" "峭" "嵪" "嶠" "嶣" "巧" "帩" "幧" "悄" "愀" "憔" "招" "撬" "撽" "敲" "桥" "樵" "橇" "橋" "殻" "殼" "毳" "焦" "燆" "燋" "癄" "睄" "瞧" "硗" "硚" "硝" "碻" "磽" "礄" "窍" "竅" "簥" "繑" "繰" "缲" "翘" "翹" "舃" "舄" "茭" "荍" "荞" "蕉" "蕎" "藮" "誚" "譙" "诮" "谯" "趫" "趬" "跤" "跷" "踍" "蹺" "蹻" "躈" "郻" "鄡" "鄥" "醮" "釥" "銚" "鍫" "鍬" "鏒" "鐈" "鐰" "锹" "陗" "雀" "鞒" "鞘" "鞽" "韒" "頝" "顦" "驕" "骹" "髚" "髜"))
    ((("q" "i" "e"))("㓶" "㗫" "㙻" "㚗" "㛍" "㛙" "㤲" "㥦" "㫸" "㰰" "㰼" "㹤" "㼤" "㾀" "㾜" "䌌" "䟙" "䤿" "䦧" "䫔" "䬊" "䶗" "且" "伽" "切" "匧" "唼" "嗛" "契" "妾" "怯" "悏" "惬" "愜" "慊" "担" "挈" "捷" "朅" "沏" "洯" "淁" "渫" "癿" "砌" "穕" "窃" "竊" "笡" "箧" "篋" "緁" "脞" "茄" "蕺" "藒" "蛪" "趄" "踥" "鍥" "锲" "鯜" "鰈"))
    ((("q" "i" "n"))("㓎" "㕋" "㘦" "㛙" "㝲" "㞬" "㢙" "㤈" "㩒" "㪁" "㮗" "㱽" "㾛" "䅾" "䇒" "䈜" "䔷" "䖌" "䠴" "䢈" "䥅" "䥆" "䦦" "䶖" "亲" "侵" "勤" "厪" "吢" "吣" "唚" "嗪" "噙" "坅" "媇" "嫀" "寑" "寖" "寝" "寢" "寴" "嵚" "嶔" "庈" "廑" "慬" "懃" "懄" "抋" "捦" "揿" "搇" "撳" "擒" "斳" "昑" "曋" "梣" "梫" "槿" "檎" "櫬" "欽" "沁" "浸" "渗" "溱" "滲" "澿" "瀙" "珡" "琴" "琹" "矜" "禽" "秦" "綅" "耹" "芩" "芹" "菣" "菦" "菫" "蓁" "蘄" "蚙" "螓" "螼" "蠄" "衾" "衿" "覃" "親" "誛" "赺" "赾" "鈙" "鋟" "钦" "锓" "靲" "頜" "顉" "顩" "駸" "骎" "鮼" "鳹" "鵭"))
    ((("q" "i" "n" "g"))("㔀" "㢣" "㩩" "㯳" "㵾" "㷫" "䋜" "䋯" "䌠" "䔛" "䝼" "䞍" "䯧" "䲔" "䵞" "亲" "倩" "倾" "傾" "凊" "剠" "勍" "卿" "啨" "圊" "夝" "寈" "庆" "庼" "廎" "情" "慶" "掅" "擎" "擏" "晴" "暒" "樈" "檠" "檾" "殑" "殸" "氢" "氫" "氰" "汫" "涇" "淸" "清" "渹" "漀" "狅" "甠" "碃" "磘" "磬" "箐" "精" "綮" "罄" "苘" "蜻" "親" "請" "謦" "请" "軽" "輕" "轻" "郬" "鑋" "靑" "青" "靘" "頃" "顷" "鯖" "鯨" "鲭" "鲸" "黥" "晴"))
    ((("q" "i" "o" "n" "g"))("㑋" "㒌" "㤨" "㧭" "㮪" "㵌" "㷀" "㼇" "䅃" "䆳" "䊄" "䓖" "䛪" "䠻" "䧆" "儝" "匔" "卭" "嬛" "宆" "惸" "桏" "棾" "橩" "焪" "焭" "煢" "琼" "璚" "瓊" "睘" "瞏" "穷" "穹" "窮" "竆" "笻" "筇" "芎" "苘" "茕" "藑" "藭" "蛩" "蛬" "赹" "跫" "輁" "邛" "銎" "鞠"))
    ((("q" "i" "u"))("㐤" "㕤" "㛏" "㞗" "㟈" "㤹" "㥢" "㧄" "㧨" "㭝" "㲹" "㷕" "㺫" "㼒" "䊆" "䊵" "䎿" "䔔" "䜪" "䞭" "䟬" "䟵" "䠗" "䣇" "䤛" "丘" "丠" "仇" "俅" "厹" "叴" "唒" "囚" "坵" "媝" "崷" "巯" "巰" "恘" "扏" "捄" "搝" "朹" "梂" "楸" "殏" "毬" "氽" "求" "汓" "泅" "浗" "渞" "湫" "煪" "犰" "玌" "球" "璆" "皳" "盚" "秋" "秌" "穐" "篍" "糗" "紌" "絿" "緧" "肍" "脙" "艽" "苬" "莍" "萩" "蓲" "虬" "虯" "蚯" "蛷" "蝤" "蝵" "螑" "蟗" "蠤" "裘" "觓" "觩" "訄" "訅" "賕" "赇" "趥" "逎" "逑" "遒" "邱" "酋" "釓" "釚" "銶" "钆" "鞦" "鞧" "頄" "頯" "馗" "鮂" "鯄" "鰌" "鰍" "鰽" "鱃" "鳅" "鳩" "鶖" "鹙" "鼽" "龜" "龝" "龟" "𠀉" "𩝠"))
    ((("q" "u"))("㖆" "㚁" "㜹" "㣄" "㤲" "㧁" "㪯" "㫢" "㯫" "㰦" "㲘" "㽛" "䀠" "䁦" "䂂" "䅓" "䆽" "䋧" "䌌" "䏣" "䒧" "䗇" "䝣" "䞤" "䟊" "䠐" "䠓" "䢗" "䪨" "䵶" "䶚" "伹" "佉" "佢" "凵" "刞" "劬" "匤" "匷" "区" "區" "厺" "去" "取" "呿" "坥" "娶" "屈" "岖" "岴" "嶇" "忂" "憈" "懅" "戵" "抾" "敺" "斪" "曲" "朐" "欋" "毆" "氍" "浀" "淭" "渠" "湨" "灈" "璖" "璩" "痀" "癯" "瞿" "砠" "磲" "祛" "竘" "竬" "筁" "籧" "紶" "組" "絇" "絮" "翑" "翵" "胊" "胠" "臞" "苣" "菃" "葋" "蕖" "蘧" "虚" "蚷" "蛆" "蛐" "蜡" "螶" "蟝" "蠷" "蠼" "衢" "袪" "覰" "覷" "覻" "觑" "詓" "詘" "誳" "诎" "豦" "趋" "趍" "趣" "趨" "躣" "躯" "軀" "軥" "遽" "鉤" "鐻" "鑺" "镼" "閴" "闃" "阒" "阹" "鞠" "鞫" "駆" "駈" "騶" "驅" "驱" "髷" "魼" "鰸" "鱋" "鴝" "鶌" "鸜" "鸲" "麮" "麯" "麴" "麹" "黢" "鼁" "鼩" "齲" "龋" "𪍸"))
    ((("q" "u" "a" "n"))("㒰" "㟨" "㟫" "㩲" "䀬" "䄐" "䅚" "䊎" "䌯" "䑏" "䟒" "䠰" "佺" "全" "券" "劝" "劵" "勧" "勸" "卷" "呟" "啳" "圈" "圏" "奆" "姾" "婘" "孉" "峑" "巏" "弮" "恮" "悛" "惓" "拳" "捲" "搼" "权" "桊" "棬" "権" "權" "汱" "泉" "洤" "湶" "烇" "牶" "牷" "犈" "犬" "獾" "玔" "琄" "瑔" "甽" "畎" "痊" "硂" "筌" "箞" "純" "絟" "絭" "綣" "縓" "纯" "绻" "腃" "荃" "荈" "葲" "虇" "蜷" "蠸" "觠" "詃" "詮" "謜" "诠" "跧" "踡" "輇" "辁" "醛" "銓" "鐉" "铨" "顴" "颧" "駩" "騡" "鬈" "鰁" "鳈" "鷤" "鸛" "齤"))
    ((("q" "u" "e"))("㕁" "㩁" "㰌" "㱋" "㱿" "㴶" "㹤" "㹱" "㾡" "䀇" "䇎" "䍳" "䢧" "䦬" "䧿" "䱜" "䲵" "却" "卻" "咑" "埆" "塙" "墧" "寉" "崅" "悫" "愨" "慤" "搉" "攉" "榷" "欠" "殻" "毃" "灍" "炔" "燩" "猎" "獡" "琷" "瘸" "皵" "硞" "确" "碏" "確" "碻" "礐" "礭" "缺" "舃" "舭" "芍" "蒛" "觳" "趞" "郄" "闋" "闕" "阕" "阙" "雀" "鳥" "鵲" "鹊" "𩨭"))
    ((("q" "u" "n"))("㪊" "㿏" "䆽" "䭽" "囷" "夋" "宭" "峮" "帬" "杶" "漘" "羣" "群" "蝽" "裙" "裠" "踆" "輴" "逡" "遁" "錞" "鰆" "麇" "麕"))
    ((("r" "a" "n"))("㒄" "㚩" "㜣" "㯗" "㲯" "㸐" "㹱" "㾆" "㿵" "䇋" "䎃" "䑙" "䒣" "䔳" "䖄" "䣸" "䤡" "䫇" "䰯" "䳿" "䶲" "冄" "冉" "呥" "嘫" "姌" "媣" "染" "橪" "然" "燃" "珃" "繎" "肰" "苒" "蚒" "蚦" "蚺" "蛅" "衻" "袇" "袡" "髥" "髯"))
    ((("r" "a" "n" "g"))("㚂" "䉴" "䑋" "儴" "勷" "嚷" "壌" "壤" "孃" "懹" "攘" "瀼" "爙" "獽" "瓤" "禳" "穣" "穰" "纕" "蘘" "蠰" "譲" "讓" "让" "躟" "鑲" "镶" "鬤"))
    ((("r" "a" "o"))("㑱" "㹛" "䫞" "娆" "嬈" "扰" "挐" "擾" "桡" "橈" "繚" "繞" "绕" "荛" "蕘" "蛲" "蟯" "襓" "遶" "隢" "顤" "饒" "饶"))
    ((("r" "e"))("㻰" "喏" "惹" "渃" "热" "焫" "熱" "爇" "若"))
    ((("r" "e" "n"))("㠴" "㣼" "㤛" "㲽" "㶵" "㸾" "䀔" "䀼" "䄒" "䇮" "䋕" "䌾" "䏕" "䏰" "䚾" "䛘" "䭃" "䴦" "人" "亻" "仁" "仞" "仭" "任" "刃" "刄" "壬" "妊" "姙" "屻" "忈" "忍" "忎" "恁" "扨" "朲" "杒" "栠" "栣" "梕" "棯" "牣" "秂" "秹" "稔" "紉" "紝" "絍" "纫" "纴" "肕" "腍" "芢" "荏" "荵" "葚" "衽" "袵" "訒" "認" "认" "讱" "賃" "赁" "軔" "軠" "轫" "鈓" "銋" "靭" "靱" "韌" "韧" "飪" "餁" "饪" "魜" "鴹" "鵀"))
    ((("r" "e" "n" "g"))("㭁" "㺱" "䄧" "䚮" "仍" "扔" "礽" "穰" "耳" "艿" "芿" "辸" "陾"))
    ((("r" "i"))("䒤" "囸" "日" "氜" "衵" "釰" "鈤" "馹" "驲"))
    ((("r" "o" "n" "g"))("㘇" "㝐" "㣑" "㭜" "㲓" "㲝" "㲨" "㺎" "㼸" "䄧" "䇀" "䇯" "䈶" "䋴" "䘬" "䠜" "䡆" "䡥" "䢇" "䤊" "䩸" "傇" "傛" "冗" "媶" "宂" "容" "嵘" "嶸" "戎" "搑" "曧" "栄" "榕" "榮" "榵" "毧" "氄" "溶" "滽" "瀜" "烿" "熔" "爃" "狨" "瑢" "穁" "絨" "縙" "縟" "绒" "羢" "肜" "茙" "茸" "荣" "蓉" "蝾" "融" "螎" "蠑" "褣" "訟" "讼" "軵" "鎔" "镕" "隔" "頌" "颂" "駥" "髶" "鰫" "鴧" "鷛"))
    ((("r" "o" "u"))("㖻" "㮟" "㽥" "䄾" "䋴" "䐓" "䢇" "䥆" "䧷" "䰆" "媃" "宍" "扰" "揉" "擾" "柔" "楺" "沑" "渘" "煣" "瑈" "瓇" "禸" "粈" "糅" "肉" "脜" "腬" "葇" "蝚" "蹂" "輮" "鍒" "鍕" "鞣" "韖" "騥" "鰇" "鶔"))
    ((("r" "u"))("㦺" "㨌" "㨎" "㱶" "㹘" "㼋" "㾒" "䋈" "䋴" "䐓" "䘫" "䞕" "䤉" "䫱" "䰭" "䰰" "乳" "侞" "傉" "儒" "入" "嗕" "嚅" "女" "如" "媷" "孺" "帤" "挐" "擩" "曘" "桇" "汝" "洳" "渪" "溽" "濡" "燸" "筎" "縟" "繻" "缛" "肉" "肗" "臑" "茹" "蓐" "蕠" "薷" "蝡" "蠕" "袽" "褥" "襦" "辱" "邚" "鄏" "醹" "銣" "鑐" "铷" "需" "顬" "颥" "鱬" "鴽"))
    ((("r" "u" "a" "n"))("㓴" "㜛" "㨎" "㮕" "㼱" "㽭" "䆓" "䎡" "䓴" "䙃" "䙇" "䞂" "䪀" "䪭" "堧" "壖" "媆" "撋" "朊" "濡" "瑌" "瓀" "盶" "碝" "礝" "緛" "耎" "腝" "蝡" "蠕" "軟" "輭" "软" "阮" "需"))
    ((("r" "u" "i"))("㓹" "㕙" "㛱" "㨅" "㪫" "㮃" "㲊" "㹘" "㻔" "䂱" "䅑" "䇤" "䌼" "䍴" "䓲" "䞩" "䦌" "䳠" "兑" "叡" "壡" "惢" "擩" "枘" "桵" "橤" "汭" "瑞" "甤" "睿" "綏" "緌" "繠" "芮" "蕊" "蕋" "蕤" "蘂" "蘃" "蚋" "蜹" "鈉" "銳" "鋭" "锐"))
    ((("r" "u" "n"))("㝄" "㠈" "䏕" "䦞" "橍" "润" "潤" "犉" "瞤" "膶" "閏" "閠" "闰"))
    ((("r" "u" "o"))("㬉" "䐞" "偌" "叒" "婼" "弱" "挪" "挼" "捼" "楉" "渃" "焫" "爇" "箬" "篛" "芮" "若" "蒻" "蠚" "鄀" "鰙" "鰯" "鶸"))
    ((("s" "a"))("㒎" "㪪" "㳐" "㽂" "䊛" "䑥" "䓲" "䘮" "䙣" "䬃" "些" "仨" "卅" "摋" "撒" "攃" "杀" "檫" "櫒" "殺" "洒" "潵" "灑" "脎" "萨" "蔡" "薩" "趿" "躠" "鈒" "鎝" "钑" "闟" "靸" "颯" "飒" "馺"))
    ((("s" "a" "i"))("㗷" "㘔" "䈢" "僿" "嗮" "噻" "塞" "思" "愢" "揌" "毢" "毸" "簺" "腮" "蓑" "賽" "赛" "顋" "鰓" "鳃"))
    ((("s" "a" "n"))("㤾" "㧲" "㪔" "㪚" "䀐" "䉈" "䊉" "䫅" "䫩" "三" "仐" "伞" "俕" "傘" "叁" "参" "參" "叄" "嘇" "弎" "攕" "散" "毵" "毿" "潵" "犙" "粣" "粪" "糁" "糂" "糝" "糣" "糤" "繖" "蔘" "鏾" "閐" "饊" "馓" "鬖")) 
    ((("s" "a" "n" "g"))("䘮" "䡦" "䫙" "丧" "喪" "嗓" "搡" "桑" "桒" "磉" "褬" "鎟" "顙" "颡"))
    ((("s" "a" "o"))("㛮" "㿋" "䐹" "䕅" "䖣" "喿" "埽" "嫂" "慅" "扫" "掃" "掻" "搔" "氉" "溞" "燥" "瘙" "矂" "繅" "繰" "缫" "缲" "臊" "艘" "颾" "騒" "騷" "骚" "鰠" "鰺" "鱢" "鳋"))
    ((("s" "e"))("㒊" "㥶" "㮦" "㱇" "㴔" "㺩" "㻎" "㻭" "㽇" "䉢" "䊂" "䔼" "䨛" "啬" "嗇" "塞" "懎" "槭" "歮" "歰" "泣" "涩" "漬" "澀" "澁" "濇" "瀒" "瑟" "璱" "穑" "穡" "繬" "翜" "色" "蔷" "薔" "譅" "趇" "轖" "鉍" "銫" "鎩" "铯" "雭" "飋"))
    ((("s" "e" "n"))("曑" "森" "椮" "槮" "洒" "滲" "甧" "穼" "篸" "蔘" "襂"))
    ((("s" "e" "n" "g"))("僧" "鬙"))
    ((("s" "h" "a"))("㚫" "㛼" "㰱" "㵤" "䀉" "䈉" "䝊" "䬊" "䮜" "䯫" "䵘" "䶎" "乷" "倽" "傻" "儍" "刹" "剎" "厦" "唦" "唼" "啑" "啥" "喢" "嗄" "帴" "帹" "廈" "擑" "杀" "杉" "柵" "栅" "桬" "榝" "樧" "檆" "歃" "歰" "殺" "沙" "煞" "猀" "痧" "砂" "硰" "箑" "粆" "紗" "纱" "翜" "翣" "莎" "萐" "蔱" "裟" "訯" "賒" "赊" "鎩" "铩" "閯" "閷" "霅" "霎" "髿" "魦" "鮻" "鯊" "鯋" "鲨"))
    ((("s" "h" "a" "i"))("㬠" "䵘" "晒" "曬" "杀" "殺" "筛" "篩" "繺" "纚" "色" "酾" "釃" "閷"))
    ((("s" "h" "a" "n"))("㚒" "㚲" "㣌" "㣣" "㨛" "㪎" "㪨" "㬭" "㱚" "㱯" "㴸" "㶒" "㹽" "㾆" "䄠" "䆄" "䗞" "䚲" "䛸" "䠾" "䡪" "䥇" "䦂" "䦅" "䱇" "䱉" "䴮" "傓" "僐" "删" "刪" "剡" "剼" "单" "善" "單" "埏" "墠" "墡" "姍" "姗" "嬗" "山" "幓" "彡" "扇" "挻" "掞" "掸" "掺" "搧" "摲" "摻" "撣" "擅" "晱" "杉" "柵" "栅" "椫" "樿" "橏" "檀" "檆" "汕" "潬" "潸" "澘" "澹" "灗" "烻" "煔" "煽" "熌" "狦" "珊" "疝" "痁" "睒" "磰" "禅" "禪" "穇" "笘" "縿" "繕" "缮" "羴" "羶" "脠" "膳" "膻" "舢" "芟" "苫" "蟬" "蟮" "蟺" "衫" "襂" "覢" "訕" "詹" "謆" "譱" "讪" "贍" "赡" "赸" "跚" "軕" "邖" "鄯" "醦" "釤" "銏" "鐥" "钐" "閃" "闪" "陕" "陝" "陿" "顫" "颤" "饍" "騸" "骟" "髟" "鯅" "鱓" "鱔" "鱣" "鳝" "鳣"))
    ((("s" "h" "a" "n" "g"))("䬕" "丄" "上" "伤" "傷" "商" "垧" "墒" "姠" "尙" "尚" "愓" "慯" "扄" "晌" "曏" "殇" "殤" "汤" "湯" "滳" "漡" "熵" "蔏" "螪" "蠰" "裳" "觞" "觴" "謪" "賞" "赏" "銄" "鑜" "鬺"))
    ((("s" "h" "a" "o"))("㪢" "㲈" "㷹" "㸛" "䏴" "䒚" "䔠" "䙼" "䬰" "佋" "劭" "勺" "卲" "召" "哨" "娋" "少" "弰" "招" "捎" "旓" "杓" "梢" "溲" "潲" "烧" "焼" "燒" "燿" "牊" "玿" "睄" "稍" "竰" "笤" "筲" "紹" "綃" "綤" "绍" "艄" "芍" "苕" "莦" "蛸" "袑" "輎" "邵" "鞘" "韶" "颵" "髾"))
    ((("s" "h" "e"))("㒤" "㢵" "㭙" "㰒" "㴇" "㵃" "䀅" "䀹" "䁋" "䁯" "䂠" "䄕" "䌰" "䏴" "䕣" "䜆" "䜓" "䞌" "䠟" "䠶" "䤁" "䤮" "䬷" "䰥" "䵥" "佘" "厍" "厙" "叶" "奓" "奢" "射" "弽" "慑" "慴" "懾" "折" "拾" "捨" "揲" "摂" "摄" "摵" "攝" "杀" "栜" "檨" "欇" "歙" "殺" "涉" "渉" "滠" "灄" "猞" "畬" "畲" "睫" "碟" "社" "聶" "舌" "舍" "葉" "蔎" "虵" "蛇" "蛞" "蛥" "蠂" "設" "譇" "讋" "设" "賒" "賖" "赊" "赦" "輋" "邪" "釶" "鉇" "鉈" "鍦" "铊" "闍" "阇" "韘" "騇" "麝"))
    ((("s" "h" "e" "i"))("誰" "谁"))
    ((("s" "h" "e" "n"))("㔤" "㚞" "㛙" "㜤" "㥲" "㰂" "㰮" "㱯" "㵊" "㵕" "㶒" "㾕" "䄕" "䆦" "䚓" "䧵" "䫖" "䰠" "什" "伔" "伸" "侁" "侺" "信" "兟" "参" "參" "叄" "吲" "呻" "哂" "妽" "姺" "娠" "婶" "嬸" "审" "宷" "審" "屾" "峷" "弞" "愼" "慎" "扟" "抌" "抻" "搷" "昚" "柛" "棽" "椮" "椹" "槮" "氠" "沈" "涁" "淰" "深" "渖" "渗" "滲" "瀋" "煁" "燊" "珅" "甚" "甡" "申" "瘆" "瘎" "瘮" "眒" "眘" "瞫" "矤" "矧" "砷" "神" "籶" "籸" "紳" "綝" "绅" "罙" "罧" "肾" "胂" "脤" "腎" "莘" "葚" "葠" "蓡" "蔘" "薓" "蜃" "裑" "襂" "襳" "覾" "訠" "訦" "訷" "詵" "諗" "諶" "讅" "诜" "谂" "谉" "身" "邥" "鉮" "鋠" "震" "頣" "頥" "駪" "魫" "鯵" "鰺" "鲹" "鵢" "黮" "神"))
    ((("s" "h" "e" "n" "g"))("㗂" "㞼" "㹌" "㼳" "㾪" "䁞" "䇸" "䋲" "䎴" "䚇" "䞉" "䪿" "䱆" "乗" "乘" "偗" "剩" "剰" "勝" "升" "呏" "圣" "墭" "声" "嵊" "憴" "斘" "昇" "晟" "晠" "椉" "榺" "殅" "泩" "渑" "渻" "湦" "溗" "澠" "焺" "牲" "狌" "珄" "琞" "生" "甡" "甥" "甸" "畻" "盛" "省" "眚" "笙" "箵" "繩" "绳" "聖" "聲" "胜" "苼" "蕂" "譝" "貹" "賸" "鉎" "阩" "陞" "鱦" "鵿" "鼪"))
    ((("s" "h" "i"))("㒾" "㔺" "㕜" "㖷" "㫅" "㫑" "㮶" "㱁" "㳏" "㵓" "㶴" "㸷" "㹝" "㹬" "㹷" "䁺" "䂖" "䂠" "䄷" "䈕" "䊓" "䏡" "䑛" "䒨" "䖨" "䛈" "䜴" "䜵" "䜻" "䟗" "䤭" "䤱" "䦠" "䦹" "䩃" "䭄" "䰄" "䲽" "䴓" "䶡" "䶵" "世" "丗" "乨" "乭" "亊" "事" "什" "仕" "似" "佀" "使" "侍" "兘" "冟" "势" "勢" "匙" "十" "卋" "卶" "叓" "史" "呞" "呩" "咶" "嗜" "噬" "埘" "埶" "塒" "士" "失" "奭" "始" "嬕" "实" "実" "室" "宩" "寔" "實" "尸" "屍" "屎" "峕" "峙" "崼" "市" "师" "師" "式" "弑" "弒" "弛" "忕" "恀" "恃" "戠" "戺" "拭" "拾" "提" "揓" "施" "时" "旹" "是" "昰" "時" "枾" "柹" "柿" "栻" "榯" "檡" "殖" "氏" "汁" "泽" "浉" "液" "湁" "湜" "湤" "湿" "溡" "溮" "溼" "澤" "澨" "濕" "灑" "炻" "烒" "狮" "獅" "甚" "眂" "眎" "睗" "矢" "石" "硕" "碩" "示" "祏" "笶" "筮" "箷" "篩" "簭" "絁" "繹" "纚" "翨" "耆" "肢" "舍" "舐" "舓" "莳" "葹" "蒒" "蒔" "蓍" "虱" "蚀" "蝕" "蝨" "螫" "褷" "襫" "襹" "視" "视" "試" "詩" "誓" "諟" "諡" "謚" "識" "识" "试" "诗" "谥" "豉" "豕" "貰" "贳" "赫" "跩" "跱" "軾" "轼" "适" "逝" "遈" "適" "遰" "遾" "邿" "郝" "酾" "醳" "釃" "釈" "释" "釋" "釶" "鈟" "鈰" "鉂" "鉃" "鉇" "鉈" "鉐" "鉽" "銴" "鍉" "鍦" "鎩" "铈" "铊" "食" "飠" "飭" "飾" "餙" "餝" "饣" "饰" "駛" "驶" "鯴" "鯷" "鰣" "鰤" "鲥" "鲺" "鳀" "鳲" "鳾" "鶳" "鸤" "鼫" "鼭" "齛" "𠀍"))
    ((("s" "h" "o" "u"))("㖟" "㝊" "㥅" "䛵" "䭭" "兽" "収" "受" "售" "垨" "壽" "夀" "守" "寿" "手" "授" "掱" "收" "涭" "濤" "熟" "狩" "獸" "璹" "痩" "瘦" "綬" "绶" "艏" "荍" "鏉" "首"))
    ((("s" "h" "u"))("㒔" "㛸" "㜐" "㟬" "㣽" "㫹" "㯮" "㳆" "㵂" "㶖" "㷂" "㻿" "㽰" "㾁" "䃞" "䆝" "䉀" "䎉" "䑕" "䘤" "䙱" "䜹" "䝂" "䝪" "䞖" "䠱" "䠼" "䢞" "䢤" "䩱" "䩳" "䭭" "䴰" "书" "侸" "俆" "俞" "倏" "倐" "儵" "兪" "凁" "叔" "埱" "塾" "墅" "姝" "婌" "孰" "尌" "尗" "属" "屬" "庶" "庻" "恕" "戍" "抒" "掓" "摅" "摴" "攄" "数" "數" "暑" "曙" "書" "朮" "术" "朱" "束" "杸" "杼" "枢" "树" "梳" "樗" "樜" "樞" "樹" "橾" "殊" "殳" "毹" "沭" "涑" "淑" "漱" "潄" "潻" "澍" "濖" "焂" "熟" "璹" "疋" "疎" "疏" "癙" "盨" "秫" "竖" "竪" "籔" "紓" "絉" "綀" "纾" "署" "翛" "腧" "舒" "荗" "荼" "菽" "蒁" "蔬" "薥" "薯" "藪" "藷" "虪" "蜀" "蜍" "術" "袕" "裋" "襡" "襩" "豎" "贖" "赎" "跾" "踈" "軗" "輸" "输" "述" "透" "鄃" "鉥" "錰" "鏣" "鐲" "钃" "陎" "除" "鮛" "鵨" "鶐" "鷸" "鸀" "黍" "鼠" "鼡"))
    ((("s" "h" "u" "a"))("刷" "唰" "涮" "耍" "誜"))
    ((("s" "h" "u" "a" "i"))("䢦" "卛" "咰" "孈" "帅" "帥" "摔" "率" "甩" "綏" "縗" "繂" "缞" "蟀" "衰"))
    ((("s" "h" "u" "a" "n"))("䧠" "拴" "揎" "栓" "汕" "涮" "踹" "閂" "闩"))
    ((("s" "h" "u" "a" "n" "g"))("㦼" "㼽" "䔪" "䗮" "䡯" "䫪" "双" "塽" "孀" "孇" "慡" "樉" "欆" "泷" "淙" "滝" "瀧" "灀" "爽" "礵" "縔" "艭" "雙" "霜" "騻" "驦" "骦" "鷞" "鸘" "鹴"))
    ((("s" "h" "u" "i"))("㔑" "㝽" "㥨" "㽷" "䭨" "䲧" "娷" "帨" "挩" "水" "涗" "涚" "睡" "瞓" "祱" "稅" "税" "脽" "蛻" "蜕" "裞" "說" "説" "誰" "说" "谁"))
    ((("s" "h" "u" "n"))("㥧" "㯗" "䀢" "䀵" "䑞" "䞐" "䴄" "吮" "揗" "楯" "橓" "盾" "眴" "瞚" "瞬" "舜" "蕣" "賰" "順" "顺" "鬊"))
    ((("s" "h" "u" "o"))("㮶" "㸛" "䀥" "䁻" "䈾" "䌃" "哾" "妁" "帅" "帥" "愬" "揱" "搠" "数" "數" "朔" "杓" "槊" "欶" "洬" "溯" "濯" "烁" "燿" "爍" "爚" "獡" "療" "矟" "硕" "碩" "箾" "芍" "蒴" "藥" "說" "説" "说" "鎙" "鑠" "铄"))
    ((("s" "i"))("㐌" "㕽" "㚶" "㜦" "㣈" "㭒" "㸻" "㹑" "㾅" "䂖" "䃽" "䇃" "䎣" "䏤" "䦙" "丝" "亖" "伺" "似" "佀" "佁" "俟" "偲" "儩" "兕" "凘" "厮" "厶" "司" "咝" "嗣" "嘶" "噝" "四" "姒" "娰" "媤" "孠" "寺" "巳" "廝" "思" "撕" "斯" "杫" "枱" "柶" "梩" "楒" "榹" "死" "汜" "泀" "泗" "泤" "洍" "涘" "澌" "瀃" "燍" "牭" "磃" "祀" "祠" "禗" "禠" "禩" "私" "竢" "笥" "簛" "籭" "糸" "糹" "絲" "緦" "纟" "缌" "罳" "耜" "肂" "肄" "肆" "苡" "菥" "蕬" "蕼" "虒" "蛳" "蜤" "螄" "蟖" "蟴" "覗" "貄" "賜" "赐" "釲" "鈻" "鉰" "鋖" "鍶" "鐁" "锶" "雉" "颸" "飔" "食" "飤" "飴" "飼" "饲" "饴" "駟" "騦" "驷" "鷥" "鸶" "鼶" "飼"))
    ((("s" "o" "n" "g"))("㕬" "㧐" "㨦" "㩳" "㮸" "䉥" "䛦" "䜬" "䢠" "倯" "傱" "凇" "娀" "宋" "崧" "嵩" "嵷" "庺" "忪" "怂" "悚" "愯" "慫" "憽" "捒" "松" "枀" "柗" "梥" "楤" "樬" "檧" "淞" "漎" "濍" "硹" "竦" "縱" "纵" "耸" "聳" "菘" "蜙" "訟" "誦" "讼" "诵" "送" "鍶" "鏓" "锶" "頌" "颂" "餸" "駷" "鬆"))
    ((("s" "o" "u"))("㖩" "㛐" "㟬" "㵻" "䈹" "䉤" "䏂" "䮟" "傁" "叜" "叟" "嗖" "嗽" "嗾" "廀" "廋" "捜" "搜" "摉" "擞" "擻" "櫢" "涑" "溲" "滫" "漱" "潄" "獀" "瘶" "瞍" "籔" "膄" "艘" "蒐" "薮" "藪" "螋" "鄋" "醙" "鎪" "锼" "颼" "飕" "餿" "馊" "騪"))
    ((("s" "u"))("㑉" "㑛" "㓘" "㔄" "㕖" "㜚" "㝛" "㥛" "㨞" "㩋" "㪩" "㬘" "㯈" "㴋" "㴑" "㴼" "䃤" "䅇" "䇤" "䌚" "䎘" "䏋" "䑿" "䔎" "䘻" "䛾" "䥔" "䩳" "俗" "傃" "僳" "嗉" "囌" "塐" "塑" "夙" "嫊" "宿" "愫" "愬" "憟" "栜" "榡" "樕" "橚" "櫯" "殐" "泝" "涑" "溯" "溸" "溹" "潥" "玊" "珟" "璛" "甦" "碿" "稣" "穌" "窣" "簌" "粛" "粟" "素" "縤" "縮" "缩" "肃" "肅" "膆" "苏" "蓿" "蔌" "藗" "蘇" "蘓" "蜶" "觫" "訴" "誎" "謖" "诉" "谡" "趚" "蹜" "速" "遡" "遬" "酥" "鋉" "餗" "驌" "骕" "鱐" "鷫" "鹔"))
    ((("s" "u" "a" "n"))("㔯" "㱹" "匴" "撰" "狻" "痠" "祘" "笇" "筭" "算" "篹" "蒜" "选" "選" "酸"))
    ((("s" "u" "i"))("㒸" "㞸" "㥞" "㴚" "㵦" "㻟" "㻪" "㻽" "䅑" "䅗" "䆳" "䉌" "䍁" "䔹" "䜆" "䜔" "䠔" "䡵" "䢫" "䤭" "䥙" "䭉" "䯝" "䲀" "亗" "倠" "哸" "埣" "夊" "嬘" "尿" "岁" "嵗" "巂" "彗" "攵" "旞" "檅" "檖" "歲" "歳" "毸" "浽" "滖" "澻" "濉" "瀡" "煫" "熣" "燧" "璲" "瓍" "眭" "睟" "睢" "砕" "碎" "祟" "禭" "穂" "穗" "穟" "篲" "粹" "綏" "繀" "繐" "繸" "绥" "膸" "芕" "荽" "荾" "莎" "葰" "蓑" "蔧" "虽" "襚" "誶" "譢" "谇" "賥" "遀" "遂" "遺" "邃" "鐆" "鐩" "队" "隊" "隋" "随" "隧" "隨" "雖" "雟" "靃" "鞖" "髄" "髓"))
    ((("s" "u" "n"))("㔼" "㡄" "㦏" "㰂" "䁚" "䐣" "孙" "孫" "愻" "损" "損" "搎" "栒" "榫" "槂" "潠" "狲" "猻" "笋" "筍" "箰" "簨" "荪" "蓀" "蕵" "薞" "跣" "鎨" "隼" "飡" "飧" "飱" "餐" "鶽"))
    ((("s" "u" "o"))("㪽" "㮦" "䂹" "䅴" "䈗" "䌇" "䐝" "䖛" "䗢" "䞆" "䞽" "䣔" "䵀" "些" "傞" "唆" "唢" "嗍" "嗦" "嗩" "娑" "惢" "所" "挱" "挲" "摍" "摵" "擌" "暛" "桫" "梭" "樎" "沙" "洓" "溑" "溹" "牺" "犧" "獻" "琐" "瑣" "璅" "瘷" "睃" "簑" "簔" "索" "縮" "缩" "羧" "莎" "莏" "蓑" "衰" "褨" "趖" "蹜" "逡" "逤" "鎍" "鎖" "鎻" "鏁" "鏼" "锁" "霍" "髿"))
    ((("t" "a"))("㒓" "㗳" "㛥" "㣛" "㣵" "㧺" "㭼" "㯓" "㳠" "㳫" "㹺" "㺚" "㿹" "䂿" "䈋" "䈳" "䌈" "䍇" "䍝" "䎓" "䑜" "䑽" "䓠" "䜚" "䠅" "䪚" "䳴" "䵬" "䶀" "䶁" "亣" "他" "傝" "嗒" "嚃" "嚺" "塌" "塔" "墖" "她" "它" "崉" "拓" "挞" "搨" "搭" "撻" "榙" "榻" "橽" "毾" "沓" "涾" "溻" "漯" "澾" "濌" "濕" "牠" "狧" "獭" "獺" "祂" "禢" "羍" "荅" "誻" "譶" "趿" "跶" "踏" "蹋" "蹹" "躂" "躢" "达" "迖" "達" "遝" "遢" "鉈" "錔" "鎉" "鑉" "铊" "闒" "闟" "闥" "闼" "阘" "靸" "鞈" "鞜" "鞳" "韃" "鮙" "鰨" "鳎" "龖" "龘"))
    ((("t" "a" "i"))("㑷" "㒗" "㘆" "㙜" "㙵" "㣍" "㥭" "㬃" "㷘" "㸀" "䈚" "䑓" "䢰" "䣭" "儓" "冭" "台" "囼" "坮" "大" "太" "夳" "奤" "嬯" "孡" "忕" "忲" "态" "態" "抬" "擡" "斄" "旲" "曃" "枱" "檯" "汏" "汰" "泰" "溙" "炱" "炲" "燤" "箈" "籉" "肽" "胎" "能" "臺" "舦" "苔" "菭" "薹" "詒" "跆" "邰" "酞" "鈦" "钛" "颱" "駘" "骀" "鮐" "鲐"))
    ((("t" "a" "n"))("㒎" "㛶" "㪔" "㫜" "㲜" "㲭" "㵃" "㵅" "㶒" "㷋" "㺥" "㽎" "㽑" "䀡" "䃪" "䆱" "䉡" "䊤" "䏙" "䐺" "䕊" "䗊" "䜖" "䞡" "䢻" "䦔" "䨢" "倓" "傝" "僋" "儃" "叹" "啴" "嗿" "嘆" "嘽" "嘾" "坍" "坛" "坦" "埮" "墰" "墵" "壇" "壜" "婒" "弹" "彈" "忐" "怹" "惔" "憛" "憳" "憻" "抩" "探" "摊" "撢" "擹" "攤" "昙" "曇" "榃" "橝" "檀" "歎" "毯" "沈" "淡" "湛" "湠" "滩" "漢" "潭" "澹" "灘" "炎" "炭" "璮" "痰" "瘫" "癉" "癱" "眈" "碳" "禪" "禫" "緂" "罈" "罎" "胆" "膻" "舑" "舔" "舕" "舚" "艢" "荨" "菼" "蕁" "蕈" "藫" "蟫" "袒" "襢" "覃" "談" "譚" "譠" "谈" "谭" "貚" "貪" "賧" "贉" "贪" "赕" "郯" "醈" "醓" "醰" "鉭" "錟" "鐔" "钽" "锬" "镡" "餤" "驔" "黮"))
    ((("t" "a" "n" "g"))("㑽" "㒉" "㙶" "㜍" "㦂" "㭻" "㲥" "㼒" "㼺" "㿩" "䅯" "䉎" "䌅" "䕋" "䟖" "䣘" "䧜" "伖" "倘" "偒" "傏" "傥" "儻" "劏" "唐" "啺" "嘡" "坣" "堂" "塘" "帑" "惝" "戃" "挡" "搪" "摚" "摥" "擋" "攩" "曭" "棠" "榶" "樘" "橖" "汤" "淌" "湯" "溏" "漟" "烫" "煻" "燙" "爣" "瑭" "矘" "磄" "禟" "篖" "糃" "糖" "糛" "羰" "耥" "膅" "膛" "蓎" "蕩" "薚" "蝪" "螗" "螳" "赯" "趟" "踼" "蹚" "躺" "逿" "鄌" "醣" "鎕" "鎲" "鏜" "鐋" "鐺" "钂" "铴" "镋" "镗" "閶" "闛" "隚" "餳" "餹" "饄" "鶶" "鼞"))
    ((("t" "a" "o"))("㚐" "㹗" "䄻" "䚯" "䚵" "䛌" "䛬" "䬞" "䱇" "䵚" "匋" "叨" "咷" "啕" "夲" "套" "嫍" "弢" "慆" "挑" "掏" "搯" "桃" "梼" "槄" "檮" "洮" "涛" "淘" "滔" "濤" "焘" "燾" "瑫" "祹" "籌" "絛" "綢" "綯" "縚" "縧" "绦" "绸" "绹" "翢" "萄" "蜪" "裪" "討" "詜" "謟" "讨" "跳" "轁" "迯" "逃" "醄" "鋾" "錭" "陶" "鞀" "鞉" "鞱" "韜" "韬" "飸" "饀" "饕" "駣" "騊" "鼗"))
    ((("t" "e"))("㥂" "㧹" "忑" "忒" "慝" "棏" "特" "犆" "職" "脦" "蚮" "螣" "蟘" "貣" "貸" "贷" "鋱" "铽" "鴏"))
    ((("t" "e" "n" "g"))("䒅" "䕨" "䠮" "䲍" "䲢" "儯" "幐" "滕" "漛" "疼" "籐" "籘" "縢" "腾" "膯" "蕛" "藤" "螣" "誊" "謄" "邆" "駦" "騰" "驣" "鰧" "鼟"))
    ((("t" "i"))("㖒" "㖷" "㗣" "㡗" "㣢" "㬱" "㯩" "䅠" "䈕" "䌡" "䎮" "䔶" "䗖" "䙗" "䚣" "䛱" "䝰" "䞶" "䢰" "䣠" "䣡" "䣽" "䧅" "䨑" "䪆" "䫮" "䬫" "䬾" "䯜" "䱱" "䴘" "䶍" "䶏" "䶑" "体" "俤" "俶" "倜" "偍" "剃" "剔" "厗" "啼" "嗁" "嚏" "嚔" "堤" "媂" "媞" "屉" "屜" "崹" "弟" "悌" "悐" "惕" "惖" "惿" "挮" "掦" "提" "揥" "擿" "替" "梯" "棣" "歒" "殢" "洟" "涕" "漽" "狄" "珶" "瑅" "睇" "睼" "碮" "禔" "禵" "稊" "籊" "綈" "緹" "绨" "缇" "罤" "肆" "苐" "荑" "蕛" "薙" "蝭" "裼" "褅" "褆" "詆" "諦" "謕" "谛" "趧" "趯" "踢" "踶" "蹄" "蹏" "躍" "躰" "軆" "达" "迏" "迖" "逖" "逷" "遆" "達" "適" "醍" "銻" "錫" "鍗" "鐟" "锑" "锡" "隄" "題" "题" "騠" "骵" "體" "髢" "髰" "鬀" "鬄" "鮧" "鮷" "鯷" "鳀" "鵜" "鶗" "鶙" "鷈" "鷉" "鷤" "鹈" "鼶"))
    ((("t" "i" "a" "n"))("㐁" "㑷" "㖭" "㙉" "㤁" "㥏" "㧂" "㧱" "㮇" "㶺" "䄕" "䄹" "䄼" "䄽" "䏦" "䐌" "䑚" "䟧" "䠄" "䡒" "䡘" "䣯" "䣶" "䥖" "䧃" "䩄" "䩞" "佃" "倎" "兲" "唺" "嗔" "塡" "填" "天" "婖" "屇" "忝" "恬" "悿" "掭" "搷" "晪" "栝" "殄" "沗" "沺" "沾" "淟" "添" "湉" "滇" "煔" "瑱" "璳" "甛" "甜" "田" "甸" "町" "畋" "畑" "盷" "睓" "磌" "窴" "紾" "緂" "胋" "腆" "舔" "舚" "苫" "菾" "蚕" "蚦" "蚺" "覥" "觍" "賟" "酟" "鈿" "錪" "鍩" "鎭" "鎮" "钿" "锘" "闐" "阗" "靔" "靝" "靦" "頲" "顛" "颋" "颠" "餂" "鷆" "鷏" "黇"))
    ((("t" "i" "a" "o"))("㑿" "㕮" "㟘" "㩖" "㸠" "䂪" "䎄" "䒒" "䖺" "䟭" "䠷" "䧂" "䩦" "䯾" "䱔" "䳂" "佻" "嬥" "宨" "岧" "岹" "庣" "恌" "挑" "旫" "晀" "朓" "条" "條" "樤" "眺" "祒" "祧" "稠" "窕" "窱" "笤" "粜" "糶" "絩" "聎" "脁" "脩" "芀" "苕" "萔" "蓧" "蓨" "蜩" "覜" "誂" "調" "调" "赵" "超" "趒" "趙" "跳" "踔" "迢" "銚" "鋚" "鎥" "铫" "鞗" "頫" "髫" "鮡" "鯈" "鰷" "鲦" "齠" "龆"))
    ((("t" "i" "e"))("䂿" "䥫" "䩞" "䴴" "䵿" "呫" "帖" "怗" "揲" "沾" "萜" "蛈" "蝶" "貼" "贴" "跕" "鉄" "銕" "鋨" "鐡" "鐵" "铁" "锇" "飻" "餮" "驖" "鴩"))
    ((("t" "i" "n" "g"))("㹶" "㼗" "䅍" "䋼" "䗴" "䦐" "䫖" "䱓" "䵺" "亭" "侹" "停" "厅" "厛" "听" "圢" "婷" "嵉" "庁" "庭" "廰" "廳" "廷" "挺" "朾" "桯" "梃" "楟" "榳" "汀" "涏" "渟" "濎" "烃" "烴" "烶" "珽" "町" "甼" "筳" "綎" "耓" "耵" "聤" "聴" "聼" "聽" "脡" "艇" "艼" "莛" "葶" "蜓" "蝏" "誔" "諪" "邒" "鋌" "铤" "閮" "霆" "鞓" "頲" "颋" "鯅" "鼮"))
    ((("t" "o" "n" "g"))("㛚" "㠉" "㠽" "㣚" "㣠" "㤏" "㪌" "㮔" "㸗" "㼧" "㼿" "䂈" "䆚" "䆹" "䮵" "䳋" "䴀" "䶱" "仝" "佟" "侗" "僮" "勭" "同" "哃" "嗵" "垌" "姛" "峂" "峒" "峝" "庝" "彤" "恫" "恸" "慟" "憅" "捅" "晍" "曈" "朣" "桐" "桶" "樋" "橦" "氃" "洞" "浵" "潼" "炵" "烔" "熥" "燑" "爞" "犝" "狪" "獞" "痌" "痛" "瞳" "砼" "硐" "秱" "穜" "童" "筒" "筩" "粡" "絧" "統" "綂" "统" "罿" "膧" "艟" "茼" "蓪" "蕫" "蘣" "衕" "詷" "赨" "迵" "通" "酮" "重" "鉖" "鉵" "銅" "铜" "餇" "鮦" "鲖" "鼕" "鼨"))
    ((("t" "o" "u"))("㓱" "㕻" "㖣" "㡏" "㢏" "㤟" "㪗" "㳆" "㼥" "䕱" "䞬" "䟝" "䡩" "䱏" "䵉" "亠" "偷" "偸" "匬" "坄" "头" "妵" "婾" "媮" "愉" "投" "斢" "牏" "紏" "綉" "諭" "諳" "透" "逗" "酘" "鈄" "鍮" "钭" "頭" "骰" "黈"))
    ((("t" "u"))("㭸" "㻌" "㻠" "㻬" "㻯" "䅷" "䖘" "䠈" "䣄" "䣝" "䤅" "䩣" "䭭" "䳜" "䴛" "兎" "兔" "凃" "凸" "吐" "唋" "啚" "図" "图" "圖" "圗" "土" "圡" "堍" "堗" "塗" "宊" "屠" "峹" "嵞" "嶀" "庩" "廜" "徒" "怢" "悇" "捈" "捸" "揬" "梌" "涂" "涋" "湥" "潳" "瑹" "痜" "瘏" "禿" "秃" "稌" "突" "筡" "腞" "腯" "芏" "荼" "菟" "葖" "蒤" "跌" "跿" "途" "酴" "釷" "鈯" "鋵" "鍎" "钍" "馟" "駼" "鵌" "鵚" "鵵" "鶟" "鷋" "鷵" "鼵"))
    ((("t" "u" "a" "n"))("㩛" "䊜" "䜝" "䳪" "䵯" "剬" "剸" "团" "団" "團" "彖" "慱" "抟" "揣" "摶" "敦" "槫" "湍" "漙" "煓" "猯" "畽" "疃" "砖" "磚" "稅" "税" "篿" "糰" "褖" "貒" "鏄" "鱄" "鶉" "鷻" "鹑" "黗"))
    ((("t" "u" "i"))("㞂" "㢈" "㢑" "㥆" "㦌" "㰐" "㱣" "㷟" "㾯" "㾼" "㾽" "㿉" "㿗" "䀃" "䅪" "䍾" "䩣" "䫋" "俀" "僓" "墤" "娧" "尵" "弚" "推" "橔" "煺" "稅" "税" "穨" "脫" "腿" "萑" "蓷" "藬" "蘈" "蛻" "褪" "蹆" "蹪" "追" "退" "隤" "頹" "頺" "頽" "颓" "饋" "駾" "骽" "魋"))
    ((("t" "u" "n"))("㖔" "㞘" "㧷" "㩔" "㹠" "㼊" "吞" "呑" "啍" "噋" "囤" "坉" "屯" "忳" "敦" "旽" "暾" "朜" "氽" "沌" "涒" "炖" "焞" "燉" "窀" "純" "纯" "肫" "臀" "臋" "芚" "褪" "訰" "豘" "豚" "軘" "迍" "逐" "霕" "飩" "饨" "魨" "鲀"))
    ((("t" "u" "o"))("㟎" "㯐" "㰐" "㵃" "㸰" "㸱" "㼠" "㾃" "䍫" "䓕" "䡐" "䪑" "䭾" "䰿" "䲊" "䲦" "䴱" "乇" "仛" "佗" "侂" "侻" "咃" "唾" "坨" "堶" "妥" "媠" "嫷" "它" "岮" "庹" "彵" "托" "扡" "扥" "拓" "拕" "拖" "挩" "捝" "摭" "撱" "杔" "柝" "棁" "椭" "楕" "槖" "橐" "橢" "毤" "毻" "汑" "池" "沰" "沱" "沲" "涶" "牠" "狏" "矺" "砖" "砣" "砤" "碢" "磚" "稅" "税" "箨" "籜" "紽" "綏" "绥" "脫" "脱" "舃" "舵" "莌" "萚" "蘀" "蛇" "蟺" "袉" "託" "詑" "說" "説" "讬" "说" "跅" "跎" "軃" "迤" "迱" "酏" "酡" "鉈" "铊" "阤" "陀" "陁" "隋" "鞁" "飥" "饦" "馱" "馲" "駄" "駝" "駞" "騨" "驒" "驝" "驮" "驼" "魄" "魠" "鮀" "鰖" "鱓" "鴕" "鵎" "鸵" "鼉" "鼍" "鼧"))
    ((("w" "a"))("㒝" "㧚" "㰪" "㼘" "䍪" "䎳" "䚴" "䠚" "佤" "凹" "劸" "咓" "哇" "啘" "嗗" "嗢" "娃" "娲" "婠" "媧" "徍" "挖" "搲" "攨" "汙" "汚" "污" "洼" "淴" "溛" "漥" "瓦" "畖" "穵" "窊" "窐" "窪" "聉" "腽" "膃" "蛙" "袜" "襪" "邷" "鞋" "韈" "韤" "鮭" "鲑" "鼃"))
    ((("w" "a" "i"))("㖞" "㨤" "䠿" "呙" "咼" "喎" "外" "懀" "歪"))
    ((("w" "a" "n"))("㜶" "㝃" "㝴" "㸘" "㺜" "㼝" "㽜" "㽹" "㿸" "䂺" "䅋" "䈮" "䏦" "䑱" "䖤" "䗕" "䘼" "䛷" "䝹" "䥑" "䩊" "䯈" "䯛" "䳃" "䵥" "万" "丸" "仴" "倇" "关" "刓" "剜" "卍" "卐" "埦" "夗" "娩" "婉" "婠" "完" "宛" "帵" "弯" "彎" "忨" "惋" "抏" "挽" "捖" "捥" "晚" "晩" "晼" "杬" "梚" "椀" "汍" "浣" "涴" "湾" "潫" "澣" "灣" "烷" "玩" "琓" "琬" "畹" "皖" "盌" "睌" "睕" "碗" "箢" "紈" "綄" "綩" "綰" "纨" "绾" "翫" "脕" "脘" "腕" "芄" "莞" "莧" "莬" "菀" "萖" "萬" "蔓" "薍" "蜿" "蟃" "豌" "貦" "貫" "贎" "贯" "踠" "輐" "輓" "鋄" "鋔" "錽" "鎫" "関" "鞔" "頑" "顽" "魭" "鯇" "鲩"))
    ((("w" "a" "n" "g"))("㓁" "㔞" "㲿" "㳹" "㴏" "䋄" "䋞" "䒽" "䛃" "䤑" "䰣" "亡" "亾" "仼" "兦" "妄" "尢" "尣" "尩" "尪" "尫" "彺" "往" "徃" "忘" "忹" "惘" "方" "旺" "暀" "望" "朢" "枉" "棢" "汪" "瀇" "王" "琞" "皇" "盲" "盳" "網" "网" "罒" "罔" "芒" "莣" "菵" "蚟" "蛧" "蝄" "誷" "輞" "辋" "迋" "迬" "魍"))
    ((("w" "e" "i"))("㕒" "㖐" "㛱" "㞇" "㞑" "㟪" "㟴" "㠕" "㢻" "㣲" "㥜" "㥨" "㦣" "㧑" "㨊" "㨒" "㬙" "㭏" "㱬" "㷉" "㸵" "㺔" "㻰" "㾯" "䃬" "䅏" "䇻" "䈧" "䉠" "䍴" "䍷" "䑊" "䓕" "䓺" "䔺" "䗆" "䗽" "䘙" "䙟" "䙿" "䛪" "䜅" "䜜" "䝐" "䞔" "䡺" "䣀" "䥆" "䥩" "䦱" "䧦" "䩈" "䩞" "䪋" "䪘" "䫥" "䬐" "䬑" "䬿" "䭳" "䮹" "䱞" "䲁" "䲘" "䵋" "䵢" "䵳" "为" "亹" "伟" "伪" "位" "倭" "偉" "偎" "偽" "僞" "儰" "卫" "危" "叞" "味" "唯" "喂" "喡" "喴" "囗" "囲" "围" "圍" "圩" "壝" "委" "威" "娓" "媁" "媙" "媦" "嬒" "寪" "尉" "尾" "峗" "峞" "崣" "崴" "嵔" "嵬" "巍" "帏" "帷" "幃" "廆" "彙" "徫" "微" "徻" "惟" "愄" "愇" "慰" "揋" "斖" "暐" "未" "桅" "梶" "椲" "椳" "楲" "欈" "沩" "洈" "洧" "浘" "涠" "渨" "渭" "湋" "溈" "溦" "溾" "潍" "潙" "潿" "濊" "濰" "濻" "瀢" "炜" "為" "烓" "煒" "煟" "煨" "熨" "熭" "燰" "爲" "犚" "犩" "猗" "猥" "猬" "玮" "琟" "瑋" "畏" "痏" "痿" "癓" "眭" "矀" "硊" "硙" "碨" "磈" "磑" "立" "維" "緭" "緯" "纬" "维" "罻" "胃" "腲" "艉" "芕" "芛" "芟" "苇" "苿" "荱" "荽" "菋" "萎" "葦" "葨" "葳" "蒍" "蓶" "蔚" "蔿" "薇" "薉" "薳" "薶" "藯" "蘤" "蘶" "蜲" "蜼" "蝛" "蝟" "螱" "衛" "衞" "褽" "覣" "覹" "觹" "詴" "諉" "謂" "讆" "讏" "诿" "谓" "贀" "踓" "躗" "躛" "軎" "轊" "违" "逶" "違" "遗" "遺" "鄬" "醀" "錗" "鍏" "鍡" "鏏" "闈" "闱" "阢" "隇" "隈" "隗" "隹" "霨" "霺" "韋" "韑" "韙" "韡" "韦" "韪" "頠" "颹" "餧" "餵" "骩" "骪" "骫" "魏" "鮇" "鮠" "鮪" "鰃" "鰄" "鰖" "鲔" "鳂" "鳚" "鷕"))
    ((("w" "e" "n"))("㒚" "㖧" "㗃" "㝧" "㟩" "㡈" "㳷" "㵮" "㼂" "䎹" "䎽" "䘇" "䦤" "䦷" "䰚" "伆" "刎" "吻" "呡" "問" "塭" "妏" "彣" "愠" "抆" "揾" "搵" "文" "昷" "桽" "歾" "殁" "殟" "汶" "渂" "温" "溫" "炆" "煴" "熓" "玟" "珉" "珳" "琝" "瑥" "璺" "瘒" "瘟" "眼" "瞃" "稳" "穏" "穩" "笏" "紊" "紋" "絻" "纹" "缊" "聞" "肳" "脗" "舋" "芠" "莬" "蕰" "蘊" "蚉" "蚊" "螡" "蟁" "豱" "輼" "轀" "辒" "閿" "闅" "闦" "问" "闻" "阌" "限" "雯" "韞" "馧" "馼" "魰" "鰛" "鰮" "鳁" "鳼" "鴍" "鴖" "鼤"))
    ((("w" "e" "n" "g"))("㘢" "㜲" "䐥" "䤰" "䨴" "勜" "嗡" "塕" "奣" "嵡" "暡" "浻" "滃" "瓮" "甕" "瞈" "罋" "翁" "聬" "蓊" "蕹" "螉" "鎓" "霐" "鶲" "鹟" "齆"))
    ((("w" "o"))("㠗" "㠛" "㦱" "㧴" "㱧" "䀑" "䁊" "䁷" "䂺" "䙠" "䠎" "䩊" "䮸" "䰀" "倭" "偓" "卧" "唩" "喔" "婐" "婑" "幄" "我" "挝" "捰" "捾" "握" "撾" "斡" "果" "楃" "沃" "涡" "涴" "涹" "渥" "渦" "濄" "濣" "焥" "猧" "瘟" "硪" "窝" "窩" "緺" "肟" "臥" "莴" "萵" "蒦" "薶" "蜗" "蝸" "踒" "齷" "龌"))
    ((("w" "u"))("㐅" "㐳" "㑄" "㒇" "㝟" "㡔" "㤇" "㬳" "㱱" "㵲" "㷻" "㹳" "㻍" "㽾" "䀛" "䃖" "䅶" "䉑" "䍢" "䎸" "䑁" "䒉" "䓊" "䚈" "䛩" "䜑" "䟼" "䡧" "䦍" "䦜" "䨁" "䫓" "䮏" "䳇" "䳱" "乌" "五" "亡" "亾" "仵" "伍" "侮" "俉" "倵" "儛" "兀" "剭" "务" "務" "勿" "午" "卼" "吳" "吴" "吾" "呉" "呜" "唔" "啎" "嗚" "噁" "圬" "坞" "垭" "塢" "墲" "奦" "妩" "娒" "娪" "娬" "婺" "媉" "嫵" "寤" "屋" "屼" "岉" "嵍" "嵨" "巫" "庑" "廡" "弙" "忢" "忤" "怃" "恶" "悞" "悟" "悮" "惡" "憮" "戊" "扝" "扤" "捂" "摀" "敄" "於" "无" "旿" "晤" "杇" "杌" "梧" "橆" "歍" "武" "毋" "母" "汙" "汚" "污" "沕" "洖" "洿" "浯" "渥" "溩" "潕" "烏" "焐" "無" "熃" "物" "牾" "玝" "珷" "珸" "瑦" "璑" "甒" "痦" "瞀" "矹" "矻" "碔" "祦" "禑" "窏" "窹" "笏" "箼" "粅" "腛" "膴" "舞" "芜" "芴" "茣" "莁" "蕪" "蘁" "蜈" "蝥" "螐" "誈" "誣" "誤" "诬" "误" "躌" "迕" "逜" "遻" "邬" "郚" "鄔" "鋈" "鋘" "鋙" "鎢" "钨" "铻" "阢" "陓" "隖" "雾" "霚" "霧" "靰" "騖" "骛" "鯃" "鰞" "鴮" "鵐" "鵡" "鷡" "鹀" "鹉" "麌" "鼯" "鼿" "齀" "齬" "兀"))
    ((("x" "i"))("㑶" "㒆" "㔒" "㗲" "㙾" "㚛" "㜎" "㞒" "㠄" "㣟" "㤴" "㤸" "㥡" "㦻" "㩗" "㪪" "㭡" "㱱" "㳀" "㳧" "㵿" "㸍" "㹫" "㽯" "㿇" "䀘" "䈪" "䊠" "䏮" "䐼" "䑂" "䒁" "䓇" "䘮" "䙽" "䚂" "䚉" "䚫" "䚷" "䛥" "䜁" "䜣" "䢄" "䦧" "䧍" "䨳" "䩤" "䫔" "䫣" "䮎" "䲪" "䴛" "䵱" "习" "係" "俙" "傒" "僁" "僖" "兮" "凞" "匸" "卌" "卥" "厀" "吸" "呬" "咥" "唏" "唽" "喜" "喺" "嘶" "嘻" "噏" "嚊" "嚱" "囍" "塈" "墍" "壐" "夕" "奚" "娭" "媐" "媳" "嬆" "嬉" "屃" "屎" "屓" "屖" "屣" "屭" "嵇" "嵠" "嶍" "嶲" "巇" "希" "席" "徆" "徙" "徯" "忚" "忥" "怬" "怷" "怸" "恄" "恓" "息" "悉" "悕" "惁" "惜" "憘" "憙" "戏" "戯" "戱" "戲" "扢" "扱" "扸" "捿" "携" "摡" "撕" "擕" "攜" "攦" "敼" "既" "旣" "昔" "晞" "晢" "晰" "晳" "暿" "曦" "析" "枲" "栖" "桸" "棤" "棲" "椞" "椺" "榽" "槢" "樨" "橀" "檄" "檕" "欯" "欷" "歖" "歙" "氣" "氥" "汐" "洒" "洗" "浠" "淅" "溪" "滊" "漇" "漝" "潝" "潟" "澌" "澙" "濕" "濦" "灑" "烯" "焈" "焟" "焬" "煕" "熂" "熄" "熈" "熙" "熹" "熺" "熻" "燨" "爔" "牺" "犀" "犔" "犧" "狶" "猎" "獡" "獥" "獻" "玺" "琋" "璽" "瓗" "畦" "瘜" "皙" "盻" "睎" "睳" "瞦" "矖" "矽" "硒" "磎" "磶" "禊" "禧" "稀" "稧" "穸" "窸" "簁" "粞" "糦" "系" "細" "綌" "緆" "縘" "縰" "繋" "繥" "繫" "纚" "细" "绤" "羛" "羲" "習" "翕" "翖" "肸" "肹" "脅" "腊" "膝" "舃" "舄" "舾" "茜" "莃" "菥" "葈" "葸" "蒠" "蒵" "蓆" "蓰" "蔇" "蕮" "薂" "虩" "蜥" "蜴" "螅" "螇" "蟋" "蟢" "蠵" "衋" "袭" "裼" "褶" "襲" "襾" "西" "覀" "覡" "覤" "觋" "觹" "觽" "觿" "訢" "誒" "諰" "謑" "謚" "謵" "譆" "诶" "谿" "豀" "豨" "豯" "貕" "赥" "赩" "赫" "趘" "蹊" "蹝" "躧" "遟" "遲" "郄" "郋" "郗" "郤" "鄎" "酅" "酾" "醯" "釃" "釐" "釳" "釸" "鉨" "鉩" "銑" "錫" "錯" "鎎" "鎴" "鏭" "鑴" "钖" "铣" "锡" "闟" "阋" "隙" "隟" "隰" "隵" "雟" "霫" "霼" "飁" "餼" "饎" "饩" "騱" "騽" "驨" "鬩" "鰓" "鰼" "鱚" "鳃" "鳛" "鵗" "鸂" "黊" "黖" "鼷" "齂" "凞"))
    ((("x" "i" "a"))("㗇" "㗿" "㘡" "㙈" "㙤" "㥦" "㭱" "㰺" "㵤" "㽠" "㿣" "䒠" "䒩" "䖎" "䖖" "䘥" "䛅" "䦖" "䨐" "䪗" "䫗" "䯟" "䶝" "丅" "下" "侠" "俠" "假" "傄" "冾" "匣" "厦" "叚" "吓" "呷" "嚇" "夏" "夓" "峡" "峽" "廈" "懗" "押" "挟" "挾" "搳" "敮" "斜" "昰" "暇" "柙" "欱" "歃" "毳" "洽" "炠" "烚" "煆" "煵" "狎" "狭" "狹" "珨" "瑕" "疜" "疨" "瘕" "睱" "瞎" "硖" "硤" "碬" "磍" "祫" "笚" "筪" "給" "縀" "縖" "罅" "翈" "舝" "舺" "芐" "葭" "蕸" "虾" "蝦" "諕" "譹" "谺" "赮" "轄" "辖" "遐" "鍜" "鎋" "鏬" "閕" "閜" "陜" "陿" "霅" "霞" "颬" "騢" "魻" "鰕" "鶷" "黠"))
    ((("x" "i" "a" "n"))("㔓" "㔵" "㘅" "㘋" "㛾" "㜪" "㜷" "㡉" "㡾" "㢺" "㥦" "㦑" "㦓" "㦥" "㧋" "㧥" "㩈" "㩮" "㪇" "㫫" "㬎" "㬗" "㭠" "㭹" "㮭" "㯀" "㯗" "㯠" "㱹" "㲽" "㳄" "㳭" "㵪" "㶍" "㺌" "㽉" "㿅" "䀏" "䁂" "䃱" "䃸" "䄯" "䇒" "䉯" "䉳" "䏹" "䐄" "䒸" "䕔" "䗾" "䘆" "䙹" "䚚" "䜢" "䝨" "䞁" "䡅" "䢾" "䤼" "䥪" "䦘" "䦥" "䧋" "䧟" "䧮" "䨘" "䨷" "䱤" "䲗" "䵇" "䵖" "䵛" "䶟" "䶠" "䶢" "仙" "仚" "伣" "俔" "僊" "僩" "僴" "先" "冼" "县" "咞" "咸" "哯" "唌" "啣" "嗛" "嘕" "垷" "塪" "奾" "姭" "姺" "娊" "娴" "娹" "婱" "嫌" "嫺" "嫻" "嬐" "孅" "宪" "尟" "尠" "屳" "岘" "峴" "崄" "嶮" "幰" "廯" "弦" "彡" "忺" "憪" "憲" "憸" "挦" "掀" "掺" "搟" "摻" "撊" "撏" "攇" "攕" "显" "晅" "晛" "暹" "杴" "枮" "橌" "檻" "櫶" "毨" "氙" "洒" "洗" "涀" "涎" "澖" "濂" "瀗" "灑" "灦" "烍" "燅" "燹" "狝" "猃" "献" "獫" "獮" "獻" "玁" "现" "珗" "現" "甉" "痃" "痫" "癇" "癎" "癣" "癬" "省" "県" "睍" "瞯" "瞷" "矣" "碱" "礆" "礥" "祅" "祆" "禒" "禰" "秈" "筅" "箲" "籼" "粯" "糮" "絃" "絤" "綅" "綫" "線" "縣" "纎" "纖" "纤" "线" "缐" "羡" "羨" "羬" "肩" "胘" "脅" "腺" "臔" "臽" "舷" "苋" "苮" "莧" "莶" "葴" "蓒" "薟" "藓" "藖" "蘐" "蘚" "蘞" "蚬" "蚿" "蛝" "蜆" "螊" "衔" "衘" "袨" "褼" "襳" "見" "覸" "见" "訮" "誢" "諴" "豏" "賢" "贒" "贤" "赻" "跣" "跹" "蹮" "躚" "軐" "軒" "輱" "轞" "酰" "釤" "銑" "銛" "銜" "鋧" "錎" "錟" "鍁" "鍌" "鏾" "钐" "铣" "铦" "锨" "锬" "閑" "閒" "闞" "闲" "限" "陥" "险" "陷" "険" "險" "霰" "韅" "韯" "韱" "顕" "顯" "餡" "馅" "馦" "鮮" "鱻" "鲜" "鶱" "鷳" "鷴" "鷼" "鹇" "鹹" "麲" "黹" "鼸" "齴" "𠜎"))
    ((("x" "i" "a" "n" "g"))("㗽" "㟄" "㟟" "䇨" "䊑" "䐟" "䒂" "䔗" "䖮" "䙹" "䛠" "䜶" "䢽" "䣈" "䤔" "䦳" "䴂" "乡" "亨" "享" "亯" "佭" "像" "勷" "厢" "向" "响" "啌" "嚮" "塂" "奛" "嶑" "巷" "庠" "廂" "忀" "恦" "想" "晑" "曏" "栙" "样" "樣" "橡" "欀" "洋" "湘" "珦" "瓖" "相" "祥" "箱" "絴" "緗" "纕" "缃" "缿" "翔" "膷" "舡" "芗" "萫" "葙" "薌" "蚃" "蟓" "蠁" "襄" "襐" "詳" "详" "象" "跭" "郷" "鄉" "鄊" "鄕" "銗" "鐌" "鑲" "镶" "闀" "闂" "降" "響" "項" "项" "飨" "餉" "饗" "饟" "饷" "香" "驤" "骧" "鮝" "鯗" "鱌" "鱶" "鲞" "麘" "祥"))
    ((("x" "i" "a" "o"))("㑾" "㒆" "㔅" "㗛" "㚣" "㤊" "㩭" "㬵" "㹲" "䇃" "䊥" "䒁" "䒕" "䒝" "䕧" "䠛" "䥵" "䴛" "俲" "傚" "削" "効" "呺" "咲" "哓" "哮" "啋" "啸" "嗃" "嘋" "嘐" "嘨" "嘯" "嘵" "嚣" "嚻" "囂" "姣" "娎" "婋" "孝" "宯" "宵" "小" "庨" "彇" "恔" "憢" "揱" "撨" "效" "敩" "斅" "斆" "晓" "暁" "曉" "枭" "枵" "校" "梟" "梢" "櫹" "歊" "歗" "殽" "毊" "洨" "消" "涍" "淆" "潇" "潚" "澩" "瀟" "灱" "灲" "烋" "焇" "熽" "爻" "狡" "猇" "獟" "獢" "痚" "痟" "皛" "皢" "硝" "硣" "穘" "窙" "笅" "笑" "筱" "筿" "箫" "箾" "篠" "簘" "簫" "絞" "綃" "绡" "翛" "肖" "胶" "膮" "芍" "茭" "萧" "萷" "蕭" "藃" "藠" "虈" "虓" "蛸" "蟏" "蟰" "蠨" "訤" "誟" "誵" "謏" "謞" "踃" "較" "逍" "郩" "酵" "銷" "销" "霄" "鞩" "騷" "驍" "驕" "骁" "骄" "骹" "髇" "髐" "魈" "鮹" "鴞" "鸮"))
    ((("x" "i" "e"))("㒠" "㓔" "㔎" "㕐" "㖑" "㖿" "㙝" "㙰" "㚗" "㜦" "㝍" "㞒" "㞕" "㢵" "㣯" "㣰" "㥟" "㦪" "㨒" "㨙" "㨝" "㩉" "㩗" "㩦" "㩪" "㭨" "㰔" "㰡" "㳦" "㳿" "㴬" "㴮" "㴽" "㷎" "㸉" "㽊" "㽳" "䀘" "䁯" "䇋" "䉏" "䉣" "䊝" "䍖" "䏮" "䔑" "䕈" "䕵" "䙊" "䙎" "䙝" "䙽" "䚳" "䚸" "䞕" "䡡" "䢡" "䥱" "䥾" "䦏" "䦑" "䦖" "䩤" "䩧" "䪥" "䬅" "䭎" "䲒" "䵦" "些" "亵" "伳" "偕" "偰" "写" "冩" "劦" "勰" "协" "協" "卨" "卸" "叶" "嗋" "垥" "塮" "奊" "契" "妎" "娎" "媟" "寫" "屑" "屟" "屧" "嶰" "廨" "徢" "恊" "愶" "慀" "懈" "拹" "挟" "挾" "揳" "搚" "携" "撷" "擑" "擕" "擷" "攜" "斜" "斺" "旪" "暬" "桔" "械" "楔" "榍" "榭" "檞" "歇" "歙" "汁" "泄" "泻" "洩" "渫" "溉" "潰" "澥" "瀉" "瀣" "灺" "炧" "焎" "熁" "燮" "燲" "爕" "猲" "獬" "疶" "眭" "祄" "禼" "籺" "糏" "紲" "絏" "絜" "絬" "綊" "緤" "緳" "纈" "绁" "缬" "缷" "翓" "耶" "胁" "脅" "脇" "脥" "膎" "苴" "葉" "薛" "薢" "薤" "藛" "蝎" "蝢" "蟹" "蠍" "蠏" "血" "衸" "衺" "褉" "褻" "襭" "觟" "解" "諜" "諧" "謝" "谐" "谢" "跬" "躞" "躠" "迦" "邂" "邪" "鋣" "隰" "靾" "鞋" "鞢" "鞵" "韰" "頁" "頡" "颉" "駴" "骱" "鮭" "鲑" "齘" "齥" "龤"))
    ((("x" "i" "n"))("㐰" "㚯" "㛛" "㜦" "㩪" "㭄" "㭡" "㹷" "㻸" "䎣" "䒖" "䚱" "䛨" "䜗" "䜣" "䪿" "䰼" "亲" "伈" "伩" "信" "俽" "兓" "卂" "噷" "囟" "妡" "孞" "寻" "尋" "廞" "心" "忻" "惞" "攳" "新" "昕" "杺" "桪" "樳" "欣" "款" "歆" "炘" "焮" "煡" "盺" "脪" "舋" "芯" "莘" "薪" "衅" "襑" "親" "訢" "訫" "軐" "辛" "鄩" "釁" "鈊" "鋅" "鐔" "鑫" "锌" "镡" "阠" "顖" "馨" "馸" "騂" "骍" "鬵"))
    ((("x" "i" "n" "g"))("㐩" "㒷" "㓑" "㓝" "㝭" "㣜" "㨘" "㬐" "㮐" "㴆" "㼛" "㼬" "䁄" "䂔" "䋲" "䓷" "䛭" "䣆" "䤯" "䮍" "䰢" "䳙" "侀" "倖" "兴" "刑" "坓" "型" "垶" "姓" "娙" "婞" "嬹" "幸" "形" "性" "悻" "惺" "擤" "星" "曐" "杏" "桯" "洐" "涬" "渻" "滎" "濴" "烆" "煋" "熒" "狌" "猩" "瑆" "皨" "省" "睲" "研" "硎" "筕" "箵" "篂" "緈" "胻" "腥" "臖" "興" "荇" "莕" "蛵" "行" "觪" "觲" "邢" "郉" "醒" "鈃" "鉶" "銒" "鋞" "鍟" "钘" "铏" "陉" "陘" "雽" "餳" "饧" "馨" "馫" "鮏" "鯹"))
    ((("x" "i" "o" "n" "g"))("䎿" "䧺" "兄" "兇" "凶" "匈" "哅" "夐" "忷" "恟" "敻" "汹" "洶" "熊" "胷" "胸" "能" "芎" "訩" "詗" "詾" "讻" "诇" "賯" "赨" "雄"))
    ((("x" "i" "u"))("㗜" "㩰" "㱙" "㾋" "䜬" "休" "俢" "修" "咻" "嗅" "嘼" "宿" "岫" "峀" "庥" "朽" "樇" "溴" "滫" "烋" "烌" "煦" "珛" "琇" "秀" "糔" "綇" "綉" "繍" "繡" "绣" "羞" "脩" "臭" "臹" "茠" "莠" "蓚" "袖" "褎" "褏" "貅" "銝" "銹" "鎀" "鏅" "鏥" "鏽" "锈" "飍" "饈" "馐" "髤" "髹" "鵂" "鸺" "齅"))
    ((("x" "u"))("㐨" "㑔" "㑯" "㒷" "㕛" "㖅" "㗵" "㘧" "㚜" "㜅" "㜿" "㞊" "㞰" "㤢" "㥠" "㦌" "㦽" "㰲" "㵰" "㷦" "㺷" "㽳" "㾥" "䂆" "䂸" "䅡" "䋶" "䍱" "䔓" "䘏" "䙒" "䛙" "䜡" "䢕" "䣱" "䣴" "䦗" "䦽" "䧁" "䨆" "䬔" "䱛" "䳳" "于" "伵" "余" "侐" "俆" "偦" "冔" "勖" "勗" "卹" "叙" "吁" "呴" "呼" "咻" "喣" "嘘" "噓" "圩" "垿" "墟" "壻" "姁" "婿" "媭" "嬃" "嬬" "屿" "嶼" "幁" "序" "徐" "怴" "恤" "慉" "戌" "掝" "揟" "敍" "敘" "旭" "旮" "旯" "旴" "昫" "晇" "朂" "栩" "楈" "槒" "欨" "欰" "欻" "歔" "歘" "殈" "汿" "沀" "洫" "淢" "湑" "溆" "滀" "滸" "漵" "潊" "烅" "煦" "獝" "珝" "珬" "畜" "疞" "盢" "盨" "盱" "瞁" "瞲" "矞" "砉" "祤" "稰" "稸" "窢" "籲" "糈" "絮" "緒" "緖" "縃" "繻" "續" "绪" "续" "聟" "肷" "胥" "芋" "芌" "芧" "蒣" "蓄" "蓲" "蓿" "蔬" "蕦" "藇" "藚" "虗" "虚" "虛" "蝑" "規" "訏" "許" "訹" "詡" "諝" "謳" "譃" "许" "诩" "谞" "豫" "賉" "邪" "鄦" "酗" "醑" "鉏" "銊" "鑐" "雩" "需" "須" "頊" "须" "顼" "馘" "驉" "鬚" "魆" "魖" "魣" "鱮"))
    ((("x" "u" "a" "n"))("㒸" "㔯" "㔵" "㘣" "㛐" "㜗" "㦏" "㧋" "㧦" "㯀" "㳙" "㳬" "㹡" "㾌" "㿅" "䁢" "䍗" "䍻" "䗠" "䘩" "䝮" "䠣" "䥧" "䧎" "䧟" "䩙" "䩰" "䮄" "䲂" "䲻" "䴉" "䴋" "伭" "佡" "儇" "县" "吅" "咺" "喛" "喧" "埍" "埙" "塇" "塤" "壎" "妶" "媗" "嫙" "宣" "弲" "怰" "悬" "愃" "愋" "懁" "懸" "揎" "撰" "擐" "旋" "昍" "昡" "晅" "暄" "暅" "暖" "暶" "梋" "楥" "楦" "檈" "泫" "洵" "涓" "渲" "漩" "潠" "炫" "烜" "煊" "煖" "玄" "玆" "玹" "珣" "琁" "琄" "瑄" "璇" "璿" "瓊" "癣" "癬" "盤" "盷" "眩" "眴" "睻" "矎" "碹" "禤" "籑" "絢" "絹" "縣" "縼" "繏" "绚" "翧" "翾" "萱" "萲" "蔙" "蕿" "藼" "蘐" "蜁" "蜎" "蝖" "蠉" "衒" "袨" "誸" "諠" "諼" "譞" "讂" "讙" "谖" "贙" "軒" "轩" "还" "选" "選" "還" "鉉" "鋗" "鍹" "鏇" "铉" "镟" "鞙" "颴" "饌" "馔" "駽" "鶱" "鹮"))
    ((("x" "u" "e"))("㔧" "㖸" "㙾" "㞽" "㡜" "㦜" "㧒" "㰒" "㶅" "㷤" "㿱" "䀜" "䋉" "䎀" "䒸" "䖼" "䛎" "䜡" "䠼" "䤕" "䨮" "䩈" "䫻" "䫼" "䬂" "䭥" "䱑" "乴" "削" "吙" "吷" "噱" "坹" "学" "學" "屵" "岤" "峃" "嶨" "斈" "桖" "泬" "泶" "澩" "炔" "烕" "燢" "狘" "瞲" "矆" "穴" "茓" "蒆" "薛" "血" "觷" "謔" "謞" "谑" "趐" "踅" "辥" "雤" "雪" "靴" "鞾" "駥" "鱈" "鳕" "鷽" "鸴" "𥄴"))
    ((("x" "u" "n"))("㚯" "㜄" "㝁" "㟧" "㡄" "㢲" "㨚" "㯠" "㰊" "㰬" "㵌" "㽦" "䃀" "䋸" "䖲" "䘩" "䙉" "䛜" "䞊" "䡅" "䭀" "伨" "侚" "偱" "勋" "勛" "勲" "勳" "噀" "噚" "坃" "埈" "埙" "塤" "壎" "壦" "奞" "孙" "孫" "寻" "尋" "峋" "巡" "巺" "巽" "廵" "徇" "循" "恂" "愻" "挦" "撏" "旬" "曛" "杊" "枔" "栒" "桪" "梭" "槆" "橁" "殉" "毥" "汛" "洒" "洵" "浔" "浚" "潃" "潭" "潯" "灥" "焄" "煇" "熏" "燂" "燅" "燖" "燻" "爋" "爓" "狥" "狻" "獯" "珣" "璕" "畃" "矄" "窨" "紃" "絢" "纁" "臐" "荀" "荤" "荨" "葷" "蔒" "蕁" "蕈" "薫" "薰" "蘍" "蟫" "蟳" "訊" "訓" "訙" "詢" "训" "讯" "询" "賐" "迅" "迿" "逊" "逡" "遁" "遜" "郇" "鄩" "醺" "鑂" "鑫" "陖" "韗" "顨" "馴" "駨" "驯" "鱏" "鱘" "鲟" "鵔" "鵕"))
    ((("y" "a"))("㝞" "㝦" "㤉" "㧎" "㮞" "㰳" "㼤" "㿿" "䂒" "䄰" "䅉" "䊦" "䍓" "䒁" "䖌" "䝟" "䢝" "䦪" "䧅" "䨙" "䪵" "䫖" "䯉" "䰲" "䵝" "丫" "亚" "亜" "亞" "伢" "俹" "劜" "厊" "压" "厌" "厓" "厭" "呀" "哑" "唖" "啞" "嚈" "圠" "圧" "垭" "埡" "堐" "壓" "娅" "婭" "孲" "岈" "崕" "崖" "庌" "庘" "御" "押" "挜" "掗" "揠" "枒" "柙" "桠" "椏" "歇" "氩" "氬" "浥" "涯" "漄" "牙" "犽" "猒" "猚" "猰" "玡" "琊" "疋" "痖" "瘂" "睚" "砑" "碣" "稏" "窫" "笌" "聐" "芽" "蕥" "蚜" "衙" "襾" "訝" "讶" "軋" "輅" "轧" "辂" "迓" "邪" "錏" "鐚" "铔" "閘" "雃" "雅" "顏" "顔" "鴉" "鴨" "鵪" "鵶" "鶕" "鸦" "鸭" "齖" "齾"))
    ((("y" "a" "i"))("厓" "崕" "崖" "睚"))
    ((("y" "a" "n"))("㒆" "㓧" "㕣" "㗴" "㘖" "㘙" "㚧" "㛪" "㡉" "㢂" "㢛" "㦔" "㫃" "㫟" "㬫" "㭺" "㰽" "㱌" "㱘" "㳂" "㶄" "㷔" "㷳" "㷼" "㺂" "㺗" "㿕" "㿼" "䀋" "䀽" "䁙" "䂩" "䂴" "䄋" "䅧" "䅬" "䇾" "䉷" "䊙" "䊻" "䌠" "䌪" "䍾" "䎦" "䑍" "䓂" "䕾" "䖗" "䗡" "䗺" "䘶" "䛳" "䜩" "䞁" "䢥" "䢭" "䣍" "䤷" "䦧" "䦲" "䨄" "䫡" "䭘" "䮗" "䱲" "䲓" "䳛" "䳺" "䴏" "䶫" "䶮" "严" "乵" "俨" "偃" "偐" "偣" "傿" "儼" "兖" "兗" "剡" "剦" "匽" "厌" "厣" "厭" "厳" "厴" "咽" "唁" "唌" "啱" "喭" "噞" "嚥" "嚴" "埏" "堰" "塩" "墕" "壛" "壧" "夵" "奄" "妍" "妟" "姲" "姶" "姸" "娫" "娮" "婩" "嫣" "嬊" "嬮" "嬿" "孍" "宴" "岩" "崦" "嵃" "嵒" "嵓" "嶖" "巌" "巖" "巗" "巘" "巚" "广" "延" "弇" "彥" "彦" "恹" "愝" "懕" "懨" "戭" "扊" "抁" "掞" "掩" "揅" "揜" "敥" "昖" "晏" "晻" "暥" "曣" "曮" "棪" "椻" "椼" "楌" "檐" "檿" "櫩" "歅" "殷" "氤" "沇" "沿" "洇" "涎" "淡" "淫" "淹" "渰" "渷" "湮" "湺" "滛" "滟" "演" "漹" "灎" "灔" "灧" "灩" "炎" "烟" "烻" "焉" "焔" "焰" "焱" "煙" "燄" "燕" "爓" "牪" "狠" "狿" "猒" "珚" "琂" "琰" "甗" "癌" "盐" "眼" "研" "砚" "硎" "硏" "硯" "硽" "碞" "礹" "筵" "篶" "簷" "綖" "縯" "罨" "羡" "羨" "胭" "腌" "臙" "艳" "艶" "艷" "芫" "莚" "菸" "萒" "葕" "蔅" "蔫" "薟" "虤" "蜒" "蝘" "衍" "裺" "褗" "覃" "覎" "觃" "觾" "言" "詽" "諺" "讌" "讞" "讠" "谚" "谳" "豓" "豔" "豣" "贋" "贗" "赝" "趼" "躽" "這" "遃" "郔" "郾" "鄢" "酀" "酓" "酽" "醃" "醼" "釅" "鈆" "鉛" "鋋" "錟" "铅" "閆" "閹" "閻" "閼" "闇" "闫" "阉" "阎" "阏" "阽" "险" "隁" "隒" "險" "雁" "靨" "顃" "顏" "顔" "顩" "颜" "餍" "饜" "騐" "験" "騴" "驗" "驠" "验" "魇" "魘" "鮟" "鰋" "鳫" "鴈" "鴳" "鵪" "鶠" "鷃" "鷰" "鹌" "鹽" "麙" "麣" "黡" "黤" "黫" "黭" "黶" "鼴" "鼹" "齞" "齴" "龑"))
    ((("y" "a" "n" "g"))("㔦" "㟅" "㦹" "㨾" "㬕" "㺊" "㿮" "䁑" "䇦" "䍩" "䑆" "䒋" "䖹" "䞁" "䬗" "䬬" "䬺" "䭐" "䭥" "䵮" "仰" "佒" "佯" "傟" "养" "劷" "勨" "卬" "咉" "坱" "垟" "央" "姎" "岟" "崵" "徉" "怏" "恙" "慃" "懩" "扬" "抰" "揚" "攁" "敭" "旸" "昜" "暘" "杨" "柍" "样" "楊" "様" "樣" "殃" "氧" "氱" "汤" "泱" "洋" "湯" "漾" "瀁" "炀" "炴" "烊" "煬" "玚" "珜" "瑒" "疡" "痒" "瘍" "癢" "眏" "眻" "禓" "秧" "紻" "羊" "羏" "羕" "胦" "英" "蛘" "蝆" "詇" "詳" "諹" "详" "軮" "輰" "鉠" "鍚" "鐊" "阦" "阳" "陽" "霷" "鞅" "颺" "飏" "飬" "養" "餋" "駚" "鰑" "鴦" "鸉" "鸯"))
    ((("y" "a" "o"))("㑸" "㑾" "㓞" "㔽" "㝔" "㞁" "㟱" "㢓" "㤊" "㨱" "㫏" "㫐" "㬭" "㮁" "㴭" "㵸" "㺒" "㿑" "㿢" "䁏" "䁘" "䂚" "䆙" "䆞" "䉰" "䋂" "䋤" "䌊" "䌛" "䍃" "䑬" "䒒" "䔄" "䖴" "䙅" "䚆" "䚺" "䚻" "䠛" "䢣" "䬙" "䭥" "䯚" "䳬" "䴠" "䶧" "么" "乐" "仸" "倄" "偠" "傜" "儌" "吆" "咬" "喓" "嗂" "垚" "堯" "夭" "妖" "姚" "婹" "媱" "宎" "尧" "尭" "岆" "峣" "崤" "崾" "嶢" "嶤" "幺" "幼" "徭" "徼" "愮" "抭" "揺" "搖" "摇" "暚" "曜" "杳" "枖" "柼" "楆" "榚" "榣" "樂" "殀" "殽" "洮" "淆" "淫" "溔" "滛" "瀹" "烑" "熎" "燿" "爻" "猇" "猶" "猺" "獟" "珧" "瑤" "瑶" "由" "疟" "瘧" "眑" "瞭" "矅" "祆" "穾" "窅" "窈" "窑" "窔" "窕" "窯" "窰" "筄" "約" "繇" "耀" "肴" "腰" "舀" "艞" "苭" "荛" "药" "葯" "葽" "蓔" "蕘" "薬" "藥" "蘨" "袎" "要" "覞" "訞" "謠" "謡" "讑" "谣" "趭" "軺" "轺" "遙" "遥" "邀" "邎" "銚" "鎐" "鑰" "钥" "铫" "闄" "陶" "隃" "靿" "颻" "飖" "餆" "餚" "騕" "驁" "鰩" "鳐" "鷂" "鷕" "鹞" "鼼" "齩"))
    ((("y" "e"))("㐖" "㖡" "㖶" "㗼" "㙒" "㙪" "㜇" "㝣" "㡋" "㥷" "㩎" "㩪" "㪑" "㭨" "㱉" "㱌" "㴸" "㷸" "㸣" "㽢" "䅬" "䈎" "䊦" "䎨" "䓉" "䔑" "䖣" "䝟" "䤳" "䤶" "䥟" "䥡" "䥺" "䧨" "䭎" "䭟" "䲜" "䳖" "䴾" "业" "也" "亱" "倻" "偞" "僷" "冶" "叶" "吔" "咽" "啘" "嘢" "噎" "埜" "堨" "墷" "壄" "夜" "射" "峫" "嶪" "嶫" "忦" "抴" "拽" "捓" "掖" "揲" "揶" "擖" "擛" "擨" "擪" "擫" "斜" "晔" "暍" "曄" "曅" "曗" "曳" "曵" "枼" "枽" "椰" "楪" "業" "殗" "殜" "洇" "液" "漜" "澲" "烨" "煠" "燁" "爗" "爷" "爺" "琊" "瑘" "皣" "瞱" "瞸" "耶" "聶" "腋" "荼" "葉" "蠮" "謁" "譺" "谒" "邪" "邺" "鄴" "野" "釾" "鋣" "鍱" "鎁" "鎑" "鐷" "铘" "閼" "靥" "靨" "頁" "页" "餘" "餣" "饁" "馌" "驜" "鵺" "鸈"))
    ((("y" "i"))("㐌" "㐹" "㑊" "㑜" "㑥" "㓷" "㔎" "㔕" "㔭" "㔴" "㕈" "㕥" "㖂" "㘁" "㘈" "㘊" "㙠" "㙪" "㙯" "㚤" "㚦" "㛕" "㛳" "㜋" "㜒" "㝖" "㝣" "㞔" "㞾" "㠖" "㠯" "㡫" "㡼" "㢞" "㣂" "㣇" "㣻" "㥴" "㥷" "㦉" "㦤" "㦾" "㩘" "㫊" "㰘" "㰝" "㰻" "㱅" "㱯" "㱲" "㲲" "㲼" "㳑" "㴁" "㴒" "㴔" "㵝" "㵩" "㵫" "㶠" "㸣" "㹑" "㹓" "㹫" "㹭" "㺿" "㼢" "㽈" "㾨" "䁆" "䂽" "䃞" "䄁" "䄩" "䄬" "䄿" "䆿" "䇣" "䇩" "䇵" "䇼" "䉨" "䋚" "䋵" "䌻" "䎈" "䏌" "䐅" "䐖" "䐙" "䑄" "䑛" "䓃" "䓈" "䓹" "䔇" "䔟" "䔬" "䕍" "䕥" "䖁" "䖊" "䖌" "䗑" "䗟" "䗷" "䘝" "䘸" "䚷" "䛖" "䝘" "䝝" "䝯" "䞅" "䢃" "䣡" "䣧" "䣱" "䤭" "䦴" "䧅" "䧇" "䧝" "䧧" "䩟" "䬁" "䬥" "䬮" "䭂" "䭇" "䭞" "䭲" "䭿" "䮊" "䯆" "䰙" "䰯" "䱈" "䱌" "䱒" "䲑" "䳬" "䴊" "䴬" "䵝" "一" "乁" "乂" "义" "乙" "亄" "亦" "亿" "仡" "以" "仪" "伇" "伊" "伿" "佁" "佚" "佾" "侇" "依" "俋" "倚" "偯" "儀" "億" "兿" "冝" "凒" "刈" "劓" "劮" "勚" "勩" "匜" "医" "台" "吚" "呓" "呭" "呹" "咦" "咿" "唈" "嗌" "噫" "囈" "圛" "圯" "垼" "埶" "埸" "墿" "壱" "壹" "夁" "夷" "奕" "姨" "嫕" "嫛" "嬑" "嬟" "宐" "宜" "宧" "寱" "寲" "射" "尾" "屹" "峄" "峓" "崺" "嶧" "嶬" "嶷" "已" "巸" "帟" "帠" "幆" "庡" "廙" "异" "弈" "弋" "弌" "弬" "彛" "彜" "彝" "彞" "役" "忆" "忔" "怈" "怡" "怿" "恞" "悒" "悘" "悥" "意" "憶" "懌" "懿" "扅" "扆" "扡" "抑" "抴" "拸" "挹" "捙" "掖" "掜" "揖" "撎" "攲" "攺" "敡" "斁" "施" "旑" "旖" "易" "昱" "昳" "晲" "晹" "暆" "曀" "曎" "曳" "杙" "杝" "枍" "枱" "枻" "柂" "栘" "栧" "桋" "棭" "椅" "椸" "榏" "槷" "檍" "檥" "檹" "欭" "欹" "歋" "歝" "殔" "殪" "殹" "毅" "毉" "汉" "汽" "沂" "沶" "治" "泄" "泆" "泽" "洂" "洟" "洢" "洫" "浂" "浥" "浳" "液" "渫" "湙" "溢" "溰" "漪" "潩" "澤" "澺" "瀷" "炈" "焈" "焉" "焱" "焲" "熙" "熠" "熤" "熪" "熼" "燚" "燡" "燱" "犄" "狋" "猗" "獈" "玴" "珆" "瑿" "瓵" "異" "疑" "疙" "疫" "痍" "痬" "瘗" "瘞" "瘱" "癔" "益" "眙" "眤" "眱" "睪" "瞖" "矣" "硪" "礒" "祎" "禕" "秇" "移" "稦" "穓" "竩" "笖" "簃" "紲" "絏" "維" "綺" "緆" "縊" "繄" "繶" "繹" "绁" "绎" "缢" "羛" "羠" "羡" "羨" "義" "羿" "翊" "翌" "翳" "翼" "肄" "肊" "肔" "胣" "胰" "腋" "膉" "臆" "臺" "舣" "艗" "艤" "艺" "艾" "芅" "芸" "苅" "苐" "苡" "苢" "荑" "萓" "蓺" "薏" "藙" "藝" "蘙" "虉" "虒" "虵" "蚁" "蛇" "蛜" "蛡" "蛦" "蛾" "蜴" "螔" "螘" "螠" "蟻" "衣" "衪" "袂" "袘" "袣" "袲" "裔" "裛" "褹" "襼" "觺" "訑" "訲" "訳" "詍" "詒" "詣" "誃" "誒" "誼" "謚" "謻" "譩" "譯" "議" "讉" "讛" "议" "译" "诒" "诣" "谊" "豙" "豛" "豷" "貤" "貽" "贻" "跇" "跠" "踦" "軼" "輢" "轙" "轶" "迆" "迤" "迻" "逘" "逸" "遗" "遺" "邑" "郼" "酏" "醫" "醳" "醷" "释" "釋" "釔" "釴" "鈠" "鈶" "鉇" "鉈" "鉯" "銕" "銥" "錡" "鎰" "鏔" "鐿" "钇" "铱" "锜" "镒" "镱" "阝" "阣" "阤" "陁" "陭" "隶" "隿" "雉" "霬" "靾" "鞥" "頉" "頤" "顊" "顗" "顡" "颐" "食" "飴" "餏" "饐" "饴" "饻" "駅" "驛" "驿" "骮" "鮧" "鮨" "鯣" "鳦" "鴺" "鶂" "鶃" "鷁" "鷊" "鷖" "鷧" "鷾" "鸃" "鹝" "鹢" "鹥" "黓" "黝" "黟" "黳" "齮" "齸" "益" "逸" "𣘦" "𥜥"))
    ((("y" "i" "n"))("㐆" "㕂" "㖗" "㗃" "㙬" "㝖" "㝙" "㞤" "㡥" "㣧" "㥯" "㥲" "㥼" "㦩" "㧈" "㪦" "㱃" "㴈" "㴽" "㸒" "㸧" "㹜" "㹞" "㼉" "㾙" "䇙" "䌠" "䌥" "䒡" "䓄" "䕃" "䕾" "䖐" "䖜" "䗞" "䚿" "䜣" "䠴" "䡛" "䡨" "䤃" "䤺" "䨙" "䨸" "䪩" "䲟" "䴛" "䴦" "乚" "侌" "冘" "凐" "印" "吟" "听" "吲" "唫" "喑" "噖" "噾" "嚚" "囙" "因" "圁" "圻" "垔" "垠" "垽" "堙" "堷" "夁" "夤" "姻" "婣" "婬" "寅" "尹" "峾" "崟" "崯" "嶾" "廕" "廴" "引" "愔" "慇" "慭" "憖" "憗" "懚" "戭" "摿" "斦" "朄" "檃" "檭" "檼" "櫽" "欽" "歅" "殥" "殷" "氤" "沂" "泿" "洇" "洕" "淫" "淾" "湚" "湮" "溵" "滛" "潭" "潯" "濥" "濦" "烎" "烟" "犾" "狋" "狠" "狺" "猌" "璌" "瘖" "瘾" "癊" "癮" "碒" "磤" "禋" "秵" "窨" "筃" "紖" "絪" "緸" "縯" "纼" "胤" "芩" "苂" "茚" "茵" "荫" "荶" "蒑" "蔩" "蔭" "蘟" "蚓" "螾" "蟫" "裀" "言" "訔" "訚" "訡" "訢" "誾" "諲" "讔" "趛" "鄞" "酳" "釿" "鈏" "鈝" "銀" "銦" "铟" "银" "闉" "阥" "阴" "陰" "陻" "隂" "隐" "隠" "隱" "霒" "霠" "霪" "靷" "鞇" "音" "韽" "韾" "飮" "飲" "饮" "馻" "駰" "骃" "鮣" "鰥" "鳏" "鷣" "黫" "齗" "齦" "龂" "龈"))
    ((("y" "i" "n" "g"))("㑞" "㕲" "㚞" "㜲" "㢍" "㦹" "㨕" "㬐" "㯋" "㲟" "㴄" "㵬" "㶈" "㹙" "㹚" "㿘" "䀰" "䀴" "䁐" "䁝" "䃷" "䋼" "䑉" "䑍" "䒢" "䔔" "䕦" "䙬" "䚆" "䤝" "䤰" "䨍" "䪯" "䭊" "䭗" "䭘" "䵥" "偀" "僌" "営" "嘤" "噟" "嚶" "塋" "婴" "媖" "媵" "嫈" "嬰" "嬴" "孆" "孾" "巆" "巊" "应" "廮" "影" "応" "應" "摬" "撄" "攍" "攖" "映" "景" "暎" "朠" "桜" "梬" "楧" "楹" "樱" "櫻" "櫿" "浧" "渶" "溁" "滎" "滢" "潁" "潆" "濙" "濚" "濴" "瀅" "瀛" "瀠" "瀯" "瀴" "煐" "熒" "營" "瑛" "瑩" "璄" "璎" "瓔" "甇" "甖" "甸" "瘿" "癭" "盁" "盈" "矨" "硬" "碤" "礯" "禜" "穎" "籝" "籯" "緓" "縈" "繩" "纓" "绬" "绳" "缨" "罂" "罃" "罌" "膡" "膺" "英" "茔" "荥" "荧" "莖" "莹" "莺" "萤" "营" "萦" "萾" "蓥" "藀" "蘡" "蛍" "蝇" "蝧" "蝿" "螢" "蠅" "蠳" "褮" "覮" "謍" "譍" "譻" "賏" "贏" "赢" "迎" "逞" "郢" "鍈" "鎣" "鐛" "鑍" "锳" "霙" "鞕" "韺" "頴" "颍" "颕" "颖" "鴬" "鶧" "鶯" "鷪" "鷹" "鸎" "鸚" "鹦" "鹰"))
    ((("y" "o"))("哟" "唷" "唹" "喲" "育"))
    ((("y" "o" "n" "g"))("㑙" "㙲" "㝘" "㞲" "㣧" "㦷" "㶲" "㷏" "㽫" "䗤" "䞻" "䮵" "佣" "俑" "傛" "傭" "勇" "勈" "咏" "喁" "嗈" "噰" "埇" "塎" "墉" "壅" "嫆" "嫞" "嵱" "庸" "廱" "彮" "恿" "悀" "惥" "愑" "愹" "慂" "慵" "拥" "搈" "擁" "柡" "栐" "槦" "永" "泳" "涌" "湧" "滽" "澭" "瀜" "灉" "牅" "用" "甬" "痈" "癕" "癰" "禜" "臃" "臾" "苚" "蕹" "蛹" "詠" "踊" "踴" "邕" "郺" "鄘" "醟" "銿" "鏞" "镛" "雍" "雝" "顒" "颙" "饔" "鯒" "鰫" "鱅" "鲬" "鳙" "鷛"))
    ((("y" "o" "u"))("㑸" "㒡" "㓜" "㔽" "㕗" "㕛" "㕱" "㘥" "㚭" "㛜" "㤑" "㫍" "㮋" "㰶" "㳺" "㶭" "㹨" "㺠" "㻀" "㽕" "㾞" "䀁" "䂚" "䅎" "䆜" "䌊" "䍃" "䑻" "䒒" "䒴" "䖻" "䚃" "䛻" "䞥" "䢊" "䢟" "䬀" "䱂" "䳑" "丣" "亴" "优" "佑" "侑" "偤" "優" "冘" "卣" "又" "友" "右" "呦" "唀" "嚘" "囮" "囿" "姷" "宥" "尢" "尤" "岰" "峟" "峳" "幼" "幽" "庮" "忧" "怞" "怣" "怮" "悠" "憂" "懮" "抭" "揄" "攸" "斿" "有" "柚" "栯" "梄" "梎" "楢" "槱" "櫌" "櫾" "沋" "油" "泅" "泑" "浟" "游" "湵" "滺" "瀀" "牖" "牰" "犹" "狖" "猶" "猷" "由" "疣" "祐" "禉" "秞" "糿" "繇" "纋" "羐" "羑" "耰" "聈" "聱" "肬" "苃" "莜" "莠" "莤" "莸" "蕕" "蚰" "蚴" "蜏" "蝣" "蝤" "褎" "褏" "訧" "誘" "诱" "貁" "輏" "輶" "迶" "逌" "逰" "遊" "邮" "郵" "鄾" "酉" "酭" "釉" "鈾" "銪" "铀" "铕" "駀" "魷" "鮋" "鯈" "鱿" "鲉" "鴢" "麀" "黝" "鼬"))
    ((("y" "u"))("㑨" "㒁" "㒜" "㔱" "㙑" "㚜" "㚥" "㝢" "㠘" "㠨" "㡰" "㣃" "㤜" "㤢" "㤤" "㥔" "㥚" "㥥" "㦛" "㦽" "㧒" "㧕" "㪀" "㪌" "㫹" "㬂" "㬰" "㭌" "㮋" "㰲" "㲾" "㳚" "㳛" "㵄" "㶛" "㷉" "㷒" "㹼" "㺄" "㺞" "㺠" "㺮" "㻀" "㻰" "㼌" "㼶" "㽣" "㽳" "䁌" "䁩" "䂊" "䂛" "䃋" "䄏" "䄨" "䆷" "䈅" "䉛" "䋖" "䋭" "䍂" "䍞" "䎉" "䏸" "䐳" "䓊" "䔡" "䖇" "䗨" "䘘" "䘱" "䘻" "䛎" "䛕" "䜡" "䜽" "䞕" "䞝" "䢓" "䢖" "䢩" "䣁" "䤋" "䥏" "䧕" "䨁" "䨒" "䨞" "䩒" "䫻" "䬄" "䬔" "䬛" "䮇" "䮙" "䰥" "䰻" "䱷" "䱾" "䲣" "䳑" "䴁" "䵥" "䵫" "丂" "与" "予" "于" "亏" "亐" "伃" "伛" "余" "俁" "俞" "俣" "俼" "偊" "傴" "兪" "吁" "哊" "唹" "喁" "喅" "喐" "喩" "喻" "噊" "噢" "噳" "圄" "圉" "圩" "圫" "域" "堉" "堣" "堬" "墺" "奧" "妤" "妪" "娛" "娯" "娱" "婾" "媀" "媮" "嫗" "嬩" "宇" "寓" "寙" "尉" "屿" "峪" "峿" "崳" "嵎" "嵛" "嶎" "嶼" "庽" "庾" "彧" "御" "忬" "悆" "悇" "惌" "惐" "愈" "愉" "愚" "慾" "懙" "或" "戫" "扜" "扵" "揄" "敔" "斔" "斞" "於" "旟" "昱" "杅" "栯" "桙" "梧" "棛" "棜" "棫" "楀" "楡" "楰" "榆" "櫲" "欎" "欝" "欤" "欥" "欲" "歈" "歟" "歶" "毓" "毹" "毺" "汙" "汚" "污" "汩" "浴" "淢" "淤" "淯" "渔" "渝" "湡" "滪" "漁" "潏" "澞" "澦" "澳" "灪" "焴" "煜" "煨" "熨" "燏" "燠" "爩" "牏" "狱" "狳" "獄" "獝" "玉" "王" "玗" "玙" "琙" "瑀" "瑜" "璵" "畬" "畭" "畲" "痀" "瘀" "瘉" "瘐" "癒" "盂" "盓" "睮" "矞" "砡" "硢" "硲" "礇" "礖" "礜" "祤" "禦" "禹" "禺" "秗" "稢" "稶" "穥" "穻" "窬" "窳" "竽" "箊" "篽" "籅" "籞" "籲" "粥" "紆" "緎" "緰" "繘" "纡" "罭" "罻" "羭" "羽" "聥" "聿" "肀" "育" "腧" "腴" "臾" "舁" "舆" "與" "舒" "艅" "芋" "芌" "苑" "茟" "茰" "菀" "菸" "萭" "萮" "萸" "蒮" "蓣" "蓹" "蔚" "蕍" "蕷" "薁" "藇" "蘌" "蘛" "虞" "虶" "蜍" "蜟" "蜮" "蝓" "螤" "螸" "蟈" "衘" "衙" "衧" "裕" "褕" "覦" "觎" "誉" "語" "諛" "諭" "謣" "譽" "语" "谀" "谕" "谷" "豫" "貐" "踰" "軉" "輍" "輿" "轝" "迂" "迃" "逳" "逾" "遇" "遹" "邘" "邪" "郁" "鄃" "鄅" "酑" "醧" "釪" "鈺" "銉" "鋊" "鋙" "錥" "鍝" "鐭" "钰" "铻" "閼" "閾" "阈" "阏" "陓" "隃" "隅" "隩" "雓" "雨" "雩" "霱" "預" "预" "飫" "餘" "饇" "饫" "馀" "馭" "騟" "驈" "驭" "骬" "髃" "鬰" "鬱" "鬻" "魊" "魚" "魣" "鮽" "鰅" "鱊" "鱼" "鳿" "鴥" "鴪" "鵌" "鵒" "鷠" "鷸" "鸆" "鸒" "鹆" "鹬" "麌" "黦" "齬" "齵" "龉" "龥" "羽"))
    ((("y" "u" "a" "n"))("㘣" "㛪" "㟲" "㟶" "㤪" "㥐" "㥳" "㭇" "㹉" "㼂" "䅈" "䏍" "䖠" "䖤" "䛄" "䛇" "䝠" "䝹" "䟦" "䣰" "䩩" "䬇" "䬧" "䬼" "䭴" "䲮" "䲻" "䳁" "䳒" "䳣" "傆" "元" "冤" "剈" "原" "厡" "厵" "员" "員" "喛" "噮" "囦" "园" "圆" "圎" "園" "圓" "圜" "垣" "塬" "夗" "妧" "妴" "媛" "媴" "嫄" "嬛" "嬽" "宛" "寃" "岏" "怨" "悁" "惌" "愿" "捐" "掾" "援" "杬" "棩" "楥" "榞" "榬" "橼" "櫞" "沅" "涓" "淵" "渁" "渆" "渊" "渕" "湲" "源" "溒" "灁" "爰" "猨" "猭" "猿" "獂" "瑗" "畹" "眢" "禐" "笎" "箢" "緣" "縁" "缘" "羱" "肙" "芫" "苑" "菀" "萲" "葾" "蒝" "蒬" "薗" "蚖" "蜎" "蜵" "蝝" "蝯" "螈" "衏" "袁" "裫" "裷" "褑" "褤" "謜" "豲" "貟" "贠" "身" "轅" "辕" "远" "逺" "遠" "邍" "邧" "鋺" "鎱" "阮" "院" "陨" "隕" "願" "駌" "騵" "魭" "鳶" "鴛" "鵷" "鶢" "鶰" "鸢" "鸳" "鹓" "黿" "鼋" "鼘" "鼝"))
    ((("y" "u" "e"))("㜧" "㜰" "㧒" "㬦" "㭾" "㯞" "㰛" "㵸" "㹊" "䋐" "䋤" "䎀" "䎳" "䒸" "䖃" "䟑" "䟠" "䠯" "䡇" "䢁" "䢲" "䤦" "䥃" "䬂" "䶳" "乐" "兑" "刖" "哕" "噦" "妜" "岄" "岳" "嶽" "恱" "悅" "悦" "戉" "抈" "捳" "曰" "曱" "月" "枂" "栎" "樂" "樾" "櫟" "汋" "泧" "瀹" "爍" "爚" "狘" "玥" "矱" "礿" "禴" "箹" "篗" "籆" "籥" "籰" "粤" "粵" "約" "约" "药" "葯" "蒦" "藥" "蘥" "蚎" "蚏" "蛻" "蠖" "說" "説" "说" "越" "趯" "跀" "跃" "躍" "躒" "軏" "鈅" "鉞" "銳" "鑠" "鑰" "钥" "钺" "锐" "閱" "閲" "阅" "鸑" "鸙" "黦" "龠"))
    ((("y" "u" "n"))("㒁" "㚃" "㚞" "㚺" "㜏" "㞌" "㟦" "㩈" "㷉" "䆬" "䇖" "䉙" "䚋" "䞫" "䡝" "䢵" "䤞" "䦾" "䨶" "䩵" "䪳" "䲰" "䵴" "云" "伝" "傊" "允" "勻" "匀" "员" "員" "喗" "囩" "均" "夽" "奫" "妘" "孕" "恽" "惲" "愠" "愪" "慍" "抎" "昀" "昷" "晕" "暈" "枟" "榅" "榲" "橒" "殒" "殞" "氲" "氳" "沄" "涢" "温" "溳" "澐" "煇" "煴" "熅" "熉" "熨" "狁" "玧" "畇" "瘟" "盾" "眃" "磒" "秐" "筠" "筼" "篔" "紜" "緷" "緼" "縕" "縜" "纭" "缊" "耘" "耺" "腪" "芸" "苑" "荺" "菀" "蒀" "蒕" "蒷" "蕓" "蕰" "蕴" "薀" "藴" "蘊" "蝹" "褞" "貟" "賱" "贇" "贠" "赟" "輑" "运" "運" "郓" "郧" "鄆" "鄖" "酝" "醖" "醞" "鈗" "鋆" "阭" "陨" "隕" "雲" "霣" "韗" "韞" "韫" "韵" "韻" "頵" "餫" "饂" "鶤" "齳"))
    ((("z" "a"))("㳨" "䕹" "䞙" "䦈" "䨿" "䪞" "倃" "偺" "匝" "咂" "咱" "唼" "囐" "嶻" "帀" "扎" "抸" "拶" "摣" "杂" "沞" "濽" "砸" "磼" "籴" "紥" "紮" "臜" "臢" "襍" "迊" "鉔" "雑" "雜" "雥" "韴" "魳" "鮺" "鲝"))
    ((("z" "a" "i"))("㞨" "㱰" "㴓" "䏁" "䣬" "䮨" "䵧" "仔" "侢" "傤" "儎" "再" "哉" "在" "宰" "崽" "扗" "栽" "渽" "災" "灾" "烖" "甾" "縡" "菑" "賳" "載" "载" "酨" "𢦏"))
    ((("z" "a" "n"))("㙻" "㜺" "㟛" "㣅" "㤰" "㳨" "䍝" "䗞" "䙉" "䟃" "䟅" "䥄" "䬤" "䭕" "倃" "偺" "儧" "儹" "兂" "咱" "喒" "噆" "囋" "囐" "寁" "拶" "撍" "攅" "攒" "攢" "昝" "暂" "暫" "桚" "欑" "沯" "涔" "淺" "湔" "濺" "濽" "灒" "瓉" "瓒" "瓚" "礸" "禶" "穳" "篸" "簪" "簮" "糌" "臜" "臢" "襸" "讃" "讚" "賛" "贊" "赞" "趱" "趲" "蹔" "鄼" "酂" "酇" "錾" "鏨" "鐕" "饡"))
    ((("z" "a" "n" "g"))("㘸" "匨" "塟" "奘" "弉" "牂" "羘" "脏" "臓" "臜" "臟" "臢" "臧" "葬" "蔵" "藏" "賍" "賘" "贓" "贜" "赃" "銺" "駔" "驵" "髒"))
    ((("z" "a" "o"))("㲧" "㿷" "䒃" "䖣" "䗢" "䜊" "䥣" "䲃" "傮" "凿" "唕" "唣" "噪" "慥" "早" "枣" "梍" "棗" "槽" "澡" "灶" "燥" "璪" "皁" "皂" "窖" "竃" "竈" "簉" "糟" "繅" "繰" "缫" "缲" "艁" "艸" "草" "薻" "藻" "蚤" "譟" "趮" "蹧" "躁" "造" "遭" "醩" "鑿" "髞"))
    ((("z" "e"))("㖽" "㟙" "㢎" "㣱" "㥽" "㮣" "㳁" "㳻" "㻭" "䂝" "䃎" "䅚" "䇥" "䔾" "䕉" "䕪" "䯔" "䰹" "䶡" "䶦" "仄" "侧" "側" "则" "則" "咋" "唶" "啧" "嘖" "夨" "崱" "帻" "幘" "庂" "戝" "択" "择" "捑" "措" "擇" "昃" "昗" "柞" "汄" "沢" "泽" "溭" "滜" "澤" "皟" "睪" "瞔" "礋" "稄" "稷" "窄" "笮" "箦" "簀" "耫" "舴" "荝" "萴" "蠈" "蠌" "襗" "諎" "謫" "謮" "責" "賊" "賾" "责" "贼" "赜" "迮" "鰂" "鲗" "齚" "齰"))
    ((("z" "e" "i"))("㖽" "戝" "賊" "贼" "鯽" "鱡"))
    ((("z" "e" "n"))("䫈" "怎" "譖" "譛" "谮"))
    ((("z" "e" "n" "g"))("㽪" "䇸" "䙢" "䰝" "䵴" "増" "增" "憎" "曾" "橧" "熷" "璔" "甑" "矰" "磳" "綜" "繒" "综" "缯" "罾" "譄" "贈" "赠" "鄫" "鋥" "锃" "驓"))
    ((("z" "h" "a"))("㑵" "㒀" "㓃" "㔍" "㚫" "㞚" "㡸" "㩹" "㯥" "㱜" "㳐" "㴙" "㷢" "㽪" "䃎" "䄍" "䄰" "䆛" "䋾" "䕢" "䖳" "䙄" "䛽" "䞢" "䢱" "䥷" "䮜" "䱹" "䵙" "䵵" "乍" "偧" "剳" "劄" "厏" "吒" "咋" "咤" "哳" "喋" "喳" "奒" "奓" "宱" "扎" "扠" "抯" "拃" "挓" "挿" "揸" "搾" "摣" "札" "柞" "柤" "查" "柵" "査" "栅" "楂" "榨" "槎" "樝" "渣" "渫" "溠" "灹" "炸" "煠" "牐" "猹" "甴" "痄" "皶" "皻" "眨" "砟" "碴" "笮" "箚" "簎" "紥" "紮" "膪" "苲" "苴" "蕏" "虴" "蚱" "蚻" "蜡" "蠿" "觰" "詐" "謯" "譗" "诈" "軋" "轧" "醡" "鍘" "铡" "閘" "闸" "霅" "鮓" "鰈" "鲊" "齄" "齇" "齟"))
    ((("z" "h" "a" "i"))("㟙" "㡯" "㢎" "㩟" "䍉" "䑲" "䓱" "亝" "债" "債" "宅" "寨" "择" "捚" "摘" "擇" "斋" "斎" "柴" "榸" "疵" "瘵" "砦" "礋" "祭" "窄" "簀" "翟" "膪" "虒" "責" "责" "鉙" "飵" "駘" "齊" "齋" "齐"))
    ((("z" "h" "a" "n"))("㙴" "㜊" "㞡" "㟞" "㠭" "㺘" "㻵" "䁪" "䁴" "䈴" "䋎" "䎒" "䐤" "䗃" "䗞" "䘺" "䟋" "䡀" "䦅" "䧯" "䩅" "䩆" "䪌" "䱠" "䱼" "䳻" "䵣" "佔" "偡" "占" "厃" "噡" "嫸" "展" "崭" "嶃" "嶄" "嶘" "嶦" "惉" "战" "戦" "戰" "拃" "搌" "摲" "斩" "斬" "旃" "旜" "栈" "栴" "桟" "棧" "椫" "椾" "榐" "樿" "橏" "毡" "氈" "氊" "沾" "湔" "湛" "澶" "琖" "皽" "盏" "盞" "瞻" "站" "粘" "綻" "绽" "菚" "薝" "蘸" "虥" "虦" "蛅" "袒" "襢" "覘" "覱" "觇" "詀" "詹" "謙" "譫" "讝" "谵" "趈" "蹍" "蹔" "躔" "輚" "輾" "轏" "辗" "邅" "醆" "醮" "鉆" "霑" "顫" "颤" "颭" "飐" "飦" "餰" "饘" "驏" "驙" "骣" "魙" "鱣" "鳣" "鸇" "鹯" "黏" "點"))
    ((("z" "h" "a" "n" "g"))("㕩" "㙊" "㙣" "㢓" "㽴" "丈" "仉" "仗" "仧" "傽" "墇" "嫜" "嶂" "帐" "帳" "幛" "张" "張" "彰" "慞" "扙" "掌" "暲" "杖" "樟" "涨" "涱" "漲" "漳" "獐" "璋" "痮" "瘬" "瘴" "瞕" "礃" "章" "粻" "緔" "绱" "胀" "脹" "蔁" "蟑" "賬" "账" "遧" "鄣" "長" "长" "障" "鞝" "餦" "騿" "鱆" "麞" "黨"))
    ((("z" "h" "a" "o"))("㑿" "㕚" "㡽" "㨄" "㫤" "㷖" "㹿" "㺐" "䃍" "䄻" "䈃" "䈇" "䍜" "䍮" "䑲" "䖺" "䝖" "䧂" "䮓" "兆" "召" "啁" "嘲" "垗" "妱" "巶" "找" "抓" "招" "搔" "旐" "昭" "曌" "朝" "枛" "柖" "棹" "櫂" "沼" "淖" "濯" "炤" "照" "燳" "爪" "狣" "瑵" "盄" "着" "瞾" "窼" "笊" "箌" "罩" "羄" "肁" "肇" "肈" "菬" "著" "蚤" "詔" "謿" "诏" "赵" "趙" "釗" "鉊" "鍣" "钊" "雿" "駋" "鮡" "鳭" "鵃" "鵫" "鸼" "鼂" "鼌"))
    ((("z" "h" "e"))("㞏" "㞼" "㡇" "㡳" "㢎" "㦻" "㪿" "㫼" "㭙" "㭯" "㯰" "㵊" "䀅" "䂝" "䂞" "䆛" "䊞" "䊮" "䋲" "䎲" "䏳" "䐑" "䐲" "䓆" "䗖" "䗪" "䙷" "䜆" "䝃" "䝕" "䠦" "䧪" "䩾" "䮰" "䵭" "乇" "厇" "哲" "啠" "啫" "喆" "嗻" "嚞" "埑" "嫬" "庻" "悊" "慑" "慴" "慹" "懾" "折" "摘" "摺" "晢" "晣" "柘" "檡" "歽" "浙" "淛" "烢" "瓋" "着" "砓" "磔" "禇" "籷" "者" "耴" "耷" "聂" "聶" "著" "蔗" "虴" "蛰" "蜇" "螫" "蟄" "蟅" "褚" "褶" "襵" "詟" "謫" "謺" "讁" "讋" "讘" "谪" "赭" "踷" "軼" "輒" "輙" "轍" "辄" "辙" "这" "這" "適" "遮" "銸" "鍺" "锗" "陬" "鮿" "鷓" "鷙" "鸅" "鹧"))
    ((("z" "h" "e" "i"))("这" "這"))
    ((("z" "h" "e" "n"))("㐱" "㓄" "㛛" "㣀" "㨋" "㪛" "㭫" "㮳" "㯢" "㴨" "㼉" "䀕" "䀼" "䂦" "䂧" "䊶" "䏖" "䑐" "䚯" "䝩" "䟴" "䠴" "䡅" "䡩" "䧵" "䨯" "䪴" "䪾" "䫬" "䲴" "䳲" "䴾" "侦" "侲" "偵" "圳" "堻" "塦" "媜" "嫃" "寊" "帪" "弫" "抌" "抮" "挋" "振" "揁" "揕" "搸" "敒" "敶" "斟" "昣" "晸" "朕" "枕" "栕" "栚" "桢" "桭" "椹" "楨" "榛" "樼" "浈" "湞" "溱" "滇" "潧" "澵" "獉" "珍" "珎" "瑊" "瑱" "甄" "甽" "畛" "疹" "眕" "眞" "真" "眹" "砧" "碪" "磌" "祯" "禎" "禛" "稹" "笉" "箴" "籈" "紖" "紾" "絼" "縝" "縥" "纼" "缜" "聄" "胗" "臻" "葴" "蒖" "蒧" "蓁" "薽" "蜄" "袗" "裖" "診" "誫" "诊" "貞" "賑" "贞" "赈" "趁" "軫" "轃" "轸" "辴" "迧" "遉" "酖" "酙" "針" "鉁" "錱" "鍖" "鍼" "鎭" "鎮" "鐤" "针" "镇" "阵" "陈" "陣" "陳" "震" "靕" "駗" "鬒" "鮝" "鱵" "鴆" "鷆" "鷏" "鸩" "黰" "鼎" "鼑"))
    ((("z" "h" "e" "n" "g"))("㐼" "㡠" "㡧" "㱏" "㽀" "䂻" "䈣" "䛫" "䡕" "䥌" "䥭" "䦛" "䦶" "䫆" "丁" "争" "佂" "侦" "偵" "埩" "姃" "峥" "崝" "崢" "帧" "幀" "征" "徰" "徴" "徵" "怔" "愸" "憆" "承" "抍" "拯" "挣" "掙" "掟" "撜" "政" "整" "晸" "桢" "楨" "正" "氶" "炡" "烝" "爭" "狰" "猙" "町" "症" "癥" "眐" "睁" "睜" "瞠" "祯" "禎" "筝" "箏" "篜" "糽" "綪" "聇" "脀" "蒸" "証" "諍" "證" "证" "诤" "趟" "踭" "遉" "郑" "鄭" "鉦" "鋥" "錚" "鏳" "钲" "铮" "锃" "鬇" "鯖" "鯹" "鲭" "鴊"))
    ((("z" "h" "i"))("㕄" "㗌" "㗧" "㘉" "㙷" "㛿" "㜱" "㜼" "㝂" "㡳" "㡶" "㣥" "㥁" "㧻" "㨁" "㨖" "㫑" "㫼" "㬪" "㮹" "㯰" "㲛" "㴛" "㾅" "㿃" "䀸" "䂡" "䄺" "䅩" "䆈" "䇛" "䇽" "䉅" "䉜" "䌤" "䎺" "䏄" "䏑" "䏯" "䐈" "䐭" "䑇" "䑭" "䓌" "䕌" "䘭" "䚇" "䚦" "䚳" "䛗" "䜠" "䝰" "䝷" "䞃" "䞇" "䟈" "䠦" "䡹" "䤠" "䥍" "䦛" "䦯" "䧝" "䩢" "䪒" "䫕" "䬹" "䭁" "䰴" "䱃" "䱥" "䱨" "䲀" "䳅" "䵂" "䶡" "之" "侄" "値" "值" "偫" "傂" "儨" "制" "剬" "劕" "劧" "卮" "厎" "厔" "只" "吱" "咫" "址" "坁" "坧" "垁" "埴" "執" "墌" "夂" "妷" "姪" "娡" "嬂" "寘" "峙" "崻" "巵" "帋" "帙" "帜" "幟" "庢" "庤" "廌" "彘" "徏" "徝" "徵" "志" "忮" "恉" "慹" "憄" "懥" "懫" "执" "扺" "扻" "抧" "拓" "挃" "指" "挚" "掷" "搘" "搱" "摭" "摯" "擲" "擿" "支" "旘" "旨" "昵" "晊" "晢" "晣" "智" "枝" "枳" "柣" "栀" "栉" "栺" "桎" "梔" "梽" "植" "椥" "楖" "榰" "樴" "櫍" "櫛" "止" "殖" "氏" "氐" "汁" "汥" "沚" "治" "泜" "洔" "洷" "淛" "淽" "滍" "滞" "滯" "漐" "潌" "炙" "熫" "犆" "狾" "猘" "璏" "瓆" "瓡" "畤" "疐" "疧" "疻" "痔" "痣" "瘈" "直" "知" "砋" "砥" "礩" "示" "祁" "祇" "祉" "祑" "祗" "祬" "禃" "禔" "秇" "秓" "秖" "秩" "秪" "秲" "秷" "稙" "稚" "稺" "穉" "窒" "筫" "紙" "紩" "絷" "絼" "綕" "緻" "縶" "織" "纸" "织" "置" "翐" "耆" "聀" "职" "職" "肢" "胑" "胝" "胵" "脂" "腟" "膣" "膱" "至" "致" "臸" "芖" "芝" "芷" "茝" "藢" "蘵" "蛭" "蛰" "蜘" "螲" "蟄" "蟙" "衹" "衼" "袟" "袠" "製" "褁" "襧" "覟" "觗" "觯" "觶" "訨" "誌" "識" "识" "豑" "豒" "豸" "貭" "質" "贄" "质" "贽" "趵" "趾" "跖" "跱" "踬" "踯" "踶" "蹛" "蹠" "蹢" "躑" "躓" "軄" "軹" "輊" "轵" "轾" "迟" "迣" "遟" "遲" "郅" "郦" "酈" "酯" "釞" "銍" "鋕" "鑕" "铚" "锧" "阤" "阯" "陟" "隻" "雉" "馶" "馽" "駤" "騭" "騺" "驇" "骘" "鮨" "鯯" "鳩" "鳷" "鴙" "鴟" "鴲" "鵄" "鷙" "鸱" "鸷" "黹" "鼅"))
    ((("z" "h" "o" "n" "g"))("㐺" "㣫" "㲴" "䱰" "䳋" "中" "乑" "仲" "伀" "众" "偅" "冢" "刣" "喠" "堹" "塚" "妐" "妕" "媑" "尰" "幒" "彸" "忠" "忪" "柊" "歱" "汷" "泈" "湩" "潨" "潼" "炂" "煄" "狆" "瘇" "盅" "眾" "祌" "种" "種" "穜" "童" "筗" "籦" "終" "緟" "终" "肿" "腫" "舂" "舯" "茽" "董" "蔠" "蚛" "蚣" "螽" "衆" "衳" "衶" "衷" "褈" "諥" "踵" "蹱" "重" "鈡" "銿" "鍾" "鐘" "钟" "锺" "鴤" "鼨" "塚")) 
    ((("z" "h" "o" "u"))("㑇" "㑳" "㔌" "㛩" "㝌" "㤘" "㥁" "㥮" "㨶" "㫶" "㲴" "㹐" "㼙" "㾭" "䇠" "䈙" "䋓" "䎻" "䐌" "䐍" "䔭" "䖞" "䛆" "䩜" "䭥" "䶇" "伷" "侜" "僽" "冑" "周" "呪" "咒" "咮" "啁" "啄" "喌" "噣" "妯" "宙" "州" "帚" "徟" "昼" "晝" "晭" "注" "洀" "洲" "淍" "烐" "珘" "甃" "疛" "皱" "皺" "盩" "睭" "矪" "碡" "祝" "箒" "籀" "籒" "籕" "粙" "粥" "紂" "縐" "繇" "纣" "绉" "肘" "胄" "脽" "舟" "舳" "荮" "菷" "葤" "薵" "詋" "詶" "調" "諏" "謅" "譸" "诌" "诪" "调" "賙" "赒" "軸" "輈" "輖" "轴" "辀" "逐" "週" "酎" "鈾" "銂" "駎" "騆" "騶" "驟" "驺" "骤" "鬻" "鮦" "鯞" "鲖" "鵃" "鸼" "𤏲"))
    ((("z" "h" "u"))("㑏" "㔉" "㝉" "㤖" "㧣" "㫂" "㵭" "㹥" "㺛" "㾻" "㿾" "䇠" "䇡" "䇧" "䌵" "䍆" "䎝" "䎷" "䐢" "䕽" "䘄" "䘚" "䘢" "䝒" "䝬" "䟉" "䠱" "䠼" "䥮" "䪒" "䫖" "䬡" "䭖" "䮱" "䰞" "䳠" "丶" "主" "伫" "佇" "住" "侏" "劚" "助" "劯" "嘱" "囑" "坾" "壴" "妯" "孎" "宁" "宔" "寧" "属" "屬" "嵀" "庻" "拄" "敱" "斸" "朝" "朮" "术" "朱" "杼" "枓" "柚" "柱" "柷" "株" "楮" "槠" "樦" "橥" "櫡" "櫧" "櫫" "欘" "殶" "泞" "注" "洙" "渚" "潴" "澍" "濐" "瀦" "灟" "炢" "炷" "烛" "煑" "煮" "燭" "爥" "牏" "猪" "珠" "疰" "瘃" "眝" "瞩" "矚" "砫" "硃" "祝" "祩" "禇" "秼" "窋" "竚" "竹" "竺" "笁" "笜" "筑" "筯" "箸" "築" "篫" "粥" "紵" "紸" "絑" "纻" "罜" "羜" "翥" "者" "胑" "膱" "舳" "芧" "苎" "苧" "茁" "茱" "茿" "莇" "著" "蓫" "蕏" "蚰" "蛀" "蛛" "蝫" "蠋" "蠩" "蠾" "袾" "褚" "註" "詝" "誅" "諔" "諸" "诛" "诸" "豬" "貯" "贮" "趉" "跓" "跦" "躅" "軴" "軸" "轴" "逐" "逗" "邾" "鉒" "銖" "鋳" "鑄" "钃" "铢" "铸" "阻" "除" "陼" "飳" "馵" "駐" "騶" "驻" "鬻" "鮢" "鯺" "鱁" "鴸" "鸀" "麆" "麈" "鼄" "猪" "諸"))
    ((("z" "h" "u" "a"))("抓" "挝" "撾" "檛" "爪" "簻" "膼" "髽" "鵽"))
    ((("z" "h" "u" "a" "i"))("拽" "跩" "𨋯"))
    ((("z" "h" "u" "a" "n"))("㑷" "䉵" "䏝" "䚈" "䡱" "䤄" "䧘" "专" "传" "傳" "僎" "剸" "叀" "啭" "囀" "堟" "塼" "嫥" "孨" "専" "專" "抟" "摶" "撰" "沌" "湍" "灷" "瑑" "瑼" "甎" "砖" "磚" "竱" "篆" "篹" "篿" "籑" "縳" "耑" "腞" "膞" "蒃" "蟤" "襈" "譔" "賺" "贃" "赚" "跧" "転" "轉" "转" "鄟" "顓" "颛" "饌" "馔" "鱄" "鷒"))
    ((("z" "h" "u" "a" "n" "g"))("䚒" "僮" "壮" "壯" "壵" "奘" "妆" "妝" "娤" "幢" "庄" "弉" "戅" "戆" "戇" "撞" "桩" "梉" "樁" "焋" "状" "狀" "粧" "糚" "艟" "荘" "莊" "装" "裝" "贛"))
    ((("z" "h" "u" "i"))("㝽" "㾽" "㿢" "䃍" "䄌" "䋘" "䨺" "坠" "埀" "墜" "娺" "惴" "揣" "桘" "椎" "槌" "沝" "甀" "硾" "礈" "窡" "笍" "綴" "縋" "缀" "缒" "腏" "膇" "致" "萑" "諈" "譵" "贅" "赘" "追" "醊" "錐" "錣" "鑆" "锥" "队" "隊" "隧" "隹" "餟" "騅" "骓" "魋" "鴭" "鵻" "鵽"))
    ((("z" "h" "u" "n"))("准" "埻" "宒" "屯" "忳" "棆" "淳" "湻" "準" "盹" "稕" "窀" "純" "綧" "纯" "肫" "胗" "衠" "諄" "谆" "迍" "隼" "頓" "顿" "飩" "鶽"))
    ((("z" "h" "u" "o"))("㒂" "㓸" "㠚" "㣿" "㧳" "㧻" "㪬" "㭬" "㲋" "㹿" "㺟" "䅵" "䏐" "䐁" "䔲" "䕴" "䙯" "䟾" "䴵" "䵵" "䶂" "丵" "倬" "剢" "劅" "勺" "卓" "叕" "啄" "啅" "噣" "圴" "妰" "彴" "拙" "捉" "撯" "擆" "擢" "斀" "斫" "斮" "斱" "斲" "斵" "晫" "桌" "梲" "棁" "棳" "棹" "椓" "槕" "櫂" "櫡" "汋" "泎" "浊" "浞" "涿" "淖" "濁" "濯" "灂" "灼" "炪" "烵" "焯" "琢" "琸" "畷" "着" "硺" "禚" "穛" "穱" "箸" "篧" "籗" "籱" "絀" "繳" "绌" "缴" "罬" "肫" "茁" "著" "蕞" "蠗" "諑" "謶" "诼" "趵" "踔" "躅" "酌" "鋜" "錣" "鐯" "鐲" "镯" "鷟" "鸀"))
    ((("z" "i"))("㑵" "㜽" "㞨" "㢀" "㧗" "㧘" "㰣" "㰷" "㱴" "㺭" "㾅" "䅆" "䐉" "䔂" "䘣" "䦻" "䴾" "亝" "仔" "倳" "兹" "剚" "吇" "吱" "呰" "呲" "咨" "啙" "嗞" "姉" "姊" "姕" "姿" "子" "孖" "字" "孜" "孳" "孶" "嵫" "恣" "扻" "杍" "柴" "栥" "梓" "椔" "榟" "淄" "渍" "湽" "滋" "滓" "漬" "澬" "牸" "玆" "甾" "疵" "瘠" "眥" "眦" "矷" "禌" "秄" "秭" "秶" "稵" "笫" "籽" "粢" "糍" "紎" "純" "紫" "緇" "缁" "耔" "胏" "胔" "胾" "自" "芓" "茈" "茊" "茡" "茲" "菑" "葘" "虸" "觜" "訾" "訿" "諮" "谘" "貲" "資" "赀" "资" "趑" "趦" "載" "輜" "輺" "辎" "鄑" "釨" "鈭" "鋅" "錙" "鍿" "鎡" "锱" "镃" "頾" "頿" "餈" "髭" "鯔" "鲻" "鴜" "鶅" "鶿" "鷀" "鹚" "鼒" "齊" "齍" "齐" "齜" "龇"))
    ((("z" "o" "n" "g"))("㢔" "㷓" "㹅" "䁓" "䍟" "䎫" "䙕" "䝋" "䡯" "䰌" "从" "倊" "倧" "偬" "傯" "堫" "宗" "嵏" "嵕" "嵸" "從" "总" "惣" "惾" "愡" "憁" "捴" "揔" "搃" "摠" "昮" "朡" "枞" "棕" "椶" "樅" "熜" "熧" "猔" "猣" "疭" "瘲" "碂" "磫" "稯" "粽" "糉" "糭" "綜" "緃" "総" "緫" "緵" "縂" "縦" "縱" "總" "纵" "综" "翪" "腙" "艐" "葼" "蓗" "蝬" "豵" "踨" "踪" "蹤" "鑁" "騌" "騣" "骔" "鬃" "鬉" "鬷" "鯮" "鯼"))
    ((("z" "o" "u"))("㔿" "㞫" "㵵" "䠫" "䲀" "奏" "媰" "掫" "揍" "族" "棷" "棸" "楱" "箃" "緅" "菆" "諏" "謅" "诌" "诹" "走" "赱" "趣" "邹" "郰" "鄒" "鄹" "陬" "騶" "驟" "驺" "骤" "鯫" "鲰" "黀" "齱" "齺")) 
    ((("z" "u"))("㞺" "㧻" "㰵" "㲋" "㲞" "㵀" "䅸" "䔃" "䖕" "䙘" "䚝" "䬨" "䯿" "䱣" "俎" "卆" "卒" "咀" "哫" "唨" "崒" "崪" "捽" "族" "柤" "沮" "淬" "爼" "珇" "祖" "租" "稡" "紣" "組" "组" "苴" "菹" "葅" "蒩" "詛" "謯" "诅" "趲" "足" "踤" "踿" "蹴" "蹵" "鎐" "鏃" "鑿" "镞" "阻" "靻" "駔" "驵"))
    ((("z" "u" "a" "n"))("㷪" "䂎" "䌣" "䡅" "䤸" "揝" "攢" "攥" "篹" "籫" "繤" "纂" "纉" "纘" "缵" "賺" "贃" "躜" "躦" "鑚" "鑽" "钻" "饡"))
    ((("z" "u" "i"))("㝡" "㠑" "㭰" "㰎" "㵃" "䘹" "䮔" "厜" "嘴" "噿" "嶉" "嶊" "嶵" "晬" "最" "栬" "槜" "樶" "檇" "檌" "洅" "濢" "璻" "祽" "絊" "纗" "罪" "羧" "脧" "蕝" "蕞" "蟕" "襊" "觜" "辠" "酔" "酨" "酻" "醉" "鋷" "錊"))
    ((("z" "u" "n"))("䔿" "僔" "噂" "壿" "尊" "嶟" "捘" "撙" "樽" "燇" "繜" "罇" "臶" "譐" "蹲" "遵" "銌" "鐏" "鱒" "鳟" "鷷"))
    ((("z" "u" "o"))("㑅" "㘀" "㘴" "㛗" "㝾" "㣱" "㤰" "㭮" "㶡" "㸲" "䇥" "䋏" "䎰" "䔘" "䜊" "䝫" "䞢" "䞰" "䟄" "䟶" "䦈" "䩦" "䬤" "䯿" "乍" "佐" "作" "侳" "做" "凿" "咗" "唑" "唨" "嘬" "坐" "夎" "岝" "岞" "左" "座" "怍" "捽" "撮" "昨" "柞" "椊" "毑" "琢" "砟" "祚" "秨" "稓" "笮" "筰" "糳" "繓" "胙" "苲" "莋" "葃" "葄" "袏" "迮" "酢" "鈼" "鑿" "阼" "飵")))
  )

