#!/bin/bash
# OpenLDAP	(http://www.openldap.org/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-06-24
# require:
#	unixODBC
#
SRC_URI="ftp://ftp.OpenLDAP.org/pub/OpenLDAP/openldap-release/openldap-2.4.10.tgz"
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tgz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/secure
PAC_DIR=$PLAMO/Packages/4.5/Network
BUILD_DIR=$PLAMO/openldap
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -mcpu=$CPU"
export PATH=$PATH:/usr/X11R6/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --prefix=/usr --enable-local \
  --sysconfdir=/etc --localstatedir=/var \
  --infodir=/usr/share/info --mandir=/usr/share/man \
  --enable-spasswd=yes --enable-modules=yes \
  --enable-backends=mod
  

make depend
make 
make install DESTDIR=$WORK

cp $CUSTOM_DIR/_odbc.ini $WORK/etc/openldap/_odbc.ini
cp $CUSTOM_DIR/slapd.conf $WORK/etc/openldap/slapd.conf
chmod 600 $WORK/etc/openldap/slapd.conf 
mkdir -p $WORK/install
cp $CUSTOM_DIR/doinst-odbc.sh $WORK/install/doinst.sh

DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -a $CUSTOM_DIR/ldap_test $DOC_DIR/
cp -r servers/slapd/back-sql/rdbms_depend/ $DOC_DIR/
cp -p ANNOUNCEMENT CHANGES COPYRIGHT INSTALL LICENSE README	$DOC_DIR/
cp -p $BUILD_DIR/`basename $0`  $DOC_DIR/
chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz
mv ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
echo "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz ... done"
cd $CWD
