/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final boolean DEBUG = false;
    private String tsaUrl = null;

    public HttpTimestamper(String string) {
        this.tsaUrl = string;
    }

    public TSResponse generateTimestamp(TSRequest tSRequest) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.tsaUrl).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.connect();
        DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        byte[] byArray = tSRequest.encode();
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.flush();
        dataOutputStream.close();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        int n = httpURLConnection.getContentLength();
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        HttpTimestamper.verifyMimeType(httpURLConnection.getContentType());
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; n2 != -1 && i < n; i += n2) {
            n2 = bufferedInputStream.read(byArray2, i, byArray2.length - i);
        }
        bufferedInputStream.close();
        return new TSResponse(byArray2);
    }

    private static void verifyMimeType(String string) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(string)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

