/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import sun.net.NetProperties;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCleanerEntry;
import sun.net.www.http.KeepAliveStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepAliveStreamCleaner
extends LinkedBlockingQueue<KeepAliveCleanerEntry>
implements Runnable {
    protected static int MAX_DATA_REMAINING;
    protected static int MAX_CAPACITY;
    protected static final int TIMEOUT = 5000;
    private static final int MAX_RETRIES = 5;

    public KeepAliveStreamCleaner() {
        super(MAX_CAPACITY);
    }

    public KeepAliveStreamCleaner(int n) {
        super(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KeepAliveCleanerEntry keepAliveCleanerEntry = null;
        do {
            try {
                keepAliveCleanerEntry = (KeepAliveCleanerEntry)this.poll(5000L, TimeUnit.MILLISECONDS);
                if (keepAliveCleanerEntry == null) break;
                KeepAliveStream keepAliveStream = keepAliveCleanerEntry.getKeepAliveStream();
                if (keepAliveStream == null) continue;
                KeepAliveStream keepAliveStream2 = keepAliveStream;
                synchronized (keepAliveStream2) {
                    Object var12_11;
                    HttpClient httpClient = keepAliveCleanerEntry.getHttpClient();
                    try {
                        block13: {
                            try {
                                if (httpClient == null || httpClient.isInKeepAliveCache()) break block13;
                                int n = httpClient.setTimeout(5000);
                                long l = keepAliveStream.remainingToRead();
                                if (l > 0L) {
                                    long l2 = 0L;
                                    int n2 = 0;
                                    while (l2 < l && n2 < 5) {
                                        if ((l2 = keepAliveStream.skip(l -= l2)) != 0L) continue;
                                        ++n2;
                                    }
                                    l -= l2;
                                }
                                if (l == 0L) {
                                    httpClient.setTimeout(n);
                                    httpClient.finished();
                                    break block13;
                                }
                                httpClient.closeServer();
                            }
                            catch (IOException iOException) {
                                httpClient.closeServer();
                                var12_11 = null;
                                keepAliveStream.setClosed();
                            }
                        }
                        var12_11 = null;
                        keepAliveStream.setClosed();
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        keepAliveStream.setClosed();
                        throw throwable;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (keepAliveCleanerEntry != null);
    }

    static {
        int n;
        int n2;
        MAX_DATA_REMAINING = 512;
        MAX_CAPACITY = 10;
        MAX_DATA_REMAINING = n2 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(NetProperties.getInteger("http.KeepAlive.remainingData", MAX_DATA_REMAINING));
            }
        }) * 1024;
        MAX_CAPACITY = n = ((Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(NetProperties.getInteger("http.KeepAlive.queuedConnections", MAX_CAPACITY));
            }
        })).intValue();
    }
}

