/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class XAWTFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    boolean displayFullRecord = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.displayFullRecord"));
    boolean useANSI = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.useANSI"));
    boolean showDate = !"false".equals(LogManager.getLogManager().getProperty("XAWTFormatter.showDate"));
    boolean showLevel = !"false".equals(LogManager.getLogManager().getProperty("XAWTFormatter.showLevel"));
    boolean swapMethodClass = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.swapMethodClass"));

    public synchronized String format(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.useANSI) {
            object = logRecord.getLevel();
            if (Level.FINEST.equals(object)) {
                stringBuffer.append("\u001b[36m");
            } else if (Level.FINER.equals(object)) {
                stringBuffer.append("\u001b[32m");
            } else if (Level.FINE.equals(object)) {
                stringBuffer.append("\u001b[34m");
            }
        }
        if (this.displayFullRecord) {
            if (this.showDate) {
                this.dat.setTime(logRecord.getMillis());
                this.args[0] = this.dat;
                object = new StringBuffer();
                if (this.formatter == null) {
                    this.formatter = new MessageFormat(format);
                }
                this.formatter.format(this.args, (StringBuffer)object, (FieldPosition)null);
                stringBuffer.append((StringBuffer)object);
                stringBuffer.append(" ");
            } else {
                stringBuffer.append("    ");
            }
            if (this.swapMethodClass) {
                if (logRecord.getSourceMethodName() != null) {
                    stringBuffer.append(" \u001b[35m");
                    stringBuffer.append(logRecord.getSourceMethodName());
                    stringBuffer.append("\u001b[30m ");
                }
                if (logRecord.getSourceClassName() != null) {
                    stringBuffer.append(logRecord.getSourceClassName());
                } else {
                    stringBuffer.append(logRecord.getLoggerName());
                }
            } else {
                if (logRecord.getSourceClassName() != null) {
                    stringBuffer.append(logRecord.getSourceClassName());
                } else {
                    stringBuffer.append(logRecord.getLoggerName());
                }
                if (logRecord.getSourceMethodName() != null) {
                    stringBuffer.append(" \u001b[35m");
                    stringBuffer.append(logRecord.getSourceMethodName());
                    stringBuffer.append("\u001b[30m");
                }
            }
            stringBuffer.append(this.lineSeparator);
        }
        if (this.useANSI) {
            object = logRecord.getLevel();
            if (Level.FINEST.equals(object)) {
                stringBuffer.append("\u001b[36m");
            } else if (Level.FINER.equals(object)) {
                stringBuffer.append("\u001b[32m");
            } else if (Level.FINE.equals(object)) {
                stringBuffer.append("\u001b[34m");
            }
        }
        if (this.showLevel) {
            stringBuffer.append(logRecord.getLevel().getLocalizedName());
            stringBuffer.append(": ");
        }
        object = this.formatMessage(logRecord);
        stringBuffer.append((String)object);
        stringBuffer.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.useANSI) {
            stringBuffer.append("\u001b[30m");
        }
        return stringBuffer.toString();
    }
}

