/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Hashtable;
import sun.awt.EventListenerAggregate;

public class PropertyChangeSupport
implements Serializable {
    private transient EventListenerAggregate listeners;
    private Hashtable children;
    private Object source;
    private int propertyChangeSupportSerializedDataVersion = 2;
    static final long serialVersionUID = 6401253773779951803L;

    public PropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new EventListenerAggregate(PropertyChangeListener.class);
            }
            this.listeners.add(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        if (this.listeners != null) {
            arrayList.addAll(Arrays.asList(this.listeners.getListenersInternal()));
        }
        if (this.children != null) {
            for (String string : this.children.keySet()) {
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
                PropertyChangeListener[] propertyChangeListenerArray = propertyChangeSupport.getPropertyChangeListeners();
                for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
                    arrayList.add(new PropertyChangeListenerProxy(string, propertyChangeListenerArray[i]));
                }
            }
        }
        return arrayList.toArray(new PropertyChangeListener[0]);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        if (propertyChangeListener == null || string == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) == null) {
            propertyChangeSupport = new PropertyChangeSupport(this.source);
            this.children.put(string, propertyChangeSupport);
        }
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || string == null) {
            return;
        }
        if (this.children == null) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        PropertyChangeSupport propertyChangeSupport;
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>();
        if (this.children != null && string != null && (propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) != null) {
            arrayList.addAll(Arrays.asList(propertyChangeSupport.getPropertyChangeListeners()));
        }
        return arrayList.toArray(new PropertyChangeListener[0]);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        this.firePropertyChange(string, (Object)bl, (Object)bl2);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object2 != null && object3 != null && object2.equals(object3)) {
            return;
        }
        if (this.listeners != null) {
            object = this.listeners.getListenersInternal();
            for (int i = 0; i < ((EventListener[])object).length; ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object[i];
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        if (this.children != null && string != null) {
            object = null;
            object = (PropertyChangeSupport)this.children.get(string);
            if (object != null) {
                ((PropertyChangeSupport)object).firePropertyChange(propertyChangeEvent);
            }
        }
    }

    public void fireIndexedPropertyChange(String string, int n, Object object, Object object2) {
        this.firePropertyChange(new IndexedPropertyChangeEvent(this.source, string, object, object2, n));
    }

    public void fireIndexedPropertyChange(String string, int n, int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        this.fireIndexedPropertyChange(string, n, new Integer(n2), new Integer(n3));
    }

    public void fireIndexedPropertyChange(String string, int n, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        this.fireIndexedPropertyChange(string, n, (Object)bl, (Object)bl2);
    }

    public synchronized boolean hasListeners(String string) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && string != null && (propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) != null && propertyChangeSupport.listeners != null) {
            return !propertyChangeSupport.listeners.isEmpty();
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.listeners != null) {
            EventListener[] eventListenerArray = this.listeners.getListenersCopy();
            for (int i = 0; i < eventListenerArray.length; ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)eventListenerArray[i];
                if (!(propertyChangeListener instanceof Serializable)) continue;
                objectOutputStream.writeObject(propertyChangeListener);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

