/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelGrabber
implements ImageConsumer {
    ImageProducer producer;
    int dstX;
    int dstY;
    int dstW;
    int dstH;
    ColorModel imageModel;
    byte[] bytePixels;
    int[] intPixels;
    int dstOff;
    int dstScan;
    private boolean grabbing;
    private int flags;
    private static final int GRABBEDBITS = 48;
    private static final int DONEBITS = 112;

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this(image.getSource(), n, n2, n3, n4, nArray, n5, n6);
    }

    public PixelGrabber(ImageProducer imageProducer, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.producer = imageProducer;
        this.dstX = n;
        this.dstY = n2;
        this.dstW = n3;
        this.dstH = n4;
        this.dstOff = n5;
        this.dstScan = n6;
        this.intPixels = nArray;
        this.imageModel = ColorModel.getRGBdefault();
    }

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, boolean bl) {
        this.producer = image.getSource();
        this.dstX = n;
        this.dstY = n2;
        this.dstW = n3;
        this.dstH = n4;
        if (bl) {
            this.imageModel = ColorModel.getRGBdefault();
        }
    }

    public synchronized void startGrabbing() {
        if ((this.flags & 0x70) != 0) {
            return;
        }
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized boolean grabPixels(long l) throws InterruptedException {
        if ((this.flags & 0x70) != 0) {
            return (this.flags & 0x30) != 0;
        }
        long l2 = l + System.currentTimeMillis();
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
        while (this.grabbing) {
            long l3;
            if (l == 0L) {
                l3 = 0L;
            } else {
                l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) break;
            }
            this.wait(l3);
        }
        return (this.flags & 0x30) != 0;
    }

    public synchronized int getStatus() {
        return this.flags;
    }

    public synchronized int getWidth() {
        return this.dstW < 0 ? -1 : this.dstW;
    }

    public synchronized int getHeight() {
        return this.dstH < 0 ? -1 : this.dstH;
    }

    public synchronized Object getPixels() {
        return this.bytePixels == null ? this.intPixels : (int[])this.bytePixels;
    }

    public synchronized ColorModel getColorModel() {
        return this.imageModel;
    }

    @Override
    public void setDimensions(int n, int n2) {
        if (this.dstW < 0) {
            this.dstW = n - this.dstX;
        }
        if (this.dstH < 0) {
            this.dstH = n2 - this.dstY;
        }
        if (this.dstW <= 0 || this.dstH <= 0) {
            this.imageComplete(3);
        } else if (this.intPixels == null && this.imageModel == ColorModel.getRGBdefault()) {
            this.intPixels = new int[this.dstW * this.dstH];
            this.dstScan = this.dstW;
            this.dstOff = 0;
        }
        this.flags |= 3;
    }

    @Override
    public void setHints(int n) {
    }

    @Override
    public void setProperties(Hashtable<?, ?> hashtable) {
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
    }

    private void convertToRGB() {
        int n = this.dstW * this.dstH;
        int[] nArray = new int[n];
        if (this.bytePixels != null) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.imageModel.getRGB(this.bytePixels[i] & 0xFF);
            }
        } else if (this.intPixels != null) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.imageModel.getRGB(this.intPixels[i]);
            }
        }
        this.bytePixels = null;
        this.intPixels = nArray;
        this.dstScan = this.dstW;
        this.dstOff = 0;
        this.imageModel = ColorModel.getRGBdefault();
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        int n8;
        if (n2 < this.dstY) {
            n8 = this.dstY - n2;
            if (n8 >= n4) {
                return;
            }
            n5 += n6 * n8;
            n2 += n8;
            n4 -= n8;
        }
        if (n2 + n4 > this.dstY + this.dstH && (n4 = this.dstY + this.dstH - n2) <= 0) {
            return;
        }
        if (n < this.dstX) {
            n8 = this.dstX - n;
            if (n8 >= n3) {
                return;
            }
            n5 += n8;
            n += n8;
            n3 -= n8;
        }
        if (n + n3 > this.dstX + this.dstW && (n3 = this.dstX + this.dstW - n) <= 0) {
            return;
        }
        n8 = this.dstOff + (n2 - this.dstY) * this.dstScan + (n - this.dstX);
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colorModel;
            } else if (this.imageModel != colorModel) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                for (n7 = n4; n7 > 0; --n7) {
                    System.arraycopy(byArray, n5, this.bytePixels, n8, n3);
                    n5 += n6;
                    n8 += this.dstScan;
                }
            }
        }
        if (this.intPixels != null) {
            n7 = this.dstScan - n3;
            int n9 = n6 - n3;
            for (int i = n4; i > 0; --i) {
                for (int j = n3; j > 0; --j) {
                    this.intPixels[n8++] = colorModel.getRGB(byArray[n5++] & 0xFF);
                }
                n5 += n9;
                n8 += n7;
            }
        }
        this.flags |= 8;
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        if (n2 < this.dstY) {
            n7 = this.dstY - n2;
            if (n7 >= n4) {
                return;
            }
            n5 += n6 * n7;
            n2 += n7;
            n4 -= n7;
        }
        if (n2 + n4 > this.dstY + this.dstH && (n4 = this.dstY + this.dstH - n2) <= 0) {
            return;
        }
        if (n < this.dstX) {
            n7 = this.dstX - n;
            if (n7 >= n3) {
                return;
            }
            n5 += n7;
            n += n7;
            n3 -= n7;
        }
        if (n + n3 > this.dstX + this.dstW && (n3 = this.dstX + this.dstW - n) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colorModel;
            } else {
                this.convertToRGB();
            }
        }
        n7 = this.dstOff + (n2 - this.dstY) * this.dstScan + (n - this.dstX);
        if (this.imageModel == colorModel) {
            for (int i = n4; i > 0; --i) {
                System.arraycopy(nArray, n5, this.intPixels, n7, n3);
                n5 += n6;
                n7 += this.dstScan;
            }
        } else {
            if (this.imageModel != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int n8 = this.dstScan - n3;
            int n9 = n6 - n3;
            for (int i = n4; i > 0; --i) {
                for (int j = n3; j > 0; --j) {
                    this.intPixels[n7++] = colorModel.getRGB(nArray[n5++]);
                }
                n5 += n9;
                n7 += n8;
            }
        }
        this.flags |= 8;
    }

    @Override
    public synchronized void imageComplete(int n) {
        this.grabbing = false;
        switch (n) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public synchronized int status() {
        return this.flags;
    }
}

