/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.istack.internal.FinalArrayList;
import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import java.util.Set;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamHeader
extends AbstractHeaderImpl {
    protected final XMLStreamBuffer _mark;
    protected boolean _isMustUnderstand;
    @NotNull
    protected String _role;
    protected boolean _isRelay;
    protected String _localName;
    protected String _namespaceURI;
    private final FinalArrayList<Attribute> attributes;

    protected StreamHeader(XMLStreamReader xMLStreamReader, XMLStreamBuffer xMLStreamBuffer) {
        assert (xMLStreamReader != null && xMLStreamBuffer != null);
        this._mark = xMLStreamBuffer;
        this._localName = xMLStreamReader.getLocalName();
        this._namespaceURI = xMLStreamReader.getNamespaceURI();
        this.attributes = this.processHeaderAttributes(xMLStreamReader);
    }

    protected StreamHeader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this._localName = xMLStreamReader.getLocalName();
        this._namespaceURI = xMLStreamReader.getNamespaceURI();
        this.attributes = this.processHeaderAttributes(xMLStreamReader);
        this._mark = XMLStreamBuffer.createNewBufferFromXMLStreamReader(xMLStreamReader);
    }

    @Override
    public final boolean isIgnorable(@NotNull SOAPVersion sOAPVersion, @NotNull Set<String> set) {
        if (!this._isMustUnderstand) {
            return true;
        }
        if (set == null) {
            return true;
        }
        return !set.contains(this._role);
    }

    @Override
    @NotNull
    public String getRole(@NotNull SOAPVersion sOAPVersion) {
        assert (this._role != null);
        return this._role;
    }

    @Override
    public boolean isRelay() {
        return this._isRelay;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        return this._localName;
    }

    @Override
    public String getAttribute(String string, String string2) {
        if (this.attributes != null) {
            for (int i = this.attributes.size() - 1; i >= 0; --i) {
                Attribute attribute = (Attribute)this.attributes.get(i);
                if (!attribute.localName.equals(string2) || !attribute.nsUri.equals(string)) continue;
                return attribute.value;
            }
        }
        return null;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this._mark.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this._mark.writeToXMLStreamWriter(xMLStreamWriter);
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            XMLStreamBufferSource xMLStreamBufferSource = new XMLStreamBufferSource(this._mark);
            DOMResult dOMResult = new DOMResult();
            transformer.transform(xMLStreamBufferSource, dOMResult);
            Node node = dOMResult.getNode();
            if (node.getNodeType() == 9) {
                node = node.getFirstChild();
            }
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            Node node2 = sOAPHeader.getOwnerDocument().importNode(node, true);
            sOAPHeader.appendChild(node2);
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this._mark.writeTo(contentHandler);
    }

    @Override
    @NotNull
    public WSEndpointReference readAsEPR(AddressingVersion addressingVersion) throws XMLStreamException {
        return new WSEndpointReference(this._mark, addressingVersion);
    }

    protected abstract FinalArrayList<Attribute> processHeaderAttributes(XMLStreamReader var1);

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    protected static final class Attribute {
        final String nsUri;
        final String localName;
        final String value;

        public Attribute(String string, String string2, String string3) {
            this.nsUri = StreamHeader.fixNull(string);
            this.localName = string2;
            this.value = string3;
        }
    }
}

