/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import javax.xml.ws.handler.MessageContext;

public abstract class HandlerTube
extends AbstractFilterTubeImpl {
    HandlerTube cousinTube;
    HandlerProcessor processor;
    boolean remedyActionTaken = false;
    @Nullable
    private final WSDLPort port;
    boolean requestProcessingSucessful = false;
    Packet packet;
    private HandlerTubeExchange exchange;

    public HandlerTube(Tube tube, WSDLPort wSDLPort) {
        super(tube);
        this.port = wSDLPort;
    }

    public HandlerTube(Tube tube, HandlerTube handlerTube) {
        super(tube);
        this.cousinTube = handlerTube;
        this.port = handlerTube != null ? handlerTube.port : null;
    }

    protected HandlerTube(HandlerTube handlerTube, TubeCloner tubeCloner) {
        super(handlerTube, tubeCloner);
        if (handlerTube.cousinTube != null) {
            this.cousinTube = tubeCloner.copy(handlerTube.cousinTube);
        }
        this.port = handlerTube.port;
    }

    public NextAction processRequest(Packet packet) {
        this.packet = packet;
        this.setupExchange();
        if (this.isHandleFalse()) {
            this.remedyActionTaken = true;
            return this.doInvoke(this.next, this.packet);
        }
        this.setUpProcessor();
        MessageUpdatableContext messageUpdatableContext = this.getContext(this.packet);
        boolean bl = this.checkOneWay(this.packet);
        try {
            if (!this.isHandlerChainEmpty()) {
                boolean bl2 = this.callHandlersOnRequest(messageUpdatableContext, bl);
                messageUpdatableContext.updatePacket();
                if (!bl && !bl2) {
                    NextAction nextAction = this.doReturnWith(this.packet);
                    return nextAction;
                }
            }
            this.requestProcessingSucessful = true;
            NextAction nextAction = this.doInvoke(this.next, this.packet);
            return nextAction;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                if (this.packet.transportBackChannel != null) {
                    this.packet.transportBackChannel.close();
                }
                this.packet.setMessage(null);
                NextAction nextAction = this.doReturnWith(this.packet);
                return nextAction;
            }
            throw runtimeException;
        }
        finally {
            if (!this.requestProcessingSucessful) {
                this.cleanUpState(messageUpdatableContext.getMessageContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet packet) {
        this.packet = packet;
        MessageUpdatableContext messageUpdatableContext = this.getContext(this.packet);
        try {
            if (this.isHandleFalse() || this.packet.getMessage() == null) {
                NextAction nextAction = this.doReturnWith(this.packet);
                return nextAction;
            }
            boolean bl = this.isHandleFault(this.packet);
            if (!this.isHandlerChainEmpty()) {
                this.callHandlersOnResponse(messageUpdatableContext, bl);
            }
        }
        finally {
            this.cleanUpState(messageUpdatableContext.getMessageContext());
        }
        messageUpdatableContext.updatePacket();
        return this.doReturnWith(this.packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        try {
            NextAction nextAction = this.doThrow(throwable);
            return nextAction;
        }
        finally {
            MessageUpdatableContext messageUpdatableContext = this.getContext(this.packet);
            this.cleanUpState(messageUpdatableContext.getMessageContext());
        }
    }

    private void cleanUpState(MessageContext messageContext) {
        this.close(messageContext);
        this.exchange = null;
        this.requestProcessingSucessful = false;
    }

    abstract void callHandlersOnResponse(MessageUpdatableContext var1, boolean var2);

    abstract boolean callHandlersOnRequest(MessageUpdatableContext var1, boolean var2);

    private boolean checkOneWay(Packet packet) {
        if (this.port != null) {
            return packet.getMessage().isOneWay(this.port);
        }
        return packet.expectReply != null && packet.expectReply != false;
    }

    abstract void setUpProcessor();

    abstract boolean isHandlerChainEmpty();

    abstract MessageUpdatableContext getContext(Packet var1);

    protected abstract void close(MessageContext var1);

    protected abstract void closeCall(MessageContext var1);

    private boolean isHandleFault(Packet packet) {
        if (this.cousinTube != null) {
            return this.exchange.isHandleFault();
        }
        boolean bl = packet.getMessage().isFault();
        this.exchange.setHandleFault(bl);
        return bl;
    }

    final void setHandleFault() {
        this.exchange.setHandleFault(true);
    }

    private boolean isHandleFalse() {
        return this.exchange.isHandleFalse();
    }

    final void setHandleFalse() {
        this.exchange.setHandleFalse();
    }

    private void setupExchange() {
        if (this.exchange == null) {
            this.exchange = new HandlerTubeExchange();
            if (this.cousinTube != null) {
                this.cousinTube.exchange = this.exchange;
            }
        }
    }

    static final class HandlerTubeExchange {
        private boolean handleFalse;
        private boolean handleFault;

        HandlerTubeExchange() {
        }

        boolean isHandleFault() {
            return this.handleFault;
        }

        void setHandleFault(boolean bl) {
            this.handleFault = bl;
        }

        public boolean isHandleFalse() {
            return this.handleFalse;
        }

        void setHandleFalse() {
            this.handleFalse = true;
        }
    }
}

