/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.PipelineAssembler;
import com.sun.xml.internal.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.internal.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.pipe.StandaloneTubeAssembler;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class TubelineAssemblerFactory {
    private static final Logger logger = Logger.getLogger(TubelineAssemblerFactory.class.getName());

    public abstract TubelineAssembler doCreate(BindingID var1);

    public static TubelineAssembler create(ClassLoader classLoader, BindingID bindingID) {
        return TubelineAssemblerFactory.create(classLoader, bindingID, null);
    }

    public static TubelineAssembler create(ClassLoader classLoader, BindingID bindingID, @Nullable Container container) {
        Object object;
        TubelineAssembler object22;
        Iterator<PipelineAssemblerFactory> iterator;
        if (container != null && (iterator = container.getSPI(TubelineAssemblerFactory.class)) != null && (object22 = ((TubelineAssemblerFactory)((Object)iterator)).doCreate(bindingID)) != null) {
            return object22;
        }
        for (TubelineAssemblerFactory tubelineAssemblerFactory : ServiceFinder.find(TubelineAssemblerFactory.class, classLoader)) {
            object = tubelineAssemblerFactory.doCreate(bindingID);
            if (object == null) continue;
            logger.fine(tubelineAssemblerFactory.getClass() + " successfully created " + object);
            return object;
        }
        for (PipelineAssemblerFactory pipelineAssemblerFactory : ServiceFinder.find(PipelineAssemblerFactory.class, classLoader)) {
            object = pipelineAssemblerFactory.doCreate(bindingID);
            if (object == null) continue;
            logger.fine(pipelineAssemblerFactory.getClass() + " successfully created " + object);
            return new TubelineAssemblerAdapter((PipelineAssembler)object);
        }
        return new StandaloneTubeAssembler();
    }

    private static class TubelineAssemblerAdapter
    implements TubelineAssembler {
        private PipelineAssembler assembler;

        TubelineAssemblerAdapter(PipelineAssembler pipelineAssembler) {
            this.assembler = pipelineAssembler;
        }

        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext clientTubeAssemblerContext) {
            ClientPipeAssemblerContext clientPipeAssemblerContext = new ClientPipeAssemblerContext(clientTubeAssemblerContext.getAddress(), clientTubeAssemblerContext.getWsdlModel(), clientTubeAssemblerContext.getService(), clientTubeAssemblerContext.getBinding(), clientTubeAssemblerContext.getContainer());
            return PipeAdapter.adapt(this.assembler.createClient(clientPipeAssemblerContext));
        }

        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext serverTubeAssemblerContext) {
            return PipeAdapter.adapt(this.assembler.createServer((ServerPipeAssemblerContext)serverTubeAssemblerContext));
        }
    }
}

