/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RetrievalMethodResolver.class.getName());

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod");
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        block18: {
            try {
                RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
                Attr attr = retrievalMethod.getURIAttr();
                String string2 = retrievalMethod.getType();
                Transforms transforms = retrievalMethod.getTransforms();
                ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
                if (resourceResolver != null) {
                    XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    }
                    if (transforms != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "We have Transforms");
                        }
                        xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Resolved to resource " + xMLSignatureInput.getSourceURI());
                    }
                    byte[] byArray = xMLSignatureInput.getBytes();
                    if (string2 != null && string2.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                        if (x509Certificate != null) {
                            return x509Certificate.getPublicKey();
                        }
                    } else {
                        KeyResolver keyResolver;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
                        }
                        Element element2 = this.getDocFromBytes(byArray);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                        }
                        if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                            return keyResolver.resolvePublicKey(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                        }
                    }
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
                }
            }
            catch (CertificateException certificateException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CertificateException", certificateException);
                }
            }
            catch (IOException iOException) {
                if (!log.isLoggable(Level.FINE)) break block18;
                log.log(Level.FINE, "IOException", iOException);
            }
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        block19: {
            try {
                ResourceResolver resourceResolver;
                RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
                Attr attr = retrievalMethod.getURIAttr();
                Transforms transforms = retrievalMethod.getTransforms();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Asked to resolve URI " + attr);
                }
                if ((resourceResolver = ResourceResolver.getInstance(attr, string)) != null) {
                    XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    }
                    if (transforms != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "We have Transforms");
                        }
                        xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Resolved to resource " + xMLSignatureInput.getSourceURI());
                    }
                    byte[] byArray = xMLSignatureInput.getBytes();
                    if (retrievalMethod.getType() != null && retrievalMethod.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                        if (x509Certificate != null) {
                            return x509Certificate;
                        }
                    } else {
                        KeyResolver keyResolver;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
                        }
                        Element element2 = this.getDocFromBytes(byArray);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                        }
                        if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                            return keyResolver.resolveX509Certificate(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                        }
                    }
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
                }
            }
            catch (CertificateException certificateException) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CertificateException", certificateException);
                }
            }
            catch (IOException iOException) {
                if (!log.isLoggable(Level.FINE)) break block19;
                log.log(Level.FINE, "IOException", iOException);
            }
        }
        return null;
    }

    Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static Element getFirstElementChild(Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }
}

