/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.Serializable;
import sun.org.mozilla.javascript.internal.ClassShutter;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeJavaClass;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;

public class NativeJavaPackage
extends ScriptableObject {
    static final long serialVersionUID = 7445054382212031523L;
    private String packageName;
    private ClassLoader classLoader;

    NativeJavaPackage(boolean bl, String string, ClassLoader classLoader) {
        this.packageName = string;
        this.classLoader = classLoader;
    }

    public NativeJavaPackage(String string, ClassLoader classLoader) {
        this(false, string, classLoader);
    }

    public NativeJavaPackage(String string) {
        this(false, string, Context.getCurrentContext().getApplicationClassLoader());
    }

    public String getClassName() {
        return "JavaPackage";
    }

    public boolean has(String string, Scriptable scriptable) {
        return true;
    }

    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    public void put(String string, Scriptable scriptable, Object object) {
    }

    public void put(int n, Scriptable scriptable, Object object) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    public Object get(String string, Scriptable scriptable) {
        return this.getPkgProperty(string, scriptable, true);
    }

    public Object get(int n, Scriptable scriptable) {
        return NOT_FOUND;
    }

    void forcePackage(String string, Scriptable scriptable) {
        NativeJavaPackage nativeJavaPackage;
        String string2;
        Object object;
        int n = string.indexOf(46);
        if (n == -1) {
            n = string.length();
        }
        if ((object = super.get(string2 = string.substring(0, n), (Scriptable)this)) != null && object instanceof NativeJavaPackage) {
            nativeJavaPackage = (NativeJavaPackage)object;
        } else {
            String string3 = this.packageName.length() == 0 ? string2 : this.packageName + "." + string2;
            nativeJavaPackage = new NativeJavaPackage(true, string3, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent(nativeJavaPackage, scriptable);
            super.put(string2, (Scriptable)this, (Object)nativeJavaPackage);
        }
        if (n < string.length()) {
            nativeJavaPackage.forcePackage(string.substring(n + 1), scriptable);
        }
    }

    synchronized Object getPkgProperty(String string, Scriptable scriptable, boolean bl) {
        Serializable serializable;
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        String string2 = this.packageName.length() == 0 ? string : this.packageName + '.' + string;
        Context context = Context.getContext();
        ClassShutter classShutter = context.getClassShutter();
        Serializable serializable2 = null;
        if (classShutter == null || classShutter.visibleToScripts(string2)) {
            serializable = null;
            serializable = this.classLoader != null ? Kit.classOrNull(this.classLoader, string2) : Kit.classOrNull(string2);
            if (serializable != null) {
                serializable2 = new NativeJavaClass(NativeJavaPackage.getTopLevelScope(this), (Class)serializable);
                serializable2.setPrototype(this.getPrototype());
            }
        }
        if (serializable2 == null && bl) {
            serializable = new NativeJavaPackage(true, string2, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent((ScriptableObject)serializable, this.getParentScope());
            serializable2 = serializable;
        }
        if (serializable2 != null) {
            super.put(string, scriptable, serializable2);
        }
        return serializable2;
    }

    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }
}

