/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly;

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, CellRendererPane cellRendererPane, JList jList) {
        this(jComboBox, icon, jComboBox.isEditable(), cellRendererPane, jList);
    }

    public MetalComboBoxButton(JComboBox jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList jList) {
        if (jComboBox == null) {
            throw new NullPointerException("Null 'cb' argument");
        }
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl;
        this.listBox = jList;
        this.rendererPane = cellRendererPane;
        this.setRolloverEnabled(false);
        this.setEnabled(this.comboBox.isEnabled());
        this.setFocusable(this.comboBox.isEnabled());
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n = this.getWidth() - (insets.left + insets.right);
        int n2 = this.getHeight() - (insets.top + insets.bottom);
        if (n2 > 0 && n > 0) {
            int n3;
            int n4 = insets.left;
            int n5 = insets.top;
            int n6 = n4 + (n - 1);
            int n7 = n5 + (n2 - 1);
            int n8 = 0;
            int n9 = n6;
            if (this.comboIcon != null) {
                n8 = this.comboIcon.getIconWidth();
                int n10 = this.comboIcon.getIconHeight();
                if (this.iconOnly) {
                    n9 = this.getWidth() / 2 - n8 / 2;
                    n3 = this.getHeight() / 2 - n10 / 2;
                } else {
                    n9 = n4 + (n - 1) - n8;
                    n3 = n5 + (n7 - n5) / 2 - n10 / 2;
                }
                this.comboIcon.paintIcon(this, graphics, n9, n3);
                if (this.hasFocus()) {
                    graphics.setColor(MetalLookAndFeel.getFocusColor());
                    graphics.drawRect(n4 - 1, n5 - 1, n + 3, n2 + 1);
                }
            }
            if (!this.iconOnly && this.comboBox != null) {
                ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
                n3 = this.getModel().isPressed();
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
                component.setFont(this.rendererPane.getFont());
                if (this.model.isArmed() && this.model.isPressed() || this.comboBox.isFocusOwner() && !this.comboBox.isPopupVisible()) {
                    if (this.isOpaque()) {
                        component.setBackground(UIManager.getColor("Button.select"));
                        component.setForeground(this.comboBox.getForeground());
                    }
                } else if (!this.comboBox.isEnabled()) {
                    if (this.isOpaque()) {
                        Color color = UIManager.getColor("ComboBox.disabledBackground");
                        component.setBackground(color);
                        Color color2 = UIManager.getColor("ComboBox.disabledForeground");
                        component.setForeground(color2);
                    }
                } else {
                    component.setForeground(this.comboBox.getForeground());
                    component.setBackground(this.comboBox.getBackground());
                }
                int n11 = n - (insets.right + n8);
                this.rendererPane.paintComponent(graphics, component, this, n4, n5, n11, n2);
            }
        }
    }
}

