/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

public class NamingManager {
    public static final String CPE = "java.naming.spi.CannotProceedException";
    private static InitialContextFactoryBuilder icfb;
    static ObjectFactoryBuilder ofb;

    NamingManager() {
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return icfb != null;
    }

    public static Context getInitialContext(Hashtable hashtable) throws NamingException {
        InitialContextFactory initialContextFactory = null;
        if (icfb != null) {
            initialContextFactory = icfb.createInitialContextFactory(hashtable);
        } else {
            String string = null;
            if (hashtable != null) {
                string = (String)hashtable.get("java.naming.factory.initial");
            }
            if (string == null) {
                string = System.getProperty("java.naming.factory.initial");
            }
            if (string == null) {
                throw new NoInitialContextException("Can't find property: java.naming.factory.initial");
            }
            try {
                initialContextFactory = (InitialContextFactory)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception exception) {
                NoInitialContextException noInitialContextException = new NoInitialContextException("Can't load InitialContextFactory class: " + string);
                noInitialContextException.setRootCause(exception);
                throw noInitialContextException;
            }
        }
        return initialContextFactory.getInitialContext(hashtable);
    }

    static Context getURLContext(Object object, Name name, Context context, String string, Hashtable hashtable) throws NamingException {
        String string2;
        String string3 = "com.sun.jndi.url";
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null && (string2 = (String)hashtable.get("java.naming.factory.url.pkgs")) != null) {
            stringBuffer.append(string2);
        }
        if ((string2 = System.getProperty("java.naming.factory.url.pkgs")) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(':');
        }
        stringBuffer.append(string3);
        string = string + "." + string + "URLContextFactory";
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            try {
                ObjectFactory objectFactory;
                Object object2;
                Context context2;
                String string5 = string4 + "." + string;
                Class clazz = NamingManager.forName(string5);
                if (clazz == null || (context2 = (Context)(object2 = (objectFactory = (ObjectFactory)clazz.newInstance()).getObjectInstance(object, name, context, hashtable))) == null) continue;
                return context2;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    static Class forName(String string) {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Context getURLContext(String string, Hashtable hashtable) throws NamingException {
        return NamingManager.getURLContext(null, null, null, string, hashtable);
    }

    public static void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws NamingException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (ofb != null) {
            throw new IllegalStateException("object factory builder already installed");
        }
        if (objectFactoryBuilder != null) {
            ofb = objectFactoryBuilder;
        }
    }

    static StringTokenizer getPlusPath(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = (String)hashtable.get(string);
        if (context == null) {
            context = NamingManager.getInitialContext(hashtable);
        }
        String string3 = (String)context.getEnvironment().get(string);
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null) {
            string2 = string2 + new StringBuffer(":").append(string3);
        }
        return new StringTokenizer(string2 != null ? string2 : "", ":");
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object object2;
        ObjectFactory objectFactory = null;
        if (ofb != null) {
            objectFactory = ofb.createObjectFactory(object, hashtable);
        } else {
            Object object3;
            Object object4;
            String string;
            Object object5;
            object2 = object;
            if (object instanceof Referenceable) {
                object2 = ((Referenceable)object).getReference();
            }
            if (object2 instanceof Reference) {
                object5 = (Reference)object2;
                string = ((Reference)object5).getFactoryClassName();
                if (string != null) {
                    object4 = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    objectFactory = (ObjectFactory)((Class)object4).newInstance();
                } else {
                    object4 = ((Reference)object5).getAll();
                    while (object4.hasMoreElements()) {
                        Object object6;
                        object3 = (RefAddr)object4.nextElement();
                        if (!(object3 instanceof StringRefAddr) || !"URL".equals(((RefAddr)object3).getType()) || (object6 = (objectFactory = (ObjectFactory)((Object)NamingManager.getURLContext(object, name, context, (String)((RefAddr)object3).getContent(), hashtable))).getObjectInstance(object, name, context, hashtable)) == null) continue;
                        return object6;
                    }
                    objectFactory = null;
                }
            }
            if (objectFactory == null) {
                object5 = NamingManager.getPlusPath("java.naming.factory.object", hashtable, context);
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    string = ((StringTokenizer)object5).nextToken();
                    object4 = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    objectFactory = (ObjectFactory)((Class)object4).newInstance();
                    object3 = objectFactory.getObjectInstance(object, name, context, hashtable);
                    if (object3 == null) continue;
                    return object3;
                }
                return object;
            }
        }
        if (objectFactory == null) {
            return object;
        }
        object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws NamingException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (icfb != null) {
            throw new IllegalStateException("ctx factory builder already installed");
        }
        if (initialContextFactoryBuilder != null) {
            icfb = initialContextFactoryBuilder;
        }
    }

    public static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        Hashtable hashtable = cannotProceedException.getEnvironment();
        if (hashtable != null) {
            hashtable.put(CPE, cannotProceedException);
        }
        try {
            Object object = NamingManager.getObjectInstance(cannotProceedException.getResolvedObj(), cannotProceedException.getAltName(), cannotProceedException.getAltNameCtx(), hashtable);
            if (object != null) {
                return (Context)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cannotProceedException.fillInStackTrace();
        throw cannotProceedException;
    }

    public static Object getStateToBind(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        StringTokenizer stringTokenizer = NamingManager.getPlusPath("java.naming.factory.state", hashtable, context);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                Class clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                StateFactory stateFactory = (StateFactory)clazz.newInstance();
                Object object2 = stateFactory.getStateToBind(object, name, context, hashtable);
                if (object2 == null) continue;
                return object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return object;
    }
}

