/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 3388685877147921107L;
    int count;
    char[] value;
    boolean shared;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
    }

    public StringBuffer(String string) {
        this.count = string.count;
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public StringBuffer(CharSequence charSequence) {
        this.count = Math.max(0, charSequence.length());
        this.value = new char[this.count + 16];
        for (int i = 0; i < this.count; ++i) {
            this.value[i] = charSequence.charAt(i);
        }
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int n) {
        this.ensureCapacity_unsynchronized(n);
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.value.length;
        this.ensureCapacity_unsynchronized(n);
        if (n < n2) {
            this.count = n;
        } else {
            while (this.count < n) {
                this.value[this.count++] = '\u0000';
            }
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public synchronized int codePointAt(int n) {
        return Character.codePointAt(this.value, n, this.count);
    }

    public synchronized int codePointBefore(int n) {
        if (n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBefore(this.value, n, 1);
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[n] = c;
    }

    public StringBuffer append(Object object) {
        return this.append(object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.count;
        this.ensureCapacity_unsynchronized(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            StringBuffer stringBuffer3;
            try {
                int n = stringBuffer.count;
                this.ensureCapacity_unsynchronized(this.count + n);
                System.arraycopy(stringBuffer.value, 0, this.value, this.count, n);
                this.count += n;
            }
            finally {
                stringBuffer3 = null;
            }
            stringBuffer3 = this;
            return stringBuffer3;
        }
    }

    public synchronized StringBuffer append(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public synchronized StringBuffer append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n2 - n);
        for (int i = n; i < n2; ++i) {
            this.value[this.count++] = charSequence.charAt(i);
        }
        return this;
    }

    public StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public synchronized StringBuffer append(char c) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public synchronized StringBuffer appendCodePoint(int n) {
        int n2 = Character.charCount(n);
        this.ensureCapacity_unsynchronized(this.count + n2);
        Character.toChars(n, this.value, this.count);
        this.count += n2;
        return this;
    }

    public native StringBuffer append(int var1);

    public StringBuffer append(long l) {
        return this.append(Long.toString(l, 10));
    }

    public StringBuffer append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBuffer append(double d) {
        return this.append(Double.toString(d));
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - n2 != 0) {
            System.arraycopy(this.value, n2, this.value, n, this.count - n2);
        }
        this.count -= n2 - n;
        return this;
    }

    public StringBuffer deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public synchronized StringBuffer replace(int n, int n2, String string) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n3 = string.count;
        int n4 = n3 - (n2 > this.count ? this.count : n2) + n;
        this.ensureCapacity_unsynchronized(this.count + n4);
        if (n4 != 0 && n2 < this.count) {
            System.arraycopy(this.value, n2, this.value, n2 + n4, this.count - n2);
        }
        string.getChars(0, n3, this.value, n);
        this.count += n4;
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public synchronized String substring(int n, int n2) {
        boolean bl;
        int n3 = n2 - n;
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return "";
        }
        boolean bl2 = bl = n3 << 2 >= this.value.length;
        if (bl) {
            this.shared = true;
        }
        return new String(this.value, n, n3, bl);
    }

    public synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.count || n3 < 0 || n2 < 0 || n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n3);
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count += n3;
        return this;
    }

    public StringBuffer insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.count;
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public synchronized StringBuffer insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public synchronized StringBuffer insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n2 < 0 || n3 < 0 || n2 > n3 || n3 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        this.ensureCapacity_unsynchronized(this.count + n4);
        System.arraycopy(this.value, n, this.value, n + n4, this.count - n);
        for (int i = n2; i < n3; ++i) {
            this.value[n++] = charSequence.charAt(i);
        }
        this.count += n4;
        return this;
    }

    public StringBuffer insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public synchronized StringBuffer insert(int n, char c) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, Long.toString(l, 10));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, Float.toString(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, Double.toString(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.count - string.count;
        while (n <= n2) {
            if (this.regionMatches(n, string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count - string.count);
    }

    public synchronized int lastIndexOf(String string, int n) {
        for (n = Math.min(n, this.count - string.count); n >= 0; --n) {
            if (!this.regionMatches(n, string)) continue;
            return n;
        }
        return -1;
    }

    public synchronized StringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        int n = this.count >> 1;
        int n2 = this.count - n;
        while (--n >= 0) {
            char c = this.value[n];
            this.value[n] = this.value[n2];
            this.value[n2] = c;
            ++n2;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    public synchronized void trimToSize() {
        int n = this.value.length - this.count;
        if (n < 20) {
            return;
        }
        if (n > 200 || n * 4 > this.value.length) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public synchronized int codePointCount(int n, int n2) {
        if (n < 0 || n2 >= this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n < n2) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != n2 && n != n3 && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            ++n3;
        }
        return n3;
    }

    public synchronized int offsetByCodePoints(int n, int n2) {
        while (n2 > 0) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != this.count && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            --n2;
        }
        return n;
    }

    private void ensureCapacity_unsynchronized(int n) {
        if (this.shared || n > this.value.length) {
            int n2 = n > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            n = n < n2 ? n2 : n;
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }

    private native boolean regionMatches(int var1, String var2);
}

