/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ShapeGraphicAttribute
extends GraphicAttribute {
    public static final boolean FILL = false;
    public static final boolean STROKE = true;
    private Shape shape;
    private boolean stroke;
    private Rectangle2D bounds;

    public ShapeGraphicAttribute(Shape shape, int n, boolean bl) {
        super(n);
        this.shape = shape;
        this.stroke = bl;
        this.bounds = shape.getBounds2D();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.translate(f, f2);
        if (this.stroke) {
            graphics2D.draw(this.shape);
        } else {
            graphics2D.fill(this.shape);
        }
        graphics2D.translate(-f, -f2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShapeGraphicAttribute)) {
            return false;
        }
        return this.equals((ShapeGraphicAttribute)object);
    }

    public boolean equals(ShapeGraphicAttribute shapeGraphicAttribute) {
        return this == shapeGraphicAttribute || this.shape.equals(shapeGraphicAttribute.shape) && this.getAlignment() == shapeGraphicAttribute.getAlignment() && this.stroke == shapeGraphicAttribute.stroke && this.getAdvance() == shapeGraphicAttribute.getAdvance() && this.getAscent() == shapeGraphicAttribute.getAscent() && this.getBounds().equals(shapeGraphicAttribute.getBounds()) && this.getDescent() == shapeGraphicAttribute.getDescent() && this.hashCode() == shapeGraphicAttribute.hashCode();
    }

    public float getAdvance() {
        return Math.max(0.0f, (float)this.bounds.getMaxX());
    }

    public float getAscent() {
        return Math.max(0.0f, -((float)this.bounds.getMinY()));
    }

    public float getDescent() {
        return Math.max(0.0f, (float)this.bounds.getMaxY());
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float_.setRect(this.bounds);
        if (this.stroke) {
            float_.width += 1.0f;
            float_.height += 1.0f;
        }
        return float_;
    }

    public int hashCode() {
        return this.shape.hashCode();
    }
}

