/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    static final DataFlavor[] supported_flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String data;

    public StringSelection(String string) {
        this.data = string;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return supported_flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < supported_flavors.length; ++i) {
            if (!supported_flavors[i].equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (DataFlavor.plainTextFlavor == dataFlavor) {
            return new StringReader(this.data);
        }
        return this.data;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

