/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.SignatureFactory;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.sig.rsa.RSA;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.KeyAgreementFactory;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.GnuDHKey;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.prng.ARCFour;
import gnu.javax.crypto.sasl.srp.SRPAuthInfoProvider;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.DiffieHellman;
import gnu.javax.net.ssl.provider.DigestInputStream;
import gnu.javax.net.ssl.provider.DigestOutputStream;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Extensions;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.GNUSecurityParameters;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyPool;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.RecordInput;
import gnu.javax.net.ssl.provider.RecordInputStream;
import gnu.javax.net.ssl.provider.RecordOutputStream;
import gnu.javax.net.ssl.provider.SSLRSASignature;
import gnu.javax.net.ssl.provider.SSLRandom;
import gnu.javax.net.ssl.provider.SSLSocketInputStream;
import gnu.javax.net.ssl.provider.SSLSocketOutputStream;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.TLSRandom;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.security.auth.callback.DefaultCallbackHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;

final class SSLSocket
extends javax.net.ssl.SSLSocket {
    private static final boolean DEBUG_HANDSHAKE_LAYER = true;
    private static final boolean DEBUG_KEY_EXCHANGE = false;
    private static final Logger logger = SystemLogger.SYSTEM;
    private Socket underlyingSocket;
    private int underlyingPort;
    private boolean autoClose;
    SessionContext sessionContext;
    Session session;
    LinkedList handshakeListeners;
    private boolean clientMode;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean createSessions;
    private boolean handshakeDone;
    private String remoteHost;
    private InputStream socketIn;
    private OutputStream socketOut;
    private InputStream applicationIn;
    private OutputStream applicationOut;
    private InputStream handshakeIn;
    private OutputStream handshakeOut;
    RecordInput recordInput;
    private long handshakeTime;
    private SocketChannel channel;
    static SortedSet supportedProtocols = new TreeSet();
    static List supportedSuites = new ArrayList(30);
    private static final byte[] SENDER_CLIENT;
    private static final byte[] SENDER_SERVER;

    SSLSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        this.underlyingSocket = socket;
        this.remoteHost = string;
        this.underlyingPort = n;
        this.autoClose = bl;
        this.initialize();
    }

    SSLSocket(Socket socket, SocketChannel socketChannel) throws IOException {
        this.underlyingSocket = socket;
        this.channel = socketChannel;
        this.initialize();
    }

    SSLSocket() throws IOException {
        this.initialize();
    }

    SSLSocket(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.initialize();
        this.remoteHost = inetAddress.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = inetAddress.getHostAddress();
        }
    }

    SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.initialize();
        this.remoteHost = inetAddress.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = inetAddress.getHostAddress();
        }
    }

    SSLSocket(String string, int n) throws IOException {
        super(string, n);
        this.initialize();
        this.remoteHost = string;
    }

    SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
        this.initialize();
        this.remoteHost = string;
    }

    private void initialize() {
        this.session = new Session();
        this.session.enabledSuites = new ArrayList(supportedSuites);
        this.session.enabledProtocols = new TreeSet(supportedProtocols);
        this.session.protocol = ProtocolVersion.TLS_1;
        this.session.params.setVersion(ProtocolVersion.TLS_1);
        this.handshakeListeners = new LinkedList();
        this.handshakeDone = false;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            block4: {
                try {
                    if (handshakeCompletedListener == null) {
                        throw new NullPointerException();
                    }
                    if (this.handshakeListeners.contains(handshakeCompletedListener)) break block4;
                    this.handshakeListeners.add(handshakeCompletedListener);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            try {
                this.handshakeListeners.remove(handshakeCompletedListener);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public String[] getEnabledProtocols() {
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            try {
                try {
                    String[] stringArray = (String[])Util.transform(this.session.enabledProtocols.toArray(), SSLSocket.class$("java.lang.String"), "toString", null);
                    Object var3_3 = null;
                    return stringArray;
                }
                catch (Exception exception) {
                    RuntimeException runtimeException = new RuntimeException(exception.getMessage());
                    runtimeException.initCause(exception);
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("SSLv3") || stringArray[i].equalsIgnoreCase("TLSv1") || stringArray[i].equalsIgnoreCase("TLSv1.1")) continue;
            throw new IllegalArgumentException("unsupported protocol: " + stringArray[i]);
        }
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            try {
                this.session.enabledProtocols.clear();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equalsIgnoreCase("SSLv3")) {
                        this.session.enabledProtocols.add(ProtocolVersion.SSL_3);
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("TLSv1")) {
                        this.session.enabledProtocols.add(ProtocolVersion.TLS_1);
                        continue;
                    }
                    this.session.enabledProtocols.add(ProtocolVersion.TLS_1_1);
                }
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
        }
    }

    public String[] getSupportedProtocols() {
        return new String[]{"TLSv1", "SSLv3"};
    }

    public String[] getEnabledCipherSuites() {
        List list2 = this.session.enabledSuites;
        synchronized (list2) {
            try {
                try {
                    String[] stringArray = (String[])Util.transform(this.session.enabledSuites.toArray(), SSLSocket.class$("java.lang.String"), "toString", null);
                    Object var3_3 = null;
                    return stringArray;
                }
                catch (Exception exception) {
                    RuntimeException runtimeException = new RuntimeException(exception.getMessage());
                    runtimeException.initCause(exception);
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (CipherSuite.forName(stringArray[i]) != null) continue;
            throw new IllegalArgumentException("unsupported suite: " + stringArray[i]);
        }
        List list2 = this.session.enabledSuites;
        synchronized (list2) {
            try {
                this.session.enabledSuites.clear();
                for (int i = 0; i < stringArray.length; ++i) {
                    CipherSuite cipherSuite = CipherSuite.forName(stringArray[i]);
                    if (this.session.enabledSuites.contains(cipherSuite)) continue;
                    this.session.enabledSuites.add(cipherSuite);
                }
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
        }
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[52]);
    }

    public SSLSession getSession() {
        return this.session;
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.createSessions = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public void setUseClientMode(boolean bl) {
        this.clientMode = bl;
    }

    public synchronized void startHandshake() throws IOException {
        logger.log((Level)Component.SSL_HANDSHAKE, "startHandshake called in {0}", Thread.currentThread());
        this.handshakeTime = System.currentTimeMillis();
        if (this.handshakeDone) {
            if (this.clientMode) {
                this.handshakeDone = false;
                this.doClientHandshake();
            } else {
                Handshake handshake = new Handshake(Handshake.Type.HELLO_REQUEST, null);
                handshake.write(this.handshakeOut, this.session.protocol);
                this.handshakeOut.flush();
            }
            return;
        }
        if (this.recordInput == null) {
            this.setupIO();
        }
        if (this.clientMode) {
            this.doClientHandshake();
        } else {
            this.doServerHandshake();
        }
    }

    public InetAddress getInetAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getInetAddress();
        }
        return super.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalAddress();
        }
        return super.getLocalAddress();
    }

    public int getPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getPort();
        }
        return super.getPort();
    }

    public int getLocalPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalPort();
        }
        return super.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        if (this.applicationIn == null) {
            this.setupIO();
        }
        return this.applicationIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.applicationOut == null) {
            this.setupIO();
        }
        return this.applicationOut;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setTcpNoDelay(bl);
        } else {
            super.setTcpNoDelay(bl);
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getTcpNoDelay();
        }
        return super.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoLinger(bl, n);
        } else {
            super.setSoLinger(bl, n);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoLinger();
        }
        return super.getSoLinger();
    }

    public void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setSoTimeout(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoTimeout(n);
        } else {
            super.setSoTimeout(n);
        }
    }

    public int getSoTimeout() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSendBufferSize(n);
        } else {
            super.setSendBufferSize(n);
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSendBufferSize();
        }
        return super.getSendBufferSize();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setReceiveBufferSize(n);
        } else {
            super.setReceiveBufferSize(n);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getReceiveBufferSize();
        }
        return super.getReceiveBufferSize();
    }

    public synchronized void close() throws IOException {
        if (this.recordInput == null) {
            if (this.underlyingSocket != null) {
                if (this.autoClose) {
                    this.underlyingSocket.close();
                }
            } else {
                super.close();
            }
            return;
        }
        Alert alert = new Alert(Alert.Level.WARNING, Alert.Description.CLOSE_NOTIFY);
        this.sendAlert(alert);
        long l = System.currentTimeMillis() + 60000L;
        while (this.session.currentAlert == null && !this.recordInput.pollClose()) {
            Thread.yield();
            if (l > System.currentTimeMillis()) continue;
            break;
        }
        boolean bl = this.session.currentAlert != null && this.session.currentAlert.getDescription() == Alert.Description.CLOSE_NOTIFY;
        this.recordInput = null;
        if (this.underlyingSocket != null) {
            if (this.autoClose) {
                this.underlyingSocket.close();
            }
        } else {
            super.close();
        }
        if (!bl) {
            this.session.invalidate();
            throw new SSLException("did not receive close notify");
        }
    }

    public String toString() {
        if (this.underlyingSocket != null) {
            return SSLSocket.class$("gnu.javax.net.ssl.provider.SSLSocket").getName() + " [ " + this.underlyingSocket + " ]";
        }
        return SSLSocket.class$("gnu.javax.net.ssl.provider.SSLSocket").getName() + " [ " + super.toString() + " ]";
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.connect(socketAddress);
        } else {
            super.connect(socketAddress);
        }
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.connect(socketAddress, n);
        } else {
            super.connect(socketAddress, n);
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.bind(socketAddress);
        } else {
            super.bind(socketAddress);
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalSocketAddress();
        }
        return super.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public boolean isBound() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isBound();
        }
        return super.isBound();
    }

    public boolean isClosed() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isClosed();
        }
        return super.isClosed();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getRemoteSocketAddress();
        }
        return super.getRemoteSocketAddress();
    }

    public void setOOBInline(boolean bl) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setOOBInline(bl);
        } else {
            super.setOOBInline(bl);
        }
    }

    public boolean getOOBInline() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getOOBInline();
        }
        return super.getOOBInline();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setKeepAlive(bl);
        } else {
            super.setKeepAlive(bl);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getKeepAlive();
        }
        return super.getKeepAlive();
    }

    public void setTrafficClass(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setTrafficClass(n);
        } else {
            super.setTrafficClass(n);
        }
    }

    public int getTrafficClass() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getTrafficClass();
        }
        return super.getTrafficClass();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setReuseAddress(bl);
        } else {
            super.setReuseAddress(bl);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getReuseAddress();
        }
        return super.getReuseAddress();
    }

    public void shutdownInput() throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.shutdownInput();
        } else {
            super.shutdownInput();
        }
    }

    public void shutdownOutput() throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.shutdownOutput();
        } else {
            super.shutdownOutput();
        }
    }

    public boolean isConnected() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isConnected();
        }
        return super.isConnected();
    }

    public boolean isInputShutdown() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isInputShutdown();
        }
        return super.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isOutputShutdown();
        }
        return super.isOutputShutdown();
    }

    protected void finalize() {
        if (this.session.currentAlert == null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    void setEnabledCipherSuites(List list2) {
        this.session.enabledSuites = list2;
    }

    void setEnabledProtocols(SortedSet sortedSet) {
        this.session.enabledProtocols = sortedSet;
    }

    void setSRPTrustManager(SRPTrustManager sRPTrustManager) {
        this.session.srpTrustManager = sRPTrustManager;
    }

    void setTrustManager(X509TrustManager x509TrustManager) {
        this.session.trustManager = x509TrustManager;
    }

    void setKeyManager(X509KeyManager x509KeyManager) {
        this.session.keyManager = x509KeyManager;
    }

    void setRandom(SecureRandom secureRandom) {
        this.session.random = secureRandom;
    }

    void sendAlert(Alert alert) throws IOException {
        RecordOutputStream recordOutputStream = new RecordOutputStream(this.socketOut, ContentType.ALERT, this.session.params);
        recordOutputStream.write(alert.getEncoded());
    }

    Alert checkAlert() {
        return this.session.currentAlert;
    }

    synchronized void checkHandshakeDone() throws IOException {
        Alert alert;
        if (!this.handshakeDone) {
            this.startHandshake();
        }
        if ((alert = this.session.currentAlert) != null && alert.getLevel() == Alert.Level.FATAL) {
            throw new AlertException(alert, false);
        }
        if (this.handshakeIn.available() > 0 && !this.clientMode) {
            this.handshakeDone = false;
            this.startHandshake();
        }
    }

    private void changeCipherSpec() throws IOException {
        RecordOutputStream recordOutputStream = new RecordOutputStream(this.socketOut, ContentType.CHANGE_CIPHER_SPEC, this.session.params);
        recordOutputStream.write(1);
    }

    private void readChangeCipherSpec() throws IOException {
        RecordInputStream recordInputStream = new RecordInputStream(this.recordInput, ContentType.CHANGE_CIPHER_SPEC);
        if (recordInputStream.read() != 1) {
            throw new SSLProtocolException("bad change cipher spec message");
        }
    }

    private synchronized void setupIO() throws IOException {
        if (this.recordInput != null) {
            return;
        }
        if (this.underlyingSocket != null) {
            this.socketIn = this.underlyingSocket.getInputStream();
            this.socketOut = this.underlyingSocket.getOutputStream();
        } else {
            this.socketIn = super.getInputStream();
            this.socketOut = super.getOutputStream();
        }
        this.recordInput = new RecordInput(this.socketIn, this.session);
        this.applicationIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.APPLICATION_DATA), this);
        this.applicationOut = new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.APPLICATION_DATA, this.session.params), this);
        this.handshakeIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.HANDSHAKE), this, false);
        this.handshakeOut = new BufferedOutputStream(new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.HANDSHAKE, this.session.params), this, false), 8096);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handshakeCompleted() {
        this.handshakeDone = true;
        HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.session);
        Object object = this.handshakeListeners.iterator();
        while (object.hasNext()) {
            try {
                ((HandshakeCompletedListener)object.next()).handshakeCompleted(handshakeCompletedEvent);
            }
            catch (Throwable throwable) {}
        }
        if (this.createSessions) {
            object = this.session;
            // MONITORENTER : object
            try {
                this.sessionContext.addSession(this.session.sessionId, this.session);
                this.session.access();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                // MONITOREXIT : object
                throw throwable;
            }
            Object var3_4 = null;
            // MONITOREXIT : object
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "Handshake finished in {0}", Thread.currentThread());
        this.handshakeTime = System.currentTimeMillis() - this.handshakeTime;
        logger.log((Level)Component.SSL_HANDSHAKE, "Elapsed time {0}s", new Long(this.handshakeTime / (long)1000));
    }

    private void doClientHandshake() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Serializable serializable;
        Object object7;
        Object object8;
        Constructed constructed;
        Object object9;
        Object object10;
        logger.log((Level)Component.SSL_HANDSHAKE, "starting client handshake in {0}", Thread.currentThread());
        IMessageDigest iMessageDigest = HashFactory.getInstance("md5");
        IMessageDigest iMessageDigest2 = HashFactory.getInstance("sha-160");
        DigestInputStream digestInputStream = new DigestInputStream(this.handshakeIn, iMessageDigest, iMessageDigest2);
        DigestOutputStream digestOutputStream = new DigestOutputStream(this.handshakeOut, iMessageDigest, iMessageDigest2);
        Session session = null;
        byte[] byArray = new byte[]{};
        LinkedList linkedList = null;
        String string = null;
        CertificateType certificateType = CertificateType.X509;
        Object object11 = this.sessionContext.getIds();
        while (object11.hasMoreElements()) {
            object10 = (byte[])object11.nextElement();
            session = (Session)this.sessionContext.getSession((byte[])object10);
            if (session == null || !this.session.enabledProtocols.contains(session.protocol) || !session.getPeerHost().equals(this.remoteHost)) continue;
            byArray = object10;
            break;
        }
        object11 = this.session.enabledSuites.iterator();
        while (object11.hasNext()) {
            object10 = (CipherSuite)object11.next();
            if (object10.getKeyExchange() != "SRP") continue;
            linkedList = new LinkedList();
            string = this.askUserName(this.remoteHost);
            object9 = string.getBytes("UTF-8");
            if (((byte[])object9).length > 255) {
                this.handshakeFailure();
                throw new SSLException("SRP username too long");
            }
            linkedList.add(new Extension(Extension.Type.SRP, Util.concat(new byte[]{(byte)((Object)object9).length}, object9)));
            break;
        }
        try {
            int n = Integer.parseInt(Util.getSecurityProperty("jessie.fragment.length"));
            object10 = new byte[1];
            if (n == 512) {
                object10[0] = 1;
            } else if (n == 1024) {
                object10[0] = 2;
            } else if (n == 2048) {
                object10[0] = 3;
            } else if (n == 4096) {
                object10[0] = 4;
            } else {
                throw new NumberFormatException();
            }
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            linkedList.add(new Extension(Extension.Type.MAX_FRAGMENT_LENGTH, (byte[])object10));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ProtocolVersion protocolVersion = this.session.protocol;
        object10 = new Random(Util.unixTime(), this.session.random.generateSeed(28));
        this.session.protocol = (ProtocolVersion)this.session.enabledProtocols.last();
        object9 = new ArrayList(2);
        object9.add(CompressionMethod.ZLIB);
        object9.add(CompressionMethod.NULL);
        ClientHello clientHello = new ClientHello(this.session.protocol, (Random)object10, byArray, this.session.enabledSuites, (List)object9, linkedList);
        Handshake handshake = new Handshake(Handshake.Type.CLIENT_HELLO, clientHello);
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        handshake.write(digestOutputStream, protocolVersion);
        digestOutputStream.flush();
        handshake = Handshake.read(digestInputStream);
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        if (handshake.getType() != Handshake.Type.SERVER_HELLO) {
            this.throwUnexpectedMessage();
        }
        ServerHello serverHello = (ServerHello)handshake.getBody();
        Random random = serverHello.getRandom();
        protocolVersion = serverHello.getVersion();
        if (!this.session.enabledProtocols.contains(protocolVersion)) {
            constructed = null;
            object8 = null;
            object7 = this.session.enabledProtocols.iterator();
            while (object7.hasNext() && ((ProtocolVersion)(constructed = (ProtocolVersion)object7.next())).compareTo(protocolVersion) <= 0) {
                object8 = constructed;
            }
            protocolVersion = constructed;
        }
        if (protocolVersion == null) {
            object8 = null;
            object8 = serverHello.getVersion() == ProtocolVersion.SSL_3 ? Alert.Description.HANDSHAKE_FAILURE : Alert.Description.PROTOCOL_VERSION;
            constructed = new Alert(Alert.Level.FATAL, (Alert.Description)object8);
            this.sendAlert((Alert)constructed);
            this.session.currentAlert = constructed;
            this.fatal();
            throw new AlertException((Alert)constructed, true);
        }
        if (serverHello.getExtensions() != null) {
            object8 = serverHello.getExtensions().iterator();
            while (object8.hasNext()) {
                constructed = (Extension)object8.next();
                if (((Extension)constructed).getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                    int n = Extensions.getMaxFragmentLength((Extension)constructed);
                    this.session.params.setFragmentLength(n);
                    continue;
                }
                if (((Extension)constructed).getType() != Extension.Type.CERT_TYPE) continue;
                certificateType = Extensions.getServerCertType((Extension)constructed);
            }
        }
        object8 = serverHello.getCipherSuite().resolve(protocolVersion);
        boolean bl = true;
        if (byArray.length > 0 && Arrays.equals(byArray, serverHello.getSessionId())) {
            object7 = this.session.params;
            serializable = this.session.random;
            this.session = (Session)session.clone();
            this.session.params = object7;
            this.session.random = serializable;
            this.recordInput.setSession(this.session);
            object8 = this.session.cipherSuite;
            bl = false;
        } else {
            this.sessionContext.removeSession(new Session.ID(byArray));
        }
        if (bl) {
            this.session.peerHost = this.remoteHost;
            this.session.sessionId = new Session.ID(serverHello.getSessionId());
            this.session.cipherSuite = object8;
        }
        this.session.params.reset();
        this.session.currentAlert = null;
        this.session.valid = true;
        this.session.protocol = protocolVersion;
        if (bl) {
            IncomingMessage incomingMessage;
            Object object12;
            Object object13;
            Object object14;
            serializable = null;
            object7 = null;
            KeyPair keyPair = null;
            Object var21_27 = null;
            boolean bl2 = false;
            Object var25_29 = null;
            IKeyAgreementParty iKeyAgreementParty = null;
            OutgoingMessage outgoingMessage = null;
            if (((CipherSuite)object8).getKeyExchange() == "SRP") {
                object14 = this.askPassword(string);
                object13 = ((String)object14).getBytes("UTF-8");
                iKeyAgreementParty = KeyAgreementFactory.getPartyAInstance("srp-tls");
                object6 = new HashMap();
                object6.put("gnu.crypto.srp6.ka.H", "sha-160");
                object6.put("gnu.crypto.srp6.ka.I", string);
                object6.put("gnu.crypto.srp6.ka.p", object13);
                try {
                    iKeyAgreementParty.init((Map)object6);
                    outgoingMessage = iKeyAgreementParty.processMessage(null);
                }
                catch (KeyAgreementException keyAgreementException) {
                    this.throwHandshakeFailure();
                }
            }
            if (((CipherSuite)object8).getSignature() != "anon") {
                handshake = Handshake.read(digestInputStream, certificateType);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                if (handshake.getType() != Handshake.Type.CERTIFICATE) {
                    this.throwUnexpectedMessage();
                }
                object14 = (Certificate)handshake.getBody();
                object13 = ((Certificate)object14).getCertificates();
                try {
                    this.session.trustManager.checkServerTrusted((X509Certificate[])object13, ((CipherSuite)object8).getAuthType());
                    if (((CipherSuite)object8).getSignature() == "RSA" && !(object13[0].getPublicKey() instanceof RSAPublicKey)) {
                        throw new InvalidKeyException("improper public key");
                    }
                    if (((CipherSuite)object8).getKeyExchange() == "DH" && !(object13[0].getPublicKey() instanceof DHPublicKey)) {
                        throw new InvalidKeyException("improper public key");
                    }
                    if (((CipherSuite)object8).getKeyExchange() == "DHE") {
                        if (((CipherSuite)object8).getSignature() == "RSA" && !(object13[0].getPublicKey() instanceof RSAPublicKey)) {
                            throw new InvalidKeyException("improper public key");
                        }
                        if (((CipherSuite)object8).getSignature() == "DSS" && !(object13[0].getPublicKey() instanceof DSAPublicKey)) {
                            throw new InvalidKeyException("improper public key");
                        }
                    }
                    this.session.peerCerts = (java.security.cert.Certificate[])object13;
                    this.session.peerVerified = true;
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.throwHandshakeFailure();
                }
                catch (Exception exception) {
                    if (!this.checkCertificates((X509Certificate[])object13)) {
                        this.peerUnverified((X509Certificate[])object13);
                        SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException("could not verify peer certificate: " + object13[0].getSubjectDN());
                        sSLPeerUnverifiedException.initCause(exception);
                        throw sSLPeerUnverifiedException;
                    }
                    this.session.peerCerts = (java.security.cert.Certificate[])object13;
                    this.session.peerVerified = true;
                }
                serializable = object13[0].getPublicKey();
                object7 = serializable;
            }
            if ((handshake = Handshake.read(digestInputStream, (CipherSuite)object8, (PublicKey)serializable)).getType() == Handshake.Type.SERVER_KEY_EXCHANGE) {
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                object14 = (ServerKeyExchange)handshake.getBody();
                object7 = ((ServerKeyExchange)object14).getPublicKey();
                if (((CipherSuite)object8).getSignature() != "anon") {
                    object13 = null;
                    if (((CipherSuite)object8).getSignature() == "RSA") {
                        object13 = new SSLRSASignature();
                    } else if (((CipherSuite)object8).getSignature() == "DSS") {
                        object13 = SignatureFactory.getInstance("dss");
                    }
                    object13.setupVerify(Collections.singletonMap("gnu.crypto.sig.public.key", serializable));
                    object6 = object10.getEncoded();
                    object13.update((byte[])object6, 0, ((byte[][])object6).length);
                    object6 = random.getEncoded();
                    object13.update((byte[])object6, 0, ((byte[][])object6).length);
                    if (((CipherSuite)object8).getKeyExchange() == "RSA") {
                        this.updateSig((ISignature)object13, ((RSAPublicKey)object7).getModulus());
                        this.updateSig((ISignature)object13, ((RSAPublicKey)object7).getPublicExponent());
                    } else if (((CipherSuite)object8).getKeyExchange() == "DHE") {
                        this.updateSig((ISignature)object13, ((DHPublicKey)object7).getParams().getP());
                        this.updateSig((ISignature)object13, ((DHPublicKey)object7).getParams().getG());
                        this.updateSig((ISignature)object13, ((DHPublicKey)object7).getY());
                    } else if (((CipherSuite)object8).getKeyExchange() == "SRP") {
                        this.updateSig((ISignature)object13, ((SRPPublicKey)object7).getN());
                        this.updateSig((ISignature)object13, ((SRPPublicKey)object7).getG());
                        object12 = ((ServerKeyExchange)object14).getSRPSalt();
                        object13.update((byte)((byte[])object12).length);
                        object13.update((byte[])object12, 0, ((byte[])object12).length);
                        this.updateSig((ISignature)object13, ((SRPPublicKey)object7).getY());
                    }
                    if (!object13.verify(((ServerKeyExchange)object14).getSignature().getSigValue())) {
                        this.throwHandshakeFailure();
                    }
                }
                if (((CipherSuite)object8).getKeyExchange() == "SRP") {
                    try {
                        outgoingMessage = new OutgoingMessage();
                        outgoingMessage.writeMPI(((SRPPublicKey)object7).getN());
                        outgoingMessage.writeMPI(((SRPPublicKey)object7).getG());
                        outgoingMessage.writeMPI(new BigInteger(1, ((ServerKeyExchange)object14).getSRPSalt()));
                        outgoingMessage.writeMPI(((SRPPublicKey)object7).getY());
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        outgoingMessage = iKeyAgreementParty.processMessage(incomingMessage);
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.throwHandshakeFailure();
                    }
                }
                handshake = Handshake.read(digestInputStream, (CipherSuite)object8, (PublicKey)serializable);
            }
            CertificateRequest certificateRequest = null;
            if (handshake.getType() == Handshake.Type.CERTIFICATE_REQUEST) {
                if (((CipherSuite)object8).getSignature() == "anon") {
                    this.throwHandshakeFailure();
                }
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                certificateRequest = (CertificateRequest)handshake.getBody();
                handshake = Handshake.read(digestInputStream);
            }
            if (handshake.getType() != Handshake.Type.SERVER_HELLO_DONE) {
                this.throwUnexpectedMessage();
            }
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            if (certificateRequest != null) {
                object14 = this.session.keyManager.chooseClientAlias(certificateRequest.getTypeStrings(), certificateRequest.getAuthorities(), null);
                if (object14 == null && protocolVersion == ProtocolVersion.SSL_3) {
                    object13 = new Alert(Alert.Level.WARNING, Alert.Description.NO_CERTIFICATE);
                    this.sendAlert((Alert)object13);
                } else {
                    object13 = this.session.keyManager.getCertificateChain((String)object14);
                    object6 = this.session.keyManager.getPrivateKey((String)object14);
                    if (object13 == null) {
                        object13 = new X509Certificate[0];
                    }
                    object12 = new Certificate((X509Certificate[])object13);
                    handshake = new Handshake(Handshake.Type.CERTIFICATE, (Handshake.Body)object12);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    handshake.write(digestOutputStream, protocolVersion);
                    digestOutputStream.flush();
                    if (((Object)object13).length > 0) {
                        this.session.localCerts = object13;
                        keyPair = new KeyPair(((java.security.cert.Certificate)object13[0]).getPublicKey(), (PrivateKey)object6);
                    }
                }
            }
            object14 = null;
            object13 = null;
            if (((CipherSuite)object8).getKeyExchange() == "RSA") {
                object6 = (ProtocolVersion)this.session.enabledProtocols.last();
                object12 = new byte[46];
                this.session.random.nextBytes((byte[])object12);
                object14 = Util.concat(((ProtocolVersion)object6).getEncoded(), (byte[])object12);
                object5 = EME_PKCS1_V1_5.getInstance((RSAPublicKey)object7);
                object4 = new BigInteger(1, ((EME_PKCS1_V1_5)object5).encode((byte[])object14, this.session.random));
                object4 = RSA.encrypt((RSAPublicKey)object7, (BigInteger)object4);
                object13 = new ClientKeyExchange(Util.trim((BigInteger)object4));
            } else if (((CipherSuite)object8).getKeyExchange().startsWith("DH")) {
                if (keyPair == null || !(keyPair.getPublic() instanceof DHPublicKey)) {
                    object6 = new GnuDHPrivateKey(null, ((DHPublicKey)object7).getParams().getP(), ((DHPublicKey)object7).getParams().getG(), null);
                    iKeyAgreementParty = KeyAgreementFactory.getPartyBInstance("dh");
                    object12 = new HashMap();
                    object12.put("gnu.crypto.dh.ka.owner.private.key", object6);
                    object12.put("gnu.crypto.dh.ka.prng", this.session.random);
                    try {
                        iKeyAgreementParty.init((Map)object12);
                        outgoingMessage = new OutgoingMessage();
                        outgoingMessage.writeMPI(((DHPublicKey)object7).getY());
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        outgoingMessage = iKeyAgreementParty.processMessage(incomingMessage);
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        object13 = new ClientKeyExchange(incomingMessage.readMPI());
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                        runtimeException.initCause(keyAgreementException);
                        throw runtimeException;
                    }
                }
                iKeyAgreementParty = KeyAgreementFactory.getPartyBInstance("elgamal");
                object6 = new HashMap();
                object6.put("gnu.crypto.elgamal.ka.recipient.private.key", keyPair.getPrivate());
                try {
                    iKeyAgreementParty.init((Map)object6);
                }
                catch (KeyAgreementException keyAgreementException) {
                    this.internalError();
                    RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                    runtimeException.initCause(keyAgreementException);
                    throw runtimeException;
                }
                object13 = new ClientKeyExchange(new byte[0]);
            } else if (((CipherSuite)object8).getKeyExchange() == "SRP") {
                object6 = null;
                try {
                    incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                    object6 = incomingMessage.readMPI();
                }
                catch (KeyAgreementException keyAgreementException) {
                    this.throwHandshakeFailure();
                }
                object13 = new ClientKeyExchange((BigInteger)object6);
            }
            handshake = new Handshake(Handshake.Type.CLIENT_KEY_EXCHANGE, (Handshake.Body)object13);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            if (((CipherSuite)object8).getKeyExchange().startsWith("DH")) {
                try {
                    object14 = iKeyAgreementParty.getSharedSecret();
                }
                catch (KeyAgreementException keyAgreementException) {
                    this.internalError();
                    object12 = new RuntimeException(keyAgreementException.getMessage());
                    ((Throwable)object12).initCause(keyAgreementException);
                    throw object12;
                }
            }
            if (((CipherSuite)object8).getKeyExchange() == "SRP") {
                try {
                    try {
                        object14 = iKeyAgreementParty.getSharedSecret();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.throwHandshakeFailure();
                    }
                    object6 = null;
                    iKeyAgreementParty = null;
                }
                catch (Throwable throwable) {
                    object6 = null;
                    iKeyAgreementParty = null;
                    throw throwable;
                }
            }
            object6 = null;
            if (protocolVersion == ProtocolVersion.SSL_3) {
                object6 = new SSLRandom();
                object12 = new HashMap();
                ((HashMap)object12).put("jessie.sslprng.secret", object14);
                ((HashMap)object12).put("jessie.sslprng.seed", Util.concat(object10.getEncoded(), random.getEncoded()));
                object6.init((Map)object12);
            } else {
                object6 = new TLSRandom();
                object12 = new HashMap();
                ((HashMap)object12).put("jessie.tls.prng.secret", object14);
                ((HashMap)object12).put("jessie.tls.prng.seed", Util.concat("master secret".getBytes("UTF-8"), Util.concat(object10.getEncoded(), random.getEncoded())));
                object6.init((Map)object12);
            }
            this.session.masterSecret = new byte[48];
            try {
                object6.nextBytes(this.session.masterSecret, 0, 48);
                for (int i = 0; i < ((Object)object14).length; ++i) {
                    object14[i] = false;
                }
            }
            catch (LimitReachedException limitReachedException) {
                this.internalError();
                object5 = new RuntimeException(limitReachedException.getMessage());
                ((Throwable)object5).initCause(limitReachedException);
                throw object5;
            }
            if (certificateRequest != null && keyPair != null) {
                block117: {
                    IMessageDigest iMessageDigest3 = (IMessageDigest)iMessageDigest.clone();
                    object5 = (IMessageDigest)iMessageDigest2.clone();
                    object4 = keyPair.getPrivate();
                    object3 = null;
                    object2 = null;
                    try {
                        if (object4 instanceof DSAPrivateKey) {
                            object3 = DSSSignature.sign((DSAPrivateKey)object4, object5.digest(), this.session.random);
                            object2 = "DSS";
                            break block117;
                        }
                        if (object4 instanceof RSAPrivateKey) {
                            object = new SSLRSASignature(iMessageDigest3, (IMessageDigest)object5);
                            ((SSLRSASignature)object).setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", object4));
                            object3 = ((SSLRSASignature)object).sign();
                            object2 = "RSA";
                            break block117;
                        }
                        throw new InvalidKeyException("no appropriate key");
                    }
                    catch (Exception exception) {
                        this.throwHandshakeFailure();
                    }
                }
                object = new CertificateVerify(object3, (String)object2);
                handshake = new Handshake(Handshake.Type.CERTIFICATE_VERIFY, (Handshake.Body)object);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
            }
            digestOutputStream.flush();
        }
        object6 = null;
        try {
            object6 = this.generateKeys(random.getEncoded(), object10.getEncoded(), protocolVersion);
        }
        catch (Exception exception) {
            this.internalError();
            object5 = new RuntimeException(exception.getMessage());
            ((Throwable)object5).initCause(exception);
            throw object5;
        }
        this.session.params.setVersion(protocolVersion);
        object5 = null;
        Object object15 = null;
        object3 = null;
        object4 = null;
        try {
            if (this.session.params instanceof GNUSecurityParameters) {
                object2 = new HashMap();
                object15 = CipherSuite.getMac(((CipherSuite)object8).getMac());
                object5 = CipherSuite.getMac(((CipherSuite)object8).getMac());
                ((HashMap)object2).put("gnu.crypto.mac.key.material", object6[0]);
                ((IMac)object15).init((Map)object2);
                ((HashMap)object2).put("gnu.crypto.mac.key.material", object6[1]);
                ((IMac)object5).init((Map)object2);
                if (((CipherSuite)object8).getCipher() == "RC4") {
                    object4 = new ARCFour();
                    object3 = new ARCFour();
                    ((HashMap)object2).clear();
                    ((HashMap)object2).put("gnu.crypto.prng.arcfour.key-material", object6[2]);
                    ((ARCFour)object4).init((Map)object2);
                    ((HashMap)object2).put("gnu.crypto.prng.arcfour.key-material", object6[3]);
                    ((ARCFour)object3).init((Map)object2);
                } else if (!((CipherSuite)object8).isStreamCipher()) {
                    object4 = CipherSuite.getCipher(((CipherSuite)object8).getCipher());
                    object3 = CipherSuite.getCipher(((CipherSuite)object8).getCipher());
                    ((HashMap)object2).clear();
                    ((HashMap)object2).put("gnu.crypto.cipher.key.material", object6[2]);
                    ((HashMap)object2).put("gnu.crypto.mode.iv", object6[4]);
                    ((HashMap)object2).put("gnu.crypto.mode.state", new Integer(1));
                    ((IMode)object4).init((Map)object2);
                    ((HashMap)object2).put("gnu.crypto.cipher.key.material", object6[3]);
                    ((HashMap)object2).put("gnu.crypto.mode.iv", object6[5]);
                    ((HashMap)object2).put("gnu.crypto.mode.state", new Integer(2));
                    ((IMode)object3).init((Map)object2);
                }
            } else {
                object15 = CipherSuite.getJCEMac(((CipherSuite)object8).getMac());
                object5 = CipherSuite.getJCEMac(((CipherSuite)object8).getMac());
                object4 = CipherSuite.getJCECipher(((CipherSuite)object8).getCipher());
                object3 = CipherSuite.getJCECipher(((CipherSuite)object8).getCipher());
                ((Mac)object15).init(new SecretKeySpec((byte[])object6[0], ((CipherSuite)object8).getMac()));
                ((Mac)object5).init(new SecretKeySpec((byte[])object6[1], ((CipherSuite)object8).getMac()));
                if (!((CipherSuite)object8).isStreamCipher()) {
                    ((Cipher)object4).init(1, (Key)new SecretKeySpec(object6[2], ((CipherSuite)object8).getCipher()), new IvParameterSpec(object6[4]));
                    ((Cipher)object3).init(2, (Key)new SecretKeySpec(object6[3], ((CipherSuite)object8).getCipher()), new IvParameterSpec(object6[5]));
                } else {
                    ((Cipher)object4).init(1, new SecretKeySpec(object6[2], ((CipherSuite)object8).getCipher()));
                    ((Cipher)object3).init(2, new SecretKeySpec(object6[3], ((CipherSuite)object8).getCipher()));
                }
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            this.internalError();
            object = new RuntimeException(invalidKeyException.getMessage());
            ((Throwable)object).initCause(invalidKeyException);
            throw object;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            this.internalError();
            object = new RuntimeException(invalidAlgorithmParameterException.getMessage());
            ((Throwable)object).initCause(invalidAlgorithmParameterException);
            throw object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.session.enabledSuites.remove(object8);
            this.internalError();
            object = new SSLException("suite " + object8 + " not available in this configuration");
            ((Throwable)object).initCause(noSuchAlgorithmException);
            throw object;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            this.session.enabledSuites.remove(object8);
            this.internalError();
            object = new SSLException("suite " + object8 + " not available in this configuration");
            ((Throwable)object).initCause(noSuchPaddingException);
            throw object;
        }
        object2 = null;
        if (bl) {
            this.changeCipherSpec();
            this.session.params.setDeflating(serverHello.getCompressionMethod() == CompressionMethod.ZLIB);
            this.session.params.setOutMac(object15);
            this.session.params.setOutCipher(object4);
            object2 = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest.clone(), (IMessageDigest)iMessageDigest2.clone(), true);
            handshake = new Handshake(Handshake.Type.FINISHED, (Handshake.Body)object2);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        object = this.session.params;
        synchronized (object) {
            Finished finished;
            try {
                this.readChangeCipherSpec();
                this.session.params.setInflating(serverHello.getCompressionMethod() == CompressionMethod.ZLIB);
                this.session.params.setInMac(object5);
                this.session.params.setInCipher(object3);
                this.session.params.notifyAll();
            }
            finally {
                finished = null;
            }
            finished = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest.clone(), (IMessageDigest)iMessageDigest2.clone(), false);
            handshake = Handshake.read(digestInputStream, (CipherSuite)object8, null);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            if (handshake.getType() != Handshake.Type.FINISHED) {
                this.throwUnexpectedMessage();
            }
            object2 = (Finished)handshake.getBody();
            if (protocolVersion == ProtocolVersion.SSL_3) {
                if (!Arrays.equals(((Finished)object2).getMD5Hash(), finished.getMD5Hash()) || !Arrays.equals(((Finished)object2).getSHAHash(), finished.getSHAHash())) {
                    this.throwHandshakeFailure();
                }
            } else if (!Arrays.equals(((Finished)object2).getVerifyData(), finished.getVerifyData())) {
                this.throwHandshakeFailure();
            }
            if (!bl) {
                this.changeCipherSpec();
                this.session.params.setDeflating(serverHello.getCompressionMethod() == CompressionMethod.ZLIB);
                this.session.params.setOutMac(object15);
                this.session.params.setOutCipher(object4);
                object2 = this.generateFinished(protocolVersion, iMessageDigest, iMessageDigest2, true);
                handshake = new Handshake(Handshake.Type.FINISHED, (Handshake.Body)object2);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
            }
            this.handshakeCompleted();
            return;
        }
    }

    private void doServerHandshake() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        IncomingMessage incomingMessage;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        logger.log((Level)Component.SSL_HANDSHAKE, "doing server handshake in {0}", Thread.currentThread());
        if (this.remoteHost == null) {
            this.remoteHost = this.getInetAddress().getHostName();
        }
        if (this.remoteHost == null) {
            this.remoteHost = this.getInetAddress().getHostAddress();
        }
        IMessageDigest iMessageDigest = HashFactory.getInstance("md5");
        IMessageDigest iMessageDigest2 = HashFactory.getInstance("sha-160");
        DigestInputStream digestInputStream = new DigestInputStream(this.handshakeIn, iMessageDigest, iMessageDigest2);
        DigestOutputStream digestOutputStream = new DigestOutputStream(this.handshakeOut, iMessageDigest, iMessageDigest2);
        Handshake handshake = Handshake.read(digestInputStream);
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        if (handshake.getType() != Handshake.Type.CLIENT_HELLO) {
            this.throwUnexpectedMessage();
        }
        ClientHello clientHello = (ClientHello)handshake.getBody();
        Random random = clientHello.getRandom();
        ProtocolVersion protocolVersion = clientHello.getVersion();
        ProtocolVersion protocolVersion2 = (ProtocolVersion)this.session.enabledProtocols.last();
        CompressionMethod compressionMethod = clientHello.getCompressionMethods().contains(CompressionMethod.ZLIB) ? CompressionMethod.ZLIB : CompressionMethod.NULL;
        if (!this.session.enabledProtocols.contains(protocolVersion) && protocolVersion.compareTo(protocolVersion2) < 0) {
            Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.PROTOCOL_VERSION);
            this.sendAlert(alert);
            this.session.currentAlert = alert;
            throw new AlertException(alert, true);
        }
        List list2 = null;
        String string = null;
        if (clientHello.getExtensions() != null) {
            object9 = clientHello.getExtensions().iterator();
            while (object9.hasNext()) {
                object8 = (Extension)object9.next();
                if (((Extension)object8).getType() == Extension.Type.SERVER_NAME) {
                    if (list2 == null) {
                        list2 = new LinkedList();
                    }
                    list2.add(object8);
                    continue;
                }
                if (((Extension)object8).getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                    int n = Extensions.getMaxFragmentLength((Extension)object8);
                    this.session.params.setFragmentLength(n);
                    if (list2 == null) {
                        list2 = new LinkedList();
                    }
                    list2.add(object8);
                    continue;
                }
                if (((Extension)object8).getType() != Extension.Type.SRP) continue;
                if (list2 == null) {
                    list2 = new LinkedList();
                }
                byte[] byArray = ((Extension)object8).getValue();
                string = new String(((Extension)object8).getValue(), 1, byArray[0] & 0xFF, "UTF-8");
                this.session.putValue("srp-username", string);
            }
        }
        if ((object9 = this.selectSuite(clientHello.getCipherSuites(), protocolVersion)) == null) {
            return;
        }
        object8 = null;
        OutgoingMessage outgoingMessage = null;
        if (((CipherSuite)object9).getKeyExchange() == "SRP") {
            if (string == null) {
                Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.MISSING_SRP_USERNAME);
                this.sendAlert(alert);
                throw new AlertException(alert, true);
            }
            SRPAuthInfoProvider sRPAuthInfoProvider = new SRPAuthInfoProvider();
            object7 = new HashMap();
            object7.put("gnu.crypto.sasl.srp.password.db", this.session.srpTrustManager.getPasswordFile());
            sRPAuthInfoProvider.activate((Map)object7);
            if (!sRPAuthInfoProvider.contains(string)) {
                Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.UNKNOWN_SRP_USERNAME);
                this.sendAlert(alert);
                throw new AlertException(alert, true);
            }
            object8 = KeyAgreementFactory.getPartyBInstance("srp-tls");
            object6 = new HashMap();
            object6.put("gnu.crypto.srp6.ka.H", "sha-160");
            object6.put("gnu.crypto.srp6.ka.password.db", sRPAuthInfoProvider);
            try {
                object8.init((Map)object6);
                outgoingMessage = new OutgoingMessage();
                outgoingMessage.writeString(string);
                incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                outgoingMessage = object8.processMessage(incomingMessage);
            }
            catch (KeyAgreementException keyAgreementException) {
                this.throwHandshakeFailure();
            }
        }
        boolean bl = true;
        logger.log((Level)Component.SSL_HANDSHAKE, "saved sessions: {0}", this.sessionContext);
        if (this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId()))) {
            object7 = this.session;
            this.session = (Session)this.sessionContext.getSession(clientHello.getSessionId());
            if (!clientHello.getCipherSuites().contains(this.session.cipherSuite)) {
                this.throwHandshakeFailure();
            }
            if (this.session.getPeerHost().equals(this.remoteHost) && ((Session)object7).enabledProtocols.contains(this.session.protocol)) {
                this.session = (Session)this.session.clone();
                object9 = this.session.cipherSuite;
                bl = false;
                this.recordInput.setSession(this.session);
                this.session.currentAlert = null;
                this.session.params = ((Session)object7).params;
                this.session.random = ((Session)object7).random;
            } else {
                logger.log((Level)Component.SSL_HANDSHAKE, "rejected section; hosts equal? {0}, same suites? {1}", new Object[]{this.session.getPeerHost().equals(this.remoteHost), ((Session)object7).enabledProtocols.contains(this.session.protocol)});
                this.session = object7;
                this.session.peerHost = this.remoteHost;
                bl = true;
            }
        } else {
            logger.log((Level)Component.SSL_HANDSHAKE, "rejected session; have session id? {0}, saved sessions: {1}", new Object[]{this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId())), this.sessionContext});
        }
        if (bl) {
            object7 = new byte[32];
            object6 = null;
            do {
                this.session.random.nextBytes((byte[])object7);
                object6 = new Session.ID((byte[])object7);
            } while (this.sessionContext.containsSessionID((Session.ID)object6));
            this.session.sessionId = object6;
        }
        this.session.valid = true;
        this.session.peerHost = this.remoteHost;
        this.session.cipherSuite = object9;
        this.session.protocol = protocolVersion;
        this.session.params.setVersion(protocolVersion);
        object7 = new Random(Util.unixTime(), this.session.random.generateSeed(28));
        object6 = new ServerHello(protocolVersion, (Random)object7, this.session.getId(), (CipherSuite)object9, compressionMethod, list2);
        handshake = new Handshake(Handshake.Type.SERVER_HELLO, (Handshake.Body)object6);
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        handshake.write(digestOutputStream, protocolVersion);
        digestOutputStream.flush();
        if (bl) {
            Object object10;
            Object object11;
            Object object12;
            Constructed constructed;
            Object object13;
            X509Certificate[] x509CertificateArray;
            Object object14;
            Serializable serializable;
            Object object15;
            Object object16;
            X509Certificate[] x509CertificateArray2 = null;
            PrivateKey privateKey = null;
            if (((CipherSuite)object9).getSignature() != "anon") {
                object16 = this.session.keyManager.chooseServerAlias(((CipherSuite)object9).getAuthType(), null, null);
                x509CertificateArray2 = this.session.keyManager.getCertificateChain((String)object16);
                privateKey = this.session.keyManager.getPrivateKey((String)object16);
                if (x509CertificateArray2 == null || privateKey == null) {
                    this.throwHandshakeFailure();
                }
                this.session.localCerts = x509CertificateArray2;
                object15 = new Certificate(x509CertificateArray2);
                handshake = new Handshake(Handshake.Type.CERTIFICATE, (Handshake.Body)object15);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
            }
            object16 = null;
            if (x509CertificateArray2 != null) {
                object16 = new KeyPair(x509CertificateArray2[0].getPublicKey(), privateKey);
            }
            object15 = object16;
            ServerKeyExchange serverKeyExchange = null;
            if (((CipherSuite)object9).getKeyExchange() == "RSA" && ((CipherSuite)object9).isExportable() && ((RSAPrivateKey)privateKey).getModulus().bitLength() > 512) {
                object15 = KeyPool.generateRSAKeyPair();
                serializable = (RSAPublicKey)((KeyPair)object15).getPublic();
                object14 = null;
                if (((CipherSuite)object9).getSignature() != "anon") {
                    x509CertificateArray = new SSLRSASignature();
                    x509CertificateArray.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object16).getPrivate()));
                    object13 = random.getEncoded();
                    x509CertificateArray.update((byte[])object13, 0, ((byte[])object13).length);
                    object13 = ((Random)object7).getEncoded();
                    x509CertificateArray.update((byte[])object13, 0, ((byte[])object13).length);
                    this.updateSig((ISignature)x509CertificateArray, serializable.getModulus());
                    this.updateSig((ISignature)x509CertificateArray, serializable.getPublicExponent());
                    object14 = new Signature(x509CertificateArray.sign(), "RSA");
                }
                serverKeyExchange = new ServerKeyExchange((PublicKey)serializable, (Signature)object14);
            } else {
                if (((CipherSuite)object9).getKeyExchange() == "DH") {
                    object8 = KeyAgreementFactory.getPartyBInstance("elgamal");
                    serializable = new HashMap();
                    serializable.put("gnu.crypto.elgamal.ka.recipient.private.key", privateKey);
                    try {
                        object8.init((Map)((Object)serializable));
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                        runtimeException.initCause(keyAgreementException);
                        throw runtimeException;
                    }
                }
                if (((CipherSuite)object9).getKeyExchange() == "DHE") {
                    object8 = KeyAgreementFactory.getPartyAInstance("dh");
                    serializable = new HashMap();
                    object14 = DiffieHellman.getParams();
                    serializable.put("gnu.crypto.dh.ka.owner.private.key", object14);
                    serializable.put("gnu.crypto.dh.ka.prng", this.session.random);
                    x509CertificateArray = null;
                    try {
                        object8.init((Map)((Object)serializable));
                        outgoingMessage = object8.processMessage(null);
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        x509CertificateArray = incomingMessage.readMPI();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                        runtimeException.initCause(keyAgreementException);
                        throw runtimeException;
                    }
                    object13 = new GnuDHPublicKey(null, object14.getParams().getP(), object14.getParams().getG(), (BigInteger)x509CertificateArray);
                    constructed = null;
                    if (((CipherSuite)object9).getSignature() != "anon") {
                        object12 = null;
                        object12 = ((CipherSuite)object9).getSignature() == "RSA" ? (Object)new SSLRSASignature() : (Object)SignatureFactory.getInstance("dss");
                        object12.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object16).getPrivate()));
                        object11 = random.getEncoded();
                        object12.update((byte[])object11, 0, ((Object)object11).length);
                        object11 = ((Random)object7).getEncoded();
                        object12.update((byte[])object11, 0, ((Object)object11).length);
                        this.updateSig((ISignature)object12, ((GnuDHKey)object13).getParams().getP());
                        this.updateSig((ISignature)object12, ((GnuDHKey)object13).getParams().getG());
                        this.updateSig((ISignature)object12, ((GnuDHPublicKey)object13).getY());
                        constructed = new Signature(object12.sign(), ((CipherSuite)object9).getSignature());
                    }
                    serverKeyExchange = new ServerKeyExchange((PublicKey)object13, (Signature)constructed);
                } else if (((CipherSuite)object9).getKeyExchange() == "SRP") {
                    serializable = null;
                    object14 = null;
                    x509CertificateArray = null;
                    object13 = null;
                    try {
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        serializable = incomingMessage.readMPI();
                        object14 = incomingMessage.readMPI();
                        x509CertificateArray = incomingMessage.readMPI();
                        object13 = incomingMessage.readMPI();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.throwHandshakeFailure();
                    }
                    constructed = null;
                    object12 = Util.trim((BigInteger)x509CertificateArray);
                    if (((CipherSuite)object9).getSignature() != "anon") {
                        object11 = null;
                        object11 = ((CipherSuite)object9).getSignature() == "RSA" ? new SSLRSASignature() : SignatureFactory.getInstance("dss");
                        object11.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object16).getPrivate()));
                        object5 = random.getEncoded();
                        object11.update((byte[])object5, 0, ((byte[][])object5).length);
                        object5 = ((Random)object7).getEncoded();
                        object11.update((byte[])object5, 0, ((byte[][])object5).length);
                        this.updateSig((ISignature)object11, (BigInteger)serializable);
                        this.updateSig((ISignature)object11, (BigInteger)object14);
                        object11.update((byte)((byte[])object12).length);
                        object11.update((byte[])object12, 0, ((Object)object12).length);
                        this.updateSig((ISignature)object11, (BigInteger)object13);
                        constructed = new Signature(object11.sign(), ((CipherSuite)object9).getSignature());
                    }
                    object11 = new SRPPublicKey((BigInteger)serializable, (BigInteger)object14, (BigInteger)object13);
                    serverKeyExchange = new ServerKeyExchange((PublicKey)object11, (Signature)constructed, (byte[])object12);
                }
            }
            if (serverKeyExchange != null) {
                handshake = new Handshake(Handshake.Type.SERVER_KEY_EXCHANGE, serverKeyExchange);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
            }
            if (this.wantClientAuth || this.needClientAuth) {
                serializable = null;
                object14 = new CertificateRequest.ClientType[]{CertificateRequest.ClientType.RSA_SIGN, CertificateRequest.ClientType.DSS_SIGN, CertificateRequest.ClientType.RSA_FIXED_DH, CertificateRequest.ClientType.DSS_FIXED_DH};
                try {
                    serializable = (Principal[])Util.transform(this.session.trustManager.getAcceptedIssuers(), SSLSocket.class$("java.security.Principal"), "getSubjectDN", null);
                }
                catch (Exception exception) {
                    this.internalError();
                    object13 = new RuntimeException(exception.getMessage());
                    ((Throwable)object13).initCause(exception);
                    throw object13;
                }
                x509CertificateArray = new CertificateRequest((CertificateRequest.ClientType[])object14, (Principal[])serializable);
                handshake = new Handshake(Handshake.Type.CERTIFICATE_REQUEST, (Handshake.Body)x509CertificateArray);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
            }
            handshake = new Handshake(Handshake.Type.SERVER_HELLO_DONE, null);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
            handshake = ((CipherSuite)object9).getKeyExchange() == "RSA" ? Handshake.read(digestInputStream, (CipherSuite)object9, ((KeyPair)object15).getPublic()) : Handshake.read(digestInputStream, (CipherSuite)object9, null);
            boolean bl2 = false;
            boolean bl3 = false;
            x509CertificateArray = null;
            object13 = null;
            if (handshake.getType() == Handshake.Type.CERTIFICATE) {
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                constructed = (Certificate)handshake.getBody();
                x509CertificateArray = constructed.getCertificates();
                try {
                    this.session.trustManager.checkClientTrusted(x509CertificateArray, ((CipherSuite)object9).getAuthType());
                    this.session.peerCerts = x509CertificateArray;
                    this.session.peerVerified = true;
                    object13 = x509CertificateArray[0].getPublicKey();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl3 = object13 instanceof DSAPublicKey || object13 instanceof RSAPublicKey;
                handshake = ((CipherSuite)object9).getKeyExchange().startsWith("DH") ? Handshake.read(digestInputStream, (CipherSuite)object9, (PublicKey)object13) : Handshake.read(digestInputStream, (CipherSuite)object9, ((KeyPair)object15).getPublic());
            }
            if (!this.session.peerVerified && this.needClientAuth) {
                this.throwHandshakeFailure();
            }
            if (handshake.getType() != Handshake.Type.CLIENT_KEY_EXCHANGE) {
                this.throwUnexpectedMessage();
            }
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            constructed = (ClientKeyExchange)handshake.getBody();
            object12 = null;
            if (((CipherSuite)object9).getKeyExchange() == "RSA") {
                object11 = (byte[])((ClientKeyExchange)constructed).getExchangeObject();
                object5 = new BigInteger(1, (byte[])object11);
                try {
                    object5 = RSA.decrypt(((KeyPair)object15).getPrivate(), (BigInteger)object5);
                    object10 = EME_PKCS1_V1_5.getInstance((RSAPrivateKey)((KeyPair)object15).getPrivate());
                    object12 = ((EME_PKCS1_V1_5)object10).decode(Util.concat(new byte[1], ((BigInteger)object5).toByteArray()));
                }
                catch (Exception exception) {
                    object4 = new byte[46];
                    this.session.random.nextBytes((byte[])object4);
                    object12 = Util.concat(protocolVersion.getEncoded(), (byte[])object4);
                }
            } else {
                if (((CipherSuite)object9).getKeyExchange().startsWith("DH")) {
                    try {
                        outgoingMessage = new OutgoingMessage();
                        if (object13 == null) {
                            outgoingMessage.writeMPI((BigInteger)((ClientKeyExchange)constructed).getExchangeObject());
                        } else {
                            outgoingMessage.writeMPI(((DHPublicKey)object13).getY());
                        }
                        incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                        object8.processMessage(incomingMessage);
                        object12 = object8.getSharedSecret();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        object5 = new RuntimeException(keyAgreementException.getMessage());
                        ((Throwable)object5).initCause(keyAgreementException);
                        throw object5;
                    }
                }
                if (((CipherSuite)object9).getKeyExchange() == "SRP") {
                    object11 = (BigInteger)((ClientKeyExchange)constructed).getExchangeObject();
                    try {
                        try {
                            outgoingMessage = new OutgoingMessage();
                            outgoingMessage.writeMPI((BigInteger)object11);
                            incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                            outgoingMessage = object8.processMessage(incomingMessage);
                            object12 = object8.getSharedSecret();
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.throwHandshakeFailure();
                        }
                        object5 = null;
                        object8 = null;
                    }
                    catch (Throwable throwable) {
                        object5 = null;
                        object8 = null;
                        throw throwable;
                    }
                }
            }
            object5 = null;
            if (protocolVersion == ProtocolVersion.SSL_3) {
                object5 = new SSLRandom();
                object10 = new HashMap();
                ((HashMap)object10).put("jessie.sslprng.secret", object12);
                ((HashMap)object10).put("jessie.sslprng.seed", Util.concat(random.getEncoded(), ((Random)object7).getEncoded()));
                object5.init((Map)object10);
            } else {
                object5 = new TLSRandom();
                object10 = new HashMap();
                ((HashMap)object10).put("jessie.tls.prng.secret", object12);
                ((HashMap)object10).put("jessie.tls.prng.seed", Util.concat("master secret".getBytes("UTF-8"), Util.concat(random.getEncoded(), ((Random)object7).getEncoded())));
                object5.init((Map)object10);
            }
            this.session.masterSecret = new byte[48];
            try {
                object5.nextBytes(this.session.masterSecret, 0, 48);
                for (int i = 0; i < ((Object)object12).length; ++i) {
                    object12[i] = false;
                }
            }
            catch (LimitReachedException limitReachedException) {
                this.internalError();
                object4 = new RuntimeException();
                ((Throwable)object4).initCause(limitReachedException);
                throw object4;
            }
            if (bl3 && (this.wantClientAuth || this.needClientAuth)) {
                handshake = Handshake.read(digestInputStream);
                if (handshake.getType() != Handshake.Type.CERTIFICATE_VERIFY) {
                    this.throwUnexpectedMessage();
                }
                CertificateVerify certificateVerify = (CertificateVerify)handshake.getBody();
                if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                    object4 = (IMessageDigest)iMessageDigest.clone();
                    object3 = (IMessageDigest)iMessageDigest2.clone();
                    object13 = x509CertificateArray[0].getPublicKey();
                    if (object13 instanceof RSAPublicKey) {
                        object2 = new SSLRSASignature((IMessageDigest)object4, (IMessageDigest)object3);
                        ((SSLRSASignature)object2).setupVerify(Collections.singletonMap("gnu.crypto.sig.public.key", object13));
                        if (!((SSLRSASignature)object2).verify(certificateVerify.getSigValue())) {
                            this.handshakeFailure();
                            throw new SSLHandshakeException("client certificate verify failed");
                        }
                    } else if (object13 instanceof DSAPublicKey) {
                        try {
                            if (!DSSSignature.verify((DSAPublicKey)object13, object3.digest(), (BigInteger[])certificateVerify.getSigValue())) {
                                throw new Exception("client's certificate could not be verified");
                            }
                        }
                        catch (Exception exception) {
                            this.handshakeFailure();
                            SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(exception.getMessage());
                            sSLHandshakeException.initCause(exception);
                            throw sSLHandshakeException;
                        }
                    }
                }
            }
        }
        object5 = null;
        try {
            object5 = this.generateKeys(((Random)object7).getEncoded(), random.getEncoded(), protocolVersion);
        }
        catch (Exception exception) {
            this.internalError();
            object4 = new RuntimeException(exception.getMessage());
            ((Throwable)object4).initCause(exception);
            throw object4;
        }
        object4 = null;
        Object object17 = null;
        object2 = null;
        object3 = null;
        try {
            if (this.session.params instanceof GNUSecurityParameters) {
                object = new HashMap();
                object17 = CipherSuite.getMac(((CipherSuite)object9).getMac());
                object4 = CipherSuite.getMac(((CipherSuite)object9).getMac());
                ((HashMap)object).put("gnu.crypto.mac.key.material", object5[1]);
                ((IMac)object17).init((Map)object);
                ((HashMap)object).put("gnu.crypto.mac.key.material", object5[0]);
                ((IMac)object4).init((Map)object);
                if (((CipherSuite)object9).getCipher() == "RC4") {
                    object3 = new ARCFour();
                    object2 = new ARCFour();
                    ((HashMap)object).clear();
                    ((HashMap)object).put("gnu.crypto.prng.arcfour.key-material", object5[3]);
                    ((ARCFour)object3).init((Map)object);
                    ((HashMap)object).put("gnu.crypto.prng.arcfour.key-material", object5[2]);
                    ((ARCFour)object2).init((Map)object);
                } else if (!((CipherSuite)object9).isStreamCipher()) {
                    object3 = CipherSuite.getCipher(((CipherSuite)object9).getCipher());
                    object2 = CipherSuite.getCipher(((CipherSuite)object9).getCipher());
                    ((HashMap)object).clear();
                    ((HashMap)object).put("gnu.crypto.cipher.key.material", object5[3]);
                    ((HashMap)object).put("gnu.crypto.mode.iv", object5[5]);
                    ((HashMap)object).put("gnu.crypto.mode.state", new Integer(1));
                    ((IMode)object3).init((Map)object);
                    ((HashMap)object).put("gnu.crypto.cipher.key.material", object5[2]);
                    ((HashMap)object).put("gnu.crypto.mode.iv", object5[4]);
                    ((HashMap)object).put("gnu.crypto.mode.state", new Integer(2));
                    ((IMode)object2).init((Map)object);
                }
            } else {
                object17 = CipherSuite.getJCEMac(((CipherSuite)object9).getMac());
                object4 = CipherSuite.getJCEMac(((CipherSuite)object9).getMac());
                object3 = CipherSuite.getJCECipher(((CipherSuite)object9).getCipher());
                object2 = CipherSuite.getJCECipher(((CipherSuite)object9).getCipher());
                ((Mac)object17).init(new SecretKeySpec(object5[1], ((CipherSuite)object9).getMac()));
                ((Mac)object4).init(new SecretKeySpec(object5[0], ((CipherSuite)object9).getMac()));
                if (!((CipherSuite)object9).isStreamCipher()) {
                    ((Cipher)object3).init(1, (Key)new SecretKeySpec(object5[3], ((CipherSuite)object9).getCipher()), new IvParameterSpec(object5[5]));
                    ((Cipher)object2).init(2, (Key)new SecretKeySpec(object5[2], ((CipherSuite)object9).getCipher()), new IvParameterSpec(object5[4]));
                } else {
                    ((Cipher)object3).init(1, new SecretKeySpec(object5[3], ((CipherSuite)object9).getCipher()));
                    ((Cipher)object2).init(2, new SecretKeySpec(object5[2], ((CipherSuite)object9).getCipher()));
                }
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            this.internalError();
            RuntimeException runtimeException = new RuntimeException(invalidKeyException.getMessage());
            runtimeException.initCause(invalidKeyException);
            throw new RuntimeException(String.valueOf(invalidKeyException));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            this.internalError();
            RuntimeException runtimeException = new RuntimeException(invalidAlgorithmParameterException.getMessage());
            runtimeException.initCause(invalidAlgorithmParameterException);
            throw runtimeException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.session.enabledSuites.remove(object9);
            this.internalError();
            SSLException sSLException = new SSLException("suite " + object9 + " not available in this configuration");
            sSLException.initCause(noSuchAlgorithmException);
            throw sSLException;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            this.session.enabledSuites.remove(object9);
            this.internalError();
            SSLException sSLException = new SSLException("suite " + object9 + " not available in this configuration");
            sSLException.initCause(noSuchPaddingException);
            throw sSLException;
        }
        object = null;
        if (!bl) {
            this.changeCipherSpec();
            this.session.params.setDeflating(compressionMethod == CompressionMethod.ZLIB);
            this.session.params.setOutMac(object17);
            this.session.params.setOutCipher(object3);
            object = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest.clone(), (IMessageDigest)iMessageDigest2.clone(), false);
            handshake = new Handshake(Handshake.Type.FINISHED, (Handshake.Body)object);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        SecurityParameters securityParameters = this.session.params;
        synchronized (securityParameters) {
            Finished finished;
            try {
                this.readChangeCipherSpec();
                this.session.params.setInflating(compressionMethod == CompressionMethod.ZLIB);
                this.session.params.setInMac(object4);
                this.session.params.setInCipher(object2);
                this.session.params.notifyAll();
            }
            finally {
                finished = null;
            }
            finished = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest.clone(), (IMessageDigest)iMessageDigest2.clone(), true);
            handshake = Handshake.read(digestInputStream, (CipherSuite)object9, null);
            if (handshake.getType() != Handshake.Type.FINISHED) {
                this.throwUnexpectedMessage();
            }
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            object = (Finished)handshake.getBody();
            if (protocolVersion == ProtocolVersion.SSL_3) {
                if (!Arrays.equals(((Finished)object).getMD5Hash(), finished.getMD5Hash()) || !Arrays.equals(((Finished)object).getSHAHash(), finished.getSHAHash())) {
                    this.throwHandshakeFailure();
                }
            } else if (!Arrays.equals(((Finished)object).getVerifyData(), finished.getVerifyData())) {
                this.throwHandshakeFailure();
            }
            if (bl) {
                this.changeCipherSpec();
                this.session.params.setDeflating(compressionMethod == CompressionMethod.ZLIB);
                this.session.params.setOutMac(object17);
                this.session.params.setOutCipher(object3);
                object = this.generateFinished(protocolVersion, iMessageDigest, iMessageDigest2, false);
                handshake = new Handshake(Handshake.Type.FINISHED, (Handshake.Body)object);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
            }
            this.handshakeCompleted();
            return;
        }
    }

    private byte[][] generateKeys(byte[] byArray, byte[] byArray2, ProtocolVersion protocolVersion) throws LimitReachedException, IOException {
        byte[][] byArrayArray;
        block6: {
            int n;
            IRandom iRandom;
            CipherSuite cipherSuite;
            block7: {
                HashMap hashMap;
                cipherSuite = this.session.cipherSuite;
                int n2 = cipherSuite.getMac().indexOf("MD5") >= 0 ? 16 : 20;
                int n3 = cipherSuite.getKeyLength();
                int n4 = 0;
                if (cipherSuite.getCipher().indexOf("DES") >= 0) {
                    n4 = 8;
                } else if (cipherSuite.getCipher() == "AES") {
                    n4 = 16;
                }
                byArrayArray = new byte[][]{new byte[n2], new byte[n2], new byte[n3], new byte[n3], new byte[n4], new byte[n4]};
                iRandom = null;
                if (protocolVersion == ProtocolVersion.SSL_3) {
                    iRandom = new SSLRandom();
                    hashMap = new HashMap();
                    hashMap.put("jessie.sslprng.secret", this.session.masterSecret);
                    hashMap.put("jessie.sslprng.seed", Util.concat(byArray, byArray2));
                    iRandom.init(hashMap);
                } else {
                    iRandom = new TLSRandom();
                    hashMap = new HashMap();
                    hashMap.put("jessie.tls.prng.secret", this.session.masterSecret);
                    hashMap.put("jessie.tls.prng.seed", Util.concat("key expansion".getBytes("UTF-8"), Util.concat(byArray, byArray2)));
                    iRandom.init(hashMap);
                }
                for (n = 0; n < byArrayArray.length; ++n) {
                    iRandom.nextBytes(byArrayArray[n], 0, byArrayArray[n].length);
                }
                if (!cipherSuite.isExportable()) break block6;
                int n5 = n = cipherSuite.getCipher() == "DES" ? 8 : 16;
                if (protocolVersion != ProtocolVersion.SSL_3) break block7;
                IMessageDigest iMessageDigest = HashFactory.getInstance("md5");
                iMessageDigest.update(byArrayArray[2], 0, byArrayArray[2].length);
                iMessageDigest.update(byArray2, 0, byArray2.length);
                iMessageDigest.update(byArray, 0, byArray.length);
                byArrayArray[2] = Util.trim(iMessageDigest.digest(), n);
                iMessageDigest.update(byArrayArray[3], 0, byArrayArray[3].length);
                iMessageDigest.update(byArray, 0, byArray.length);
                iMessageDigest.update(byArray2, 0, byArray2.length);
                byArrayArray[3] = Util.trim(iMessageDigest.digest(), n);
                if (cipherSuite.isStreamCipher()) break block6;
                iMessageDigest.update(byArray2, 0, byArray2.length);
                iMessageDigest.update(byArray, 0, byArray.length);
                byArrayArray[4] = Util.trim(iMessageDigest.digest(), n4);
                iMessageDigest.update(byArray, 0, byArray.length);
                iMessageDigest.update(byArray2, 0, byArray2.length);
                byArrayArray[5] = Util.trim(iMessageDigest.digest(), n4);
                break block6;
            }
            HashMap hashMap = new HashMap();
            hashMap.put("jessie.tls.prng.secret", byArrayArray[2]);
            hashMap.put("jessie.tls.prng.seed", Util.concat("client write key".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
            iRandom.init(hashMap);
            byArrayArray[2] = new byte[n];
            iRandom.nextBytes(byArrayArray[2], 0, n);
            hashMap.put("jessie.tls.prng.secret", byArrayArray[3]);
            hashMap.put("jessie.tls.prng.seed", Util.concat("server write key".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
            iRandom.init(hashMap);
            byArrayArray[3] = new byte[n];
            iRandom.nextBytes(byArrayArray[3], 0, n);
            if (cipherSuite.isStreamCipher()) break block6;
            hashMap.put("jessie.tls.prng.secret", new byte[0]);
            hashMap.put("jessie.tls.prng.seed", Util.concat("IV block".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
            iRandom.init(hashMap);
            iRandom.nextBytes(byArrayArray[4], 0, byArrayArray[4].length);
            iRandom.nextBytes(byArrayArray[5], 0, byArrayArray[5].length);
        }
        return byArrayArray;
    }

    private Finished generateFinished(ProtocolVersion protocolVersion, IMessageDigest iMessageDigest, IMessageDigest iMessageDigest2, boolean bl) {
        if (protocolVersion == ProtocolVersion.SSL_3) {
            int n;
            if (bl) {
                iMessageDigest.update(SENDER_CLIENT, 0, 4);
            } else {
                iMessageDigest.update(SENDER_SERVER, 0, 4);
            }
            byte[] byArray = this.session.masterSecret;
            iMessageDigest.update(byArray, 0, byArray.length);
            for (int i = 0; i < 48; ++i) {
                iMessageDigest.update((byte)54);
            }
            byte[] byArray2 = iMessageDigest.digest();
            iMessageDigest.update(byArray, 0, byArray.length);
            for (n = 0; n < 48; ++n) {
                iMessageDigest.update((byte)92);
            }
            iMessageDigest.update(byArray2, 0, byArray2.length);
            if (bl) {
                iMessageDigest2.update(SENDER_CLIENT, 0, 4);
            } else {
                iMessageDigest2.update(SENDER_SERVER, 0, 4);
            }
            iMessageDigest2.update(byArray, 0, byArray.length);
            for (n = 0; n < 40; ++n) {
                iMessageDigest2.update((byte)54);
            }
            byArray2 = iMessageDigest2.digest();
            iMessageDigest2.update(byArray, 0, byArray.length);
            for (n = 0; n < 40; ++n) {
                iMessageDigest2.update((byte)92);
            }
            iMessageDigest2.update(byArray2, 0, byArray2.length);
            return new Finished(iMessageDigest.digest(), iMessageDigest2.digest());
        }
        byte[] byArray = iMessageDigest.digest();
        byte[] byArray3 = iMessageDigest2.digest();
        String string = bl ? "client finished" : "server finished";
        byte[] byArray4 = null;
        try {
            byArray4 = Util.concat(string.getBytes("UTF-8"), Util.concat(byArray, byArray3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            RuntimeException runtimeException = new RuntimeException(unsupportedEncodingException.getMessage());
            runtimeException.initCause(unsupportedEncodingException);
            throw runtimeException;
        }
        TLSRandom tLSRandom = new TLSRandom();
        HashMap hashMap = new HashMap();
        hashMap.put("jessie.tls.prng.secret", this.session.masterSecret);
        hashMap.put("jessie.tls.prng.seed", byArray4);
        tLSRandom.init(hashMap);
        byte[] byArray5 = new byte[12];
        try {
            tLSRandom.nextBytes(byArray5, 0, 12);
        }
        catch (LimitReachedException limitReachedException) {
            RuntimeException runtimeException = new RuntimeException(limitReachedException.getMessage());
            runtimeException.initCause(limitReachedException);
            throw runtimeException;
        }
        return new Finished(byArray5);
    }

    private Alert unexpectedMessage() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private void throwUnexpectedMessage() throws IOException {
        throw new AlertException(this.unexpectedMessage(), true);
    }

    private Alert handshakeFailure() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private void throwHandshakeFailure() throws IOException {
        throw new AlertException(this.handshakeFailure(), true);
    }

    private Alert internalError() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private void throwInternalError() throws IOException {
        throw new AlertException(this.internalError(), true);
    }

    private Alert peerUnverified(X509Certificate[] x509CertificateArray) throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private void throwPeerUnverified(X509Certificate[] x509CertificateArray) throws IOException {
        this.peerUnverified(x509CertificateArray);
        throw new SSLPeerUnverifiedException("could not verify: " + x509CertificateArray[0].getSubjectDN());
    }

    private CipherSuite selectSuite(List list2, ProtocolVersion protocolVersion) throws IOException {
        logger.log((Level)Component.SSL_HANDSHAKE, "selectSuite req:{0} suites:{1}", new Object[]{list2, this.session.enabledSuites});
        boolean bl = false;
        Object object = list2.iterator();
        while (object.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)object.next();
            Iterator iterator = this.session.enabledSuites.iterator();
            while (iterator.hasNext()) {
                CipherSuite cipherSuite2 = (CipherSuite)iterator.next();
                if (!cipherSuite2.equals(cipherSuite)) continue;
                logger.log((Level)Component.SSL_HANDSHAKE, "{0} == {1}", new Object[]{cipherSuite2, cipherSuite});
                if (cipherSuite2.getSignature() != "anon" && this.session.keyManager != null && this.session.keyManager.chooseServerAlias(cipherSuite2.getAuthType(), null, null) == null) {
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}: no certificate/private key", cipherSuite2);
                    continue;
                }
                if (cipherSuite2.getKeyExchange() == "SRP") {
                    if (this.session.getValue("srp-username") == null) {
                        logger.log(Component.SSL_HANDSHAKE, "no SRP username");
                        bl = true;
                        continue;
                    }
                    if (this.session.srpTrustManager == null) {
                        logger.log(Component.SSL_HANDSHAKE, "no SRP password file");
                        continue;
                    }
                }
                return cipherSuite2.resolve(protocolVersion);
            }
        }
        object = null;
        if (bl) {
            object = new Alert(Alert.Level.WARNING, Alert.Description.MISSING_SRP_USERNAME);
            this.sendAlert((Alert)object);
            return null;
        }
        object = new Alert(Alert.Level.FATAL, Alert.Description.INSUFFICIENT_SECURITY);
        this.sendAlert((Alert)object);
        this.fatal();
        throw new AlertException((Alert)object, true);
    }

    private String askUserName(String string) {
        Serializable serializable;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            serializable = Class.forName(Util.getSecurityProperty("jessie.srp.user.handler"));
            callbackHandler = (CallbackHandler)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new TextInputCallback("User name for " + string + ": ", Util.getProperty("user.name"));
        try {
            callbackHandler.handle(new Callback[]{serializable});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((TextInputCallback)serializable).getText();
    }

    private String askPassword(String string) {
        Serializable serializable;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            serializable = Class.forName(Util.getSecurityProperty("jessie.srp.password.handler"));
            callbackHandler = (CallbackHandler)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new PasswordCallback(string + "'s password: ", false);
        try {
            callbackHandler.handle(new Callback[]{serializable});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(((PasswordCallback)serializable).getPassword());
    }

    private boolean checkCertificates(X509Certificate[] x509CertificateArray) {
        Object object;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            object = Class.forName(Util.getSecurityProperty("jessie.certificate.handler"));
            callbackHandler = (CallbackHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = Util.getProperty("line.separator");
        ConfirmationCallback confirmationCallback = new ConfirmationCallback("The server's certificate could not be verified. There is no proof" + (String)object + "that this server is who it claims to be, or that their certificate" + (String)object + "is valid. Do you wish to continue connecting?", 2, 0, 1);
        try {
            callbackHandler.handle(new Callback[]{confirmationCallback});
        }
        catch (Exception exception) {
            return false;
        }
        return confirmationCallback.getSelectedIndex() == 0;
    }

    private void updateSig(ISignature iSignature, BigInteger bigInteger) {
        byte[] byArray = Util.trim(bigInteger);
        iSignature.update((byte)(byArray.length >>> 8));
        iSignature.update((byte)byArray.length);
        iSignature.update(byArray, 0, byArray.length);
    }

    private void fatal() throws IOException {
        if (this.session != null) {
            this.session.invalidate();
        }
        if (this.underlyingSocket != null) {
            this.underlyingSocket.close();
        } else {
            super.close();
        }
    }

    static {
        supportedProtocols.add(ProtocolVersion.TLS_1);
        supportedProtocols.add(ProtocolVersion.SSL_3);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_RC4_128_MD5);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_RC4_128_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_EXPORT_WITH_RC4_40_MD5);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_MD5);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_SHA);
        SENDER_CLIENT = new byte[]{67, 76, 78, 84};
        SENDER_SERVER = new byte[]{83, 82, 86, 82};
    }
}

