/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.IMessageDigest;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class DigestOutputStream
extends FilterOutputStream {
    private IMessageDigest md5;
    private IMessageDigest sha;
    private boolean digesting;

    DigestOutputStream(OutputStream outputStream, IMessageDigest iMessageDigest, IMessageDigest iMessageDigest2) {
        super(outputStream);
        this.md5 = iMessageDigest;
        this.sha = iMessageDigest2;
        this.digesting = true;
    }

    void setDigesting(boolean bl) {
        this.digesting = bl;
    }

    public void write(int n) throws IOException {
        if (this.digesting) {
            this.md5.update((byte)n);
            this.sha.update((byte)n);
        }
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.digesting) {
            this.md5.update(byArray, n, n2);
            this.sha.update(byArray, n, n2);
        }
        this.out.write(byArray, n, n2);
    }
}

