/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.pkcs.PKCS7Data;
import gnu.java.security.pkcs.SignerInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;

public class PKCS7SignedData {
    private static final Logger log = Logger.getLogger(PKCS7SignedData.class$("gnu.java.security.pkcs.PKCS7SignedData").getName());
    public static final OID PKCS7_SIGNED_DATA = new OID("1.2.840.113549.1.7.2");
    private BigInteger version;
    private Set digestAlgorithms;
    private OID contentType;
    private byte[] content;
    private Certificate[] certificates;
    private CRL[] crls;
    private Set signerInfos;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PKCS7SignedData(InputStream inputStream) throws CRLException, CertificateException, IOException {
        this(new BERReader(inputStream));
    }

    public PKCS7SignedData(BERReader bERReader) throws CRLException, CertificateException, IOException {
        int n;
        Object object;
        AbstractList abstractList;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        DERValue dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        if (!PKCS7_SIGNED_DATA.equals(dERValue.getValue())) {
            throw new BEREncodingException("content is not SignedData");
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 0) {
            throw new BEREncodingException("malformed Content");
        }
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed SignedData");
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 2) {
            throw new BEREncodingException("expecting Version");
        }
        this.version = (BigInteger)dERValue.getValue();
        this.digestAlgorithms = new HashSet();
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifiers");
        }
        int n2 = 0;
        DERValue dERValue2 = bERReader.read();
        while (dERValue2 != BER.END_OF_SEQUENCE && dERValue.getLength() > 0 && dERValue.getLength() > n2) {
            if (!dERValue2.isConstructed()) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            n2 += dERValue2.getEncodedLength();
            dERValue2 = bERReader.read();
            if (dERValue2.getTag() != 6) {
                throw new BEREncodingException("malformed AlgorithmIdentifier");
            }
            abstractList = new ArrayList(2);
            abstractList.add(dERValue2.getValue());
            dERValue2 = bERReader.read();
            if (dERValue2 != BER.END_OF_SEQUENCE) {
                n2 += dERValue2.getEncodedLength();
                if (dERValue2.getTag() == 5) {
                    abstractList.add(null);
                } else {
                    abstractList.add(dERValue2.getEncoded());
                }
                if (dERValue2.isConstructed()) {
                    bERReader.skip(dERValue2.getLength());
                }
                if (BERValue.isIndefinite(dERValue)) {
                    dERValue2 = bERReader.read();
                }
            } else {
                abstractList.add(null);
            }
            this.digestAlgorithms.add(abstractList);
        }
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed ContentInfo");
        }
        dERValue2 = bERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new BEREncodingException("malformed ContentType");
        }
        this.contentType = (OID)dERValue2.getValue();
        if ((BERValue.isIndefinite(dERValue) || dERValue.getLength() > 0 && dERValue.getLength() > dERValue2.getEncodedLength()) && (dERValue2 = bERReader.read()) != BER.END_OF_SEQUENCE) {
            this.content = dERValue2.getEncoded();
            if (BERValue.isIndefinite(dERValue)) {
                dERValue2 = bERReader.read();
            }
        }
        if ((dERValue = bERReader.read()).getTag() == 0) {
            if (!dERValue.isConstructed()) {
                throw new BEREncodingException("malformed ExtendedCertificatesAndCertificates");
            }
            n2 = 0;
            dERValue2 = bERReader.read();
            abstractList = new LinkedList();
            while (dERValue2 != BER.END_OF_SEQUENCE && dERValue.getLength() > 0 && dERValue.getLength() > n2) {
                object = certificateFactory.generateCertificate(new ByteArrayInputStream(dERValue2.getEncoded()));
                abstractList.add(object);
                bERReader.skip(dERValue2.getLength());
                if (!BERValue.isIndefinite(dERValue) && dERValue.getLength() <= (n2 += dERValue2.getEncodedLength())) continue;
                dERValue2 = bERReader.read();
            }
            this.certificates = (Certificate[])abstractList.toArray(new Certificate[abstractList.size()]);
            dERValue = bERReader.read();
        }
        if (dERValue.getTag() == 1) {
            if (!dERValue.isConstructed()) {
                throw new BEREncodingException("malformed CertificateRevocationLists");
            }
            n2 = 0;
            dERValue2 = bERReader.read();
            abstractList = new LinkedList();
            while (dERValue2 != BER.END_OF_SEQUENCE && dERValue.getLength() > 0 && dERValue.getLength() > n2) {
                object = certificateFactory.generateCRL(new ByteArrayInputStream(dERValue2.getEncoded()));
                abstractList.add(object);
                bERReader.skip(dERValue2.getLength());
                if (!BERValue.isIndefinite(dERValue) && dERValue.getLength() <= (n2 += dERValue2.getEncodedLength())) continue;
                dERValue2 = bERReader.read();
            }
            this.crls = (CRL[])abstractList.toArray(new CRL[abstractList.size()]);
            dERValue = bERReader.read();
        }
        this.signerInfos = new HashSet();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfos");
        }
        while ((n = bERReader.peek()) != 0 && n != -1) {
            this.signerInfos.add(new SignerInfo(bERReader));
        }
    }

    public PKCS7SignedData(Set set, PKCS7Data pKCS7Data, Certificate[] certificateArray, X509CRL[] x509CRLArray, Set set2) {
        this.version = BigInteger.ONE;
        this.digestAlgorithms = set;
        this.contentType = PKCS7_SIGNED_DATA;
        this.content = pKCS7Data == null ? null : pKCS7Data.getEncoded();
        this.certificates = certificateArray;
        this.crls = x509CRLArray;
        this.signerInfos = set2;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (Certificate[])this.certificates.clone();
        }
        return null;
    }

    public OID getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        if (this.content != null) {
            return (byte[])this.content.clone();
        }
        return null;
    }

    public Set getDigestAlgorithms() {
        return Collections.unmodifiableSet(this.digestAlgorithms);
    }

    public Set getSignerInfos() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.signerInfos.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void encode(OutputStream outputStream) throws IOException, CRLException, CertificateEncodingException {
        Object object;
        Object object2;
        DERValue dERValue = new DERValue(2, this.version);
        DERValue dERValue2 = new DERValue(49, this.digestAlgorithms);
        DERValue dERValue3 = new DERValue(6, PKCS7Data.PKCS7_DATA);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(dERValue3);
        if (this.content == null) {
            arrayList.add(new DERValue(5, null));
        } else {
            arrayList.add(this.content);
        }
        DERValue dERValue4 = new DERValue(48, arrayList);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        for (int i = 0; i < this.certificates.length; ++i) {
            byteArrayOutputStream.write(this.certificates[i].getEncoded());
        }
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERValue dERValue5 = new DERValue(160, byArray.length, byArray, null);
        DERValue dERValue6 = null;
        if (this.crls != null && this.crls.length > 0) {
            byteArrayOutputStream.reset();
            for (int i = 0; i < this.crls.length; ++i) {
                byteArrayOutputStream.write(((X509CRL)this.crls[i]).getEncoded());
            }
            byteArrayOutputStream.flush();
            object2 = byteArrayOutputStream.toByteArray();
            dERValue6 = new DERValue(161, ((Object)object2).length, object2, null);
        }
        byteArrayOutputStream.reset();
        object2 = this.signerInfos.iterator();
        while (object2.hasNext()) {
            object = (SignerInfo)object2.next();
            ((SignerInfo)object).encode(byteArrayOutputStream);
        }
        byteArrayOutputStream.flush();
        object2 = byteArrayOutputStream.toByteArray();
        object = new DERValue(49, ((Object)object2).length, object2, null);
        ArrayList arrayList2 = new ArrayList(6);
        arrayList2.add(dERValue);
        arrayList2.add(dERValue2);
        arrayList2.add(dERValue4);
        arrayList2.add(dERValue5);
        if (dERValue6 != null) {
            arrayList2.add(dERValue6);
        }
        arrayList2.add(object);
        DERValue dERValue7 = new DERValue(48, arrayList2);
        ArrayList arrayList3 = new ArrayList(3);
        arrayList3.add(new DERValue(6, PKCS7_SIGNED_DATA));
        arrayList3.add(new DERValue(128, null));
        arrayList3.add(dERValue7);
        DERValue dERValue8 = new DERValue(48, arrayList3);
        DERWriter.write(outputStream, dERValue8);
    }
}

