/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FreetypeGlyphVector
extends GlyphVector {
    private Font font;
    private GdkFontPeer peer;
    private Rectangle2D logicalBounds;
    private float[] glyphPositions;
    private String s;
    private FontRenderContext frc;
    private int nGlyphs;
    private int[] glyphCodes;
    private AffineTransform[] glyphTransforms;
    private GlyphMetrics[] metricsCache;

    public FreetypeGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this(font, string, fontRenderContext, 0);
    }

    public FreetypeGlyphVector(Font font, String string, FontRenderContext fontRenderContext, int n) {
        this.s = string;
        this.font = font;
        this.frc = fontRenderContext;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.getGlyphs();
        if (n == 1) {
            int[] nArray = new int[this.nGlyphs];
            for (int i = 0; i < this.nGlyphs; ++i) {
                nArray[i] = this.glyphCodes[this.nGlyphs - i - 1];
            }
            this.glyphCodes = nArray;
        }
        this.performDefaultLayout();
    }

    public FreetypeGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        if (!(this.font.getPeer() instanceof GdkFontPeer)) {
            throw new IllegalArgumentException("Not a valid font.");
        }
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.glyphCodes = new int[nArray.length];
        System.arraycopy(nArray, 0, this.glyphCodes, 0, nArray.length);
        this.nGlyphs = this.glyphCodes.length;
        this.performDefaultLayout();
    }

    private FreetypeGlyphVector(FreetypeGlyphVector freetypeGlyphVector) {
        this.font = freetypeGlyphVector.font;
        this.peer = freetypeGlyphVector.peer;
        this.frc = freetypeGlyphVector.frc;
        this.s = freetypeGlyphVector.s;
        this.nGlyphs = freetypeGlyphVector.nGlyphs;
        this.logicalBounds = freetypeGlyphVector.logicalBounds.getBounds2D();
        if (freetypeGlyphVector.metricsCache != null) {
            this.metricsCache = new GlyphMetrics[this.nGlyphs];
            System.arraycopy(freetypeGlyphVector.metricsCache, 0, this.metricsCache, 0, this.nGlyphs);
        }
        this.glyphCodes = new int[this.nGlyphs];
        this.glyphPositions = new float[this.nGlyphs];
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        for (int i = 0; i < this.nGlyphs; ++i) {
            this.glyphTransforms[i] = new AffineTransform(freetypeGlyphVector.glyphTransforms[i]);
            this.glyphCodes[i] = freetypeGlyphVector.glyphCodes[i];
            this.glyphPositions[i] = freetypeGlyphVector.glyphPositions[i];
        }
    }

    private void getGlyphs() {
        this.nGlyphs = this.s.codePointCount(0, this.s.length());
        this.glyphCodes = new int[this.nGlyphs];
        int[] nArray = new int[this.nGlyphs];
        int n = 0;
        for (int i = 0; i < this.nGlyphs; ++i) {
            nArray[i] = this.s.codePointAt(n);
            if (nArray[i] != this.s.charAt(n)) {
                ++n;
            }
            ++n;
        }
        this.glyphCodes = this.getGlyphs(nArray);
    }

    public native int[] getGlyphs(int[] var1);

    private native Point2D getKerning(int var1, int var2);

    private native double[] getMetricsNative(int var1);

    private native GeneralPath getGlyphOutlineNative(int var1);

    public Object clone() {
        return new FreetypeGlyphVector(this);
    }

    public boolean equals(GlyphVector glyphVector) {
        if (!(glyphVector instanceof FreetypeGlyphVector)) {
            return false;
        }
        return ((FreetypeGlyphVector)glyphVector).font.equals(this.font) && ((FreetypeGlyphVector)glyphVector).frc.equals(this.frc) && ((FreetypeGlyphVector)glyphVector).s.equals(this.s);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.glyphPositions = null;
        this.glyphTransforms = new AffineTransform[this.nGlyphs];
        double d = 0.0;
        for (int i = 0; i < this.nGlyphs; ++i) {
            GlyphMetrics glyphMetrics = this.getGlyphMetrics(i);
            this.glyphTransforms[i] = AffineTransform.getTranslateInstance(d, 0.0);
            d += (double)glyphMetrics.getAdvanceX();
            if (i <= 0) continue;
            Point2D point2D = this.getKerning(this.glyphCodes[i - 1], this.glyphCodes[i]);
            d += point2D.getX();
        }
    }

    public int getGlyphCode(int n) {
        return this.glyphCodes[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray == null ? new int[n2] : nArray;
        System.arraycopy(this.glyphCodes, n, nArray2, 0, n2);
        return nArray2;
    }

    public Shape getGlyphLogicalBounds(int n) {
        GlyphMetrics glyphMetrics = this.getGlyphMetrics(n);
        if (glyphMetrics == null) {
            return null;
        }
        Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
        Point2D point2D = this.getGlyphPosition(n);
        return new Rectangle2D.Double(point2D.getX() + rectangle2D.getX() - (double)glyphMetrics.getLSB(), point2D.getY() + rectangle2D.getY(), glyphMetrics.getAdvanceX(), rectangle2D.getHeight());
    }

    public void setupGlyphMetrics() {
        this.metricsCache = new GlyphMetrics[this.nGlyphs];
        for (int i = 0; i < this.nGlyphs; ++i) {
            GlyphMetrics glyphMetrics = this.peer.getGlyphMetrics(this.glyphCodes[i]);
            if (glyphMetrics == null) {
                double[] dArray = this.getMetricsNative(this.glyphCodes[i]);
                if (dArray == null) {
                    glyphMetrics = null;
                } else {
                    glyphMetrics = new GlyphMetrics(true, (float)dArray[1], (float)dArray[2], new Rectangle2D.Double(dArray[3], dArray[4], dArray[5], dArray[6]), 0);
                    this.peer.putGlyphMetrics(this.glyphCodes[i], glyphMetrics);
                }
            }
            this.metricsCache[i] = glyphMetrics;
        }
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        if (this.metricsCache == null) {
            this.setupGlyphMetrics();
        }
        return this.metricsCache[n];
    }

    public Shape getGlyphOutline(int n) {
        GeneralPath generalPath = this.getGlyphOutlineNative(this.glyphCodes[n]);
        generalPath.transform(this.glyphTransforms[n]);
        return generalPath;
    }

    public Point2D getGlyphPosition(int n) {
        return this.glyphTransforms[n].transform(new Point2D.Double(0.0, 0.0), null);
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (this.glyphPositions != null) {
            return this.glyphPositions;
        }
        float[] fArray2 = fArray == null ? new float[2 * n2] : fArray;
        for (int i = n; i < n2; ++i) {
            Point2D point2D = this.getGlyphPosition(i);
            fArray2[i * 2] = (float)point2D.getX();
            fArray2[i * 2 + 1] = (float)point2D.getY();
        }
        this.glyphPositions = fArray2;
        return fArray2;
    }

    public AffineTransform getGlyphTransform(int n) {
        return new AffineTransform(this.glyphTransforms[n]);
    }

    public Shape getGlyphVisualBounds(int n) {
        return this.getGlyphOutline(n).getBounds2D();
    }

    public Rectangle2D getLogicalBounds() {
        if (this.nGlyphs == 0) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        if (this.logicalBounds != null) {
            return this.logicalBounds;
        }
        Rectangle2D rectangle2D = (Rectangle2D)this.getGlyphLogicalBounds(0);
        for (int i = 1; i < this.nGlyphs; ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)this.getGlyphLogicalBounds(i);
            rectangle2D = rectangle2D.createUnion(rectangle2D2);
        }
        this.logicalBounds = rectangle2D;
        return rectangle2D;
    }

    public int getNumGlyphs() {
        return this.glyphCodes.length;
    }

    public Shape getOutline() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            generalPath.append(this.getGlyphOutline(i), false);
        }
        return generalPath;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return null;
    }

    public Shape getOutline(float f, float f2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        GeneralPath generalPath = (GeneralPath)this.getOutline();
        generalPath.transform(affineTransform);
        return generalPath;
    }

    public Rectangle2D getVisualBounds() {
        return this.getOutline().getBounds2D();
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.glyphTransforms[n].setToTranslation(point2D.getX(), point2D.getY());
        this.logicalBounds = null;
        this.glyphPositions = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        this.glyphTransforms[n].setTransform(affineTransform);
        this.logicalBounds = null;
        this.glyphPositions = null;
    }
}

