/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class JARUpdater {
    private JARDesc _jar = null;
    private CacheEntry _ce = null;
    private boolean _updateChecked = false;
    private boolean _updateAvailable = false;
    private boolean _updateDownloaded = false;

    public JARUpdater(JARDesc jARDesc) {
        this._jar = jARDesc;
    }

    public synchronized boolean isUpdateAvailable() {
        if (!this._updateChecked) {
            Trace.println((String)("JARUpdater:isUpdateAvailable: " + this._jar.getLocation().toString()), (TraceLevel)TraceLevel.NETWORK);
            try {
                this._updateAvailable = this.updateCheck();
                this._updateChecked = true;
                this._updateDownloaded = !this._updateAvailable;
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return this._updateAvailable;
    }

    public boolean isUpdateDownloaded() {
        return this._updateDownloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadUpdate() throws Exception {
        if (this.isUpdateAvailable()) {
            this.download();
        }
        JARUpdater jARUpdater = this;
        synchronized (jARUpdater) {
            this._updateAvailable = false;
            this._updateDownloaded = true;
        }
    }

    private CacheEntry getCacheEntry() {
        return this._ce;
    }

    public void updateCache() throws IOException {
        URL uRL = this._jar.getLocation();
        CacheEntry cacheEntry = this.getCacheEntry();
        CacheEntry cacheEntry2 = Cache.getCacheEntry((URL)uRL, null, (String)this._jar.getVersion(), (int)this.getContentType());
        if (cacheEntry != null) {
            Cache.processNewCacheEntry((URL)uRL, (boolean)true, (CacheEntry)cacheEntry, (CacheEntry)cacheEntry2);
        }
        Trace.println((String)("Background Update Thread: update cache: " + uRL), (TraceLevel)TraceLevel.NETWORK);
    }

    private boolean updateCheck() throws JNLPException {
        URL uRL = this._jar.getLocation();
        String string = this._jar.getVersion();
        boolean bl = false;
        if (string != null) {
            return false;
        }
        try {
            bl = DownloadEngine.isUpdateAvailable((URL)uRL, (String)string, (boolean)this._jar.isPack200Enabled());
        }
        catch (IOException iOException) {
            throw new FailedDownloadingResourceException(uRL, null, iOException);
        }
        return bl;
    }

    private void download() throws JNLPException {
        int n = this.getContentType();
        URL uRL = this._jar.getLocation();
        String string = this._jar.getVersion();
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = DownloadEngine.getResourceTempCacheEntry((URL)uRL, (String)string, (int)n);
            Trace.println((String)("Downloaded " + uRL + " to " + URLUtil.fileToURL((File)new File(cacheEntry.getResourceFilename())) + "\n\t Cache Entry disabled"), (TraceLevel)TraceLevel.NETWORK);
        }
        catch (IOException iOException) {
            throw new FailedDownloadingResourceException(uRL, string, iOException);
        }
        if (Cache.isCacheEnabled() && cacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        this._ce = cacheEntry;
    }

    private int getContentType() {
        int n = 256;
        if (this._jar.isNativeLib()) {
            n |= 0x10;
        }
        if (this._jar.isPack200Enabled()) {
            n |= 0x1000;
        }
        return n;
    }
}

