/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.util.ClassLogger;

public abstract class ServerCommunicatorAdmin {
    private long timestamp;
    private final int[] lock = new int[0];
    private int currentJobs = 0;
    private long timeout;
    private boolean terminated = false;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ServerCommunicatorAdmin");
    private static final ClassLogger timelogger = new ClassLogger("javax.management.remote.timeout", "ServerCommunicatorAdmin");

    public ServerCommunicatorAdmin(long l) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "Creates a new ServerCommunicatorAdmin object with the timeout " + l);
        }
        this.timeout = l;
        this.timestamp = 0L;
        if (l < Long.MAX_VALUE) {
            Timeout timeout = new Timeout();
            Thread thread = new Thread(timeout);
            thread.setName("JMX server connection timeout " + thread.getId());
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reqIncoming() {
        if (logger.traceOn()) {
            logger.trace("reqIncoming", "Receive a new request.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                logger.warning("reqIncoming", "The server has decided to close this client connection.");
            }
            ++this.currentJobs;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rspOutgoing() {
        if (logger.traceOn()) {
            logger.trace("reqIncoming", "Finish a request.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (--this.currentJobs == 0) {
                this.timestamp = System.currentTimeMillis();
                this.logtime("Admin: Timestamp=", this.timestamp);
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.terminated;
        }
    }

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "terminate the ServerCommunicatorAdmin object.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.lock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void logtime(String string, long l) {
        timelogger.trace("synchro", string + l);
    }

    private class Timeout
    implements Runnable {
        private Timeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            int[] nArray = ServerCommunicatorAdmin.this.lock;
            synchronized (nArray) {
                if (ServerCommunicatorAdmin.this.timestamp == 0L) {
                    ServerCommunicatorAdmin.this.timestamp = System.currentTimeMillis();
                }
                ServerCommunicatorAdmin.this.logtime("Admin: timeout=", ServerCommunicatorAdmin.this.timeout);
                ServerCommunicatorAdmin.this.logtime("Admin: Timestamp=", ServerCommunicatorAdmin.this.timestamp);
                while (!ServerCommunicatorAdmin.this.terminated) {
                    try {
                        while (!ServerCommunicatorAdmin.this.terminated && ServerCommunicatorAdmin.this.currentJobs != 0) {
                            if (logger.traceOn()) {
                                logger.trace("Timeout-run", "Waiting without timeout.");
                            }
                            ServerCommunicatorAdmin.this.lock.wait();
                        }
                        if (ServerCommunicatorAdmin.this.terminated) {
                            return;
                        }
                        long l = ServerCommunicatorAdmin.this.timeout - (System.currentTimeMillis() - ServerCommunicatorAdmin.this.timestamp);
                        ServerCommunicatorAdmin.this.logtime("Admin: remaining timeout=", l);
                        if (l > 0L) {
                            if (logger.traceOn()) {
                                logger.trace("Timeout-run", "Waiting with timeout: " + l + " ms remaining");
                            }
                            ServerCommunicatorAdmin.this.lock.wait(l);
                        }
                        if (ServerCommunicatorAdmin.this.currentJobs > 0) continue;
                        long l2 = System.currentTimeMillis() - ServerCommunicatorAdmin.this.timestamp;
                        ServerCommunicatorAdmin.this.logtime("Admin: elapsed=", l2);
                        if (ServerCommunicatorAdmin.this.terminated || l2 <= ServerCommunicatorAdmin.this.timeout) continue;
                        if (logger.traceOn()) {
                            logger.trace("Timeout-run", "timeout elapsed");
                        }
                        ServerCommunicatorAdmin.this.logtime("Admin: timeout elapsed! " + l2 + ">", ServerCommunicatorAdmin.this.timeout);
                        ServerCommunicatorAdmin.this.terminated = true;
                        bl = true;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warning("Timeout-run", "Unexpected Exception: " + interruptedException);
                        logger.debug("Timeout-run", interruptedException);
                        return;
                    }
                }
            }
            if (bl) {
                if (logger.traceOn()) {
                    logger.trace("Timeout-run", "Call the doStop.");
                }
                ServerCommunicatorAdmin.this.doStop();
            }
        }
    }
}

