#!/bin/sh -f
# apr:Apache Portable Runtime	(http://apr.apache.org/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-20
# require:
#	Heimdal-1.2
#	neon-0.26.3

APR=apr-1.3.2
APRUTIL=apr-util-1.3.2
APRICONV=apr-iconv-1.2.1

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www
PAC_DIR=$PLAMO/Packages/4.5/WWW
BUILD_DIR=$PLAMO/apr
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


for a in $APR $APRUTIL $APRICONV; do \
	PAC_NAME=$a
	SRC_FILE=${PAC_NAME}.tar.gz
	if [ ! -f $SRC_DIR/$SRC_FILE ]; then
	    (cd $SRC_DIR; \
		 wget -N  http://ftp.riken.jp/net/apache/apr/$SRC_FILE);
	fi;

	umask 022
	CWD=`pwd`
	WORK=$CWD/work
	rm -rf $WORK/*
	mkdir -p  $WORK
	export LANG=C
	export CFLAGS="-O2"
	export PATH=$PATH:/usr/X11R6/bin


	tar xvfz $SRC_DIR/$SRC_FILE
	cd $PAC_NAME
	 ./configure --prefix=/usr --with-apxs=/opt/httpd/bin/apxs --with-ssl --with-neon=/usr --with-apr=/usr
	 make
	 chkinstall -P -y | tee checkinst.log

	DOC_DIR=usr/share/doc/$PAC_NAME
	mkdir -p $WORK/$DOC_DIR || exit 1
	cp -p $BUILD_DIR/`basename $0`  \
	      config.log [A-Z]*  $WORK/$DOC_DIR
	rm  $WORK/$DOC_DIR/*[Mm]akefile*
	chown -R root.root  $WORK/$DOC_DIR

	tar xvfz ${PAC_NAME}-i386-1.tgz -C $WORK
	cd $WORK


	tar cvfz ${PAC_NAME}.tgz  usr/*/* install/doinst.sh 
	echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
	if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz` 1>/dev/null 2>&1; then
	  echo " ... done"
	else
	  echo " ... false"
	fi
	cd $CWD
done
