#!/bin/sh

SERVER=/usr/bin/sj3serv
KILLER="killall sj3serv"
LOCKD=/var/lock/subsys

[ -f $SERVER ] || exit 0
case "$1" in
start)
  echo -n "Starting Sj3 server: "
  $SERVER
  echo
  [ -d $LOCKD ] && touch $LOCKD/sj3
  ;;
stop)
  echo -n "Shutting down Sj3 server: "
  $KILLER
  echo
  [ -d $LOCKD ] && rm -f $LOCKD/sj3
  ;;
install)
  echo sj3 network
  ;;
*)
  echo "Usage: sj3 {start|stop}"
  exit 1
  ;;
esac
exit 0
