#!/bin/sh

#kmajor=2.6.20
kmajor=2.6.30
kvers=2.6.30.7
config=config-"$kvers"-aufs-plamoSMP
#config=config-"$kvers"-plamoSMP_with_IDE
#config=config-"$kvers"-noLSF
#config=config-$kvers-plamoUP
source=linux-2.6.30.tar.bz2
build=P1

patch0=patch-$kvers.bz2
patch1=vd_unicon-kernel-20090324-2.6.29.patch
patch2=vd_unicon-kernel-fonts-20040205.patch.bz2
patch3=2.6.29-export-init_mm.patch
patch4=aufs2-2.6.30.patch
#patch5=050-pcomp_update.patch
#patch6=051-squashfs_pcomp.patch
#patch7=052-pcomp_lzma_support.patch
#patch8=053-squashfs_lzma.patch
#patch3=tuxonice-3.0-rc5-for-2.6.24.patch.bz2
source_expand=on

root_chk=`id | grep 'uid=0' | cut -d" " -f1`
echo $root_chk

if [ $root_chk".x" == ".x" ] ; then
  SUDO='/usr/bin/sudo'
else
  SUDO=''
fi

src_dir=`pwd`

build_dir=$src_dir/Build

if [ "$source_expand.x" == "on.x" ]; then

if [ -d $build_dir ]; then
   $SUDO rm -rf $build_dir
fi

mkdir -p $build_dir
cd $build_dir
tar xvjpf $src_dir/$source
pushd linux-$kmajor
  if [ -f $src_dir/$patch0 ] ; then
      bzcat $src_dir/$patch0 | patch -p1
  fi
  if [ -f $src_dir/$patch1 ] ; then
      patch -p1 < $src_dir/$patch1
      bzcat $src_dir/$patch2 | patch -p1
  fi
  cat $src_dir/$patch3 | patch -p1
  cat $src_dir/$patch4 | patch -p1
  # cat $src_dir/$patch5 | patch -p1
  # cat $src_dir/$patch6 | patch -p1
  # cat $src_dir/$patch7 | patch -p1
  # cat $src_dir/$patch8 | patch -p1

  
popd 
mv linux-$kmajor linux-$kvers
cd linux-$kvers

# reverted to original action at 2.6.29.2
# so this patch doesn't need any more
#
#patch -p0 <<EOF 
#*** drivers/char/vt.c.orig	2009-04-27 19:53:09.000000000 +0900
#--- drivers/char/vt.c	2009-04-27 19:54:31.000000000 +0900
#***************
#*** 2403,2409 ****
#  				    continue; /* nothing to display */
#  				}
#  				/* Glyph not found */
#! 				if ((!(vc->vc_utf && !vc->vc_disp_ctrl) && c < 128) && !(c & ~charmask)) {
#  				    /* In legacy mode use the glyph we get by a 1:1 mapping.
#  				       This would make absolutely no sense with Unicode in mind,
#  				       but do this for ASCII characters since a font may lack
#--- 2403,2409 ----
#  				    continue; /* nothing to display */
#  				}
#  				/* Glyph not found */
#! 				if ((!(vc->vc_utf && !vc->vc_disp_ctrl) || c < 128) && !(c & ~charmask)) {
#  				    /* In legacy mode use the glyph we get by a 1:1 mapping.
#  				       This would make absolutely no sense with Unicode in mind,
#  				       but do this for ASCII characters since a font may lack
#EOF

#echo "config = $src_dir/$config"
config=config-2.6.30.6-aufs-plamoSMP
cp $src_dir/$config ./.config
fi

cd $build_dir/linux-$kvers

#arch_chk=`echo $config | grep SMP`
#if [ $arch_chk".x" == ".x" ]; then 
#  arch=i586
#else
#  arch=i686
#fi
arch=i586
pkgbase=kernel

if [ -f Makefile ]; then
  major=`grep "^VERSION" Makefile | cut -d" " -f3`
  minor=`grep "^PATCH" Makefile | cut -d" " -f3`
  rel=`grep "^SUBLEVEL" Makefile | cut -d" " -f3`
  patch=`grep "^EXTRAVERSION" Makefile | cut -d" " -f3`
fi

if [ -f .config ]; then
  local=`grep "^CONFIG_LOCALVERSION=" .config | cut -d"=" -f2 | sed 's/\"//g' `
fi

vers=${major}"."${minor}"."${rel}${patch}${local}
pkgvers=`echo $vers | sed 's/-/_/'`

pkg=${pkgbase}"-"${pkgvers}"-"${arch}"-"${build}".tgz"

H=`pwd`
T=`pwd`/../pkg

if [ -d $T ]; then
  $SUDO rm -rf $T
fi

make -j5
make modules_install INSTALL_MOD_PATH=$build_dir/modules
make firmware_install INSTALL_FW_PATH=$build_dir/firmware
# make headers_install INSTALL_HDR_PATH=$build_dir/headers
mkdir -p $T/lib/modules
cp -a $build_dir/modules/lib/modules/$vers $T/lib/modules
mkdir -p $T/lib/firmware
cp -a $build_dir/firmware/* $T/lib/firmware

# mkdir -p $T/usr
# cp -a $build_dir/headers/include $T/usr

pushd $T/lib/modules/$vers
  rm build source
  ln -sf /usr/src/linux build
  ln -sf /usr/src/linux source
popd

mkdir -p $T/boot
pushd $T/boot
  cp $H/.config ./config-$vers
  cp $H/System.map ./System.map-$vers
  cp $H/arch/i386/boot/bzImage ./vmlinuz-$vers
  ln -sf config-$vers config
  ln -sf System.map-$vers System.map
  ln -sf vmlinuz-$vers vmlinuz
popd

mkdir -p $T/usr/share/doc/linux-$vers
for i in `seq 0 4 `; do
    file="patch"$i
    cp $src_dir/${!file} $T/usr/share/doc/linux-$vers
done
cp $src_dir/$0 $T/usr/share/doc/linux-$vers

$SUDO chown -R root.root $T
pushd $T
$SUDO /sbin/makepkg $pkg << EOF
y
EOF
$SUDO mv $pkg ..
popd
