/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIAbLDAPAttributeMap.idl
 */

#ifndef __gen_nsIAbLDAPAttributeMap_h__
#define __gen_nsIAbLDAPAttributeMap_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISimpleEnumerator; /* forward declaration */

class nsILDAPMessage; /* forward declaration */

class nsIAbCard; /* forward declaration */


/* starting interface:    nsIAbLDAPAttributeMap */
#define NS_IABLDAPATTRIBUTEMAP_IID_STR "2ba46eae-9141-4d79-af90-3c7ecf2dc357"

#define NS_IABLDAPATTRIBUTEMAP_IID \
  {0x2ba46eae, 0x9141, 0x4d79, \
    { 0xaf, 0x90, 0x3c, 0x7e, 0xcf, 0x2d, 0xc3, 0x57 }}

/**
 * A mapping between addressbook properties and ldap attributes.
 *
 * Each addressbook property can map to one or more attributes.  If
 * there is no entry in preferences for a field, the getters generally
 * return null; empty strings are passed through as usual. The intent is
 * that properties with a non-zero number of attributes can be overridden for
 * a specific server by supplying a zero-length string.  For this to work,
 * most callers are likely to want to check for both success and a 
 * non-empty string. 
 *
 * Note that the one exception to this pattern is getAttributes, which
 * throws NS_ERROR_FAILURE for non-existent property entries, since
 * XPConnect doesn't like returning null arrays.
 *
 * Note that each LDAP attribute can map to at most one addressbook
 * property.  The checkState method is a useful tool in enforcing
 * this.  Failure to enforce it may make it impossible to guarantee
 * that getProperty will do something consistent and reasonable.
 *
 * Maybe someday once we support ldap autoconfig stuff (ie
 * draft-joslin-config-schema-11.txt), we can simplify this and other
 * code and only allow a property to map to a single attribute.
 */
class NS_NO_VTABLE nsIAbLDAPAttributeMap : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IABLDAPATTRIBUTEMAP_IID)

  /**
   * Get all the LDAP attributes associated with a given property
   * name, in order of precedence (highest to lowest).
   *
   * @param       aProperty   the address book property to return attrs for   
   *    
   * @return      a comma-separated list of attributes, null if no entry is
   *              present
   */
  /* ACString getAttributeList (in ACString aProperty); */
  NS_IMETHOD GetAttributeList(const nsACString & aProperty, nsACString & _retval) = 0;

  /**
   * Get all the LDAP attributes associated with a given property name, in 
   * order of precedence (highest to lowest).
   * 
   * @param       aProperty   the address book property to return attrs for   
   *
   * @return      an array of attributes
   *
   * @exception   NS_ERROR_FAILURE if there is no entry for this property
   */
  /* void getAttributes (in ACString aProperty, out unsigned long aCount, [array, retval, size_is (aCount)] out string aAttrs); */
  NS_IMETHOD GetAttributes(const nsACString & aProperty, PRUint32 *aCount, char ***aAttrs) = 0;

  /**
   * Get the first (canonical) LDAP attribute associated with a given property
   * name
   *
   * @param       aProperty   the address book property to return attrs for   
   * 
   * @return      the first attribute associated with a given property, 
   *              null if there is no entry for this property
   */
  /* ACString getFirstAttribute (in ACString aProperty); */
  NS_IMETHOD GetFirstAttribute(const nsACString & aProperty, nsACString & _retval) = 0;

  /**
   * Set an existing mapping to the comma-separated list of attributes.
   * 
   * @param aProperty               the mozilla addressbook property name
   *
   * @param aAttributeList          a comma-separated list of attributes in
   *                                order of precedence from high to low
   *
   * @param aAllowInconsistencies   allow changes that would result in
   *                                a map with an LDAP attribute associated
   *                                with more than one property.  Useful for
   *                                doing a bunch of sets at once, and
   *                                calling checkState at the end.
   *
   * @exception NS_ERROR_FAILURE    making this change would result in a map
   *                                with an LDAP attribute pointing to more
   *                                than one property
   */
  /* void setAttributeList (in ACString aProperty, in ACString aAttributeList, in boolean allowInconsistencies); */
  NS_IMETHOD SetAttributeList(const nsACString & aProperty, const nsACString & aAttributeList, PRBool allowInconsistencies) = 0;

  /**
   * Find the Mozilla addressbook property name that this attribute should
   * map to. 
   * 
   * @return the addressbook property name, null if it's not used in the map
   */
  /* ACString getProperty (in ACString aAttribute); */
  NS_IMETHOD GetProperty(const nsACString & aAttribute, nsACString & _retval) = 0;

  /**
   * Get all attributes that may be used in an addressbook card via this
   * property map (used for passing to to an LDAP search when you want
   * everything that could be in a card returned).
   *
   * @return                      a comma-separated list of attribute names
   *
   * @exception NS_ERROR_FAILURE  there are no attributes in this property map
   */
  /* ACString getAllCardAttributes (); */
  NS_IMETHOD GetAllCardAttributes(nsACString & _retval) = 0;

  /**
   * Check that no LDAP attributes are listed in more than one property.
   *
   * @exception NS_ERROR_FAILURE    one or more LDAP attributes are listed
   *                                multiple times.  The object is now in an
   *                                inconsistent state, and should be either
   *                                manually repaired or discarded.
   */
  /* void checkState (); */
  NS_IMETHOD CheckState(void) = 0;

  /**
   * Set any attributes specified in the given prefbranch on this object.
   *
   * @param aPrefBranchName         the pref branch containing all the
   *                                property names
   * 
   * @exception NS_ERROR_FAILURE    one or more LDAP attributes are listed
   *                                multiple times.  The object is now in an
   *                                inconsistent state, and should be either
   *                                manually repaired or discarded.
   */
  /* void setFromPrefs (in ACString aPrefBranchName); */
  NS_IMETHOD SetFromPrefs(const nsACString & aPrefBranchName) = 0;

  /**
   * Set the properties on an addressbook card from the given LDAP message
   * using the map in this object.
   *
   * @param       aCard is the card object whose values are to be set
   * @param       aMessage is the LDAP message to get the values from
   *
   * @exception   NS_ERROR_FAILURE is thrown if no addressbook properties
   *              are found in the message
   */
  /* void setCardPropertiesFromLDAPMessage (in nsILDAPMessage aMessage, in nsIAbCard aCard); */
  NS_IMETHOD SetCardPropertiesFromLDAPMessage(nsILDAPMessage *aMessage, nsIAbCard *aCard) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABLDAPATTRIBUTEMAP \
  NS_IMETHOD GetAttributeList(const nsACString & aProperty, nsACString & _retval); \
  NS_IMETHOD GetAttributes(const nsACString & aProperty, PRUint32 *aCount, char ***aAttrs); \
  NS_IMETHOD GetFirstAttribute(const nsACString & aProperty, nsACString & _retval); \
  NS_IMETHOD SetAttributeList(const nsACString & aProperty, const nsACString & aAttributeList, PRBool allowInconsistencies); \
  NS_IMETHOD GetProperty(const nsACString & aAttribute, nsACString & _retval); \
  NS_IMETHOD GetAllCardAttributes(nsACString & _retval); \
  NS_IMETHOD CheckState(void); \
  NS_IMETHOD SetFromPrefs(const nsACString & aPrefBranchName); \
  NS_IMETHOD SetCardPropertiesFromLDAPMessage(nsILDAPMessage *aMessage, nsIAbCard *aCard); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABLDAPATTRIBUTEMAP(_to) \
  NS_IMETHOD GetAttributeList(const nsACString & aProperty, nsACString & _retval) { return _to GetAttributeList(aProperty, _retval); } \
  NS_IMETHOD GetAttributes(const nsACString & aProperty, PRUint32 *aCount, char ***aAttrs) { return _to GetAttributes(aProperty, aCount, aAttrs); } \
  NS_IMETHOD GetFirstAttribute(const nsACString & aProperty, nsACString & _retval) { return _to GetFirstAttribute(aProperty, _retval); } \
  NS_IMETHOD SetAttributeList(const nsACString & aProperty, const nsACString & aAttributeList, PRBool allowInconsistencies) { return _to SetAttributeList(aProperty, aAttributeList, allowInconsistencies); } \
  NS_IMETHOD GetProperty(const nsACString & aAttribute, nsACString & _retval) { return _to GetProperty(aAttribute, _retval); } \
  NS_IMETHOD GetAllCardAttributes(nsACString & _retval) { return _to GetAllCardAttributes(_retval); } \
  NS_IMETHOD CheckState(void) { return _to CheckState(); } \
  NS_IMETHOD SetFromPrefs(const nsACString & aPrefBranchName) { return _to SetFromPrefs(aPrefBranchName); } \
  NS_IMETHOD SetCardPropertiesFromLDAPMessage(nsILDAPMessage *aMessage, nsIAbCard *aCard) { return _to SetCardPropertiesFromLDAPMessage(aMessage, aCard); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABLDAPATTRIBUTEMAP(_to) \
  NS_IMETHOD GetAttributeList(const nsACString & aProperty, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttributeList(aProperty, _retval); } \
  NS_IMETHOD GetAttributes(const nsACString & aProperty, PRUint32 *aCount, char ***aAttrs) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAttributes(aProperty, aCount, aAttrs); } \
  NS_IMETHOD GetFirstAttribute(const nsACString & aProperty, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstAttribute(aProperty, _retval); } \
  NS_IMETHOD SetAttributeList(const nsACString & aProperty, const nsACString & aAttributeList, PRBool allowInconsistencies) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAttributeList(aProperty, aAttributeList, allowInconsistencies); } \
  NS_IMETHOD GetProperty(const nsACString & aAttribute, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProperty(aAttribute, _retval); } \
  NS_IMETHOD GetAllCardAttributes(nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllCardAttributes(_retval); } \
  NS_IMETHOD CheckState(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckState(); } \
  NS_IMETHOD SetFromPrefs(const nsACString & aPrefBranchName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFromPrefs(aPrefBranchName); } \
  NS_IMETHOD SetCardPropertiesFromLDAPMessage(nsILDAPMessage *aMessage, nsIAbCard *aCard) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCardPropertiesFromLDAPMessage(aMessage, aCard); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbLDAPAttributeMap : public nsIAbLDAPAttributeMap
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABLDAPATTRIBUTEMAP

  nsAbLDAPAttributeMap();

private:
  ~nsAbLDAPAttributeMap();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbLDAPAttributeMap, nsIAbLDAPAttributeMap)

nsAbLDAPAttributeMap::nsAbLDAPAttributeMap()
{
  /* member initializers and constructor code */
}

nsAbLDAPAttributeMap::~nsAbLDAPAttributeMap()
{
  /* destructor code */
}

/* ACString getAttributeList (in ACString aProperty); */
NS_IMETHODIMP nsAbLDAPAttributeMap::GetAttributeList(const nsACString & aProperty, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAttributes (in ACString aProperty, out unsigned long aCount, [array, retval, size_is (aCount)] out string aAttrs); */
NS_IMETHODIMP nsAbLDAPAttributeMap::GetAttributes(const nsACString & aProperty, PRUint32 *aCount, char ***aAttrs)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getFirstAttribute (in ACString aProperty); */
NS_IMETHODIMP nsAbLDAPAttributeMap::GetFirstAttribute(const nsACString & aProperty, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setAttributeList (in ACString aProperty, in ACString aAttributeList, in boolean allowInconsistencies); */
NS_IMETHODIMP nsAbLDAPAttributeMap::SetAttributeList(const nsACString & aProperty, const nsACString & aAttributeList, PRBool allowInconsistencies)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getProperty (in ACString aAttribute); */
NS_IMETHODIMP nsAbLDAPAttributeMap::GetProperty(const nsACString & aAttribute, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getAllCardAttributes (); */
NS_IMETHODIMP nsAbLDAPAttributeMap::GetAllCardAttributes(nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void checkState (); */
NS_IMETHODIMP nsAbLDAPAttributeMap::CheckState()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFromPrefs (in ACString aPrefBranchName); */
NS_IMETHODIMP nsAbLDAPAttributeMap::SetFromPrefs(const nsACString & aPrefBranchName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCardPropertiesFromLDAPMessage (in nsILDAPMessage aMessage, in nsIAbCard aCard); */
NS_IMETHODIMP nsAbLDAPAttributeMap::SetCardPropertiesFromLDAPMessage(nsILDAPMessage *aMessage, nsIAbCard *aCard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIAbLDAPAttributeMapService */
#define NS_IABLDAPATTRIBUTEMAPSERVICE_IID_STR "12e2d589-3c2a-48e4-8c82-b1e6464a0dfd"

#define NS_IABLDAPATTRIBUTEMAPSERVICE_IID \
  {0x12e2d589, 0x3c2a, 0x48e4, \
    { 0x8c, 0x82, 0xb1, 0xe6, 0x46, 0x4a, 0x0d, 0xfd }}

/**
 * The nsIAbLDAPAttributeMapService is used to build and hold a cache
 * of maps.  
 */
class NS_NO_VTABLE nsIAbLDAPAttributeMapService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IABLDAPATTRIBUTEMAPSERVICE_IID)

  /**
   * Accessor to construct or return a cached copy of the attribute
   * map for a given preference branch.  The map is constructed by
   * first taking the default map (as specified by the
   * "ldap_2.servers.default.attrmap" prefbranch), and then having any
   * preferences specified by aPrefBranchName override the defaults.
   * LDIF import and export code should use the default map.
   *
   * @return      the requested map
   *
   * @exception   NS_ERROR_FAILURE    error constructing the map;
   *                                  possibly because of a failure
   *                                  from checkState()
   */
  /* nsIAbLDAPAttributeMap getMapForPrefBranch (in ACString aPrefBranchName); */
  NS_IMETHOD GetMapForPrefBranch(const nsACString & aPrefBranchName, nsIAbLDAPAttributeMap **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIABLDAPATTRIBUTEMAPSERVICE \
  NS_IMETHOD GetMapForPrefBranch(const nsACString & aPrefBranchName, nsIAbLDAPAttributeMap **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIABLDAPATTRIBUTEMAPSERVICE(_to) \
  NS_IMETHOD GetMapForPrefBranch(const nsACString & aPrefBranchName, nsIAbLDAPAttributeMap **_retval) { return _to GetMapForPrefBranch(aPrefBranchName, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIABLDAPATTRIBUTEMAPSERVICE(_to) \
  NS_IMETHOD GetMapForPrefBranch(const nsACString & aPrefBranchName, nsIAbLDAPAttributeMap **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMapForPrefBranch(aPrefBranchName, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsAbLDAPAttributeMapService : public nsIAbLDAPAttributeMapService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIABLDAPATTRIBUTEMAPSERVICE

  nsAbLDAPAttributeMapService();

private:
  ~nsAbLDAPAttributeMapService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsAbLDAPAttributeMapService, nsIAbLDAPAttributeMapService)

nsAbLDAPAttributeMapService::nsAbLDAPAttributeMapService()
{
  /* member initializers and constructor code */
}

nsAbLDAPAttributeMapService::~nsAbLDAPAttributeMapService()
{
  /* destructor code */
}

/* nsIAbLDAPAttributeMap getMapForPrefBranch (in ACString aPrefBranchName); */
NS_IMETHODIMP nsAbLDAPAttributeMapService::GetMapForPrefBranch(const nsACString & aPrefBranchName, nsIAbLDAPAttributeMap **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// test whether one of the getters has actually found an attribute
#define ATTRMAP_FOUND_ATTR(rv, str) (NS_SUCCEEDED(rv) && !(str).IsEmpty())

#endif /* __gen_nsIAbLDAPAttributeMap_h__ */
