/**
 * @file bidiEntry.h
 * @breaf Functions for Entry object.
 * @date $Date: 2004/02/18 20:48:05 $
 * @version 1.0.0
   copyright            : (C) 2004 by Turbolinux,Inc.

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

#ifndef BIDI_ENTRY_H
#define BIDI_ENTRY_H

#include <libxml/xmlreader.h>

#include <bidiTypes.h>
#include <entryPrtLocalization.h>
#include <entryPrtMarkerSupplies.h>
#include <entryPrtAlert.h>

#ifdef __cplusplus
extern "C" {
#endif

  /**
   * The top structure containing the parsed printer status.
   *
   * @struct Entry.
   */
  typedef struct {
    EntryPrtLocalization *EntryPrtLocalizationPtr;     /**< Pointer to EntryPrtLocalization. */
    EntryPrtMarkerSupplies *EntryPrtMarkerSuppliesPtr; /**< Pointer to EntryPrtMarkerSupplies. */
    EntryPrtAlert *EntryPrtAlertPtr;                   /**< Pointer to EntryPrtAlert. */
  } Entry;

  typedef struct {
    int value;        
    const char *name; 
  } enumList;         
  
  Entry *newEntry(void);
  void deleteEntry(Entry *);
  char *getEnumName(const enumList *,const int);
  
#ifdef __cplusplus
}
#endif

#endif
