proc dsk_config_gen_menu {configfile sectname sectlabel secthead tailname} {
  global dsk_config_popup tkdesk

  set dsk_config_popup(secthead) $secthead
  set dsk_config_popup(sectname) $sectname
  set dsk_config_popup(index1) ""
  foreach item $sectname {
    set dsk_config_popup($item) ""
  }
  set dsk_config_popup(head) ""
  set dsk_config_popup(tail) ""
  for {set i 0} {$i <= 3} {incr i} {
    set item1 [lindex $sectname $i]
    set item2 [lindex $secthead $i]
    set item3 [lindex $sectlabel $i]
    set heads($item1) $item2
    set labels($item1) $item3
  }
  set fd [open $configfile "r"]
  set index "head"
  while {[gets $fd line] >= 0} {
    if {[string first $tailname $line] >~ 0} {
      set index "tail"
    }
    foreach item $sectname {
      if {[string first $heads($item) $line] >~ 0} {
        set index $item
        set line "\{"
      }
    }
    if {$index != "head" && $index != "tail"} {
      set rem [string range $line 0 0]
      if {$rem == "#"} continue
      append dsk_config_popup($index) $line
    } else {
      append dsk_config_popup($index) $line
      append dsk_config_popup($index) "\n"
    }
  }
  close $fd
  foreach item $sectname {
    set dsk_config_popup($item) [lindex $dsk_config_popup($item) 0]
  }
  catch {destroy .dsk_configure}
  toplevel [set t .dsk_configure]
  wm title $t "Popup menu configure"  
  frame $t.title
  pack $t.title -side top -fill x
  label $t.title.label -text "ݥåץåץ˥塼 for TkDeskܸ"
  pack $t.title.label -side top -ipady 8
  frame $t.button
  pack $t.button -side bottom -fill x
  button $t.button.set -text "" -command "dsk_config_save $t $configfile"
  button $t.button.cancel -text "" -command "destroy $t"
  pack $t.button.set -side left
  pack $t.button.cancel -side right
  frame $t.select
  pack $t.select -side top
  foreach item $sectname {
    radiobutton $t.select.$item -variable sect -text $labels($item) -value $item -command {
      dsk_config_set_group $sect .dsk_configure
    }
    pack $t.select.$item -side left
  }
  frame $t.main
  pack $t.main -side top -fill x
  frame $t.main.select
  frame $t.main.edit
  pack $t.main.select $t.main.edit -side left -fill y
  listbox $t.main.select.group -width 20 -height 16 -yscroll "$t.main.select.groupy set" \
          -font $tkdesk(font,labels)
  pack $t.main.select.group -side left -fill y
  bind $t.main.select.group <Button-1> "dsk_config_set_item $t %x %y"
  scrollbar $t.main.select.groupy -orient vertical -width 10 -command "$t.main.select.group yview"
  pack $t.main.select.groupy -side left -fill y
  listbox $t.main.select.item -width 20 -height 16 -yscroll "$t.main.select.itemy set" \
          -font $tkdesk(font,labels)
  pack $t.main.select.item -side left -fill y
  bind $t.main.select.item <Button-1> "dsk_config_load_data $t %x %y"
  scrollbar $t.main.select.itemy -orient vertical -width 10 -command "$t.main.select.item yview"
  pack $t.main.select.itemy -side left -fill y
  frame $t.input
  pack $t.input -side top -fill x -ipady 6
  button $t.input.label -text "ѹ" -command "dsk_config_rename $t 1"
  entry $t.input.line -bg white -font $tkdesk(font,labels)
  pack $t.input.label -side right
  pack $t.input.line -side left -expand 1 -fill x
  frame $t.main.edit.command
  pack $t.main.edit.command -side top
  button $t.main.edit.command.insert -text "" -command "dsk_config_insert $t"
  button $t.main.edit.command.rename -text "ѹ" -command "dsk_config_rename $t 0"
  button $t.main.edit.command.delete -text "" -command "dsk_config_delete $t"
  pack $t.main.edit.command.rename $t.main.edit.command.insert -side left
  pack $t.main.edit.command.delete -side left 
  frame $t.main.edit.input
  pack $t.main.edit.input -side top -fill x
  entry $t.main.edit.input.line -bg white -font $tkdesk(font,labels)
  pack $t.main.edit.input.line -side left -fill x

  frame $t.main.edit.none -relief ridge
  frame $t.main.edit.term -relief ridge
  frame $t.main.edit.option -relief ridge
  frame $t.main.edit.exec -relief ridge
  frame $t.main.edit.edit -relief ridge
  frame $t.main.edit.view -relief ridge
  frame $t.main.edit.print -relief ridge
  pack $t.main.edit.none $t.main.edit.term $t.main.edit.option -side top -fill x
  pack $t.main.edit.exec -side top -fill x
  pack $t.main.edit.edit $t.main.edit.view $t.main.edit.print -side top -fill x
  radiobutton $t.main.edit.none.sel -variable dsk_config_popup(tag) -text "ʤ" -value none
  pack $t.main.edit.none.sel -side left
  button $t.main.edit.none.clear -text "õ" -command "$t.main.edit.input.line delete 0 end"
  pack $t.main.edit.none.clear -side right
  radiobutton $t.main.edit.term.sel -variable dsk_config_popup(tag) -text "ü" -value term
  checkbutton $t.main.edit.term.mini -text "" -variable dsk_config_popup(mini_check)
  checkbutton $t.main.edit.term.pause -text "ݡ" -variable dsk_config_popup(pause_check)
  pack $t.main.edit.term.sel $t.main.edit.term.mini $t.main.edit.term.pause -side left
  radiobutton $t.main.edit.option.sel -variable dsk_config_popup(tag) -text "" -value option
  pack $t.main.edit.option.sel -side left  
  checkbutton $t.main.edit.option.term -text "ü" -variable dsk_config_popup(term_check)
  pack $t.main.edit.option.term -side left
  checkbutton $t.main.edit.option.exec -text "¹" -variable dsk_config_popup(exec_check)
  pack $t.main.edit.option.exec -side left
  radiobutton $t.main.edit.exec.sel -variable dsk_config_popup(tag) -text "¹" -value exec
  pack $t.main.edit.exec.sel -side left  
  radiobutton $t.main.edit.edit.sel -variable dsk_config_popup(tag) -text "Խ" -value edit
  pack $t.main.edit.edit.sel -side left
  radiobutton $t.main.edit.view.sel -variable dsk_config_popup(tag) -text "ɽ" -value view
  pack $t.main.edit.view.sel -side left  
  radiobutton $t.main.edit.print.sel -variable dsk_config_popup(tag) -text "" -value print
  pack $t.main.edit.print.sel -side left

  frame $t.main.edit.sub -relief ridge
  pack $t.main.edit.sub -side bottom -fill x
  checkbutton $t.main.edit.sub.level -text "֥˥塼" -variable dsk_config_popup(level_check)
  pack $t.main.edit.sub.level -side left
}

proc dsk_config_insert {t} {
  global dsk_config_popup

  set name [$t.main.edit.input.line get]
  $t.main.edit.input.line delete 0 end
  if {$name == ""} return
  set index $dsk_config_popup(index1)
  set groupsel [$t.main.select.group curselection]
  set itemsel [$t.main.select.item curselection]
  if {$itemsel != {}} {
    set newline [list $name {}]
    set current $dsk_config_popup(index1)
    set index2 $dsk_config_popup(index2)
    set lines [lindex $dsk_config_popup($index) $index2]
    set line [lindex $lines 1]
    set line [dsk_config_extend_inslist $t $line $itemsel $name] 
    set lines [lreplace $lines 1 1 $line]
    set newlist [lreplace $dsk_config_popup($index) $index2 $index2 $lines]
    set dsk_config_popup($index) $newlist
    dsk_config_set_item2 $t $index2
  } elseif {$groupsel != {}} {
    set newline [list $name {{}}]
    set newlist [linsert $dsk_config_popup($index) $groupsel $newline]
    set dsk_config_popup($index) $newlist
    dsk_config_set_group $index $t
    $t.main.select.item delete 0 end
  }
}

proc dsk_config_rename {t id} {
  global dsk_config_popup

  if {$id == 1} {
    set name [$t.input.line get]
    if {$dsk_config_popup(tag) == "print"} {
      set name "dsk_print $name"
    }
    if {$dsk_config_popup(tag) == "view"} {
      set name "dsk_view $name"
    }
    if {$dsk_config_popup(tag) == "edit"} {
      set name "dsk_edit $name "
    }
    if {$dsk_config_popup(tag) == "exec"} {
      set name "dsk_exec $name "
    }
    if {$dsk_config_popup(tag) == "term" || $dsk_config_popup(term_check) != 0} {
      set com "dsk_exec \$tkdesk(cmd,xterm) "
      if {$dsk_config_popup(mini_check) != 0} {
        append com "-geom 80x15 "
      }
      append com "-T %f -n %f -e "
      if {$dsk_config_popup(pause_check) != 0} {
        append com "pauseme "
      }
      set name "$com$name"
    } elseif {$dsk_config_popup(exec_check) != 0} {
      set name "dsk_exec $name"
    }
    if {$dsk_config_popup(tag) == "option"} {
      set title [$t.main.edit.input.line get]
      regsub -all {##} $name {$dsk_read_string} name
      set name [list dsk_read_string $title $name]
    }
  } else {
    set name [$t.main.edit.input.line get]
    $t.main.edit.input.line delete 0 end
  }
  if {$name == ""} return
  set index $dsk_config_popup(index1)
  set groupsel [$t.main.select.group curselection]
  set itemsel [$t.main.select.item curselection]
  if {$itemsel != {}} {
    set current $dsk_config_popup(index1)
    set index2 $dsk_config_popup(index2)
    set lines [lindex $dsk_config_popup($index) $index2]
    set line [lindex $lines 1]
    if {$id == 0} {
      set line [dsk_config_extend_renlist $t $line $itemsel $name] 
    } else {
      set line [dsk_config_extend_setlist $t $line $itemsel $name] 
    }
    set lines [lreplace $lines 1 1 $line]
    set newlist [lreplace $dsk_config_popup($index) $index2 $index2 $lines]
    set dsk_config_popup($index) $newlist
    dsk_config_set_item2 $t $index2
  } elseif {$groupsel != {}} {
    if {$id == 0} {
      set lines [lindex $dsk_config_popup($index) $groupsel]
      set lines [lreplace $lines 0 0 $name]
      set newlist [lreplace $dsk_config_popup($index) $groupsel $groupsel $lines]
      set dsk_config_popup($index) $newlist
      dsk_config_set_group $index $t
      $t.main.select.item delete 0 end
    }
  }
}

proc dsk_config_delete {t} {
  global dsk_config_popup

  set index $dsk_config_popup(index1)
  set groupsel [$t.main.select.group curselection]
  set itemsel [$t.main.select.item curselection]
  if {$itemsel != {}} {
    set current $dsk_config_popup(index1)
    set index2 $dsk_config_popup(index2)
    set lines [lindex $dsk_config_popup($index) $index2]
    set line [lindex $lines 1]
    set line [dsk_config_extend_dellist $t $line $itemsel] 
    set lines [lreplace $lines 1 1 $line]
    set newlist [lreplace $dsk_config_popup($index) $index2 $index2 $lines]
    set dsk_config_popup($index) $newlist
    dsk_config_set_item2 $t $index2
  } elseif {$groupsel != {}} {
    set size [expr [llength $dsk_config_popup($index)] - 1]
    if {$groupsel <= $size} {
      set newlist [lreplace $dsk_config_popup($index) $groupsel $groupsel]
      set dsk_config_popup($index) $newlist
      dsk_config_set_group $index $t
      $t.main.select.item delete 0 end
    }
  }
}

proc dsk_config_set_group {index t} {
  global dsk_config_popup

  set dsk_config_popup(index1) $index
  $t.main.select.group delete 0 end
  foreach line $dsk_config_popup($index) {
    set item [lindex $line 0]
    $t.main.select.group insert end $item
  }
  $t.main.select.item delete 0 end
  $t.input.line delete 0 end
}

proc dsk_config_set_item {t x y} {
  set n [$t.main.select.group index @$x,$y]
  dsk_config_set_item2 $t $n
}

proc dsk_config_set_item2 {t n} {
  global dsk_config_popup

  set current $dsk_config_popup(index1)
  if {$current == ""} return
  set lines [lindex $dsk_config_popup($current) $n]
  set line [lindex $lines 1]
  set dsk_config_popup(index2) $n
  $t.main.select.item delete 0 end
  foreach item $line {
    set num [llength $item]
    set title [lindex $item 0]
    $t.main.select.item insert end $title
    if {$num > 2} {
      for {set i 1} {$i < $num} {incr i} {
        set title [lindex [lindex $item $i] 0]
        $t.main.select.item insert end $title
      }
    }
  }
  $t.input.line delete 0 end
}

proc dsk_config_extend_getlist {t line num} {
  dsk_config_extend_list $t $line $num get {}
}

proc dsk_config_extend_dellist {t line num} {
  dsk_config_extend_list $t $line $num delete {}
}

proc dsk_config_extend_inslist {t line num name} {
  dsk_config_extend_list $t $line $num insert $name
}

proc dsk_config_extend_renlist {t line num name} {
  dsk_config_extend_list $t $line $num rename $name
}

proc dsk_config_extend_setlist {t line num name} {
  dsk_config_extend_list $t $line $num set $name
}

proc dsk_config_extend_list {t line num command name} {
  global dsk_config_popup

  set level_check $dsk_config_popup(level_check)
  set newline {}
  set index 0
  set n 0
  set id 0
  if {$command == "set"} {
    set command "rename"
    set id 1
  }
  foreach items $line {
    set size [llength $items]
    if {$size < 3} {
      if {$n == $num} {
        set item $items
        $t.main.edit.sub.level deselect
        if {$command == "insert"} {
          set s [llength $newline]
          incr s -1
          if {$level_check == 0 || $s < 0} {
            lappend newline [list $name {}]
          } else {
            set newitems [lindex [lindex $newline $s] 0]
            incr s -1
            if {$s < 0} {
              set newline {}
            } else {
              set newline [lrange $newline 0 $s]
            }
            lappend newitems [list $name {}]
            lappend newitems [list $name {}]
            lappend newline $newitems
          }
          lappend newline $items
        }
        if {$command == "rename"} {
          lappend newline [lreplace $items $id $id $name]
        }
      } else {
        lappend newline $items
      }
      incr index
      incr n
    } else {
      set subindex 0
      foreach subitems $items {
        if {$subindex > 0} {
          if {$n == $num} {
            set rmflag -1
            set item [lindex $items $subindex]
            $t.main.edit.sub.level select
            if {$command == "insert"} {
              lappend newitems [list $name {}]
              lappend newitems $subitems
            }
            if {$command == "rename"} {
              lappend newitems [lreplace $subitems $id $id $name]
            }
          } else {
            lappend newitems $subitems
          }
        } else {
          set rmflag 1
          set newitems {}
          if {$n == $num} {
            set item [list [lindex $items 0]]
            $t.main.edit.sub.level deselect
            if {$command == "insert"} {
              lappend newline [list $name]
              lappend newitems [list $subitems]
            }
            if {$command == "rename" && $id == 0} {
              lappend newline [lreplace $items $id $id $name]
            }
          } else {
            set rmflag 0
            set newitems [list $subitems]
          }
        }
        incr subindex
        incr n
      }
      if {$rmflag <= 0 || $command == "insert" || $command == "rename"} {
      	if {$rmflag == -1 && $command == "delete"} {
      	  set itemnum [llength $newitems]
      	  if {$itemnum == 2} {
            set newitems [list [lindex $newitems 0]]
      	  }
      	}
        lappend newline $newitems
      }
    }
  }
  if {$command == "delete" || $command == "insert" || $command == "rename"} {
    return $newline
  }
  if {$command == "get"} {return $item}
}

proc dsk_config_load_data {t x y} {
  global dsk_config_popup

  set num [$t.main.select.item index @$x,$y]
  set current $dsk_config_popup(index1)
  if {$current == ""} return
  set lines [lindex $dsk_config_popup($current) $dsk_config_popup(index2)]
  set line [lindex $lines 1]
  set item [dsk_config_extend_getlist $t $line $num]  
  set command [string trim [lindex $item 1]]
  set first [lindex $command 0]
  set second [lindex $command 1]
  set dsk_config_popup(tag) none
  $t.main.edit.term.mini deselect
  $t.main.edit.term.pause deselect
  $t.main.edit.option.term deselect
  $t.main.edit.option.exec deselect
  if {$first == "dsk_print"} {
    set dsk_config_popup(tag) print
    set command [lrange $command 1 end]
  } 
  if {$first == "dsk_view"} {
    set dsk_config_popup(tag) view
    set command [lrange $command 1 end]
  } 
  if {$first == "dsk_edit"} {
    set dsk_config_popup(tag) edit
    set command [lrange $command 1 end]
  }
  if {$first == "dsk_read_string"} {
    set dsk_config_popup(tag) option
    $t.main.edit.input.line delete 0 end
    $t.main.edit.input.line insert 0 $second
    set command [lindex $command 2]
    set first [lindex $command 0]
    set second [lindex $command 1]
    regsub -all {\$dsk_read_string} $command {##} command
  }
  if {$first == "dsk_exec"} {
    if {$second == "\$tkdesk(cmd,xterm)"} {
      set index 0
      set e -1
      set mini 0
      foreach item $command {
        if {$item == "\-e"} {set e $index}
        if {$item == "\-geom" && $mini == 0} {incr mini}
        if {$item == "80x15" && $mini == 1} {incr mini}
        incr index
      }
      incr e
      if {$e > 0} {
        if {$dsk_config_popup(tag) == "option"} {
          $t.main.edit.option.term select
          $t.main.edit.option.exec select
        } else {
          set dsk_config_popup(tag) term
        }
        if {[lindex $command $e] == "pauseme"} {
          $t.main.edit.term.pause select
          incr e
        }
        if {$mini == 2} {
          $t.main.edit.term.mini select
        }
        set command [lrange $command $e end]
      }
    } else {
      if {$dsk_config_popup(tag) == "option"} {
        $t.main.edit.option.exec select
      } else {
        set dsk_config_popup(tag) exec
      }
      set command [lrange $command 1 end]
    }
  }
  $t.input.line delete 0 end
  $t.input.line insert 0 $command	
}

proc dsk_config_save {t configfile} {
  global dsk_config_popup

  set fd [open $configfile "w"]
  puts -nonewline $fd $dsk_config_popup(head)
  set i 0
  foreach index $dsk_config_popup(sectname) {
    set head [lindex $dsk_config_popup(secthead) $i]
    puts $fd "$head \{"
    incr i
    foreach lines $dsk_config_popup($index) {
      set title [lindex $lines 0]
      set items [lindex $lines 1]
      puts $fd "\t\{\{$title\} \{"
      foreach item $items {
      	if {$item == "-" || [lindex $item 0] == "-"} {
      	  puts $fd "\t\t-"
      	} else {
          puts $fd "\t\t\{$item\}"
        }
      }
      puts $fd "\t\}\}"
    }
    puts $fd "\}\n"
  }
  puts -nonewline $fd $dsk_config_popup(tail)
  close $fd
  unset dsk_config_popup
  destroy $t
  dsk_reread_config [file tail $configfile]
}

proc dsk_config_main {} {
  global env

  set configfile $env(HOME)
  set configfile "$configfile/.tkdesk/Popups"
  set sectname {directories executables regulars}
  set sectlabel {ե ¹ԥե ̾ե}
  set secthead {
    "set tkdesk(popup,directories)"
    "set tkdesk(popup,executables)"
    "set tkdesk(popup,regulars)"
  }
  set tailname "set tkdesk(fileops,popup)"
  dsk_config_gen_menu $configfile $sectname $sectlabel $secthead $tailname
}

proc dsk_appbar_main {} {
  global env

  set configfile $env(HOME)
  set configfile "$configfile/.tkdesk/AppBar"
  set sectname {appbar}
  set sectlabel {硼ȥå}
  set secthead {
    "set tkdesk(appbar)"
  }
  set tailname "proc view_manual_page"
  dsk_config_gen_menu $configfile $sectname $sectlabel $secthead $tailname
}
