proc dsk_mailer {to subject msg} {
    dsk_mailer2 $to $subject $msg 0
}

proc dsk_mailer2 {to subject msg msgid} {
    global tkdesk dsk_mailer dsk_get_config tkdesk

    catch {destroy .dsk_mailer}
    toplevel [set t .dsk_mailer]
    wm withdraw $t
    wm title $t "TkMailer Composer"  
    set dsk_mailer(size) "46x15"
    set dsk_mailer(msgid) $msgid
    set mailer "᡼"
    if {$tkdesk(TkMailer) == "news"} {
        set mailer "˥塼"
    }

    frame $t.ti -bd 1 -relief raised
    pack $t.ti -fill x
    label $t.lti -text "TkMailerܸ($mailer ) by 乬"
    pack $t.lti -in $t.ti
    frame $t.f0 -bd 1 -relief raised
    pack $t.f0 -fill x
    label $t.lt -text ":"
    pack $t.lt -in $t.f0 -side left -padx 4 -pady 4
    entry $t.et -width 10 -bd 2 -relief sunken
    $t.et insert end $to
    pack $t.et -in $t.f0 -side left -fill x -expand yes 
    frame $t.f1 -bd 1 -relief raised
    pack $t.f1 -fill x
    label $t.ls -text "̾:"
    pack $t.ls -in $t.f1 -side left -padx 4 -pady 4
    entry $t.es -width 10 -bd 2 -relief sunken
    $t.es insert end $subject
    pack $t.es -in $t.f1 -side left -fill x -expand yes
    frame $t.f4 -bd 1 -relief raised
    pack $t.f4 -fill x
    label $t.lc -text "ã:"
    pack $t.lc -in $t.f4 -side left -padx 4 -pady 4
    entry $t.ec -width 10 -bd 2 -relief sunken
    pack $t.ec -in $t.f4 -side left -fill x -expand yes

    frame $t.f2 -bd 1 -relief raised
    pack $t.f2 -fill both -expand yes
    frame $t.f2a
    frame $t.f2b
    pack $t.f2a -in $t.f2 -fill both -side left -expand yes -padx 4 -pady 4
    pack $t.f2b -in $t.f2 -fill y -side right -padx 4 -pady 4
    text $t.tm -width 20 -height 1 -bd 2 -relief sunken -setgrid 1 \
	    -yscroll "$t.sb set"
    $t.tm insert end "$msg"
    $t.tm mark set insert 2.0
    pack $t.tm -in $t.f2a -side left -fill both -expand yes
    scrollbar $t.sb -orient vertical -command "$t.tm yview"
    pack $t.sb -in $t.f2a -side left -fill y
    label $t.filesl -text "źեե"
    listbox $t.files -width 16 -bd 1 -height 1 -relief sunken -bg navy -fg gold \
        -xscroll "$t.fsbx set" -selectmode extended -font $tkdesk(font,entries)
    bind $t.files <Delete> "dsk_delete_listbox $t.files"
    scrollbar $t.fsbx -orient horiz -command "$t.files xview"
    pack $t.filesl -in $t.f2b -side top -fill x
    pack $t.files -in $t.f2b -side top -fill both -expand yes
    pack $t.fsbx -in $t.f2b -side bottom -fill x

    frame $t.f3 -bd 1 -relief raised
    pack $t.f3 -fill x
    button $t.bc -text "" -command "destroy $t"
    button $t.bs -text "¸..." -command "dsk_mailer_save $t"
    button $t.bi -text "ź..." -command "dsk_mailer_set_listbox $t.files źեե"
    button $t.bd -text "źպ" -command "dsk_delete_listbox $t.files"
    button $t.bg -text "" -command dsk_config_mail
    button $t.br -text "" -command "dsk_mailer_remote $t"
    set dsk_get_config(#easy) "no"
    dsk_get_config
    if {$dsk_get_config(#easy) == "yes"} {
        $t.bg configure -command dsk_easyconf_mail
    }
    pack $t.br $t.bs $t.bi $t.bd $t.bg $t.bc -in $t.f3 -side left -padx 4 -pady 4 -ipady 1

    wm protocol $t WM_DELETE_WINDOW "destroy $t"
    wm geometry $t $dsk_mailer(size)
    cb_centerToplevel $t
    wm deiconify $t
    focus $t.tm
}
    
proc dsk_mailer_remote {t} {
    global tkdesk dsk_mailer
    
    set com "| imput --ObeyHeader=on --JPconv=on  --filenameadd=on --AddHeader=TkMailer:tkdesk-ver$tkdesk(version)$tkdesk(patch) --Fcc=+send"
    if {[$t.files size] >= 1} {
    	set com "$com --MultipartAdd="
        set items [$t.files get 0 end]
        foreach item $items {
            set com "$com$item,"
        }
    }
    catch {set fd [open $com w]}
    if ![info exists fd] {
        cb_error "¹ԤǤޤ: im򥤥󥹥ȡ뤷Ƥ"
        tkwait variable dsk_mailer(mail)
    } else {
        set msg [$t.tm get 1.0 end]
        if {$dsk_mailer(msgid) != 0} {
            puts $fd "In-Reply-To: Your message of \"$dsk_mailer(date)\""
            puts $fd "             $dsk_mailer(msgid)"
            puts $fd "References: $dsk_mailer(msgid)"
        }
        if {$tkdesk(TkMailer) == "mail"} {
            puts $fd "To: [$t.et get] "
        } else {
            puts $fd "Newsgroups: [$t.et get] "
        }
        puts $fd "Subject: [$t.es get] "
        if {[$t.ec get] != ""} {
            puts $fd "Cc: [$t.ec get] "
        }
        puts -nonewline $fd $msg
        close $fd
    }
    set tkdesk(TkMailer) "mail"
    destroy $t
}
    
proc dsk_mailer_save {t} {
    while 1 {
       set f [cb_fileSelector -label "᡼¸"]
       if {$f != ""} {
           set err [catch {set fd [open $f "w"]}]
           if $err {
               cb_error "񤭹ߤ $f ޤ"
           } else {
               set msg [$t.tm get 1.0 end]
               puts -nonewline $fd $msg
               close $fd
               break
           }
       } else {
           break
       }
    }
}

proc dsk_mailer_set_listbox {lb msg} {
    set f [cb_fileSelector -label $msg]
    if {$f != ""} {
        $lb insert end $f
    }
}

proc dsk_delete_listbox {lb} {
    set items [$lb curselection]
    foreach item $items {
        $lb delete $item
    }
}

proc dsk_mailer_file {to subject file} {
    set err [catch {set fd [open $file "r"]}]
    if $err {
         cb_error "$file ޤ"
    } else {
         set msg [read -nonewline $fd]
         close $fd
    }
    dsk_mailer $to $subject $msg
}

proc dsk_config_mail {} {
    global dsk_config_mail dsk_config_mail_cb env

    catch {destroy .dsk_config_mail}
    toplevel [set t .dsk_config_mail]
    wm withdraw $t
    wm title $t "TkMailer Configure"  

    set home $env(HOME)
    set host [exec hostname]
    frame $t.f1 -bd 1 -relief raised
    pack $t.f1 -fill x
    label $t.title -text "TkMailerܸ(᡼&˥塼) by 乬"
    pack $t.title -in $t.f1 -padx 4 -pady 4

    set titles(addr) "᡼륢ɥ쥹:" 
    set titles(name) "ʤ̾:"
    set titles(smtp) "᡼륵С:" 
    set titles(emgsmtp) "إ᡼륵С:" 
    set titles(nntp) "˥塼С:" 
    set titles(pop) "POPС:"
    set titles(maildir) "᡼γǼ:" 
    set titles(newsdir) "˥塼γǼ:" 
    set titles(width) "᡼ιԿ:" 
    set titles(jissafe) "JISθ" 
    set titles(jphead) "JISإå"
#    set titles(jpconv) "JISѴ" 
    set titles(nofold) "޻"
    set titles(qencode) "Q󥳡" 
    set titles(8to7) "7ӥåѴ"
    set titles(keep) "᡼Ĥ"
    set dsk_config_mail(addr) Address
    set dsk_config_mail(name) Name
    set dsk_config_mail(smtp) Smtpservers
    set dsk_config_mail(emgsmtp) EmgSmtpSvrs 
    set dsk_config_mail(nntp) NntpServers 
    set dsk_config_mail(pop) #PopServers 
    set dsk_config_mail(maildir) MailDir 
    set dsk_config_mail(newsdir) NewsDir 
    set dsk_config_mail(width) Width
    set dsk_config_mail(jissafe) JisSafe 
    set dsk_config_mail(jphead) JPheader
#    set dsk_config_mail(jpconv) JPconv 
    set dsk_config_mail(nofold) NoHdrFolding 
    set dsk_config_mail(qencode) HdrQEncoding
    set dsk_config_mail(8to7) 8to7
    set dsk_config_mail(keep) keep
    set dsk_config_mail(disphead) #head
    set i 6
    foreach wname {addr name smtp emgsmtp pop nntp maildir newsdir width} {
        frame $t.f$i 
        pack $t.f$i -fill x
        label $t.l$i -text $titles($wname)
        pack $t.l$i -in $t.f$i -side left
        entry $t.$wname -width 38 -bd 2 -relief sunken
        pack $t.$wname -in $t.f$i -side left -fill x -expand yes
        incr i
    }
    frame $t.f3
    pack $t.f3 -fill x
    radiobutton $t.disphead1 -text "إåɽʤ" -variable dsk_config_mail_cb(disphead) -value none
    radiobutton $t.disphead2 -text "إåɽ" -variable dsk_config_mail_cb(disphead) -value all
    radiobutton $t.disphead3 -text "إåάɽ" -variable dsk_config_mail_cb(disphead) -value some
    pack $t.disphead1 $t.disphead2 $t.disphead3 -in $t.f3 -side left
    $t.disphead1 select
    frame $t.f4
    pack $t.f4 -fill x
    foreach wname {jissafe jphead nofold qencode 8to7} {
        checkbutton $t.$wname -text $titles($wname) \
            -variable dsk_config_mail_cb($wname) -onvalue "on" -offvalue "off"
        pack $t.$wname -in $t.f4 -side left
    }
    frame $t.f5
    pack $t.f5 -fill x
    checkbutton $t.keep -text $titles(keep) \
            -variable dsk_config_mail_cb(keep) -onvalue "-1" -offvalue "0"
    pack $t.keep -in $t.f5 -side left
    set err [catch {set fd [open "$home/.im/Config" "r"]}]
    if $err {
        catch {exec mkdir $home/.im}
        dsk_mail_default $t
    } else {
    	 while {[gets $fd line] != -1} {
    	     set option [split $line =]
    	     set opt1 [lindex $option 0]
    	     set opt2 [lindex $option 1]
             foreach wname {addr name smtp emgsmtp pop nntp maildir newsdir width} {
                 if {$opt1 == $dsk_config_mail($wname)} {
                     $t.$wname insert end $opt2
                 }
             }
             foreach wname {jissafe jphead nofold qencode 8to7} {
                 if {$opt1 == $dsk_config_mail($wname)} {
             	     if {$opt2 == "on"} {
             	         $t.$wname select
             	     }
                 }
             }
             if {$opt1 == $dsk_config_mail(keep)} {
             	 if {$opt2 == "-1"} {
             	     $t.$wname select
             	 }
             }
             if {$opt1 == $dsk_config_mail(disphead)} {
             	 if {$opt2 == "all"} {
             	     $t.disphead2 select
             	 }
             	 if {$opt2 == "some"} {
             	     $t.disphead3 select
             	 }
             }
         }
    	 set option [gets $fd]
         close $fd
    }
    
    frame $t.f0 -bd 1 -relief raised
    pack $t.f0 -fill x
    button $t.bc -text "" -command "destroy $t"
    button $t.bs -text "" -command "dsk_set_mail $t"
#    button $t.bd -text "ǥե" -command "dsk_mail_default $t"
    pack $t.bs $t.bc -in $t.f0 -side left -padx 2 -pady 2 -ipady 1

    wm protocol $t WM_DELETE_WINDOW "destroy $t"
    cb_centerToplevel $t
    wm deiconify $t
}

proc dsk_easyconf_mail {} {
    global dsk_easyconf_mail env

    catch {destroy .dsk_easyconf_mail}
    toplevel [set t .dsk_easyconf_mail]
    wm withdraw $t
    wm title $t "TkMailer Easy Setup"  

    set home $env(HOME)
    set host [exec hostname]
    frame $t.f1 -bd 1 -relief raised
    pack $t.f1 -fill x
    label $t.title -text "TkMailerܸ(᡼&˥塼ñ) by 乬"
    pack $t.title -in $t.f1 -padx 4 -pady 4

    set dsk_easyconf_mail(addr) Address
    set dsk_easyconf_mail(smtp) Smtpservers
    set dsk_easyconf_mail(nntp) NntpServers

    frame $t.f2
    pack $t.f2 -fill x
    label $t.l2 -text "ʤΥ᡼륢ɥ쥹"
    pack $t.l2 -in $t.f2 -side left
    entry $t.addr -width 38 -bd 2 -relief sunken
    pack $t.addr -in $t.f2 -side left -fill x -expand yes
    frame $t.f3
    pack $t.f3 -fill x
    label $t.l3 -text "ץХΥ᡼륵С"
    pack $t.l3 -in $t.f3 -side left
    entry $t.smtp -width 38 -bd 2 -relief sunken
    pack $t.smtp -in $t.f3 -side left -fill x -expand yes
    frame $t.f4
    pack $t.f4 -fill x
    label $t.l4 -text "ץХΥ˥塼С"
    pack $t.l4 -in $t.f4 -side left
    entry $t.nntp -width 38 -bd 2 -relief sunken
    pack $t.nntp -in $t.f4 -side left -fill x -expand yes

    set err [catch {set fd [open "$env(HOME)/.im/Config" "r"]}]
    if $err {
        catch {exec mkdir $home/.im}
        $t.addr insert end "$env(LOGNAME)@$host"
        $t.smtp insert end $host
    } else {
    	 while {[gets $fd line] != -1} {
    	     set option [split $line =]
    	     set opt1 [lindex $option 0]
    	     set opt2 [lindex $option 1]
             foreach wname {addr smtp nntp} {
                 if {$opt1 == $dsk_easyconf_mail($wname)} {
                     $t.$wname insert end $opt2
                 }
             }
         }
         close $fd
    }
    
    frame $t.f0 -bd 1 -relief raised
    pack $t.f0 -fill x
    button $t.bc -text "" -command "destroy $t"
    button $t.bs -text "" -command "dsk_easyset_mail $t"
    pack $t.bs $t.bc -in $t.f0 -side left -padx 2 -pady 2 -ipady 1

    wm protocol $t WM_DELETE_WINDOW "destroy $t"
    cb_centerToplevel $t
    wm deiconify $t
}

proc dsk_get_config {} {
    global dsk_get_config

    set err [catch {set fd [open "~/.im/Config" "r"]}]
    if $err {
        catch {exec mkdir $env(HOME)/.im}
#        dsk_mail_default $t
    } else {
    	 while {[gets $fd line] != -1} {
    	     set option [split $line =]
    	     set opt1 [lindex $option 0]
    	     set opt2 [lindex $option 1]
    	     set dsk_get_config($opt1) $opt2
         }
         close $fd
    }
}

proc dsk_mail_default {t} {
    global env

    set host [exec hostname]
    foreach wname {addr name smtp emgsmtp pop nntp maildir newsdir width} {
    	$t.$wname delete 0 end
    }
    $t.addr insert end "$env(LOGNAME)@$host"
    $t.name insert end $env(LOGNAME)
    foreach wname {smtp emgsmtp pop nntp} {
        $t.$wname insert end $host
    }
    $t.maildir insert end "Mail"
    $t.newsdir insert end "News"
    $t.width insert end "80"
    foreach wname {jissafe jphead 8to7} {
        $t.$wname select
    }
    foreach wname {nofold qencode keep} {
        $t.$wname deselect
    }
}

proc dsk_set_mail {t} {
    global tkdesk dsk_config_mail dsk_config_mail_cb env dsk_get_config
    
    set home $env(HOME)
    if {[cb_dialog $t.que "եξ" \
        "$home/.im/Config񤭤츽ߤ $home/.im/Config.old¸ޤǤ\n(̾ϡλפ򤷤ޤ)" \
	questhead 0 "λ" ""] == 1} {
   	return
    }
    catch { exec cp $home/.im/Config $home/.im/Config.old }
    set err [catch {set fd [open "$home/.im/Config" "w"]}]
    if $err {
        cb_error "~/.imޤ"
    } else {
        foreach wname {addr name smtp pop emgsmtp nntp maildir newsdir width} {
            set value [$t.$wname get]
            puts $fd "$dsk_config_mail($wname)=$value"
        }
        foreach wname {jissafe jphead nofold qencode 8to7 keep disphead} {
            puts $fd "$dsk_config_mail($wname)=$dsk_config_mail_cb($wname)"
        }
    	set addrlist [split [$t.addr get] @]
    	set user [lindex $addrlist 0]
    	set domain [lindex $addrlist 1]
	puts $fd "NameInComment=off"
    	puts $fd "User=$user"
    	puts $fd "ToDomain=$domain"
    	puts $fd "FromDomain=$domain"
    	puts $fd "Defcode=EUC"
#    	puts $fd "AddHeader=TkMailer: ver$tkdesk(version) $tkdesk(patch)"
    	close $fd
    }
    dsk_get_config
    destroy $t
}

proc dsk_resend_mail {t} {
    global tkdesk dsk_mailer

    set filename $tkdesk(TkMailerFile)
    if {$filename == "none"} {
        return
    }
    set fd [open "| jisdecode < $filename | nkf -e" "r"]
    set re ""
    set multi "no"
    gets $fd line
    while {[gets $fd line] != -1 && $line != ""} {
        set head [string tolower $line]
        set pos [string first "subject: " $head]
        if {$pos == 0} {
            set subject [string range $line [expr $pos + 9] end]
       	}
        set pos [string first "from: " $head]
        if {$pos == 0} {
            set from [string range $line [expr $pos + 6] end]
       	}
        set pos [string first "reply-to: " $head]
        if {$pos == 0} {
            set re [string range $line [expr $pos + 10] end]
       	}
        set pos [string first "content-type: multipart/mixed" $head]
        if {$pos >= 0} {
            set multi "yes"
        }
        set pos [string first "content-type: multipart/alternative" $head]
        if {$pos >= 0} {
            set multi "yes"
        }
        set pos [string first "message-id: " $head]
        if {$pos == 0} {
            set msgid [string range $line [expr $pos + 12] end]
        }
        set pos [string first "date: " $head]
        if {$pos == 0} {
            set date [string range $line [expr $pos + 6] end]
        }
        if {$multi == "yes"} {
            set head [string tolower $line]
            set pos [string first "boundary=" $head]
            set b [expr $pos + 10]
            set e [expr [string length $line] - 2]
            if {$pos != -1} {
                set boundary [string range $line $b $e]
            }
        }
    }
    if {$re == ""} {
        set re $from
    }
    catch {close $fd}
    set fd [open "| nkf -e < $filename" "r"]
    while {[gets $fd line] != -1 && $line != ""} {}
    set msg ""
    if {$multi == "yes"} {
        while {[gets $fd line] != -1 && [string first $boundary $line] == -1} {}
        while {[gets $fd line] != -1 && $line != ""} {}
        while {[gets $fd line] != -1 && [string first $boundary $line] == -1} {
            set msg "$msg> $line\n"
        }
    } else {
        while {[gets $fd line] != -1} {
            set msg "$msg> $line\n"
        }
    }
    catch {close $fd}
    set str [string toupper [string range $subject 0 2]]
    if {$str != "RE:"} {
        set subject "Re: $subject"
    }
    set tkdesk(TkMailer) "mail"
    set dsk_mailer(date) $date
    dsk_mailer2 $re $subject $msg $msgid
}

proc dsk_easyset_mail {t} {
    global tkdesk dsk_get_config dsk_easyconf_mail env
    
    if {[cb_dialog $t.que "եξ" \
        "$env(HOME)/.im/Config񤭤츽ߤ $env(HOME)/.im/Config.old¸ޤǤ\n(̾ϡλפ򤷤ޤ)" \
	questhead 0 "λ" ""] == 1} {
   	return
    }
    catch { exec cp $env(HOME)/.im/Config $env(HOME)/.im/Config.old }
    set err [catch {set fd [open "~/.im/Config" "w"]}]
    if $err {
        cb_error "~/.imޤ"
    } else {
        foreach wname {addr smtp nntp} {
            set value [$t.$wname get]
            puts $fd "$dsk_easyconf_mail($wname)=$value"
        }
    	set addrlist [split [$t.addr get] @]
    	set user [lindex $addrlist 0]
    	set domain [lindex $addrlist 1]
    	set smtp [$t.smtp get]
	puts $fd "Name=$user"
	puts $fd "#PopServers=$smtp"
	puts $fd "MailDir=Mail"
	puts $fd "NewsDir=News"
	puts $fd "Width=80"
	puts $fd "JisSafe=on"
	puts $fd "JPheader=on"
	puts $fd "JPconv=on"
	puts $fd "NoHdrFolding=off"
	puts $fd "HdrQEncoding=off"
	puts $fd "NameInComment=off"
	puts $fd "8to7=on"
    	puts $fd "User=$user"
    	puts $fd "ToDomain=$domain"
    	puts $fd "FromDomain=$domain"
    	puts $fd "Defcode=EUC"
    	puts $fd "keep=0"
    	puts $fd "AddHeader=TkMailer: ver$tkdesk(version) $tkdesk(patch)"
    	puts $fd "#easy=yes"
    	close $fd
    }
    dsk_get_config
    destroy $t
}

proc dsk_receive_mail {} {
    global dsk_receive_mail dsk_get_config env tkdesk

    set dsk_receive_mail(sjsize) 46
    set dsk_receive_mail(fromsize) 32
    set dsk_receive_mail(sjnum) 7
    set dsk_receive_mail(size) "50x14"
    set dsk_receive_mail(folder) "inbox"
    set dsk_get_config(#easy) "no"
    dsk_get_config
    set dsk_receive_mail(rootdir) "$env(HOME)/$dsk_get_config(MailDir)"
    
    catch {destroy .dsk_receive_mail}
    toplevel [set t .dsk_receive_mail]
    wm withdraw $t
    wm title $t "TkMailer Viewer"  

    frame $t.f1 -bd 1 -relief raised
    pack $t.f1 -fill x
    menubutton $t.folder -text "ե" -menu $t.folder.m
    menu $t.folder.m
    label $t.title -anchor center -text "TkMailerܸ(᡼) by 乬"
    pack $t.folder -in $t.f1 -side left
    pack $t.title -in $t.f1 -side left -fill x -expand yes -padx 4 -pady 4

    frame $t.f2 -bd 1 -relief raised
    pack $t.f2 -fill x
    frame $t.f2a
    pack $t.f2a -in $t.f2 -fill x -expand yes -padx 4 -pady 4
    listbox $t.sj -height $dsk_receive_mail(sjnum) -bd 2 -relief sunken -yscroll \
      "$t.sby set" -xscroll "$t.sbx set" -selectmode extended -font $tkdesk(font,entries)
    pack $t.sj -in $t.f2a -side left -fill x -expand yes
    bind $t.sj <Double-Button-1> "dsk_mail_settext $t %x %y"
    bind $t.sj <Delete> "dsk_delete_mail $t"
    scrollbar $t.sby -orient vertical -command "$t.sj yview"
    pack $t.sby -in $t.f2a -side left -fill y
    scrollbar $t.sbx -orient horiz -command "$t.sj xview"
    pack $t.sbx -in $t.f2 -side bottom -fill x

    set curdir [pwd]
    set err [catch {cd  $dsk_receive_mail(rootdir)}]
    if $err {
        exec mkdir $dsk_receive_mail(rootdir)
        exec mkdir $dsk_receive_mail(rootdir)/inbox
        exec mkdir $dsk_receive_mail(rootdir)/trash
        exec mkdir $dsk_receive_mail(rootdir)/send
        cd  $dsk_receive_mail(rootdir)
    }
    set dirs [glob -nocomplain *]
    set dirs [lsort $dirs]
    foreach dir $dirs {
    	if {[file isdirectory $dir]} {
            $t.folder.m add command -label "$dir" \
                -command "dsk_set_maildir $t $dsk_receive_mail(rootdir) $dir"
            cd $dir
    	    set subdirs [glob -nocomplain *]
            set subdirs [lsort $subdirs]
            foreach subdir $subdirs {
    	        if {[file isdirectory $subdir]} {
                    $t.folder.m add command -label "-$subdir" \
                         -command "dsk_set_maildir $t $dsk_receive_mail(rootdir) $dir/$subdir"
    	        }
            }
    	    cd ..
        }
    }
    $t.folder.m add separator
    $t.folder.m add command -label "ե"\
        -command "dsk_mk_maildir $dsk_receive_mail(rootdir)/inbox"
    $t.folder.m add command -label "᡼뿶ʬ" -command dsk_mail_seldef
    $t.folder.m add command -label "Ȣˤ" -command "catch {exec imclean}"
    cd $curdir

    frame $t.f3 -bd 1 -relief raised
    pack $t.f3 -fill both -expand yes
    frame $t.f3a
    frame $t.f3b
    pack $t.f3a -in $t.f3 -fill both -side left -expand yes -padx 4 -pady 4
    pack $t.f3b -in $t.f3 -fill y -side right -padx 4 -pady 4
    text $t.tm -bd 2 -height 1 -width 30 -relief sunken -setgrid 1 -yscroll "$t.sby3 set"
    pack $t.tm -in $t.f3a -side left -fill both -expand yes
    scrollbar $t.sby3 -orient vertical -command "$t.tm yview"
    pack $t.sby3 -in $t.f3a -side left -fill y
    listbox $t.files -width 12 -bd 2 -height 1 -relief sunken -bg navy -fg gold \
       -font $tkdesk(font,entries)
    bind $t.files <Double-Button-1> "dsk_mail_savefile $t %x %y"
    pack $t.files -in $t.f3b -side left -fill y

    frame $t.f0 -bd 1 -relief raised
    pack $t.f0 -fill x
    button $t.bn -text "" -command "dsk_set_subject $t"
    button $t.br -text "POP" -command "dsk_remote_receive $t"
    button $t.bl -text "" -command "dsk_local_receive $t"
    button $t.bre -text "ֿ" -command "dsk_resend_mail $t"
    button $t.bse -text "ʬ" -command "dsk_mail_select $t"
    button $t.bsv -text "¸..." -command "dsk_mailer_save $t"
    button $t.bd -text "" -command "dsk_delete_mail $t"
#    button $t.bs -text "" -command dsk_config_mail
    button $t.bc -text "Ĥ" -command "destroy $t"
    if {$dsk_get_config(#easy) == "yes"} {
        $t.bl configure -state disabled
#        $t.bs configure -command dsk_easyconf_mail
    }
    pack $t.bn $t.br $t.bl $t.bre $t.bse $t.bsv $t.bd $t.bc -in $t.f0 \
        -side left -padx 2 -pady 2 -ipady 1

    set dsk_receive_mail(curdir) "$dsk_receive_mail(rootdir)/$dsk_receive_mail(folder)"
    dsk_set_subject $t

    wm geometry $t $dsk_receive_mail(size)
    wm protocol $t WM_DELETE_WINDOW "destroy $t"
    cb_centerToplevel $t
    wm deiconify $t
}

proc dsk_set_maildir {t root dir} {
    global dsk_receive_mail
   
    set dsk_receive_mail(curdir) "$root/$dir"
    set dsk_receive_mail(folder) $dir
    dsk_set_subject $t
}

proc dsk_mk_maildir {dir} {
    set name [cb_readString "᡼ե̾"]
    catch {exec mkdir "$dir/$name"}
}

proc dsk_delete_mail {t} {
    global dsk_receive_mail

    set size [$t.sj size]
    set lists [$t.sj curselection]
    if {[llength $lists] <= 0} {
        return
    }
    set newlists ""
    foreach item $lists {
    	incr item
    	set newlists [concat $newlists $item]
    }
    exec sh -c "imrm --src=+$dsk_receive_mail(folder) $newlists"
    dsk_set_subject $t
}

proc dsk_local_receive {t} {
    catch {exec imget > "~/.tkdesk/mailerr"}
#    dsk_set_subject $t
}

proc dsk_remote_receive {t} {
    global tkdesk dsk_get_config

    dsk_get_config
    set command "--src=pop/POP:$dsk_get_config(User)@$dsk_get_config(#PopServers)"
    dsk_exec $tkdesk(cmd,xterm) -sb -T "POP" -e pauseme "imget $command"
    catch {exec imget > "~/.tkdesk/mailerr"}
#    dsk_set_subject $t
}

proc dsk_mail_settext {t x y} {
    global tkdesk dsk_receive_mail dsk_mail_settext dsk_get_config 

    dsk_get_config
    set disphead {}
    catch {set disphead $dsk_get_config(#head)}
    set multi "no"
    set n [$t.sj index @$x,$y]
    incr n
    set dir $dsk_receive_mail(curdir)
    if {[file exists $dir/$n] == 0} {
        return
    }
    $t.files delete 0 end
    $t.tm delete 1.0 end
    set tkdesk(TkMailerFile) "$dir/$n"
    set fd [open "| nkf -e < $dir/$n" "r"]
    while {[gets $fd line] != -1 && $line != ""} {
        set head [string tolower $line]
        set pos [string first "content-type: multipart/mixed" $head]
        if {$pos >= 0} {
            set multi "yes"
        }
        set pos [string first "content-type: multipart/alternative" $head]
        if {$pos >= 0} {
            set multi "yes"
        }
        if {$multi == "yes"} {
            set head [string tolower $line]
            set pos [string first "boundary=" $head]
            set b [expr $pos + 10]
            set e [expr [string length $line] - 2]
            if {$pos != -1} {
                set boundary [string range $line $b $e]
            }
        }
        if {$disphead == "all"} {
            $t.tm insert end "$line\n"
        }
        if {$disphead == "some"} {
            set key [string range $head 0 1]
            if {$key == "to"} {
                $t.tm insert end "$line\n"
            }
            if {$key == "cc"} {
                $t.tm insert end "$line\n"
            }
            set key [string range $head 0 3]
            if {$key == "from"} {
                $t.tm insert end "$line\n"
            }
            if {$key == "date"} {
                $t.tm insert end "$line\n"
            }
        }
    }
    if {$disphead == "all" || $disphead == "some"} {
        $t.tm insert end "\n"
    }
    if {$multi == "no"} {
        set msg [read -nonewline $fd]
        $t.tm insert end $msg
        catch {close $fd}
        return
    }
    set i -2
    while {[gets $fd line] != -1} {
        if {[string first $boundary $line] != -1} {
            set heads "on"
            incr i
            set name "noname$i"
            set dsk_mail_settext($name) ""
            set dsk_mail_settext($i) ""
            set hf "off"
        } else {
            if {$i == -1} {
                if {$heads == "off"} {
                    $t.tm insert end "$line\n"
                }
                if {$line == "" && $heads == "on"} {
                    set heads "off"
                }
            }
            if {$i >= 0} {
                if {$heads == "on"} {
                    if {$line == ""} {
                        set dsk_mail_settext($name) ""
                        set heads "off"
                        if {$hf == "on"} {
                            $t.files insert end $name
                        }
                    } else {
                    	set hf "on"
                        set head [string tolower $line]
                        set pos [string first "content-transfer-encoding: base64" $head]
                        if {$pos >= 0} {
                            set dsk_mail_settext($i) "base64"
                        }
                        set pos [string first "filename=" $head]
                        if {$pos != -1} {
                            set head [string range $head $pos end]
                            set b [string first "\"" $head]
                            set e [string last "\"" $head]
                            if {$b != -1 && $e != -1} {
                                set name [string range $head [expr $b + 1] [expr $e - 1]]
                            } else {
                            	set b [string first "=" $head]
                                set name [string range $head [expr $b + 1] end]
                            }
                        }
                    }
                } else {
                    set dsk_mail_settext($name) "$dsk_mail_settext($name)$line\n"
                }
            }
        }
    }
    catch {close $fd}
}

proc dsk_mail_savefile {t x y} {
    global dsk_mail_settext

    if {[$t.files size] == 0} {
        return
    } 
    set n [$t.files index @$x,$y]
    set name [$t.files get $n]
    set form $dsk_mail_settext($n)
    set varname $name
    while 1 {
        set f [cb_fileSelector -label "źեե $varname ¸" -variable varname ]
        if {$f != ""} {
       	    if {$form == "base64"} {
       	        set f "| text2bin > $f"
       	    }
            set err [catch {set fd [open $f "w"]}]
            if $err {
                cb_error "񤭹ߤ $f ޤ"
            } else {
                set msg $dsk_mail_settext($name)
                puts -nonewline $fd $msg
                catch {close $fd}
                break
            }
        } else {
            break
        }
    }
}

proc dsk_mail_select {t} {
    global dsk_get_config env

    dsk_get_config
    set dir "$env(HOME)/$dsk_get_config(MailDir)/inbox"
    set dsk_mail_select(̾) subject
    set dsk_mail_select(п) from
    set dsk_mail_select() to
    set config [dsk_mail_seldef_read]
    set fd [open "| catheader $dir | nkf -e" "r"]
    set j 0
    foreach list $config {
        set folder [lindex $list 1]
        set command($j) "exec immv --src=+inbox --dst=+inbox/$folder "
        set flag($j) "off"
        incr j
    }
    set i 1
    gets $fd line
    while {[gets $fd line] != -1} {
        set head [string tolower $line]
        set pos [string first "subject: " $head]
        if {$pos == 0} {
            set dsk_mail_select(subject) [string range $line [expr $pos + 9] end]
       	}
        set pos [string first "from: " $head]
        if {$pos == 0} {
            set dsk_mail_select(from) [string range $line [expr $pos + 6] end]
       	}
        set pos [string first "to: " $head]
        if {$pos == 0} {
            set dsk_mail_select(to) [string range $line [expr $pos + 4] end]
       	}
        set head [string range $line 0 4]
        if {$head == "---- "} {
            set j 0
            foreach list $config {
                set item [lindex $list 0]
                set match [lindex $list 2]
                set varname $dsk_mail_select($item)
                if {[string first $match $dsk_mail_select($varname)] >= 0} {
                     set command($j) "$command($j) $i"
                     set flag($j) "on"
                }
                incr j
            }
            incr i
        }
    }
    catch {close $fd}
    set j 0
    foreach list $config {
        set item [lindex $list 0]
        set match [lindex $list 2]
        set varname $dsk_mail_select($item)
        if {[string first $match $dsk_mail_select($varname)] >= 0} {
            set command($j) "$command($j) $i"
            set flag($j) "on"
        }
    	if {$flag($j) == "on"} {
            eval $command($j)
        }
        incr j
    }
    dsk_set_subject $t
}

proc dsk_sort_mails {} {
    global dsk_receive_mail

    set dir $dsk_receive_mail(curdir)
    set dirs [glob -nocomplain $dir/*]
    set dirs [lsort $dirs]
    set max 0
    set n 0
    foreach item $dirs {
        if {[file isfile $item]} {
            set cur [file tail $item]
            if {$max <= $cur} {
                 set max $cur
            }
            incr n
        }
    }
    if {$n != $max} {
        set j 1
        for {set i 1} {$i <= $max} {incr i} {
            if {[file exists $dir/$i]} {
                if {"$dir/$i" != "$dir/$j"} {
                    exec mv $dir/$i $dir/$j
                }
                incr j
            }
        }
    }
}

proc dsk_set_subject_form {subject from date} {
    global dsk_receive_mail

    set n $dsk_receive_mail(sjsize)
    set f $dsk_receive_mail(fromsize)
    set form [format "%%-%ds" $n]
    set str [format $form $subject]
    set title [string range $str 0 [expr $n - 1]]
    set form [format "%%-%ds" $f]
    set str [format $form $from]
    set str [string range $str 0 [expr $f - 1]]
    set title "$title $str"
    set str [format "%32s" $date]
    set str [string range $str 0 31]
    set title "$title $str"
    return $title
}

proc dsk_set_subject {t} {
    global dsk_receive_mail tkdesk

    dsk_sort_mails
    set n $dsk_receive_mail(sjsize)
    set f $dsk_receive_mail(fromsize)
    set dir $dsk_receive_mail(curdir)
    if {$dir == "$dsk_receive_mail(rootdir)/trash"} {
        $t.bd configure -state disabled
    } else {
        $t.bd configure -state active
    }
    $t.sj delete 0 end
    set subject "(̾ʤ)"
    set count 0
    set fd [open "| catheader $dir | nkf -e" "r"]
    set form [format "%%-%ds %%-%ds %%32s" $n $f]
    gets $fd line
    while {[gets $fd line] != -1} {
    	incr count
        set head [string tolower $line]
        set pos [string first "subject: " $head]
        if {$pos >= 0} {
            set subject [string range $line [expr $pos + 9] end]
       	}
        set pos [string first "from: " $head]
        if {$pos >= 0} {
            set from [string range $line [expr $pos + 6] end]
       	}
        set pos [string first "date: " $head]
        if {$pos >= 0} {
            set dt [string range $line [expr $pos + 6] end]
       	}
        set head [string range $line 0 4]
        if {$head == "---- "} {
            $t.sj insert end [dsk_set_subject_form $subject $from $dt]
            set subject "(̾ʤ)"
        }
    }
    if {$count > 0} {
        $t.sj insert end [dsk_set_subject_form $subject $from $dt]
    }
    catch {close $fd}
    $t.tm delete 1.0 end
    set tkdesk(TkMailerFile) "none"
}

proc dsk_mail_seldef {} {
    global dsk_mail_seldef dsk_get_config env tkdesk

    catch {destroy .dsk_mail_seldef}
    toplevel [set t .dsk_mail_seldef]
    wm withdraw $t
    wm title $t "TkMailer Selection define"  

    dsk_get_config
    set home $env(HOME)
    set maildir $dsk_get_config(MailDir)
    set dsk_mail_seldef(item) ""
    set dsk_mail_seldef(folder) ""
    set dsk_mail_seldef(config) [dsk_mail_seldef_read]
    frame $t.f1 -bd 1 -relief raised
    pack $t.f1 -fill x
    label $t.title -text "TkMailerܸ(᡼뿶ʬ) by 乬"
    pack $t.title -in $t.f1 -padx 4 -pady 4

    frame $t.f2
    pack $t.f2 -fill x
    menubutton $t.item -text "" -menu $t.item.m
    menu $t.item.m
    foreach item {̾ п } {
        $t.item.m add command -label $item \
          -command "dsk_mail_seldef_key $t 1 $item"
    }
    menubutton $t.folder -text "ž" -menu $t.folder.m
    menu $t.folder.m
    set curdir [pwd]
    cd "$home/$maildir/inbox"
    set dirs [glob -nocomplain *]
    set dirs [lsort $dirs]
    foreach dir $dirs {
    	if {[file isdirectory $dir]} {
            $t.folder.m add command -label $dir \
              -command "dsk_mail_seldef_key $t 2 $dir"
       }
    }
    cd $curdir

    label $t.lmatch -text ""
    entry $t.match -bd 2 -width 48 -relief sunken
    pack $t.item $t.folder $t.lmatch -in $t.f2 -side left
    pack $t.match -in $t.f2 -side left -fill x -expand yes -padx 4 -pady 4

    frame $t.f3
    pack $t.f3 -fill x
    entry $t.define
    pack $t.define -in $t.f3 -side left -fill x -expand yes -padx 4 -pady 4
     
    frame $t.f4
    pack $t.f4 -fill both -expand yes -padx 4 -pady 4
    listbox $t.list -height 4 -bd 2 -relief sunken \
        -yscroll "$t.y set" -selectmode browse -font $tkdesk(font,entries)
    bind $t.list <Double-Button-1> {}
    bind $t.list <Delete> {}
    scrollbar $t.y -orient vertical -command "$t.list yview"
    pack $t.list -in $t.f4 -side left -fill both -expand yes
    pack $t.y -in $t.f4 -side right -fill y
    dsk_mail_seldef_list $t

    frame $t.f0 -bd 1 -relief raised
    pack $t.f0 -fill x
    button $t.bs -text "ɲ" -command "dsk_mail_add_config $t"
    button $t.bd -text "" -command "dsk_mail_del_config $t"
    button $t.bc -text "Ĥ" -command "destroy $t"
    pack $t.bs $t.bd $t.bc -in $t.f0 -side left -padx 2 -pady 2 -ipady 1

    wm protocol $t WM_DELETE_WINDOW "destroy $t"
    cb_centerToplevel $t
    wm deiconify $t
}

proc dsk_mail_del_config {t} {
    global dsk_mail_seldef env

    set n [$t.list curselection]
    set dsk_mail_seldef(config) [lreplace $dsk_mail_seldef(config) $n $n]
    set err [catch {set fd [open "$env(HOME)/.tkdesk/_mailselconf" "w"]}]
    if $err {
        cb_error "񤭹ߤ $f ޤ"
    } else {
        puts -nonewline $fd $dsk_mail_seldef(config)
        catch {close $fd}
    }
    dsk_mail_seldef_list $t
}

proc dsk_mail_add_config {t} {
    global dsk_mail_seldef env

    set item $dsk_mail_seldef(item)
    set folder $dsk_mail_seldef(folder)
    set match [$t.match get]
    if {$item != "" && $folder != "" && $match != ""} {
    	lappend dsk_mail_seldef(config) [list $item $folder $match]  
    }
    set item $dsk_mail_seldef(item)
    set folder $dsk_mail_seldef(folder)
    $t.match delete 0 end
    $t.define delete 0 end
    set err [catch {set fd [open "$env(HOME)/.tkdesk/_mailselconf" "w"]}]
    if $err {
        cb_error "񤭹ߤ $f ޤ"
    } else {
        puts -nonewline $fd $dsk_mail_seldef(config)
        catch {close $fd}
    }
    dsk_mail_seldef_list $t
}

proc dsk_mail_seldef_list {t} {
    global dsk_mail_seldef
    
    $t.list delete 0 end
    foreach line $dsk_mail_seldef(config) {
    	set item [lindex $line 0]
    	set folder [lindex $line 1]
    	set match [lindex $line 2]
        $t.list insert end "$item  $match ޤʤ $folder ˿ʬ"
    }
}

proc dsk_mail_seldef_read {} {
    global env

    set confname "$env(HOME)/.tkdesk/_mailselconf"
    set err [catch {set fd [open $confname "r"]}]
    if $err {
        return {}
    } else {
        set data [read -nonewline $fd]
        close $fd
    }
    return $data
}

proc dsk_mail_seldef_key {t id text} {
    global dsk_mail_seldef

    if {$id == 1} {
        set dsk_mail_seldef(item) $text
    }
    if {$id == 2} {
        set dsk_mail_seldef(folder) $text
    }
    $t.define delete 0 end
    set item $dsk_mail_seldef(item)
    set folder $dsk_mail_seldef(folder)
    set match [$t.match get]
    $t.define insert end "$item  $match ޤʤ $folder ˿ʬ"
}
