# style.tcl --
#
# This demonstration script creates a text widget that illustrates the
# various display styles that may be set for tags.
#
# RCS: @(#) $Id: style.tcl,v 1.1 1999/03/31 15:08:41 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .style
catch {destroy $w}
toplevel $w
wm title $w "Text Demonstration - Display Styles"
wm iconname $w "style"
positionWindow $w

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

text $w.text -yscrollcommand "$w.scroll set" -setgrid true \
	-width 70 -height 32 -wrap word
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

# Set up display styles

$w.text tag configure bold -font {Courier12bolditalic}
$w.text tag configure big -font {Courier14bold}
$w.text tag configure verybig -font {Helvetica24bold}
$w.text tag configure small -font {Helvetica10}
if {[winfo depth $w] > 1} {
    $w.text tag configure color1 -background #a0b7ce
    $w.text tag configure color2 -foreground red
    $w.text tag configure raised -relief raised -borderwidth 1
    $w.text tag configure sunken -relief sunken -borderwidth 1
} else {
    $w.text tag configure color1 -background black -foreground white
    $w.text tag configure color2 -background black -foreground white
    $w.text tag configure raised -background white -relief raised \
	    -borderwidth 1
    $w.text tag configure sunken -background white -relief sunken \
	    -borderwidth 1
}
$w.text tag configure bgstipple -background black -borderwidth 0 \
	-bgstipple gray12
$w.text tag configure fgstipple -fgstipple gray50
$w.text tag configure underline -underline on
$w.text tag configure overstrike -overstrike on
$w.text tag configure right -justify right
$w.text tag configure center -justify center
$w.text tag configure super -offset 4p -font {Courier 10}
$w.text tag configure sub -offset -2p -font {Courier 10}
$w.text tag configure margins -lmargin1 12m -lmargin2 6m -rmargin 10m
$w.text tag configure spacing -spacing1 10p -spacing2 2p \
	-lmargin1 12m -lmargin2 6m -rmargin 10m

langSwitch {
$w.text insert end {Text widgets like this one allow you to display information in a
variety of styles.  Display styles are controlled using a mechanism
called }
$w.text insert end tags bold
$w.text insert end {. Tags are just textual names that you can apply to one
or more ranges of characters within a text widget.  You can configure
tags with various display styles.  If you do this, then the tagged
characters will be displayed with the styles you chose.  The
available display styles are:
}
$w.text insert end "\n1. Font." big
$w.text insert end "  You can choose any X font, "
$w.text insert end large verybig
$w.text insert end " or "
$w.text insert end "small.\n"
$w.text insert end "\n2. Color." big
$w.text insert end "  You can change either the "
$w.text insert end background color1
$w.text insert end " or "
$w.text insert end foreground color2
$w.text insert end "\ncolor, or "
$w.text insert end both {color1 color2}
$w.text insert end ".\n"
$w.text insert end "\n3. Stippling." big
$w.text insert end "  You can cause either the "
$w.text insert end background bgstipple
$w.text insert end " or "
$w.text insert end foreground fgstipple
$w.text insert end {
information to be drawn with a stipple fill instead of a solid fill.
}
$w.text insert end "\n4. Underlining." big
$w.text insert end "  You can "
$w.text insert end underline underline
$w.text insert end " ranges of text.\n"
$w.text insert end "\n5. Overstrikes." big
$w.text insert end "  You can "
$w.text insert end "draw lines through" overstrike
$w.text insert end " ranges of text.\n"
$w.text insert end "\n6. 3-D effects." big
$w.text insert end {  You can arrange for the background to be drawn
with a border that makes characters appear either }
$w.text insert end raised raised
$w.text insert end " or "
$w.text insert end sunken sunken
$w.text insert end ".\n"
$w.text insert end "\n7. Justification." big
$w.text insert end " You can arrange for lines to be displayed\n"
$w.text insert end "left-justified,\n"
$w.text insert end "right-justified, or\n" right
$w.text insert end "centered.\n" center
$w.text insert end "\n8. Superscripts and subscripts."  big
$w.text insert end " You can control the vertical\n"
$w.text insert end "position of text to generate superscript effects like 10"
$w.text insert end "n" super
$w.text insert end " or\nsubscript effects like X"
$w.text insert end "i" sub
$w.text insert end ".\n"
$w.text insert end "\n9. Margins." big
$w.text insert end " You can control the amount of extra space left"
$w.text insert end " on\neach side of the text:\n"
$w.text insert end "This paragraph is an example of the use of " margins
$w.text insert end "margins.  It consists of a single line of text " margins
$w.text insert end "that wraps around on the screen.  There are two " margins
$w.text insert end "separate left margin values, one for the first " margins
$w.text insert end "display line associated with the text line, " margins
$w.text insert end "and one for the subsequent display lines, which " margins
$w.text insert end "occur because of wrapping.  There is also a " margins
$w.text insert end "separate specification for the right margin, " margins
$w.text insert end "which is used to choose wrap points for lines.\n" margins
$w.text insert end "\n10. Spacing." big
$w.text insert end " You can control the spacing of lines with three\n"
$w.text insert end "separate parameters.  \"Spacing1\" tells how much "
$w.text insert end "extra space to leave\nabove a line, \"spacing3\" "
$w.text insert end "tells how much space to leave below a line,\nand "
$w.text insert end "if a text line wraps, \"spacing2\" tells how much "
$w.text insert end "space to leave\nbetween the display lines that "
$w.text insert end "make up the text line.\n"
$w.text insert end "These indented paragraphs illustrate how spacing " spacing
$w.text insert end "can be used.  Each paragraph is actually a " spacing
$w.text insert end "single line in the text widget, which is " spacing
$w.text insert end "word-wrapped by the widget.\n" spacing
$w.text insert end "Spacing1 is set to 10 points for this text, " spacing
$w.text insert end "which results in relatively large gaps between " spacing
$w.text insert end "the paragraphs.  Spacing2 is set to 2 points, " spacing
$w.text insert end "which results in just a bit of extra space " spacing
$w.text insert end "within a pararaph.  Spacing3 isn't used " spacing
$w.text insert end "in this example.\n" spacing
$w.text insert end "To see where the space is, select ranges of " spacing
$w.text insert end "text within these paragraphs.  The selection " spacing
$w.text insert end "highlight will cover the extra space." spacing
} {
$w.text insert end \
{$B$3$N$h$&$K%F%-%9%H(B widget $B$O>pJs$rMM!9$J%9%?%$%k$GI=<($9$k$3$H(B
$B$,$G$-$^$9!#I=<(%9%?%$%k$O(B}
$w.text insert end $B%?%0(B bold
$w.text insert end {$B$H$$$&%a%+%K%:%`$G%3%s%H%m!<%k$5$l$^$9!#(B
$B%?%0$H$O%F%-%9%H(B widget $BFb$N$"$kJ8;z(B ($B$NHO0O(B)$B$KBP$7$FE,MQ$G$-$k(B
$BC1$J$kL>A0$N$3$H$G$9!#%?%0$OMM!9$JI=<(%9%?%$%k$K@_Dj$G$-$^$9!#(B
$B@_Dj$9$k$H!"$=$N%?%0$N$D$$$?J8;z$O;XDj$7$?%9%?%$%k$GI=<($5$l$k(B
$B$h$&$K$J$j$^$9!#;HMQ$G$-$kI=<(%9%?%$%k$O<!$NDL$j$G$9!#(B
}
$w.text insert end "1. $B%U%)%s%H(B" big
$w.text insert end "  $B$I$s$J(B X $B$N%U%)%s%H$G$b;H$($^$9!#(B"
$w.text insert end $BBg$-$$(B verybig
$w.text insert end "$B$H$+(B"
$w.text insert end $B>.$5$$(B small
$w.text insert end "$B$H$+!#(B\n"
$w.text insert end "\n2. $B?'(B" big
$w.text insert end "  "
$w.text insert end $BGX7J?'(B color1
$w.text insert end "$B$b(B"
$w.text insert end $BA07J?'(B color2
$w.text insert end "$B$b(B"
$w.text insert end $BN>J}(B {color1 color2}
$w.text insert end "$B$H$bJQ$($k$3$H$,$G$-$^$9!#(B\n"
$w.text insert end "\n3. $BLV$+$1(B" big
$w.text insert end "  $B$3$N$h$&$KIA2h$N:]$K(B"
$w.text insert end $BGX7J(B bgstipple
$w.text insert end "$B$b(B"
$w.text insert end $BJ8;z(B fgstipple
$w.text insert end {
$B$bC1$J$kEI$j$D$V$7$G$J$/!"LV$+$1$r;H$&$3$H$,$G$-$^$9!#(B
}
$w.text insert end "\n4. $B2<@~(B" big
$w.text insert end "  $B$3$N$h$&$K(B"
$w.text insert end "$BJ8;z$K2<@~$r0z$/(B" underline
$w.text insert end "$B$3$H$,$G$-$^$9!#(B\n"
$w.text insert end "\n5. $BBG$A>C$7@~(B" big
$w.text insert end "  $B$3$N$h$&$K(B"
$w.text insert end "$BJ8;z$K=E$M$F@~$r0z$/(B" overstrike
$w.text insert end "$B$3$H$,$G$-$^$9!#(B\n"
$w.text insert end "\n6. 3D $B8z2L(B" big
$w.text insert end "  $BGX7J$KOH$r$D$1$F!"J8;z$r(B"
$w.text insert end "$BHt$S=P$9(B" raised
$w.text insert end "$B$h$&$K$7$?$j(B"
$w.text insert end "$BD@$`(B" sunken
$w.text insert end "$B$h$&(B\n$B$K$G$-$^$9!#(B\n"
$w.text insert end "\n7. $B9TB7$((B" big
$w.text insert end "  $B$3$N$h$&$K9T$r(B\n"
$w.text insert end "$B:8$KB7$($?$j(B\n"
$w.text insert end "$B1&$KB7$($?$j(B\n" right
$w.text insert end "$B??Cf$KB7$($?$j$G$-$^$9!#(B\n" center
$w.text insert end "\n8. $B8*IU$-J8;z$HE:;z(B"  big
$w.text insert end "  10"
$w.text insert end "n" super
$w.text insert end "$B$N$h$&$K8*IU$-J8;z$N8z2L$d!"(B\nX"
$w.text insert end "i" sub
$w.text insert end "$B$N$h$&$KE:;z$N8z2L$r=P$9$3$H$,$G$-$^$9!#(B\n"
$w.text insert end "\n9. $B%^!<%8%s(B" big
$w.text insert end "  $B%F%-%9%H$N:8B&$KM>J,$J6uGr$r(B"
$w.text insert end "$BCV$/$3$H$,$G$-$^$9(B:\n"
$w.text insert end "$B$3$NCJMn$O%^!<%8%s$N;HMQNc$G$9!#%9%/%j!<%s(B" margins
$w.text insert end "$B>e$G@^$jJV$5$l$FI=<($5$l$F$$$k(B1$B9T$N%F%-%9%H$G$9!#(B" margins
$w.text insert end "$B:8B&$K$O(B2$B<oN`$N%^!<%8%s$r;}$A$^$9!#(B" margins
$w.text insert end "1$B9TL\$KBP$9$k$b$N$H!"(B" margins
$w.text insert end "2$B9TL\0J9_$NO"B3$7$?%^!<%8%s(B" margins
$w.text insert end "$B$G$9!#$^$?1&B&$K$b%^!<%8%s$,$"$j$^$9!#(B" margins
$w.text insert end "$B9T$N@^$jJV$70LCV$r7h$a$k$?$a$K;HMQ$9$k$3$H$,$G$-$^$9!#(B\n" margins
$w.text insert end "\n10. $B%9%Z!<%7%s%0(B" big
$w.text insert end "  3$B$D$N%Q%i%a!<%?$G9T$N%9%Z!<%7%s%0$r@)8f$9$k(B\n"
$w.text insert end "$B$3$H$,$G$-$^$9!#(B\"Spacing1\"$B$G!"9T$N>e$K$I$N$/$i$$$N(B"
$w.text insert end "$B6u4V$rCV$/$+!"(B\n\"spacing3\"$B$G9T$N2<$K$I$N$/$i$$$N(B"
$w.text insert end "$B6u4V$rCV$/$+!"9T$,@^$jJV$5$l$F(B\n$B$$$k$J$i$P!"(B"
$w.text insert end "\"spacing2\"$B$G!"%F%-%9%H9T$r@8@.$7$F$$$k9T$N4V$K(B\n"
$w.text insert end "$B$I$N$/$i$$$N6u4V$rCV$/$+$r<($7$^$9!#(B\n"
$w.text insert end "$B$3$l$i$N%$%s%G%s%H$5$l$?CJMn$O$I$N$h$&$K(B" spacing
$w.text insert end "$B%9%Z!<%7%s%0$,$,9T$o$l$k$N$+$r<($7$^$9!#(B" spacing
$w.text insert end "$B3FCJMn$O<B:]$O%F%-%9%H(Bwidget" spacing
$w.text insert end "$B$N(B1$B9T$G!"(Bwidget$B$K$h$C$F@^$j>v$^$l$F$$$^$9!#(B\n" spacing
$w.text insert end "Spacing1$B$O$3$N%F%-%9%H$G$O(B10point$B$K(B" spacing
$w.text insert end "$B@_Dj$5$l$F$$$^$9!#(B" spacing
$w.text insert end "$B$3$l$K$h$j!"CJMn$N4V$KBg$-$J4V3V$,(B" spacing
$w.text insert end "$BB8:_$7$F$$$^$9!#(B" spacing
$w.text insert end "Spacing2$B$O(B2point$B$K@_Dj$5$l$F$$$^$9!#(B" spacing
$w.text insert end "$B$3$l$GCJMn$NCf$K$[$s$N>/$74V3V$,B8:_$7$F$$$^$9!#(B" spacing
$w.text insert end "Spacing3$B$O$3$NNc$G$O;HMQ$5$l$F$$$^$;$s!#(B\n" spacing
$w.text insert end "$B4V3V$,$I$3$K$"$k$+$r8+$?$1$l$P!"$3$l$i$NCJMn$N(B" spacing
$w.text insert end "$B$J$+$G%F%-%9%H$rA*Br$7$F$/$@$5$$!#A*Br$N(B" spacing
$w.text insert end "$BH?E>$7$?ItJ,$K$OM>J,$K$H$i$l$?4V3V$,(B" spacing
$w.text insert end "$B4^$^$l$F$$$^$9!#(B\n" spacing
}
