#!/bin/sh

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=2.4.3
PKGVER=P3

PACKAGE=ppp-$ORIGVER-i386-$PKGVER.tgz
SRCURL1=ftp://ftp.samba.org/pub/ppp/ppp-2.4.3.tar.gz
SRC1=ppp-$ORIGVER.tar.gz
SRCDIR1=ppp-$ORIGVER
SRC2=patches/pon.sh
SRC3=patches/poff.sh
SRC4=patches/pppsetup.sh
SRC5=patches/pppselect.sh
SRC6=patches/xpppselect.py
SRC7=patches/ip-up.sh
SRC8=patches/ip-down.sh
PATCH1=patches/ppp-2.4.3-build.patch

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
PKGPREFIX=$PKGROOT$PREFIX

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT
cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH1 | patch -sp1
./configure
make || exit 1
make install DESTDIR=$PKGPREFIX || exit 1

install_script () {
    DIST=${1##*/}
    DIST=$PKGROOT$2/${DIST%.*}
    cp $1 $DIST
    chown 0.0 $DIST
    chmod $3 $DIST
}

mkdir -p $PKGPREFIX/bin
mkdir -p $PKGROOT/etc/ppp
install_script $SRCROOT/$SRC2 $PREFIX/sbin 755
install_script $SRCROOT/$SRC3 $PREFIX/sbin 755
install_script $SRCROOT/$SRC4 $PREFIX/sbin 755
install_script $SRCROOT/$SRC5 $PREFIX/bin 755
install_script $SRCROOT/$SRC6 $PREFIX/bin 755
install_script $SRCROOT/$SRC7 /etc/ppp 755
install_script $SRCROOT/$SRC8 /etc/ppp 755

echo "lock" > $PKGROOT/etc/ppp/options
chown 0.0 $PKGROOT/etc/ppp/options
chmod 644 $PKGROOT/etc/ppp/options

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
cp Changes-2.3 FAQ PLUGINS README README.* SETUP $PKGROOT$DOCPREFIX/$SRCDIR1
cp $SRCROOT/README $PKGROOT$DOCPREFIX/$SRCDIR1/00README-Plamo.euc
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches

gzip $PKGPREFIX/man/man?/*
gzip $PKGROOT$DOCPREFIX/$SRCDIR1/*
strip $PKGPREFIX/lib/pppd/$ORIGVER/*

cd $PKGROOT
makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
