/* cpufreq tools
 *  Copyright (C) 2005 Yuuki Harano
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: string_buffer.h 281 2005-06-25 11:22:46Z masm $
 */

#ifndef CPUFREQ__STRING_BUFFER_H__INCLUDED
#define CPUFREQ__STRING_BUFFER_H__INCLUDED

#include <cpufreq/common.h>

struct string_buffer_t;

/** ¤Τݤ롣*/
struct string_buffer_t *string_buffer_new(void);

/** ʸ򥯥ꥢ롣*/
void string_buffer_clear(struct string_buffer_t *w);

/** ʸɲä롣*/
void string_buffer_append(struct string_buffer_t *w, const char *str);

/** ʸɲä롣 */
void string_buffer_printf(struct string_buffer_t *w, const char *fmt, ...);

/** ʸ롣
 * @return ʸΥݥ󥿡
 */
const char *string_buffer_get(const struct string_buffer_t *w);

/** ¤Τ롣*/
void string_buffer_free(struct string_buffer_t *w);

#endif	/* ifndef CPUFREQ__STRING_BUFFER_H__INCLUDED */
