/* cpufreq tools
 *  Copyright (C) 2005 Yuuki Harano
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: socket_recv.h 324 2005-07-07 09:17:20Z masm $
 */

#ifndef CPUFREQ__SOCKET_RECV_H__INCLUDED
#define CPUFREQ__SOCKET_RECV_H__INCLUDED

#include <cpufreq/common.h>

struct socket_recv_t;

/** socket_recv 롣
 */
struct socket_recv_t *socket_recv_new(int sock, pthread_mutex_t *mutex, pthread_cond_t *cond);

/** socket_recv ʸ 1롣
 * mutex  lock ֤ǸƤ֤ȡ
 *  '\n' ϴޤޤʤ
 * Ԥʤ NULL ֤
 */
char *socket_recv_get_line(struct socket_recv_t *w);

/** socket Ĥ褦ȤƤ뤫֤
 * mutex  lock ֤ǸƤ֤ȡ
 */
int socket_recv_get_closing(struct socket_recv_t *w);

/** socket_recv ˴롣
 * mutex  lock Ƥʤ֤ǸƤ֤ȡ
 * mutex, cond, socket ˤĤƤϲ˴ʤ
 */
void socket_recv_free(struct socket_recv_t *w);

#endif	/* ifndef CPUFREQ__SOCKET_RECV_H__INCLUDED */
