#!/bin/sh

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=0.3.14
PKGVER=P2
PACKAGE=scrollkeeper-$ORIGVER-i386-$PKGVER.tgz

SRCURL1=http://ftp.gnome.org/pub/GNOME/sources/scrollkeeper/0.3/scrollkeeper-0.3.14.tar.bz2
SRC1=scrollkeeper-$ORIGVER.tar.bz2
SRCDIR1=scrollkeeper-$ORIGVER
PATCH11=patches/scrollkeeper-0.3.12-rebuilddb.patch
PATCH12=patches/scrollkeeper-0.3.12-xmlcatalog.patch

SRC2=patches/catalog.ad.scrollkeeper

INITSCRIPTS="patches/scrollkeeper-rebuilddb.sh patches/scrollkeeper-xmlcatalog.sh"

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar jxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
cat $SRCROOT/$PATCH12 | patch -sp1
./configure --prefix=$PREFIX --localstatedir=/var --with-omfdirs=/usr/share/omf:/usr/local/share/omf:/opt/kde/omf || exit 1
make || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT/etc/xml
install -c -o0 -g0 -m0644 $SRCROOT/$SRC2 $PKGROOT/etc/xml

#mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
#cp ABOUT-NLS AUTHORS COPYING COPYING.DOC ChangeLog INSTALL NEWS README TODO $PKGROOT$DOCPREFIX/$SRCDIR1
cp ABOUT-NLS INSTALL $PKGROOT$DOCPREFIX/$SRCDIR1

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
